/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurableTreeList
extends AbstractList<AbstractNode>
implements Iterable<AbstractNode> {
    DurableAVLNode root;
    int size = 0;
    private int preConsistent = 0;
    protected int[] levelsSize;
    private final GraphViewImpl view;

    public DurableTreeList(GraphViewImpl view) {
        this.view = view;
        this.levelsSize = new int[1];
    }

    public GraphViewImpl getView() {
        return this.view;
    }

    public void incPreConsistent() {
        ++this.preConsistent;
    }

    @Override
    public AbstractNode get(int index) {
        this.checkInterval(index, 0, this.size() - 1);
        return this.root.get(index).getValue();
    }

    public DurableAVLNode getNode(int index) {
        this.checkInterval(index, 0, this.size() - 1);
        return this.root.get(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<AbstractNode> iterator() {
        return new TreeListIterator(this);
    }

    public Iterator<AbstractNode> iterator(int fromIndex) {
        return new TreeListIterator(this, fromIndex);
    }

    public int indexOf(AbstractNode object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(object, this.root.relativePosition);
    }

    public boolean contains(AbstractNode object) {
        return this.indexOf(object) >= 0;
    }

    public AbstractNode[] toArray() {
        AbstractNode[] array = new AbstractNode[this.size()];
        if (this.root != null) {
            this.root.toArray(array, this.root.relativePosition);
        }
        return array;
    }

    @Override
    public void add(int index, AbstractNode obj) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size());
        this.incPreConsistent();
        if (this.root == null) {
            this.root = new DurableAVLNode(this, index, obj, null, null, null);
        } else {
            this.root = this.root.insert(index, obj);
            this.root.parent = null;
        }
        if (obj.level >= this.levelsSize.length) {
            this.levelsSize = Arrays.copyOf(this.levelsSize, this.levelsSize.length + 1);
        }
        int n = obj.level;
        this.levelsSize[n] = this.levelsSize[n] + 1;
        ++this.size;
    }

    @Override
    public boolean add(AbstractNode e) {
        this.add(this.size, e);
        return true;
    }

    @Override
    public AbstractNode set(int index, AbstractNode obj) {
        this.checkInterval(index, 0, this.size() - 1);
        DurableAVLNode node = this.root.get(index);
        AbstractNode result = node.value;
        node.setValue(obj);
        return result;
    }

    @Override
    public AbstractNode remove(int index) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size() - 1);
        AbstractNode result = this.get(index);
        int n = result.level;
        this.levelsSize[n] = this.levelsSize[n] - 1;
        result.avlNode.setIndex(index);
        this.root = this.root.remove(index);
        result.avlNode = null;
        result.parent = null;
        --this.size;
        this.incPreConsistent();
        return result;
    }

    public AbstractNode removeAndKeepParent(int index) {
        this.checkInterval(index, 0, this.size() - 1);
        AbstractNode result = this.get(index);
        int n = result.level;
        this.levelsSize[n] = this.levelsSize[n] - 1;
        this.root = this.root.remove(index);
        result.avlNode = null;
        result.size = 0;
        --this.size;
        this.incPreConsistent();
        return result;
    }

    public void move(int index, int destination) {
        this.checkInterval(index, 0, this.size() - 1);
        AbstractNode node = this.get(index);
        AbstractNode parent = this.get(destination);
        int destinationPre = parent.pre + parent.size + 1;
        int nodeLimit = node.pre + node.size;
        boolean forward = destinationPre > node.pre;
        int difflevel = 0;
        int count = 0;
        for (int i = node.pre; i <= nodeLimit; ++i) {
            int sourcePre = i;
            int destPre = destinationPre + count;
            if (forward) {
                sourcePre -= count;
                destPre -= count + 1;
            }
            AbstractNode sourceNode = this.get(sourcePre);
            int n = sourceNode.level;
            this.levelsSize[n] = this.levelsSize[n] - 1;
            this.root = this.root.remove(sourcePre);
            sourceNode.avlNode = null;
            --this.size;
            if (count == 0) {
                sourceNode.parent = parent;
                difflevel = node.parent.level - node.level + 1;
            }
            sourceNode.level += difflevel;
            this.add(destPre, sourceNode);
            ++count;
        }
        this.incPreConsistent();
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.root = null;
        this.size = 0;
        this.levelsSize = new int[1];
    }

    private void checkInterval(int index, int startIndex, int endIndex) {
        if (index < startIndex || index > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index:" + index + ", size=" + this.size());
        }
    }

    public DurableAVLNode getRoot() {
        return this.root;
    }

    public static class DurableAVLNode {
        private DurableAVLNode left;
        private boolean leftIsPrevious;
        private DurableAVLNode right;
        private boolean rightIsNext;
        private int height;
        private int relativePosition;
        AbstractNode value;
        private DurableAVLNode parent;
        private int preConsistent;
        private DurableTreeList tree;

        private DurableAVLNode(DurableTreeList treeParent, int relativePosition, AbstractNode obj, DurableAVLNode rightFollower, DurableAVLNode leftFollower, DurableAVLNode parentNode) {
            this.relativePosition = relativePosition;
            this.value = obj;
            obj.avlNode = this;
            this.tree = treeParent;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
            this.parent = parentNode;
            this.preConsistent = this.tree.preConsistent;
        }

        public DurableTreeList getList() {
            return this.tree;
        }

        public int getIndex() {
            if (this.preConsistent != this.tree.preConsistent) {
                DurableAVLNode currentParent = this.parent;
                int index = this.relativePosition;
                while (currentParent != null) {
                    index += currentParent.relativePosition;
                    currentParent = currentParent.parent;
                }
                this.value.pre = index;
                this.value.getPost();
                this.preConsistent = this.tree.preConsistent;
            }
            return this.value.pre;
        }

        public void setIndex(int index) {
            this.value.pre = index;
            this.value.getPost();
            this.preConsistent = this.tree.preConsistent;
        }

        public boolean isConsistent() {
            return this.preConsistent == this.tree.preConsistent;
        }

        public AbstractNode getValue() {
            return this.value;
        }

        void setValue(AbstractNode obj) {
            this.value = obj;
            obj.avlNode = this;
        }

        DurableAVLNode get(int index) {
            DurableAVLNode nextNode;
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe == 0) {
                return this;
            }
            DurableAVLNode durableAVLNode = nextNode = indexRelativeToMe < 0 ? this.getLeftSubTree() : this.getRightSubTree();
            if (nextNode == null) {
                return null;
            }
            return nextNode.get(indexRelativeToMe);
        }

        int indexOf(AbstractNode object, int index) {
            int result;
            if (this.getLeftSubTree() != null && (result = this.left.indexOf(object, index + this.left.relativePosition)) != -1) {
                return result;
            }
            if (this.value == null ? this.value == object : this.value.equals(object)) {
                return index;
            }
            if (this.getRightSubTree() != null) {
                return this.right.indexOf(object, index + this.right.relativePosition);
            }
            return -1;
        }

        void toArray(AbstractNode[] array, int index) {
            array[index] = this.value;
            if (this.getLeftSubTree() != null) {
                this.left.toArray(array, index + this.left.relativePosition);
            }
            if (this.getRightSubTree() != null) {
                this.right.toArray(array, index + this.right.relativePosition);
            }
        }

        public DurableAVLNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        DurableAVLNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        DurableAVLNode insert(int index, AbstractNode obj) {
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe <= 0) {
                return this.insertOnLeft(indexRelativeToMe, obj);
            }
            return this.insertOnRight(indexRelativeToMe, obj);
        }

        private DurableAVLNode insertOnLeft(int indexRelativeToMe, AbstractNode obj) {
            DurableAVLNode ret = this;
            if (this.getLeftSubTree() == null) {
                this.setLeft(new DurableAVLNode(this.tree, -1, obj, this, this.left, this), null);
            } else {
                this.setLeft(this.left.insert(indexRelativeToMe, obj), null);
            }
            if (this.relativePosition >= 0) {
                ++this.relativePosition;
            }
            ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private DurableAVLNode insertOnRight(int indexRelativeToMe, AbstractNode obj) {
            DurableAVLNode ret = this;
            if (this.getRightSubTree() == null) {
                this.setRight(new DurableAVLNode(this.tree, 1, obj, this.right, this, this), null);
            } else {
                this.setRight(this.right.insert(indexRelativeToMe, obj), null);
            }
            if (this.relativePosition < 0) {
                --this.relativePosition;
            }
            ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private DurableAVLNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private DurableAVLNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private DurableAVLNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private DurableAVLNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        DurableAVLNode remove(int index) {
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe == 0) {
                return this.removeSelf();
            }
            if (indexRelativeToMe > 0) {
                this.setRight(this.right.remove(indexRelativeToMe), this.right.right);
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                this.setLeft(this.left.remove(indexRelativeToMe), this.left.left);
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this.balance();
        }

        private DurableAVLNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            if (this.relativePosition < 0) {
                ++this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private DurableAVLNode removeMin() {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(), this.left.left);
            if (this.relativePosition > 0) {
                --this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private DurableAVLNode removeSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                if (this.relativePosition > 0) {
                    this.left.relativePosition = this.left.relativePosition + (this.relativePosition + (this.relativePosition > 0 ? 0 : 1));
                }
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                this.right.relativePosition = this.right.relativePosition + (this.relativePosition - (this.relativePosition < 0 ? 0 : 1));
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                DurableAVLNode rightMin = this.right.min();
                this.value = rightMin.value;
                this.value.avlNode = this;
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin();
                this.right.parent = this;
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                DurableAVLNode leftMax = this.left.max();
                this.value = leftMax.value;
                this.value.avlNode = this;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                DurableAVLNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else {
                    this.left.parent = this;
                }
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this;
        }

        private DurableAVLNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(DurableAVLNode node) {
            if (node == null) {
                return 0;
            }
            return node.relativePosition;
        }

        private int setOffset(DurableAVLNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relativePosition = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(DurableAVLNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private DurableAVLNode rotateLeft() {
            DurableAVLNode newTop = this.right;
            DurableAVLNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relativePosition + this.getOffset(newTop);
            int myNewPosition = -newTop.relativePosition;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            this.setRight(movedNode, newTop);
            newTop.parent = this.parent;
            newTop.setLeft(this, null);
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            return newTop;
        }

        private DurableAVLNode rotateRight() {
            DurableAVLNode newTop = this.left;
            DurableAVLNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relativePosition + this.getOffset(newTop);
            int myNewPosition = -newTop.relativePosition;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            this.setLeft(movedNode, newTop);
            newTop.parent = this.parent;
            newTop.setRight(this, null);
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            return newTop;
        }

        private void setLeft(DurableAVLNode node, DurableAVLNode previous) {
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(DurableAVLNode node, DurableAVLNode next) {
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "AVLNode(" + this.relativePosition + "," + (this.left != null) + "," + this.value + "," + (this.getRightSubTree() != null) + ", faedelung " + this.rightIsNext + " )";
        }
    }
}

