/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.event.AbstractEvent;
import org.gephi.graph.dhns.event.EdgeEvent;
import org.gephi.graph.dhns.event.GeneralEvent;
import org.gephi.graph.dhns.event.GraphEventDataImpl;
import org.gephi.graph.dhns.event.GraphEventImpl;
import org.gephi.graph.dhns.event.NodeEvent;
import org.gephi.graph.dhns.event.ViewEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager
implements Runnable {
    private static final long DELAY = 1L;
    private final Dhns dhns;
    private final List<GraphListener> listeners;
    private final AtomicReference<Thread> thread = new AtomicReference();
    private final LinkedBlockingQueue<AbstractEvent> eventQueue;
    private final Object lock = new Object();
    private boolean stop;

    public EventManager(Dhns dhns) {
        this.dhns = dhns;
        this.eventQueue = new LinkedBlockingQueue();
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            Object event;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            ArrayList eventCompress = null;
            AbstractEvent precEvt = null;
            AbstractEvent evt = null;
            while ((evt = this.eventQueue.peek()) != null) {
                if (precEvt != null) {
                    if (!(evt instanceof NodeEvent) && !(evt instanceof EdgeEvent) || !precEvt.getEventType().equals((Object)evt.getEventType()) || precEvt.getView() != evt.getView()) break;
                    if (eventCompress == null) {
                        eventCompress = new ArrayList();
                        eventCompress.add(precEvt.getData());
                    }
                    eventCompress.add(evt.getData());
                }
                this.eventQueue.poll();
                precEvt = evt;
            }
            if (precEvt != null) {
                event = this.createEvent(precEvt, eventCompress);
                for (GraphListener l : this.listeners.toArray(new GraphListener[0])) {
                    l.graphChanged((GraphEvent)event);
                }
            }
            while (this.eventQueue.isEmpty()) {
                try {
                    event = this.lock;
                    synchronized (event) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    private GraphEvent createEvent(AbstractEvent event, List<Object> compress) {
        GraphEventDataImpl eventData = event instanceof GeneralEvent ? null : new GraphEventDataImpl();
        GraphEventImpl graphEventImpl = new GraphEventImpl(event.getView(), event.getEventType(), eventData);
        if (event instanceof NodeEvent) {
            Node[] nodes = compress != null ? compress.toArray(new Node[0]) : new Node[]{(Node)event.getData()};
            switch (event.getEventType()) {
                case ADD_NODES: {
                    eventData.setAddedNodes(nodes);
                    break;
                }
                case REMOVE_NODES: {
                    eventData.setRemovedNodes(nodes);
                    break;
                }
                case EXPAND: {
                    eventData.setExpandedNodes(nodes);
                    break;
                }
                case RETRACT: {
                    eventData.setRetractedNodes(nodes);
                    break;
                }
                case MOVE_NODES: {
                    eventData.setMovedNodes(nodes);
                }
            }
        } else if (event instanceof EdgeEvent) {
            Edge[] edges = compress != null ? compress.toArray(new Edge[0]) : new Edge[]{(Edge)event.getData()};
            switch (event.getEventType()) {
                case ADD_EDGES: {
                    eventData.setAddedEdges(edges);
                    break;
                }
                case REMOVE_EDGES: {
                    eventData.setRemovedEdges(edges);
                }
            }
        } else if (event instanceof ViewEvent) {
            eventData.setView((GraphView)event.getData());
        }
        return graphEventImpl;
    }

    public void stop(boolean stop) {
        this.stop = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(AbstractEvent event) {
        this.eventQueue.add(event);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName("graph-event-bus");
        if (this.thread.compareAndSet(null, t)) {
            t.start();
        }
    }

    public boolean isRunning() {
        return this.thread.get() != null;
    }

    public void addGraphListener(GraphListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeGraphListener(GraphListener listener) {
        this.listeners.remove(listener);
    }
}

