/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeRowFactory;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.TextData;
import org.gephi.graph.dhns.core.IDGen;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.edge.MixedEdgeImpl;
import org.gephi.graph.dhns.edge.ProperEdgeImpl;
import org.gephi.graph.dhns.edge.SelfLoopImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.spi.TextDataFactory;
import org.openide.util.Lookup;

public class GraphFactoryImpl
implements GraphFactory {
    private IDGen idGen;
    private AttributeRowFactory attributesFactory;
    private TextDataFactory textDataFactory;

    public GraphFactoryImpl(IDGen idGen, AttributeRowFactory attributesFactory) {
        this.idGen = idGen;
        this.attributesFactory = attributesFactory;
        this.textDataFactory = (TextDataFactory)Lookup.getDefault().lookup(TextDataFactory.class);
    }

    public AttributeRow newNodeAttributes(NodeData nodeData) {
        if (this.attributesFactory == null) {
            return null;
        }
        return this.attributesFactory.newNodeRow(nodeData);
    }

    public AttributeRow newEdgeAttributes(EdgeData edgeData) {
        if (this.attributesFactory == null) {
            return null;
        }
        return this.attributesFactory.newEdgeRow(edgeData);
    }

    public TextData newTextData() {
        if (this.textDataFactory == null) {
            return null;
        }
        return this.textDataFactory.newTextData();
    }

    public AbstractNode newNode() {
        return this.newNode(null, 0);
    }

    public AbstractNode newNode(int viewId) {
        return this.newNode(null, viewId);
    }

    public AbstractNode newNode(String id, int viewId) {
        AbstractNode node = new AbstractNode(this.idGen.newNodeId(), viewId, 0, 0, 0, null);
        node.getNodeData().setAttributes(this.newNodeAttributes(node.getNodeData()));
        node.getNodeData().setTextData(this.newTextData());
        if (id != null) {
            node.getNodeData().setId(id);
        } else {
            node.getNodeData().setId("" + node.getId());
        }
        return node;
    }

    public AbstractNode newNode(String id) {
        return this.newNode(id, 0);
    }

    public AbstractEdge newEdge(Node source, Node target) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        AbstractNode nodeSource = (AbstractNode)source;
        AbstractNode nodeTarget = (AbstractNode)target;
        AbstractEdge edge = source == target ? new SelfLoopImpl(this.idGen.newEdgeId(), nodeSource) : new ProperEdgeImpl(this.idGen.newEdgeId(), nodeSource, nodeTarget);
        edge.setAttributes(this.newEdgeAttributes(edge.getEdgeData()));
        edge.getEdgeData().setTextData(this.newTextData());
        edge.getEdgeData().setId("" + edge.getId());
        return edge;
    }

    public AbstractEdge newEdge(Node source, Node target, float weight, boolean directed) {
        return this.newEdge(null, source, target, weight, directed);
    }

    public AbstractEdge newEdge(String id, Node source, Node target, float weight, boolean directed) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        AbstractNode nodeSource = (AbstractNode)source;
        AbstractNode nodeTarget = (AbstractNode)target;
        AbstractEdge edge = source == target ? new SelfLoopImpl(this.idGen.newEdgeId(), nodeSource) : new MixedEdgeImpl(this.idGen.newEdgeId(), nodeSource, nodeTarget, directed);
        edge.setAttributes(this.newEdgeAttributes(edge.getEdgeData()));
        edge.setWeight(weight);
        edge.getEdgeData().setTextData(this.newTextData());
        if (id != null) {
            edge.getEdgeData().setId(id);
        } else {
            edge.getEdgeData().setId("" + edge.getId());
        }
        return edge;
    }

    public MetaEdgeImpl newMetaEdge(Node source, Node target) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        AbstractNode nodeSource = (AbstractNode)source;
        AbstractNode nodeTarget = (AbstractNode)target;
        MetaEdgeImpl edge = new MetaEdgeImpl(this.idGen.newEdgeId(), nodeSource, nodeTarget);
        edge.setAttributes(this.newEdgeAttributes(edge.getEdgeData()));
        edge.getEdgeData().setTextData(this.newTextData());
        edge.getEdgeData().setId("" + edge.getId());
        return edge;
    }
}

