/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.event.ViewEvent;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.NodeDataImpl;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.utils.collection.avl.ParamAVLIterator;

public class GraphStructure {
    private final AtomicInteger viewId = new AtomicInteger(1);
    private final Dhns dhns;
    private final GraphViewImpl mainView;
    private final Queue<GraphViewImpl> views;
    private final GraphDictionnary dictionnary;
    private GraphViewImpl visibleView;
    private final Object lock = new Object();
    private final ConcurrentLinkedQueue<GraphViewImpl> destroyQueue;

    public GraphStructure(Dhns dhns) {
        this.dhns = dhns;
        this.views = new ConcurrentLinkedQueue<GraphViewImpl>();
        this.dictionnary = new GraphDictionnary();
        this.mainView = new GraphViewImpl(dhns, 0);
        this.views.add(this.mainView);
        this.visibleView = this.mainView;
        this.destroyQueue = new ConcurrentLinkedQueue();
        ViewDestructorThread viewDestructorThread = new ViewDestructorThread(this);
        viewDestructorThread.start();
    }

    public GraphViewImpl[] getViews() {
        return this.views.toArray(new GraphViewImpl[0]);
    }

    public GraphViewImpl getMainView() {
        return this.mainView;
    }

    public GraphViewImpl createView(int viewId) {
        this.viewId.set(Math.max(viewId + 1, this.viewId.get()));
        return new GraphViewImpl(this.dhns, viewId);
    }

    public GraphViewImpl getNewView() {
        return this.copyView(this.mainView);
    }

    public GraphViewImpl copyView(GraphViewImpl view) {
        GraphViewImpl viewCopy = new GraphViewImpl(this.dhns, this.viewId.getAndIncrement());
        TreeStructure newStructure = viewCopy.getStructure();
        this.dhns.writeLock();
        TreeListIterator itr = new TreeListIterator(view.getStructure().getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            AbstractNode nodeCopy = new AbstractNode(node.getNodeData(), viewCopy.getViewId());
            nodeCopy.setEnabled(node.isEnabled());
            nodeCopy.setEnabledInDegree(node.getEnabledInDegree());
            nodeCopy.setEnabledOutDegree(node.getEnabledOutDegree());
            nodeCopy.setEnabledMutualDegree(node.getEnabledMutualDegree());
            AbstractNode parentCopy = node.parent != null ? newStructure.getNodeAt(node.parent.getPre()) : null;
            newStructure.insertAsChild(nodeCopy, parentCopy);
        }
        ParamAVLIterator edgeIterator = new ParamAVLIterator();
        TreeListIterator itr2 = new TreeListIterator(view.getStructure().getTree(), 1);
        while (itr2.hasNext()) {
            AbstractNode node = itr2.next();
            if (node.getEdgesOutTree().isEmpty()) continue;
            edgeIterator.setNode(node.getEdgesOutTree());
            while (edgeIterator.hasNext()) {
                AbstractEdge edge = (AbstractEdge)edgeIterator.next();
                AbstractNode sourceCopy = newStructure.getNodeAt(edge.getSource().getPre());
                AbstractNode targetCopy = newStructure.getNodeAt(edge.getTarget().getPre());
                sourceCopy.getEdgesOutTree().add(edge);
                targetCopy.getEdgesInTree().add(edge);
                this.addToDictionnary(edge);
            }
        }
        viewCopy.setNodesEnabled(view.getNodesEnabled());
        viewCopy.setEdgesCountTotal(view.getEdgesCountTotal());
        viewCopy.setEdgesCountEnabled(view.getEdgesCountEnabled());
        viewCopy.setMutualEdgesTotal(view.getMutualEdgesTotal());
        viewCopy.setMutualEdgesEnabled(view.getMutualEdgesEnabled());
        viewCopy.getStructureModifier().getEdgeProcessor().computeMetaEdges();
        this.views.add(viewCopy);
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new ViewEvent(GraphEvent.EventType.NEW_VIEW, viewCopy));
        return viewCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyView(GraphViewImpl view) {
        if (this.views.contains(view)) {
            this.destroyQueue.add(view);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    public void addToDictionnary(AbstractNode node) {
        this.dictionnary.addNode(node);
    }

    public void removeFromDictionnary(AbstractNode node) {
        this.dictionnary.removeNode(node);
    }

    public void addToDictionnary(AbstractEdge edge) {
        this.dictionnary.addEdge(edge);
    }

    public void removeFromDictionnary(AbstractEdge edge) {
        this.dictionnary.removeEdge(edge);
    }

    public AbstractEdge getEdgeFromDictionnary(int id) {
        return this.dictionnary.getEdge(id);
    }

    public AbstractEdge getEdgeFromDictionnary(String id) {
        return this.dictionnary.getEdge(id);
    }

    public AbstractNode getNodeFromDictionnary(int id, int viewId) {
        return this.dictionnary.getNode(id, viewId);
    }

    public AbstractNode getNodeFromDictionnary(String id, int viewId) {
        return this.dictionnary.getNode(id, viewId);
    }

    public void setNodeId(NodeDataImpl node, String id) {
        String oldId = node.setId(id);
        this.dictionnary.setNodeId(oldId, id, node);
    }

    public void setEdgeId(AbstractEdge edge, String id) {
        String oldId = edge.getEdgeData().setId(id);
        this.dictionnary.setEdgeId(oldId, id, edge);
    }

    public GraphViewImpl getVisibleView() {
        return this.visibleView;
    }

    public void setVisibleView(GraphViewImpl visibleView) {
        if (this.visibleView == visibleView) {
            return;
        }
        this.visibleView = visibleView == null ? this.mainView : visibleView;
        this.dhns.getEventManager().fireEvent(new ViewEvent(GraphEvent.EventType.VISIBLE_VIEW, this.visibleView));
    }

    private static class GraphDictionnary {
        private final TObjectIntHashMap<String> nodesMap = new TObjectIntHashMap();
        private final TIntObjectHashMap<NodeDataImpl> nodesIntMap = new TIntObjectHashMap();
        private final TIntObjectHashMap<EdgeCounter> edgesRefCount = new TIntObjectHashMap();
        private final TObjectIntHashMap<String> edgesMap = new TObjectIntHashMap();

        public synchronized void addNode(AbstractNode node) {
            if (node.getNodeData().getId() != null) {
                this.nodesMap.put((Object)node.getNodeData().getId(), node.getId());
            }
            this.nodesIntMap.put(node.getId(), (Object)node.getNodeData());
        }

        public synchronized void removeNode(AbstractNode node) {
            if (node.getNodeData().getNodes().getCount() == 1) {
                if (node.getNodeData().getId() != null) {
                    this.nodesMap.remove((Object)node.getNodeData().getId());
                }
                this.nodesIntMap.remove(node.getId());
            }
        }

        public synchronized void addEdge(AbstractEdge edge) {
            EdgeCounter edgeCounter = (EdgeCounter)this.edgesRefCount.get(edge.getId());
            if (edgeCounter != null) {
                edgeCounter.inc();
            } else {
                edgeCounter = new EdgeCounter(edge);
                this.edgesRefCount.put(edge.getId(), (Object)edgeCounter);
                String id = edge.getEdgeData().getId();
                if (id != null) {
                    this.edgesMap.put((Object)id, edge.getId());
                }
            }
        }

        public synchronized void removeEdge(AbstractEdge edge) {
            EdgeCounter edgeCounter = (EdgeCounter)this.edgesRefCount.get(edge.getId());
            int count = edgeCounter.decAndGet();
            if (count == 0) {
                this.edgesRefCount.remove(edge.getId());
                String id = edge.getEdgeData().getId();
                if (id != null) {
                    this.edgesMap.remove((Object)id);
                }
            }
        }

        public synchronized AbstractNode getNode(int id, int viewId) {
            NodeDataImpl nodeDataImpl = (NodeDataImpl)this.nodesIntMap.get(id);
            if (nodeDataImpl != null) {
                return (AbstractNode)nodeDataImpl.getNode(viewId);
            }
            return null;
        }

        public synchronized AbstractNode getNode(String id, int viewId) {
            int natId = this.nodesMap.get((Object)id);
            if (natId != 0) {
                return this.getNode(natId, viewId);
            }
            return null;
        }

        public synchronized AbstractEdge getEdge(int id) {
            EdgeCounter edgeCounter = (EdgeCounter)this.edgesRefCount.get(id);
            if (edgeCounter != null) {
                return edgeCounter.edge;
            }
            return null;
        }

        public synchronized AbstractEdge getEdge(String id) {
            int natId = this.edgesMap.get((Object)id);
            if (natId != 0) {
                return this.getEdge(natId);
            }
            return null;
        }

        public synchronized void setNodeId(String oldId, String newId, NodeDataImpl node) {
            if (oldId != null) {
                int val = this.nodesMap.remove((Object)oldId);
                this.nodesMap.put((Object)newId, val);
            } else {
                this.nodesMap.put((Object)newId, node.getID());
            }
        }

        public synchronized void setEdgeId(String oldId, String newId, AbstractEdge edge) {
            if (oldId != null) {
                int val = this.edgesMap.remove((Object)oldId);
                this.edgesMap.put((Object)newId, val);
            } else {
                this.edgesMap.put((Object)newId, edge.getId());
            }
        }

        private static class EdgeCounter {
            protected final AbstractEdge edge;
            private int counter = 1;

            public EdgeCounter(AbstractEdge edge) {
                this.edge = edge;
            }

            private void inc() {
                ++this.counter;
            }

            private int decAndGet() {
                return --this.counter;
            }

            public boolean equals(Object obj) {
                if (obj != null && obj instanceof EdgeCounter) {
                    EdgeCounter e = (EdgeCounter)obj;
                    return e.edge.equals(this.edge);
                }
                if (obj != null && obj instanceof AbstractEdge) {
                    return obj.equals(this.edge);
                }
                return false;
            }

            public int hashCode() {
                return this.edge.hashCode();
            }
        }
    }

    private static class ViewDestructorThread
    extends Thread {
        private final WeakReference<GraphStructure> structureReference;
        private final int STD_TIMER = 300;
        private final int UNDESTRO_TIMER = 2000;
        private boolean running = true;

        public ViewDestructorThread(GraphStructure graphStructure) {
            super("DHNS View Destructor");
            this.setDaemon(true);
            this.structureReference = new WeakReference<GraphStructure>(graphStructure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GraphStructure structure = null;
            while (this.running && (structure = (GraphStructure)this.structureReference.get()) != null) {
                while (structure.destroyQueue.isEmpty()) {
                    try {
                        Object object = structure.lock;
                        synchronized (object) {
                            structure.lock.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                boolean undestroyableViews = false;
                for (GraphViewImpl v : structure.destroyQueue.toArray(new GraphViewImpl[0])) {
                    if (!v.hasGraphReference()) {
                        this.destroyView(structure, v);
                        structure.destroyQueue.remove(v);
                        continue;
                    }
                    undestroyableViews = true;
                }
                try {
                    Object object = structure.lock;
                    synchronized (object) {
                        structure.lock.wait(undestroyableViews ? 2000L : 300L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }

        private void destroyView(GraphStructure structure, GraphViewImpl view) {
            structure.dhns.writeLock();
            ParamAVLIterator edgeIterator = new ParamAVLIterator();
            TreeListIterator itr = new TreeListIterator(structure.mainView.getStructure().getTree(), 1);
            while (itr.hasNext()) {
                AbstractNode node = itr.next();
                AbstractNode nodeInView = node.getNodeData().getNodes().get(view.getViewId());
                if (nodeInView == null) continue;
                node.getNodeData().getNodes().remove(view.getViewId());
                if (nodeInView.getEdgesOutTree().isEmpty()) continue;
                edgeIterator.setNode(nodeInView.getEdgesOutTree());
                while (edgeIterator.hasNext()) {
                    AbstractEdge edge = (AbstractEdge)edgeIterator.next();
                    structure.removeFromDictionnary(edge);
                }
            }
            structure.views.remove(view);
            structure.dhns.writeUnlock();
            structure.dhns.getEventManager().fireEvent(new ViewEvent(GraphEvent.EventType.DESTROY_VIEW, view));
            if (structure.visibleView == view) {
                structure.visibleView = structure.mainView;
                structure.dhns.getEventManager().fireEvent(new ViewEvent(GraphEvent.EventType.VISIBLE_VIEW, structure.mainView));
            }
        }
    }
}

