/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.WeakHashMap;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.StructureModifier;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.graph.AbstractGraphImpl;

public class GraphViewImpl
implements GraphView {
    private final Dhns dhns;
    private final int viewId;
    private final TreeStructure structure;
    private final StructureModifier structureModifier;
    private int nodesEnabled;
    private int edgesCountTotal;
    private int mutualEdgesTotal;
    private int edgesCountEnabled;
    private int mutualEdgesEnabled;
    private int metaEdgesCountTotal;
    private int mutualMetaEdgesTotal;
    private final WeakHashMap<AbstractGraphImpl, Boolean> graphsMap = new WeakHashMap();

    public GraphViewImpl(Dhns dhns, int viewId) {
        this.dhns = dhns;
        this.viewId = viewId;
        this.structure = new TreeStructure(this);
        this.structureModifier = new StructureModifier(dhns, this);
    }

    public void addGraphReference(AbstractGraphImpl graph) {
        this.graphsMap.put(graph, Boolean.TRUE);
    }

    public boolean hasGraphReference() {
        return !this.graphsMap.isEmpty();
    }

    public int getViewId() {
        return this.viewId;
    }

    public TreeStructure getStructure() {
        return this.structure;
    }

    public StructureModifier getStructureModifier() {
        return this.structureModifier;
    }

    public boolean isMainView() {
        return this.viewId == 0;
    }

    public void incNodesEnabled(int shift) {
        this.nodesEnabled += shift;
    }

    public void decNodesEnabled(int shift) {
        this.nodesEnabled -= shift;
    }

    public void incEdgesCountTotal(int shift) {
        this.edgesCountTotal += shift;
    }

    public void incEdgesCountEnabled(int shift) {
        this.edgesCountEnabled += shift;
    }

    public void incMutualEdgesTotal(int shift) {
        this.mutualEdgesTotal += shift;
    }

    public void incMutualEdgesEnabled(int shift) {
        this.mutualEdgesEnabled += shift;
    }

    public void decEdgesCountTotal(int shift) {
        this.edgesCountTotal -= shift;
    }

    public void decEdgesCountEnabled(int shift) {
        this.edgesCountEnabled -= shift;
    }

    public void decMutualEdgesTotal(int shift) {
        this.mutualEdgesTotal -= shift;
    }

    public void decMutualEdgesEnabled(int shift) {
        this.mutualEdgesEnabled -= shift;
    }

    public void incMetaEdgesCount(int shift) {
        this.metaEdgesCountTotal += shift;
    }

    public void decMetaEdgesCount(int shift) {
        this.metaEdgesCountTotal -= shift;
    }

    public void incMutualMetaEdgesTotal(int shift) {
        this.mutualMetaEdgesTotal += shift;
    }

    public void decMutualMetaEdgesTotal(int shift) {
        this.mutualMetaEdgesTotal -= shift;
    }

    public int getEdgesCountEnabled() {
        return this.edgesCountEnabled;
    }

    public void setEdgesCountEnabled(int edgesCountEnabled) {
        this.edgesCountEnabled = edgesCountEnabled;
    }

    public int getEdgesCountTotal() {
        return this.edgesCountTotal;
    }

    public void setEdgesCountTotal(int edgesCountTotal) {
        this.edgesCountTotal = edgesCountTotal;
    }

    public int getMutualEdgesEnabled() {
        return this.mutualEdgesEnabled;
    }

    public void setMutualEdgesEnabled(int mutualEdgesEnabled) {
        this.mutualEdgesEnabled = mutualEdgesEnabled;
    }

    public int getMutualEdgesTotal() {
        return this.mutualEdgesTotal;
    }

    public void setMutualEdgesTotal(int mutualEdgesTotal) {
        this.mutualEdgesTotal = mutualEdgesTotal;
    }

    public int getNodesEnabled() {
        return this.nodesEnabled;
    }

    public void setNodesEnabled(int nodesEnabled) {
        this.nodesEnabled = nodesEnabled;
    }

    public int getMetaEdgesCountTotal() {
        return this.metaEdgesCountTotal;
    }

    public void setMetaEdgesCountTotal(int metaEdgesCountTotal) {
        this.metaEdgesCountTotal = metaEdgesCountTotal;
    }

    public int getMutualMetaEdgesTotal() {
        return this.mutualMetaEdgesTotal;
    }

    public void setMutualMetaEdgesTotal(int mutualMetaEdgesTotal) {
        this.mutualMetaEdgesTotal = mutualMetaEdgesTotal;
    }

    public Dhns getGraphModel() {
        return this.dhns;
    }
}

