/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.ArrayList;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.EdgeProcessor;
import org.gephi.graph.dhns.core.GraphVersion;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.event.EdgeEvent;
import org.gephi.graph.dhns.event.GeneralEvent;
import org.gephi.graph.dhns.event.NodeEvent;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.node.iterators.ChildrenIterator;
import org.gephi.graph.dhns.node.iterators.DescendantAndSelfIterator;
import org.gephi.graph.dhns.node.iterators.DescendantIterator;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.graph.dhns.predicate.Tautology;

public class StructureModifier {
    private final Dhns dhns;
    private final GraphVersion graphVersion;
    private final TreeStructure treeStructure;
    private final GraphViewImpl view;
    private final EdgeProcessor edgeProcessor;
    private final Business business;

    public StructureModifier(Dhns dhns, GraphViewImpl view) {
        this.dhns = dhns;
        this.view = view;
        this.treeStructure = view.getStructure();
        this.graphVersion = dhns.getGraphVersion();
        this.edgeProcessor = new EdgeProcessor(dhns, view);
        this.business = new Business();
    }

    public EdgeProcessor getEdgeProcessor() {
        return this.edgeProcessor;
    }

    public void expand(AbstractNode node) {
        this.dhns.writeLock();
        if (node.level < this.treeStructure.getTreeHeight()) {
            this.business.expand(node);
        }
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.EXPAND, node, this.view));
    }

    public void retract(AbstractNode node) {
        this.dhns.writeLock();
        if (node.level < this.treeStructure.getTreeHeight()) {
            this.business.retract(node);
        }
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.RETRACT, node, this.view));
    }

    public void addNode(AbstractNode node, AbstractNode parent) {
        this.dhns.writeLock();
        AbstractNode parentNode = parent == null ? this.treeStructure.getRoot() : parent;
        node.parent = parentNode;
        this.business.addNode(node);
        this.dhns.getGraphStructure().addToDictionnary(node);
        this.graphVersion.incNodeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.ADD_NODES, node, this.view));
    }

    public void deleteNode(AbstractNode node) {
        if (this.view.isMainView() && node.getNodeData().getNodes().getCount() > 1) {
            this.dhns.writeLock();
            AbstractNodeIterator itr = node.getNodeData().getNodes().iterator();
            while (itr.hasNext()) {
                AbstractNode nodeInOtherView = itr.next();
                if (nodeInOtherView.getViewId() == this.view.getViewId()) continue;
                GraphViewImpl otherView = nodeInOtherView.avlNode.getList().getView();
                this.business.deleteNode(nodeInOtherView, otherView);
            }
            AbstractNode[] deletesNodes = this.business.deleteNode(node, this.view);
            this.graphVersion.incNodeAndEdgeVersion();
            this.dhns.writeUnlock();
            for (int i = 0; i < deletesNodes.length; ++i) {
                this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.REMOVE_NODES, deletesNodes[i], this.view));
            }
        } else {
            this.dhns.writeLock();
            AbstractNode[] deletesNodes = this.business.deleteNode(node, this.view);
            this.graphVersion.incNodeAndEdgeVersion();
            this.dhns.writeUnlock();
            for (int i = 0; i < deletesNodes.length; ++i) {
                this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.REMOVE_NODES, deletesNodes[i], this.view));
            }
        }
    }

    public void addEdge(AbstractEdge edge) {
        this.dhns.writeLock();
        this.business.addEdge(edge);
        this.graphVersion.incEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.ADD_EDGES, edge, this.view));
    }

    public boolean deleteEdge(AbstractEdge edge) {
        this.dhns.writeLock();
        boolean res = this.business.delEdge(edge);
        this.graphVersion.incEdgeVersion();
        this.dhns.writeUnlock();
        if (res) {
            this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.REMOVE_EDGES, edge, this.view));
        }
        return res;
    }

    public boolean deleteMetaEdge(AbstractEdge edge) {
        this.dhns.writeLock();
        boolean res = this.business.delMetaEdge((MetaEdgeImpl)edge);
        this.graphVersion.incEdgeVersion();
        this.dhns.writeUnlock();
        return res;
    }

    public void clear() {
        int i;
        this.dhns.writeLock();
        AbstractEdge[] clearedEdges = this.business.clearAllEdges();
        AbstractNode[] clearedNodes = this.business.clearAllNodes();
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        if (clearedEdges != null) {
            for (i = 0; i < clearedEdges.length; ++i) {
                if (clearedEdges[i] == null) continue;
                this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.REMOVE_EDGES, clearedEdges[i], this.view));
            }
        }
        if (clearedNodes != null) {
            for (i = 0; i < clearedNodes.length; ++i) {
                if (clearedNodes[i] == null) continue;
                this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.REMOVE_NODES, clearedNodes[i], this.view));
            }
        }
    }

    public void clearEdges() {
        this.dhns.writeLock();
        AbstractEdge[] clearedEdges = this.business.clearAllEdges();
        this.graphVersion.incEdgeVersion();
        this.dhns.writeUnlock();
        if (clearedEdges != null) {
            for (int i = 0; i < clearedEdges.length; ++i) {
                if (clearedEdges[i] == null) continue;
                this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.REMOVE_EDGES, clearedEdges[i], this.view));
            }
        }
    }

    public void clearEdges(AbstractNode node) {
        this.dhns.writeLock();
        AbstractEdge[] clearedEdges = this.business.clearEdges(node);
        this.graphVersion.incEdgeVersion();
        this.dhns.writeUnlock();
        if (clearedEdges != null) {
            for (int i = 0; i < clearedEdges.length; ++i) {
                if (clearedEdges[i] == null) continue;
                this.dhns.getGraphStructure().removeFromDictionnary(clearedEdges[i]);
                this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.REMOVE_EDGES, clearedEdges[i], this.view));
            }
        }
    }

    public void clearMetaEdges(AbstractNode node) {
        this.dhns.writeLock();
        this.business.clearMetaEdges(node);
        this.graphVersion.incEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new GeneralEvent(GraphEvent.EventType.META_EDGES_UPDATE, this.view));
    }

    public void resetViewToLeaves() {
        AbstractNode node;
        this.dhns.writeLock();
        this.edgeProcessor.clearAllMetaEdges();
        this.view.setNodesEnabled(0);
        AbstractNodeIterator itr = new TreeListIterator(this.treeStructure.getTree(), 1);
        while (((TreeListIterator)itr).hasNext()) {
            node = ((TreeListIterator)itr).next();
            node.setEnabled(node.size == 0);
            if (node.isEnabled()) {
                this.view.incNodesEnabled(1);
            }
            this.edgeProcessor.resetEdgesCounting(node);
        }
        this.view.setEdgesCountEnabled(0);
        this.view.setMutualEdgesEnabled(0);
        itr = new TreeIterator(this.treeStructure, true, Tautology.instance);
        while (((TreeIterator)itr).hasNext()) {
            node = ((TreeIterator)itr).next();
            this.edgeProcessor.computeMetaEdges(node, node);
            this.edgeProcessor.computeEdgesCounting(node);
        }
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new GeneralEvent(GraphEvent.EventType.META_EDGES_UPDATE, this.view));
    }

    public void resetViewToTopNodes() {
        AbstractNode node;
        this.dhns.writeLock();
        this.edgeProcessor.clearAllMetaEdges();
        this.view.setNodesEnabled(0);
        AbstractNodeIterator itr = new TreeListIterator(this.treeStructure.getTree(), 1);
        while (((TreeListIterator)itr).hasNext()) {
            node = ((TreeListIterator)itr).next();
            node.setEnabled(node.parent == this.treeStructure.root);
            if (node.isEnabled()) {
                this.view.incNodesEnabled(1);
            }
            this.edgeProcessor.resetEdgesCounting(node);
        }
        this.view.setEdgesCountEnabled(0);
        this.view.setMutualEdgesEnabled(0);
        itr = new TreeIterator(this.treeStructure, true, Tautology.instance);
        while (((TreeIterator)itr).hasNext()) {
            node = ((TreeIterator)itr).next();
            this.edgeProcessor.computeMetaEdges(node, node);
            this.edgeProcessor.computeEdgesCounting(node);
        }
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new GeneralEvent(GraphEvent.EventType.META_EDGES_UPDATE, this.view));
    }

    public void resetViewToLevel(int level) {
        AbstractNode node;
        this.dhns.writeLock();
        this.edgeProcessor.clearAllMetaEdges();
        this.view.setNodesEnabled(0);
        AbstractNodeIterator itr = new TreeListIterator(this.treeStructure.getTree(), 1);
        while (((TreeListIterator)itr).hasNext()) {
            node = ((TreeListIterator)itr).next();
            node.setEnabled(node.level == level);
            if (node.isEnabled()) {
                this.view.incNodesEnabled(1);
            }
            this.edgeProcessor.resetEdgesCounting(node);
        }
        this.view.setEdgesCountEnabled(0);
        this.view.setMutualEdgesEnabled(0);
        itr = new TreeIterator(this.treeStructure, true, Tautology.instance);
        while (((TreeIterator)itr).hasNext()) {
            node = ((TreeIterator)itr).next();
            this.edgeProcessor.computeMetaEdges(node, node);
            this.edgeProcessor.computeEdgesCounting(node);
        }
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new GeneralEvent(GraphEvent.EventType.META_EDGES_UPDATE, this.view));
    }

    public void moveToGroup(AbstractNode node, AbstractNode nodeGroup) {
        this.dhns.writeLock();
        this.business.moveToGroup(node, nodeGroup);
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.MOVE_NODES, node, this.view));
    }

    public Node group(AbstractNode[] nodes) {
        this.dhns.writeLock();
        AbstractNode group = this.dhns.factory().newNode(this.view.getViewId());
        this.business.group(group, nodes);
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.getGraphStructure().addToDictionnary(group);
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.ADD_NODES, group, this.view));
        for (int i = 0; i < nodes.length; ++i) {
            this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.MOVE_NODES, nodes[i], this.view));
        }
        return group;
    }

    public void ungroup(AbstractNode nodeGroup) {
        this.dhns.writeLock();
        AbstractNode[] ungroupedNodes = this.business.ungroup(nodeGroup);
        this.graphVersion.incNodeAndEdgeVersion();
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.REMOVE_NODES, nodeGroup, this.view));
        for (int i = 0; i < ungroupedNodes.length; ++i) {
            this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.MOVE_NODES, ungroupedNodes[i], this.view));
        }
    }

    public void flatten() {
        this.dhns.writeLock();
        if (this.treeStructure.getTreeHeight() > 1) {
            TreeIterator nodesIterator = new TreeIterator(this.treeStructure, true, Tautology.instance);
            while (nodesIterator.hasNext()) {
                AbstractNode node = nodesIterator.next();
                AbstractEdge[] newEdges = this.edgeProcessor.flattenNode(node);
                if (newEdges == null) continue;
                for (int i = 0; i < newEdges.length; ++i) {
                    AbstractEdge e = newEdges[i];
                    if (e == null) continue;
                    this.dhns.getGraphStructure().addToDictionnary(e);
                    this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.ADD_EDGES, e, this.view));
                }
            }
            ArrayList<AbstractNode> nodesToDelete = new ArrayList<AbstractNode>();
            ArrayList<AbstractNode> nodesToKeep = new ArrayList<AbstractNode>();
            TreeListIterator itr = new TreeListIterator(this.treeStructure.getTree(), 1);
            while (itr.hasNext()) {
                AbstractNode node = itr.next();
                if (!node.isEnabled()) {
                    nodesToDelete.add(node);
                    continue;
                }
                nodesToKeep.add(node);
            }
            for (AbstractNode node : nodesToDelete) {
                AbstractEdge[] deletedEdges = this.edgeProcessor.clearEdges(node);
                if (deletedEdges != null) {
                    for (int j = 0; j < deletedEdges.length; ++j) {
                        if (deletedEdges[j] == null) continue;
                        this.dhns.getGraphStructure().removeFromDictionnary(deletedEdges[j]);
                        this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.REMOVE_EDGES, deletedEdges[j], this.view));
                    }
                }
                this.dhns.getGraphStructure().removeFromDictionnary(node);
                this.treeStructure.deleteOnlySelf(node);
                this.dhns.getEventManager().fireEvent(new NodeEvent(GraphEvent.EventType.REMOVE_NODES, node, this.view));
            }
            for (AbstractNode node : nodesToKeep) {
                node.size = 0;
                node.parent = this.treeStructure.root;
                node.level = 1;
                node.getPost();
            }
            this.treeStructure.root.size = nodesToKeep.size();
            this.treeStructure.root.getPost();
            this.treeStructure.resetLevelSize(nodesToKeep.size());
            this.graphVersion.incNodeAndEdgeVersion();
        }
        this.dhns.writeUnlock();
        this.dhns.getEventManager().fireEvent(new GeneralEvent(GraphEvent.EventType.META_EDGES_UPDATE, this.view));
    }

    private class Business {
        private Business() {
        }

        private void expand(AbstractNode absNode) {
            AbstractNode child;
            absNode.setEnabled(false);
            StructureModifier.this.view.decNodesEnabled(1);
            StructureModifier.this.edgeProcessor.clearMetaEdges(absNode);
            ChildrenIterator itr = new ChildrenIterator(StructureModifier.this.treeStructure, absNode, Tautology.instance);
            while (itr.hasNext()) {
                child = itr.next();
                child.setEnabled(true);
                StructureModifier.this.view.incNodesEnabled(1);
                StructureModifier.this.edgeProcessor.computeMetaEdges(child, child);
            }
            itr = new ChildrenIterator(StructureModifier.this.treeStructure, absNode, Tautology.instance);
            while (itr.hasNext()) {
                child = itr.next();
                StructureModifier.this.edgeProcessor.incrementEdgesCounting(child, absNode);
            }
            StructureModifier.this.edgeProcessor.decrementEdgesCouting(absNode, null);
        }

        private void retract(AbstractNode parent) {
            AbstractNode child;
            ChildrenIterator itr = new ChildrenIterator(StructureModifier.this.treeStructure, parent, Tautology.instance);
            while (itr.hasNext()) {
                child = itr.next();
                child.setEnabled(false);
                StructureModifier.this.view.decNodesEnabled(1);
                StructureModifier.this.edgeProcessor.clearMetaEdges(child);
            }
            parent.setEnabled(true);
            StructureModifier.this.view.incNodesEnabled(1);
            StructureModifier.this.edgeProcessor.computeMetaEdges(parent, parent);
            itr = new ChildrenIterator(StructureModifier.this.treeStructure, parent, Tautology.instance);
            while (itr.hasNext()) {
                child = itr.next();
                StructureModifier.this.edgeProcessor.decrementEdgesCouting(child, parent);
            }
            StructureModifier.this.edgeProcessor.incrementEdgesCounting(parent, null);
        }

        private void addNode(AbstractNode node) {
            boolean enabled = StructureModifier.this.treeStructure.getEnabledAncestor(node) == null;
            node.setEnabled(enabled);
            StructureModifier.this.treeStructure.insertAsChild(node, node.parent);
            if (node.isEnabled()) {
                StructureModifier.this.view.incNodesEnabled(1);
            }
        }

        private void addEdge(AbstractEdge edge) {
            AbstractNode sourceNode = edge.getSource(StructureModifier.this.view.getViewId());
            AbstractNode targetNode = edge.getTarget(StructureModifier.this.view.getViewId());
            boolean enabled = sourceNode.isEnabled() && targetNode.isEnabled();
            sourceNode.getEdgesOutTree().add(edge);
            targetNode.getEdgesInTree().add(edge);
            if (!edge.isSelfLoop() && sourceNode.getEdgesInTree().hasNeighbour(targetNode)) {
                StructureModifier.this.view.incMutualEdgesTotal(1);
                if (enabled) {
                    sourceNode.incEnabledMutualDegree();
                    targetNode.incEnabledMutualDegree();
                    StructureModifier.this.view.incMutualEdgesEnabled(1);
                }
            }
            StructureModifier.this.view.incEdgesCountTotal(1);
            if (enabled) {
                StructureModifier.this.view.incEdgesCountEnabled(1);
                sourceNode.incEnabledOutDegree();
                targetNode.incEnabledInDegree();
            }
            StructureModifier.this.dhns.getGraphStructure().addToDictionnary(edge);
            if (!edge.isSelfLoop()) {
                StructureModifier.this.edgeProcessor.createMetaEdge(edge);
            }
        }

        private AbstractNode[] deleteNode(AbstractNode node, GraphViewImpl graphView) {
            AbstractNode[] descendants = new AbstractNode[node.size + 1];
            int i = 0;
            DescendantAndSelfIterator itr = new DescendantAndSelfIterator(graphView.getStructure(), node, Tautology.instance);
            while (itr.hasNext()) {
                AbstractEdge[] deletedEdges;
                AbstractNode descendant;
                descendants[i] = descendant = itr.next();
                if (descendant.isEnabled()) {
                    graphView.getStructureModifier().edgeProcessor.clearMetaEdges(descendant);
                    graphView.decNodesEnabled(1);
                }
                if ((deletedEdges = graphView.getStructureModifier().edgeProcessor.clearEdges(descendant)) != null) {
                    for (int j = 0; j < deletedEdges.length; ++j) {
                        if (deletedEdges[j] == null) continue;
                        StructureModifier.this.dhns.getGraphStructure().removeFromDictionnary(deletedEdges[j]);
                        StructureModifier.this.dhns.getEventManager().fireEvent(new EdgeEvent(GraphEvent.EventType.REMOVE_EDGES, deletedEdges[j], graphView));
                    }
                }
                StructureModifier.this.dhns.getGraphStructure().removeFromDictionnary(descendant);
                ++i;
            }
            graphView.getStructure().deleteDescendantAndSelf(node);
            return descendants;
        }

        private boolean delEdge(AbstractEdge edge) {
            boolean res;
            boolean enabled;
            AbstractNode source = edge.getSource(StructureModifier.this.view.getViewId());
            AbstractNode target = edge.getTarget(StructureModifier.this.view.getViewId());
            boolean bl = enabled = source.isEnabled() && target.isEnabled();
            if (!edge.isSelfLoop() && source.getEdgesInTree().hasNeighbour(target)) {
                if (enabled) {
                    StructureModifier.this.view.decMutualEdgesEnabled(1);
                    source.decEnabledMutualDegree();
                    target.decEnabledMutualDegree();
                }
                StructureModifier.this.view.decMutualEdgesTotal(1);
            }
            StructureModifier.this.view.decEdgesCountTotal(1);
            if (enabled) {
                StructureModifier.this.view.decEdgesCountEnabled(1);
                source.decEnabledOutDegree();
                target.decEnabledInDegree();
            }
            res = (res = source.getEdgesOutTree().remove(edge)) && target.getEdgesInTree().remove(edge);
            StructureModifier.this.dhns.getGraphStructure().removeFromDictionnary(edge);
            StructureModifier.this.edgeProcessor.removeEdgeFromMetaEdge(edge);
            return res;
        }

        public boolean delMetaEdge(MetaEdgeImpl edge) {
            AbstractNode source = edge.getSource(StructureModifier.this.view.getViewId());
            AbstractNode target = edge.getTarget(StructureModifier.this.view.getViewId());
            if (!edge.isSelfLoop() && source.getEdgesInTree().hasNeighbour(target)) {
                StructureModifier.this.view.decMutualMetaEdgesTotal(1);
                source.decMutualMetaEdgeDegree();
                target.decMutualMetaEdgeDegree();
            }
            StructureModifier.this.view.decMetaEdgesCount(1);
            boolean res = source.getMetaEdgesOutTree().remove(edge);
            res = res && target.getMetaEdgesInTree().remove(edge);
            return res;
        }

        private AbstractEdge[] clearAllEdges() {
            return StructureModifier.this.edgeProcessor.clearAllEdges();
        }

        private AbstractNode[] clearAllNodes() {
            AbstractNode[] deletedNodes = new AbstractNode[StructureModifier.this.treeStructure.getTreeSize() - 1];
            int n = 0;
            TreeListIterator itr = new TreeListIterator(StructureModifier.this.treeStructure.getTree(), 1);
            while (itr.hasNext()) {
                AbstractNode node = itr.next();
                node.getNodeData().getNodes().remove(StructureModifier.this.view.getViewId());
                StructureModifier.this.dhns.getGraphStructure().removeFromDictionnary(node);
                deletedNodes[n++] = node;
            }
            StructureModifier.this.treeStructure.clear();
            StructureModifier.this.view.setNodesEnabled(0);
            return deletedNodes;
        }

        private AbstractEdge[] clearEdges(AbstractNode node) {
            return StructureModifier.this.edgeProcessor.clearEdges(node);
        }

        private void clearMetaEdges(AbstractNode node) {
            StructureModifier.this.edgeProcessor.clearMetaEdges(node);
        }

        private void group(AbstractNode group, AbstractNode[] nodes) {
            AbstractNode parent;
            group.setEnabled(true);
            group.parent = parent = nodes[0].parent;
            StructureModifier.this.business.addNode(group);
            for (int i = 0; i < nodes.length; ++i) {
                AbstractNode nodeToGroup = nodes[i];
                nodeToGroup = nodeToGroup.getInView(StructureModifier.this.view.getViewId());
                StructureModifier.this.business.moveToGroup(nodeToGroup, group);
            }
        }

        private AbstractNode[] ungroup(AbstractNode nodeGroup) {
            int count = 0;
            ChildrenIterator itr = new ChildrenIterator(StructureModifier.this.treeStructure, nodeGroup, Tautology.instance);
            while (itr.hasNext()) {
                itr.next();
                ++count;
            }
            AbstractNode[] ungroupedNodes = new AbstractNode[count];
            if (nodeGroup.isEnabled()) {
                StructureModifier.this.business.expand(nodeGroup);
            }
            for (int i = 0; i < count; ++i) {
                AbstractNode node = StructureModifier.this.treeStructure.getNodeAt(nodeGroup.getPre() + 1);
                StructureModifier.this.business.moveToGroup(node, nodeGroup.parent);
                ungroupedNodes[i] = node;
            }
            StructureModifier.this.business.deleteNode(nodeGroup, StructureModifier.this.view);
            return ungroupedNodes;
        }

        private void moveToGroup(AbstractNode node, AbstractNode nodeGroup) {
            AbstractNode destinationAncestor;
            AbstractNode toMoveAncestor = StructureModifier.this.treeStructure.getEnabledAncestor(node);
            if (toMoveAncestor != (destinationAncestor = StructureModifier.this.treeStructure.getEnabledAncestorOrSelf(nodeGroup))) {
                if (toMoveAncestor != null) {
                    if (node.size > 0) {
                        DescendantAndSelfIterator itr = new DescendantAndSelfIterator(StructureModifier.this.treeStructure, node, Tautology.instance);
                        while (itr.hasNext()) {
                            AbstractNode descendant = itr.next();
                            StructureModifier.this.edgeProcessor.clearEdgesWithoutRemove(descendant);
                        }
                    } else {
                        StructureModifier.this.edgeProcessor.clearEdgesWithoutRemove(node);
                    }
                } else if (node.isEnabled()) {
                    if (destinationAncestor != null) {
                        StructureModifier.this.edgeProcessor.clearMetaEdges(node);
                        node.setEnabled(false);
                        StructureModifier.this.view.decNodesEnabled(1);
                        StructureModifier.this.edgeProcessor.decrementEdgesCouting(node, null);
                    } else {
                        StructureModifier.this.edgeProcessor.clearMetaEdgesOutOfRange(node, nodeGroup);
                    }
                } else if (node.size > 0) {
                    if (destinationAncestor != null) {
                        DescendantIterator itr = new DescendantIterator(StructureModifier.this.treeStructure, node, Tautology.instance);
                        while (itr.hasNext()) {
                            AbstractNode descendant = itr.next();
                            if (!descendant.isEnabled()) continue;
                            StructureModifier.this.edgeProcessor.clearMetaEdges(descendant);
                            descendant.setEnabled(false);
                            StructureModifier.this.view.decNodesEnabled(1);
                            StructureModifier.this.edgeProcessor.decrementEdgesCouting(descendant, null);
                        }
                    } else {
                        DescendantIterator itr = new DescendantIterator(StructureModifier.this.treeStructure, node, Tautology.instance);
                        while (itr.hasNext()) {
                            AbstractNode descendant = itr.next();
                            if (!descendant.isEnabled()) continue;
                            StructureModifier.this.edgeProcessor.clearMetaEdgesOutOfRange(node, nodeGroup);
                        }
                    }
                }
            }
            StructureModifier.this.treeStructure.move(node, nodeGroup);
            if (destinationAncestor != null) {
                destinationAncestor.getPre();
                StructureModifier.this.edgeProcessor.computeMetaEdges(node, destinationAncestor);
            }
        }
    }
}

