/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge;

import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.dhns.edge.EdgeDataImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.utils.collection.avl.AVLItem;

public abstract class AbstractEdge
implements Edge,
AVLItem {
    protected final int ID;
    protected final AbstractNode source;
    protected final AbstractNode target;
    protected EdgeDataImpl edgeData;

    public AbstractEdge(int ID, AbstractNode source, AbstractNode target) {
        this.source = source;
        this.target = target;
        this.ID = ID;
        this.edgeData = new EdgeDataImpl(this);
    }

    public AbstractEdge(AbstractEdge edge, AbstractNode source, AbstractNode target) {
        this.source = source;
        this.target = target;
        this.ID = edge.ID;
        this.edgeData = edge.edgeData;
    }

    public AbstractNode getSource() {
        return this.source;
    }

    public AbstractNode getTarget() {
        return this.target;
    }

    public AbstractNode getSource(int viewId) {
        return this.source.getInView(viewId);
    }

    public AbstractNode getTarget(int viewId) {
        return this.target.getInView(viewId);
    }

    public float getWeight() {
        return this.edgeData.getWeight();
    }

    public float getWeight(double low, double high) {
        return this.edgeData.getWeight(low, high);
    }

    public void setWeight(float weight) {
        this.edgeData.setWeight(weight);
    }

    public int getNumber() {
        return this.ID;
    }

    public EdgeDataImpl getEdgeData() {
        return this.edgeData;
    }

    public AbstractEdge getUndirected(int viewId) {
        if (this.source == this.target) {
            return this;
        }
        AbstractEdge mutual = (AbstractEdge)this.getSource(viewId).getEdgesInTree().getItem(this.target.getNumber());
        if (mutual != null && mutual.getId() < this.ID) {
            return mutual;
        }
        return this;
    }

    public boolean isDirected() {
        return true;
    }

    public boolean isSelfLoop() {
        return this.source == this.target;
    }

    public boolean isValid(int viewId) {
        return this.source.isValid(viewId) && this.target.isValid(viewId);
    }

    public boolean isValid() {
        return this.source.avlNode != null && this.target.avlNode != null;
    }

    public boolean isMetaEdge() {
        return false;
    }

    public boolean isMixed() {
        return false;
    }

    public boolean hasAttributes() {
        return this.edgeData.getAttributes() != null;
    }

    public void setAttributes(Attributes attributes) {
        if (attributes != null) {
            this.edgeData.setAttributes(attributes);
        }
    }

    public int getId() {
        return this.ID;
    }

    public String toString() {
        return this.source.getId() + "-" + this.target.getId();
    }
}

