/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.MetaEdge;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.MetaEdgeBuilder;

public class AverageMetaEdgeBuilder
implements MetaEdgeBuilder {
    private float nonDeepDivisor = 1.0f;

    public AverageMetaEdgeBuilder() {
    }

    public AverageMetaEdgeBuilder(float divisor) {
        this.nonDeepDivisor = divisor;
    }

    public void pushEdge(Edge edge, Node source, Node target, MetaEdge metaEdge) {
        float edgeWeight = edge.getWeight();
        float metaWeight = metaEdge.getWeight();
        float edgeCount = metaEdge.getCount();
        float div = 1.0f;
        if (source == metaEdge.getSource() || source == metaEdge.getTarget() || target == metaEdge.getTarget() || target == metaEdge.getSource()) {
            div = this.nonDeepDivisor;
        }
        metaWeight = (metaWeight * edgeCount + (edgeWeight /= div)) / (edgeCount + 1.0f);
        metaEdge.setWeight(metaWeight);
    }

    public void pullEdge(Edge edge, Node source, Node target, MetaEdge metaEdge) {
        float edgeWeight = edge.getWeight();
        float metaWeight = metaEdge.getWeight();
        float edgeCount = metaEdge.getCount();
        float div = 1.0f;
        if (source == metaEdge.getSource() || source == metaEdge.getTarget() || target == metaEdge.getTarget() || target == metaEdge.getSource()) {
            div = this.nonDeepDivisor;
        }
        metaWeight = (metaWeight * edgeCount - (edgeWeight /= div)) / (edgeCount - 1.0f);
        metaEdge.setWeight(metaWeight);
    }
}

