/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge;

import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicFloat;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.Model;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.TextData;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.spi.LayoutData;

public class EdgeDataImpl
implements EdgeData {
    protected AbstractEdge edge;
    protected LayoutData layoutData;
    protected float r = -1.0f;
    protected float g = 0.0f;
    protected float b = 0.0f;
    protected float alpha = 1.0f;
    private String label;
    private Model model;
    protected Attributes attributes;
    protected TextData textData;

    public EdgeDataImpl(AbstractEdge edge) {
        this.edge = edge;
    }

    public AbstractEdge getEdge() {
        return this.edge;
    }

    public NodeData getSource() {
        return this.edge.getSource().getNodeData();
    }

    public NodeData getTarget() {
        return this.edge.getTarget().getNodeData();
    }

    public String getLabel() {
        if (this.attributes != null) {
            return (String)this.attributes.getValue(PropertiesColumn.EDGE_LABEL.getIndex());
        }
        return this.label;
    }

    public LayoutData getLayoutData() {
        return this.layoutData;
    }

    public void setLayoutData(LayoutData layoutData) {
        this.layoutData = layoutData;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public float x() {
        return (this.getSource().x() + 2.0f * this.getTarget().x()) / 3.0f;
    }

    public float y() {
        return (this.getSource().y() + 2.0f * this.getTarget().y()) / 3.0f;
    }

    public float z() {
        return (this.getSource().z() + 2.0f * this.getTarget().z()) / 3.0f;
    }

    public void setX(float x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setY(float y) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setZ(float z) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getRadius() {
        return 0.0f;
    }

    public float getSize() {
        return this.edge.getWeight();
    }

    public void setSize(float size) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float r() {
        return this.r;
    }

    public float g() {
        return this.g;
    }

    public float b() {
        return this.b;
    }

    public void setR(float r) {
        this.r = r;
    }

    public void setG(float g) {
        this.g = g;
    }

    public void setB(float b) {
        this.b = b;
    }

    public void setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public float alpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model obj) {
        this.model = obj;
    }

    public TextData getTextData() {
        return this.textData;
    }

    public void setTextData(TextData textData) {
        this.textData = textData;
    }

    public void setLabel(String label) {
        if (this.attributes != null) {
            this.attributes.setValue(PropertiesColumn.EDGE_LABEL.getIndex(), (Object)label);
        } else {
            this.label = label;
        }
    }

    public String setId(String id) {
        if (this.attributes == null) {
            return null;
        }
        String oldId = (String)this.attributes.getValue(PropertiesColumn.EDGE_ID.getIndex());
        this.attributes.setValue(PropertiesColumn.EDGE_ID.getIndex(), (Object)id);
        return oldId;
    }

    public String getId() {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.getValue(PropertiesColumn.EDGE_ID.getIndex());
    }

    public float getWeight() {
        if (this.attributes == null) {
            return 1.0f;
        }
        Object weight = this.attributes.getValue(PropertiesColumn.EDGE_WEIGHT.getIndex());
        if (weight instanceof DynamicFloat) {
            weight = ((DynamicFloat)weight).getValue(Estimator.AVERAGE);
        }
        if (weight == null) {
            return 1.0f;
        }
        return ((Float)weight).floatValue();
    }

    public float getWeight(double low, double high) {
        if (this.attributes == null) {
            return 1.0f;
        }
        Object weight = this.attributes.getValue(PropertiesColumn.EDGE_WEIGHT.getIndex());
        if (weight instanceof DynamicFloat) {
            weight = ((DynamicFloat)weight).getValue(low, high, Estimator.AVERAGE);
        }
        if (weight == null) {
            return 1.0f;
        }
        return ((Float)weight).floatValue();
    }

    public void setWeight(float weight) {
        if (this.attributes != null && !((AttributeRow)this.attributes).getColumnAt(PropertiesColumn.EDGE_WEIGHT.getIndex()).getType().equals((Object)AttributeType.DYNAMIC_FLOAT)) {
            this.attributes.setValue(PropertiesColumn.EDGE_WEIGHT.getIndex(), (Object)Float.valueOf(weight));
        }
    }

    public void moveFrom(EdgeData edgeData) {
        this.r = edgeData.r();
        this.g = edgeData.g();
        this.b = edgeData.b();
        this.alpha = edgeData.alpha();
        this.label = edgeData.getLabel();
        this.textData = edgeData.getTextData();
        if (this.attributes != null) {
            ((AttributeRow)this.attributes).setValues((AttributeRow)edgeData.getAttributes());
        }
    }
}

