/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.MetaEdge;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.MetaEdgeBuilder;

public class SumMetaEdgeBuilder
implements MetaEdgeBuilder {
    private float nonDeepDivisor = 1.0f;

    public SumMetaEdgeBuilder() {
    }

    public SumMetaEdgeBuilder(float divisor) {
        this.nonDeepDivisor = divisor;
    }

    public void pushEdge(Edge edge, Node source, Node target, MetaEdge metaEdge) {
        float edgeWeight = edge.getWeight();
        float metaWeight = metaEdge.getWeight();
        float div = 1.0f;
        if (edge.getSource() == metaEdge.getSource() || edge.getSource() == metaEdge.getTarget() || edge.getTarget() == metaEdge.getTarget() || edge.getTarget() == metaEdge.getSource()) {
            div = this.nonDeepDivisor;
        }
        metaEdge.setWeight(metaWeight += edgeWeight / div);
    }

    public void pullEdge(Edge edge, Node source, Node target, MetaEdge metaEdge) {
        float edgeWeight = edge.getWeight();
        float metaWeight = metaEdge.getWeight();
        float div = 1.0f;
        if (source == metaEdge.getSource() || source == metaEdge.getTarget() || target == metaEdge.getTarget() || target == metaEdge.getSource()) {
            div = this.nonDeepDivisor;
        }
        metaEdge.setWeight(metaWeight -= edgeWeight / div);
    }
}

