/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.utils.avl.MetaEdgeTree;
import org.gephi.utils.collection.avl.ParamAVLIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaEdgeNodeIterator
extends AbstractEdgeIterator
implements Iterator<Edge> {
    protected ParamAVLIterator<MetaEdgeImpl> edgeIterator;
    protected EdgeNodeIteratorMode mode;
    protected MetaEdgeImpl pointer;
    protected boolean undirected;
    protected MetaEdgeTree outTree;
    protected MetaEdgeTree inTree;

    public MetaEdgeNodeIterator(MetaEdgeTree outTree, MetaEdgeTree inTree, EdgeNodeIteratorMode mode, boolean undirected) {
        this.outTree = outTree;
        this.inTree = inTree;
        this.mode = mode;
        this.edgeIterator = new ParamAVLIterator();
        if (mode.equals((Object)EdgeNodeIteratorMode.OUT) || mode.equals((Object)EdgeNodeIteratorMode.BOTH)) {
            this.edgeIterator.setNode(outTree);
        } else {
            this.edgeIterator.setNode(inTree);
        }
        this.undirected = undirected;
    }

    @Override
    public boolean hasNext() {
        while (this.pointer == null || this.undirected && this.pointer.getUndirected() != this.pointer) {
            if (this.mode.equals((Object)EdgeNodeIteratorMode.BOTH)) {
                boolean res = this.edgeIterator.hasNext();
                if (res) {
                    this.pointer = this.edgeIterator.next();
                    if (!this.pointer.isSelfLoop()) continue;
                    this.pointer = null;
                    continue;
                }
                this.edgeIterator.setNode(this.inTree);
                this.mode = EdgeNodeIteratorMode.IN;
                continue;
            }
            if (this.edgeIterator.hasNext()) {
                this.pointer = this.edgeIterator.next();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public AbstractEdge next() {
        MetaEdgeImpl e = this.pointer;
        this.pointer = null;
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeNodeIteratorMode {
        OUT,
        IN,
        BOTH;

    }
}

