/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.node.iterators.DescendantAndSelfIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.utils.collection.avl.ParamAVLIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeEdgeIterator
extends AbstractEdgeIterator
implements Iterator<Edge> {
    protected AbstractNodeIterator nodeIterator;
    protected ParamAVLIterator<AbstractEdge> edgeIterator;
    protected AbstractNode currentNode;
    protected AbstractEdge pointer;
    protected boolean IN = false;
    protected boolean inner;
    protected int rangeStart;
    protected int rangeLimit;
    protected AbstractNode nodeGroup;
    protected boolean undirected;
    protected Predicate<AbstractEdge> edgePredicate;
    protected Predicate<AbstractNode> nodePredicate;
    protected int viewId;

    public RangeEdgeIterator(TreeStructure treeStructure, int viewId, AbstractNode nodeGroup, AbstractNode target, boolean inner, boolean undirected, Predicate<AbstractNode> nodePredicate, Predicate<AbstractEdge> edgePredicate) {
        this.nodeIterator = new DescendantAndSelfIterator(treeStructure, nodeGroup, nodePredicate);
        this.inner = inner;
        this.nodeGroup = nodeGroup;
        this.rangeStart = target.getPre();
        this.rangeLimit = this.rangeStart + target.size;
        this.undirected = undirected;
        this.edgeIterator = new ParamAVLIterator();
        this.nodePredicate = nodePredicate;
        this.edgePredicate = edgePredicate;
        this.viewId = viewId;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (!this.edgeIterator.hasNext()) {
                if (this.currentNode == null) {
                    if (this.nodeIterator.hasNext()) {
                        this.currentNode = this.nodeIterator.next();
                        this.edgeIterator.setNode(this.currentNode.getEdgesOutTree());
                        this.IN = false;
                        continue;
                    }
                    return false;
                }
                this.edgeIterator.setNode(this.currentNode.getEdgesInTree());
                this.currentNode = null;
                this.IN = true;
                continue;
            }
            this.pointer = this.edgeIterator.next();
            if (this.testTarget(this.pointer)) break;
        }
        return true;
    }

    protected boolean testTarget(AbstractEdge edgeImpl) {
        if ((!this.undirected || edgeImpl.getUndirected(this.viewId) == edgeImpl) && this.edgePredicate.evaluate(edgeImpl)) {
            if (this.IN) {
                AbstractNode source = edgeImpl.getSource(this.viewId);
                if (!this.nodePredicate.evaluate(source)) {
                    return false;
                }
                int pre = source.getPre();
                if (!this.inner) {
                    return pre < this.rangeStart || pre > this.rangeLimit;
                }
            } else {
                AbstractNode target = edgeImpl.getTarget(this.viewId);
                if (!this.nodePredicate.evaluate(target)) {
                    return false;
                }
                int pre = target.getPre();
                boolean isInner = pre >= this.rangeStart && pre <= this.rangeLimit;
                return this.inner && isInner || !this.inner && !isInner;
            }
        }
        return false;
    }

    @Override
    public AbstractEdge next() {
        return this.pointer;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

