/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.node.AbstractNode;

public abstract class AbstractGraphImpl {
    protected final Dhns dhns;
    protected final GraphViewImpl view;
    protected final TreeStructure structure;

    public AbstractGraphImpl(Dhns dhns, GraphViewImpl view) {
        this.dhns = dhns;
        this.view = view;
        this.structure = view.getStructure();
        view.addGraphReference(this);
    }

    public GraphModel getGraphModel() {
        return this.dhns;
    }

    public GraphView getView() {
        return this.view;
    }

    public void readLock() {
        this.dhns.readLock();
    }

    public void readUnlock() {
        this.dhns.readUnlock();
    }

    public void readUnlockAll() {
        this.dhns.readUnlockAll();
    }

    public void writeLock() {
        this.dhns.writeLock();
    }

    public void writeUnlock() {
        this.dhns.writeUnlock();
    }

    public int getNodeVersion() {
        return this.dhns.getGraphVersion().getNodeVersion();
    }

    public int getEdgeVersion() {
        return this.dhns.getGraphVersion().getEdgeVersion();
    }

    protected AbstractNode checkNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        AbstractNode absNode = (AbstractNode)node;
        if (!absNode.isValid(this.view.getViewId()) && (absNode = absNode.getInView(this.view.getViewId())) == null) {
            throw new IllegalArgumentException("Node must be in the graph");
        }
        return absNode;
    }

    protected AbstractEdge checkEdge(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("edge can't be null");
        }
        AbstractEdge abstractEdge = (AbstractEdge)edge;
        if (!abstractEdge.isValid()) {
            throw new IllegalArgumentException("Nodes must be in the graph");
        }
        if (abstractEdge.isMetaEdge()) {
            throw new IllegalArgumentException("Edge can't be a meta edge");
        }
        return abstractEdge;
    }

    protected MetaEdgeImpl checkMetaEdge(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("edge can't be null");
        }
        AbstractEdge absEdge = (AbstractEdge)edge;
        if (!absEdge.isMetaEdge()) {
            throw new IllegalArgumentException("edge must be a meta edge");
        }
        if (!absEdge.isValid()) {
            throw new IllegalArgumentException("Nodes must be in the graph");
        }
        return (MetaEdgeImpl)absEdge;
    }

    protected AbstractEdge checkEdgeOrMetaEdge(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("edge can't be null");
        }
        AbstractEdge absEdge = (AbstractEdge)edge;
        if (!absEdge.isValid()) {
            throw new IllegalArgumentException("Nodes must be in the graph");
        }
        return absEdge;
    }

    protected boolean checkEdgeExist(AbstractNode source, AbstractNode target) {
        if (source == null) {
            throw new IllegalArgumentException("Source node must be in the graph");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target node must be in the graph");
        }
        return source.getEdgesOutTree().hasNeighbour(target);
    }

    protected AbstractEdge getSymmetricEdge(AbstractEdge edge) {
        return (AbstractEdge)edge.getTarget(this.view.getViewId()).getEdgesOutTree().getItem(edge.getSource().getNumber());
    }

    protected AbstractEdge getSymmetricMetaEdge(AbstractEdge edge) {
        return (AbstractEdge)edge.getTarget(this.view.getViewId()).getMetaEdgesOutTree().getItem(edge.getSource().getNumber());
    }
}

