/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.ImmutableTreeNode;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.graph.AbstractGraphImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.ChildrenIterator;
import org.gephi.graph.dhns.node.iterators.DescendantIterator;
import org.gephi.graph.dhns.node.iterators.LevelIterator;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.graph.dhns.predicate.Tautology;
import org.gephi.graph.dhns.utils.TreeNodeWrapper;

public abstract class HierarchicalGraphImpl
extends AbstractGraphImpl
implements HierarchicalGraph {
    protected Predicate<AbstractNode> enabledNodePredicate = new Predicate<AbstractNode>(){

        @Override
        public boolean evaluate(AbstractNode element) {
            return element.isEnabled();
        }
    };

    public HierarchicalGraphImpl(Dhns dhns, GraphViewImpl view) {
        super(dhns, view);
    }

    public abstract HierarchicalGraphImpl copy(Dhns var1, GraphViewImpl var2);

    public boolean addNode(Node node, Node parent) {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        AbstractNode absNode = (AbstractNode)node;
        AbstractNode absParent = null;
        if (parent != null) {
            absParent = this.checkNode(parent);
        }
        if (absNode.isValid(this.view.getViewId())) {
            return false;
        }
        if (absNode.avlNode != null) {
            if (absNode.getInView(this.view.getViewId()) != null) {
                return false;
            }
            absNode = new AbstractNode(absNode.getNodeData(), this.view.getViewId());
        }
        if (!absNode.getNodeData().hasAttributes()) {
            absNode.getNodeData().setAttributes(this.dhns.factory().newNodeAttributes(absNode.getNodeData()));
        }
        this.view.getStructureModifier().addNode(absNode, absParent);
        return true;
    }

    public boolean addNode(Node node) {
        return this.addNode(node, null);
    }

    public boolean contains(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        AbstractNode absNode = (AbstractNode)node;
        boolean res = false;
        if (absNode.isValid(this.view.getViewId())) {
            res = this.structure.getTree().contains(absNode);
        } else if ((absNode = absNode.getInView(this.view.getViewId())) != null) {
            res = true;
        }
        return res;
    }

    public Node getNode(int id) {
        return this.dhns.getGraphStructure().getNodeFromDictionnary(id, this.view.getViewId());
    }

    public Edge getEdge(int id) {
        return this.dhns.getGraphStructure().getEdgeFromDictionnary(id);
    }

    public Node getNode(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return this.dhns.getGraphStructure().getNodeFromDictionnary(id, this.view.getViewId());
    }

    public Edge getEdge(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return this.dhns.getGraphStructure().getEdgeFromDictionnary(id);
    }

    public NodeIterable getNodes() {
        this.readLock();
        return this.dhns.newNodeIterable(new TreeIterator(this.structure, true, Tautology.instance));
    }

    public NodeIterable getNodesTree() {
        this.readLock();
        return this.dhns.newNodeIterable(new TreeIterator(this.structure, false, Tautology.instance));
    }

    public int getNodeCount() {
        int count = this.view.getNodesEnabled();
        return count;
    }

    public NodeIterable getNodes(int level) {
        this.readLock();
        int height = this.structure.getTreeHeight();
        if (++level > height) {
            this.readUnlock();
            throw new IllegalArgumentException("Level must be between 0 and the height of the tree, currently height=" + (height - 1));
        }
        return this.dhns.newNodeIterable(new LevelIterator(this.structure, level, Tautology.instance));
    }

    public int getLevelSize(int level) {
        int height = this.structure.getTreeHeight();
        if (++level > height) {
            throw new IllegalArgumentException("Level must be between 0 and the height of the tree, currently height=" + (height - 1));
        }
        int res = this.structure.getLevelSize(level);
        return res;
    }

    public boolean isSelfLoop(Edge edge) {
        AbstractEdge absEdge = this.checkEdge(edge);
        return absEdge.getSource(this.view.getViewId()) == absEdge.getTarget(this.view.getViewId());
    }

    public boolean isAdjacent(Edge edge1, Edge edge2) {
        if (edge1 == edge2) {
            throw new IllegalArgumentException("Edges can't be the same");
        }
        AbstractEdge absEdge1 = this.checkEdge(edge1);
        AbstractEdge absEdge2 = this.checkEdge(edge2);
        return absEdge1.getSource(this.view.getViewId()) == absEdge2.getSource(this.view.getViewId()) || absEdge1.getSource(this.view.getViewId()) == absEdge2.getTarget(this.view.getViewId()) || absEdge1.getTarget(this.view.getViewId()) == absEdge2.getSource(this.view.getViewId()) || absEdge1.getTarget(this.view.getViewId()) == absEdge2.getTarget(this.view.getViewId());
    }

    public Node getOpposite(Node node, Edge edge) {
        this.checkNode(node);
        AbstractEdge absEdge = this.checkEdge(edge);
        if (absEdge.getSource(this.view.getViewId()) == node) {
            return absEdge.getTarget(this.view.getViewId());
        }
        if (absEdge.getTarget(this.view.getViewId()) == node) {
            return absEdge.getSource(this.view.getViewId());
        }
        throw new IllegalArgumentException("Node must be either source or target of the edge.");
    }

    public boolean removeNode(Node node) {
        AbstractNode absNode = this.checkNode(node);
        this.view.getStructureModifier().deleteNode(absNode);
        return true;
    }

    public void clear() {
        this.view.getStructureModifier().clear();
    }

    public void clearEdges() {
        this.view.getStructureModifier().clearEdges();
    }

    public void clearEdges(Node node) {
        AbstractNode absNode = this.checkNode(node);
        this.view.getStructureModifier().clearEdges(absNode);
    }

    public void clearMetaEdges(Node node) {
        AbstractNode absNode = this.checkNode(node);
        this.view.getStructureModifier().clearMetaEdges(absNode);
    }

    public void setId(Node node, String id) {
        if (node == null) {
            throw new NullPointerException("node can't be null");
        }
        this.dhns.getGraphStructure().setNodeId(((AbstractNode)node).getNodeData(), id);
    }

    public void setId(Edge edge, String id) {
        if (edge == null) {
            throw new NullPointerException("edge can't be null");
        }
        this.dhns.getGraphStructure().setEdgeId((AbstractEdge)edge, id);
    }

    public ImmutableTreeNode wrapToTreeNode() {
        TreeNodeWrapper wrapper = new TreeNodeWrapper(this.structure);
        this.readLock();
        ImmutableTreeNode treeNode = wrapper.wrap(new TreeIterator(this.structure, false, Tautology.instance));
        this.readUnlock();
        return treeNode;
    }

    public int getChildrenCount(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = 0;
        ChildrenIterator itr = new ChildrenIterator(this.structure, absNode, Tautology.instance);
        while (itr.hasNext()) {
            itr.next();
            ++count;
        }
        return count;
    }

    public int getDescendantCount(Node node) {
        AbstractNode absNode = this.checkNode(node);
        return absNode.size;
    }

    public Node getParent(Node node) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode parent = null;
        if (absNode.parent != this.structure.getRoot()) {
            parent = absNode.parent;
        }
        return parent;
    }

    public NodeIterable getChildren(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new ChildrenIterator(this.structure, absNode, Tautology.instance));
    }

    public NodeIterable getDescendant(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new DescendantIterator(this.structure, absNode, Tautology.instance));
    }

    public NodeIterable getTopNodes() {
        this.readLock();
        return this.dhns.newNodeIterable(new ChildrenIterator(this.structure, Tautology.instance));
    }

    public boolean isDescendant(Node node, Node descendant) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode absDesc = this.checkNode(descendant);
        boolean res = false;
        res = absDesc.getPre() > absNode.getPre() && absDesc.getPost() < absNode.getPost();
        return res;
    }

    public boolean isAncestor(Node node, Node ancestor) {
        return this.isDescendant(ancestor, node);
    }

    public boolean isFollowing(Node node, Node following) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode absFoll = this.checkNode(following);
        boolean res = absFoll.getPre() > absNode.getPre() && absFoll.getPost() > absNode.getPost();
        return res;
    }

    public boolean isPreceding(Node node, Node preceding) {
        return this.isFollowing(preceding, node);
    }

    public boolean isParent(Node node, Node parent) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode absParent = this.checkNode(parent);
        boolean res = absNode.parent == absParent;
        return res;
    }

    public int getHeight() {
        int res = this.structure.getTreeHeight() - 1;
        return res;
    }

    public int getLevel(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int res = absNode.level - 1;
        return res;
    }

    public void moveToGroup(Node node, Node nodeGroup) {
        AbstractNode absGroup;
        AbstractNode absNode = this.checkNode(node);
        if (this.isDescendant(absNode, absGroup = this.checkNode(nodeGroup))) {
            throw new IllegalArgumentException("nodeGroup can't be a descendant of node");
        }
        this.view.getStructureModifier().moveToGroup(absNode, absGroup);
    }

    public void removeFromGroup(Node node) {
        AbstractNode absNode = this.checkNode(node);
        if (absNode.parent.parent == null) {
            throw new IllegalArgumentException("Node parent can't be the root of the tree");
        }
        this.view.getStructureModifier().moveToGroup(absNode, absNode.parent.parent);
    }

    public Node groupNodes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("nodes can't be null or empty");
        }
        AbstractNode[] absNodes = new AbstractNode[nodes.length];
        AbstractNode parent = null;
        for (int i = 0; i < nodes.length; ++i) {
            AbstractNode node;
            absNodes[i] = node = this.checkNode(nodes[i]);
            if (parent == null) {
                parent = node.parent;
                continue;
            }
            if (parent == node.parent) continue;
            throw new IllegalArgumentException("All nodes must have the same parent");
        }
        Node group = this.view.getStructureModifier().group(absNodes);
        return group;
    }

    public void ungroupNodes(Node nodeGroup) {
        AbstractNode absNode = this.checkNode(nodeGroup);
        if (absNode.size == 0) {
            throw new IllegalArgumentException("nodeGroup can't be empty");
        }
        this.view.getStructureModifier().ungroup(absNode);
    }

    public boolean expand(Node node) {
        AbstractNode absNode = this.checkNode(node);
        if (absNode.size == 0 || !absNode.isEnabled()) {
            return false;
        }
        this.view.getStructureModifier().expand(absNode);
        return true;
    }

    public boolean retract(Node node) {
        AbstractNode absNode = this.checkNode(node);
        if (absNode.size == 0 || absNode.isEnabled()) {
            return false;
        }
        this.view.getStructureModifier().retract(absNode);
        return true;
    }

    public boolean isInView(Node node) {
        AbstractNode absNode = this.checkNode(node);
        boolean res = absNode.isEnabled();
        return res;
    }

    public void resetViewToLeaves() {
        this.view.getStructureModifier().resetViewToLeaves();
    }

    public void resetViewToLevel(int level) {
        this.readLock();
        int height = this.structure.getTreeHeight();
        if (++level > height) {
            this.readUnlock();
            throw new IllegalArgumentException("Level must be between 0 and the height of the tree, currently height=" + (height - 1));
        }
        this.readUnlock();
        this.view.getStructureModifier().resetViewToLevel(level);
    }

    public void resetViewToTopNodes() {
        this.view.getStructureModifier().resetViewToTopNodes();
    }

    public void flatten() {
        this.view.getStructureModifier().flatten();
    }
}

