/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.HierarchicalMixedGraph;
import org.gephi.graph.api.MetaEdge;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.edge.iterators.BiEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeAndMetaEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeNodeIterator;
import org.gephi.graph.dhns.edge.iterators.MetaEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.MetaEdgeNodeIterator;
import org.gephi.graph.dhns.graph.HierarchicalGraphImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.NeighborIterator;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.graph.dhns.predicate.Tautology;

public class HierarchicalMixedGraphImpl
extends HierarchicalGraphImpl
implements HierarchicalMixedGraph {
    private Predicate<AbstractEdge> undirectedPredicate;
    private Predicate<AbstractEdge> directedPredicate = new Predicate<AbstractEdge>(){

        @Override
        public boolean evaluate(AbstractEdge t) {
            return t.isDirected();
        }
    };

    public HierarchicalMixedGraphImpl(Dhns dhns, GraphViewImpl view) {
        super(dhns, view);
        this.undirectedPredicate = new Predicate<AbstractEdge>(){

            @Override
            public boolean evaluate(AbstractEdge t) {
                return !t.isDirected();
            }
        };
    }

    public boolean addEdge(Edge edge) {
        AbstractNode target;
        AbstractEdge absEdge = this.checkEdge(edge);
        AbstractNode source = this.checkNode(edge.getSource());
        if (this.checkEdgeExist(source, target = this.checkNode(edge.getTarget()))) {
            return false;
        }
        AbstractEdge symmetricEdge = this.getSymmetricEdge(absEdge);
        if (!(symmetricEdge == null || symmetricEdge.isDirected() && absEdge.isDirected())) {
            return false;
        }
        if (!absEdge.hasAttributes()) {
            absEdge.setAttributes(this.dhns.factory().newEdgeAttributes(edge.getEdgeData()));
        }
        this.view.getStructureModifier().addEdge(absEdge);
        if (absEdge.isDirected()) {
            this.dhns.touchDirected();
        } else {
            this.dhns.touchUndirected();
        }
        return true;
    }

    public boolean addEdge(Node source, Node target, boolean directed) {
        AbstractNode absSource = this.checkNode(source);
        AbstractNode absTarget = this.checkNode(target);
        if (directed && this.checkEdgeExist(absSource, absTarget)) {
            return false;
        }
        AbstractEdge symmetricEdge = (AbstractEdge)absSource.getEdgesInTree().getItem(absTarget.getNumber());
        if (!(symmetricEdge == null || symmetricEdge.isDirected() && directed)) {
            return false;
        }
        AbstractEdge edge = this.dhns.factory().newEdge(null, source, target, 1.0f, directed);
        this.view.getStructureModifier().addEdge(edge);
        if (directed) {
            this.dhns.touchDirected();
        } else {
            this.dhns.touchUndirected();
        }
        return true;
    }

    public boolean removeEdge(Edge edge) {
        AbstractEdge absEdge = this.checkEdge(edge);
        AbstractEdge undirected = absEdge.getUndirected(this.view.getViewId());
        return this.view.getStructureModifier().deleteEdge(undirected);
    }

    public EdgeIterable getDirectedEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, Tautology.instance, Tautology.instance), this.directedPredicate);
    }

    public EdgeIterable getUndirectedEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, Tautology.instance, Tautology.instance), this.undirectedPredicate);
    }

    public boolean isDirected(Edge edge) {
        AbstractEdge absEdge = this.checkEdgeOrMetaEdge(edge);
        return absEdge.isDirected();
    }

    public boolean contains(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        AbstractEdge absEdge = (AbstractEdge)edge;
        return this.getEdge(absEdge.getSource(this.view.getViewId()), absEdge.getTarget(this.view.getViewId())) != null;
    }

    public Edge getEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        this.readLock();
        AbstractNode sourceNode = this.checkNode(node1);
        AbstractNode targetNode = this.checkNode(node2);
        AbstractEdge res = (AbstractEdge)sourceNode.getEdgesOutTree().getItem(targetNode.getNumber());
        if (res == null) {
            res = (AbstractEdge)sourceNode.getEdgesInTree().getItem(targetNode.getNumber());
        }
        this.readUnlock();
        return res;
    }

    public EdgeIterable getEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, Tautology.instance, Tautology.instance));
    }

    public EdgeIterable getEdgesTree() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, Tautology.instance, Tautology.instance));
    }

    public NodeIterable getNeighbors(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new NeighborIterator(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true, Tautology.instance, Tautology.instance), absNode, Tautology.instance));
    }

    public EdgeIterable getEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false, Tautology.instance, Tautology.instance));
    }

    public int getEdgeCount() {
        return this.view.getEdgesCountEnabled();
    }

    public int getTotalEdgeCount() {
        return this.view.getEdgesCountEnabled() + this.view.getMetaEdgesCountTotal();
    }

    public int getDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEdgesInTree().getCount() + absNode.getEdgesOutTree().getCount();
        return count;
    }

    public int getInDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEdgesInTree().getCount();
        return count;
    }

    public int getOutDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEdgesOutTree().getCount();
        return count;
    }

    public boolean isAdjacent(Node node1, Node node2) {
        if (node1 == node2) {
            throw new IllegalArgumentException("Nodes can't be the same");
        }
        return this.isSuccessor(node1, node2) || this.isPredecessor(node1, node2);
    }

    public boolean isSuccessor(Node node, Node successor) {
        return this.getEdge(node, successor) != null;
    }

    public boolean isPredecessor(Node node, Node predecessor) {
        return this.getEdge(predecessor, node) != null;
    }

    public EdgeIterable getInnerEdges(Node nodeGroup) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public EdgeIterable getOuterEdges(Node nodeGroup) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public EdgeIterable getMetaEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new MetaEdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false));
    }

    public EdgeIterable getEdgesAndMetaEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeAndMetaEdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, this.enabledNodePredicate, Tautology.instance));
    }

    public EdgeIterable getMetaEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false));
    }

    public EdgeIterable getEdgesAndMetaEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        EdgeNodeIterator std = new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false, this.enabledNodePredicate, Tautology.instance);
        MetaEdgeNodeIterator meta = new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false);
        return this.dhns.newEdgeIterable(new BiEdgeIterator(std, meta));
    }

    public MetaEdge getMetaEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        this.readLock();
        AbstractNode sourceNode = this.checkNode(node1);
        AbstractNode targetNode = this.checkNode(node2);
        AbstractEdge res = (AbstractEdge)sourceNode.getMetaEdgesOutTree().getItem(targetNode.getNumber());
        if (res == null) {
            res = (AbstractEdge)sourceNode.getMetaEdgesInTree().getItem(targetNode.getNumber());
        }
        this.readUnlock();
        return (MetaEdge)((Object)res);
    }

    public int getMetaDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getMetaEdgesInTree().getCount() + absNode.getMetaEdgesOutTree().getCount();
        return count;
    }

    public int getTotalDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEdgesInTree().getCount() + absNode.getEdgesOutTree().getCount() + absNode.getMetaEdgesInTree().getCount() + absNode.getMetaEdgesOutTree().getCount();
        return count;
    }

    public boolean removeMetaEdge(Edge edge) {
        MetaEdgeImpl absEdge = this.checkMetaEdge(edge);
        return this.view.getStructureModifier().deleteMetaEdge(absEdge);
    }

    public HierarchicalMixedGraphImpl copy(Dhns dhns, GraphViewImpl view) {
        return new HierarchicalMixedGraphImpl(dhns, view);
    }

    public EdgeIterable getHierarchyEdges() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

