/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.MetaEdge;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.edge.MixedEdgeImpl;
import org.gephi.graph.dhns.edge.iterators.BiEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeAndMetaEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeNodeIterator;
import org.gephi.graph.dhns.edge.iterators.MetaEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.MetaEdgeNodeIterator;
import org.gephi.graph.dhns.edge.iterators.RangeEdgeIterator;
import org.gephi.graph.dhns.graph.HierarchicalGraphImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.NeighborIterator;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.predicate.Tautology;

public class HierarchicalUndirectedGraphImpl
extends HierarchicalGraphImpl
implements HierarchicalUndirectedGraph {
    public HierarchicalUndirectedGraphImpl(Dhns dhns, GraphViewImpl view) {
        super(dhns, view);
    }

    public boolean addEdge(Edge edge) {
        AbstractNode target;
        AbstractEdge absEdge = this.checkEdge(edge);
        if (absEdge instanceof MixedEdgeImpl && edge.isDirected() && !absEdge.isSelfLoop()) {
            throw new IllegalArgumentException("Can't add a directed egde");
        }
        AbstractNode source = this.checkNode(edge.getSource());
        if (this.checkEdgeExist(source, target = this.checkNode(edge.getTarget())) || this.checkEdgeExist(target, source)) {
            return false;
        }
        if (!absEdge.hasAttributes()) {
            absEdge.setAttributes(this.dhns.factory().newEdgeAttributes(edge.getEdgeData()));
        }
        this.view.getStructureModifier().addEdge(absEdge);
        this.dhns.touchUndirected();
        return true;
    }

    public boolean addEdge(Node node1, Node node2) {
        AbstractNode absNode2;
        AbstractNode absNode1 = this.checkNode(node1);
        if (this.checkEdgeExist(absNode1, absNode2 = this.checkNode(node2)) || this.checkEdgeExist(absNode2, absNode1)) {
            return false;
        }
        AbstractEdge edge = this.dhns.factory().newEdge(null, absNode1, absNode2, 1.0f, false);
        this.view.getStructureModifier().addEdge(edge);
        this.dhns.touchUndirected();
        return true;
    }

    public boolean removeEdge(Edge edge) {
        AbstractEdge symmetricEdge;
        AbstractEdge absEdge = this.checkEdge(edge);
        boolean res = false;
        if (!absEdge.isSelfLoop() && (symmetricEdge = this.getSymmetricEdge(absEdge)) != null) {
            res = this.view.getStructureModifier().deleteEdge(symmetricEdge);
        }
        res = this.view.getStructureModifier().deleteEdge(absEdge) || res;
        return res;
    }

    public boolean contains(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        AbstractEdge absEdge = (AbstractEdge)edge;
        return this.getEdge(absEdge.getSource(this.view.getViewId()), absEdge.getTarget(this.view.getViewId())) != null;
    }

    public EdgeIterable getEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), true, this.enabledNodePredicate, Tautology.instance));
    }

    public EdgeIterable getEdgesTree() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), true, Tautology.instance, Tautology.instance));
    }

    public EdgeIterable getEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true, this.enabledNodePredicate, Tautology.instance));
    }

    public NodeIterable getNeighbors(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new NeighborIterator(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true, this.enabledNodePredicate, Tautology.instance), absNode, Tautology.instance));
    }

    public int getEdgeCount() {
        return this.view.getEdgesCountEnabled() - this.view.getMutualEdgesEnabled();
    }

    public int getTotalEdgeCount() {
        return this.getEdgeCount() + this.view.getMetaEdgesCountTotal() - this.view.getMutualMetaEdgesTotal();
    }

    public int getDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEnabledInDegree() + absNode.getEnabledOutDegree() - absNode.getEnabledMutualDegree();
        return count;
    }

    public boolean isAdjacent(Node node1, Node node2) {
        if (node1 == node2) {
            throw new IllegalArgumentException("Nodes can't be the same");
        }
        return this.getEdge(node1, node2) != null;
    }

    public boolean isDirected(Edge edge) {
        this.checkEdgeOrMetaEdge(edge);
        return false;
    }

    public Edge getEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        this.readLock();
        AbstractNode sourceNode = this.checkNode(node1);
        AbstractNode targetNode = this.checkNode(node2);
        AbstractEdge res = null;
        AbstractEdge edge1 = (AbstractEdge)sourceNode.getEdgesOutTree().getItem(targetNode.getNumber());
        AbstractEdge edge2 = (AbstractEdge)sourceNode.getEdgesInTree().getItem(targetNode.getNumber());
        if (edge1 != null && edge2 != null) {
            res = edge1.getId() < edge2.getId() ? edge1 : edge2;
        } else if (edge1 != null) {
            res = edge1;
        } else if (edge2 != null) {
            res = edge2;
        }
        this.readUnlock();
        return res;
    }

    public EdgeIterable getInnerEdges(Node nodeGroup) {
        this.readLock();
        AbstractNode absNode = this.checkNode(nodeGroup);
        return this.dhns.newEdgeIterable(new RangeEdgeIterator(this.structure, this.view.getViewId(), absNode, absNode, true, true, Tautology.instance, Tautology.instance));
    }

    public EdgeIterable getOuterEdges(Node nodeGroup) {
        this.readLock();
        AbstractNode absNode = this.checkNode(nodeGroup);
        return this.dhns.newEdgeIterable(new RangeEdgeIterator(this.structure, this.view.getViewId(), absNode, absNode, false, true, Tautology.instance, Tautology.instance));
    }

    public boolean removeMetaEdge(Edge edge) {
        AbstractEdge symmetricEdge;
        MetaEdgeImpl absEdge = this.checkMetaEdge(edge);
        boolean res = false;
        if (!absEdge.isSelfLoop() && (symmetricEdge = this.getSymmetricMetaEdge(absEdge)) != null) {
            res = this.view.getStructureModifier().deleteMetaEdge(symmetricEdge);
        }
        res = this.view.getStructureModifier().deleteMetaEdge(absEdge) || res;
        return res;
    }

    public int getMetaDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getMetaEdgesInTree().getCount() + absNode.getMetaEdgesOutTree().getCount() - absNode.getMutualMetaEdgeDegree();
        return count;
    }

    public int getTotalDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getMetaEdgesInTree().getCount() + absNode.getMetaEdgesOutTree().getCount() - absNode.getMutualMetaEdgeDegree();
        return count += absNode.getEnabledInDegree() + absNode.getEnabledOutDegree() - absNode.getEnabledMutualDegree();
    }

    public EdgeIterable getMetaEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new MetaEdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), true));
    }

    public EdgeIterable getEdgesAndMetaEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeAndMetaEdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), true, this.enabledNodePredicate, Tautology.instance));
    }

    public EdgeIterable getMetaEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true));
    }

    public EdgeIterable getEdgesAndMetaEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        EdgeNodeIterator std = new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true, this.enabledNodePredicate, Tautology.instance);
        MetaEdgeNodeIterator meta = new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true);
        return this.dhns.newEdgeIterable(new BiEdgeIterator(std, meta));
    }

    public MetaEdge getMetaEdge(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        this.readLock();
        AbstractNode sourceNode = this.checkNode(node1);
        AbstractNode targetNode = this.checkNode(node2);
        AbstractEdge res = null;
        AbstractEdge edge1 = (AbstractEdge)sourceNode.getMetaEdgesOutTree().getItem(targetNode.getNumber());
        AbstractEdge edge2 = (AbstractEdge)sourceNode.getMetaEdgesInTree().getItem(targetNode.getNumber());
        if (edge1 != null && edge2 != null) {
            res = edge1.getId() < edge2.getId() ? edge1 : edge2;
        } else if (edge1 != null) {
            res = edge1;
        } else if (edge2 != null) {
            res = edge2;
        }
        this.readUnlock();
        return (MetaEdge)((Object)res);
    }

    public HierarchicalUndirectedGraphImpl copy(Dhns dhns, GraphViewImpl view) {
        return new HierarchicalUndirectedGraphImpl(dhns, view);
    }

    public EdgeIterable getHierarchyEdges() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

