/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node;

import org.gephi.graph.api.Group;
import org.gephi.graph.api.GroupData;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.DurableTreeList;
import org.gephi.graph.dhns.node.NodeDataImpl;
import org.gephi.graph.dhns.utils.avl.EdgeOppositeTree;
import org.gephi.graph.dhns.utils.avl.MetaEdgeTree;
import org.gephi.utils.collection.avl.AVLItem;

public class AbstractNode
implements Node,
Group,
AVLItem {
    protected final NodeDataImpl nodeData;
    protected final int viewId;
    public AbstractNode parent;
    public int pre;
    public int size;
    public int level;
    public int post;
    public DurableTreeList.DurableAVLNode avlNode;
    protected boolean enabled;
    private EdgeOppositeTree edgesOutTree;
    private EdgeOppositeTree edgesInTree;
    private MetaEdgeTree metaEdgesOutTree;
    private MetaEdgeTree metaEdgesInTree;
    private int enabledInDegree;
    private int enabledOutDegree;
    private int enabledMutualDegree;
    private int mutualMetaEdgeDegree;

    public AbstractNode(int ID, int viewId) {
        this(viewId, new NodeDataImpl(ID, null), 0, 0, 0, null);
        this.nodeData.getNodes().add(this);
    }

    public AbstractNode(NodeDataImpl nodeData, int viewId) {
        this(viewId, nodeData, 0, 0, 0, null);
        nodeData.getNodes().add(this);
    }

    public AbstractNode(int ID, int viewId, int pre, int size, int level, AbstractNode parent) {
        this(viewId, new NodeDataImpl(ID, null), pre, size, level, parent);
        this.nodeData.getNodes().add(this);
    }

    public AbstractNode(NodeDataImpl nodeData, int viewId, int pre, int size, int level, AbstractNode parent) {
        this(viewId, nodeData, pre, size, level, parent);
        nodeData.getNodes().add(this);
    }

    private AbstractNode(int viewId, NodeDataImpl nodeData, int pre, int size, int level, AbstractNode parent) {
        this.viewId = viewId;
        this.parent = parent;
        this.pre = pre;
        this.size = size;
        this.level = level;
        this.post = pre - level + size;
        this.nodeData = nodeData;
        this.edgesOutTree = new EdgeOppositeTree(this);
        this.edgesInTree = new EdgeOppositeTree(this);
        this.metaEdgesOutTree = new MetaEdgeTree(this);
        this.metaEdgesInTree = new MetaEdgeTree(this);
    }

    public int getViewId() {
        return this.viewId;
    }

    public int getPre() {
        return this.avlNode.getIndex();
    }

    public int getPost() {
        this.post = this.pre - this.level + this.size;
        return this.post;
    }

    public int getId() {
        return this.nodeData.ID;
    }

    public int getNumber() {
        return this.nodeData.ID;
    }

    public NodeDataImpl getNodeData() {
        return this.nodeData;
    }

    public GroupData getGroupData() {
        return this.nodeData;
    }

    public EdgeOppositeTree getEdgesInTree() {
        return this.edgesInTree;
    }

    public void setEdgesInTree(EdgeOppositeTree edgesInTree) {
        this.edgesInTree = edgesInTree;
    }

    public EdgeOppositeTree getEdgesOutTree() {
        return this.edgesOutTree;
    }

    public void setEdgesOutTree(EdgeOppositeTree edgesOutTree) {
        this.edgesOutTree = edgesOutTree;
    }

    public MetaEdgeTree getMetaEdgesInTree() {
        return this.metaEdgesInTree;
    }

    public void setMetaEdgesInTree(MetaEdgeTree metaEdgesInTree) {
        this.metaEdgesInTree = metaEdgesInTree;
    }

    public MetaEdgeTree getMetaEdgesOutTree() {
        return this.metaEdgesOutTree;
    }

    public void setMetaEdgesOutTree(MetaEdgeTree metaEdgesOutTree) {
        this.metaEdgesOutTree = metaEdgesOutTree;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void clearMetaEdges() {
        this.metaEdgesOutTree = new MetaEdgeTree(this);
        this.metaEdgesInTree = new MetaEdgeTree(this);
    }

    public boolean isValid(int viewId) {
        return this.avlNode != null && this.viewId == viewId;
    }

    public AbstractNode getInView(int viewId) {
        if (this.avlNode == null) {
            return null;
        }
        if (this.viewId == viewId) {
            return this;
        }
        return this.nodeData.getNodes().get(viewId);
    }

    public void removeFromView(int viewId) {
        this.nodeData.getNodes().remove(viewId);
    }

    public int countInViews() {
        return this.nodeData.getNodes().getCount();
    }

    public void incEnabledInDegree() {
        ++this.enabledInDegree;
    }

    public void incEnabledOutDegree() {
        ++this.enabledOutDegree;
    }

    public void incEnabledMutualDegree() {
        ++this.enabledMutualDegree;
    }

    public void incMutualMetaEdgeDegree() {
        ++this.mutualMetaEdgeDegree;
    }

    public void decEnabledInDegree() {
        --this.enabledInDegree;
    }

    public void decEnabledOutDegree() {
        --this.enabledOutDegree;
    }

    public void decEnabledMutualDegree() {
        --this.enabledMutualDegree;
    }

    public void decMutualMetaEdgeDegree() {
        --this.mutualMetaEdgeDegree;
    }

    public int getEnabledInDegree() {
        return this.enabledInDegree;
    }

    public void setEnabledInDegree(int enabledInDegree) {
        this.enabledInDegree = enabledInDegree;
    }

    public int getEnabledMutualDegree() {
        return this.enabledMutualDegree;
    }

    public void setEnabledMutualDegree(int enabledMutualDegree) {
        this.enabledMutualDegree = enabledMutualDegree;
    }

    public int getEnabledOutDegree() {
        return this.enabledOutDegree;
    }

    public void setEnabledOutDegree(int enabledOutDegree) {
        this.enabledOutDegree = enabledOutDegree;
    }

    public int getMutualMetaEdgeDegree() {
        return this.mutualMetaEdgeDegree;
    }

    public void setMutualMetaEdgeDegree(int mutualMetaEdgeDegree) {
        this.mutualMetaEdgeDegree = mutualMetaEdgeDegree;
    }

    public String toString() {
        return this.nodeData.getId();
    }
}

