/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.DurableTreeList;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.utils.collection.avl.ResetableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildrenIterator
extends AbstractNodeIterator
implements Iterator<Node>,
ResetableIterator {
    protected int treeSize;
    protected DurableTreeList treeList;
    protected int nextIndex;
    protected int diffIndex;
    protected DurableTreeList.DurableAVLNode currentNode;
    protected boolean loopStart = true;
    protected Predicate<AbstractNode> predicate;

    public ChildrenIterator(TreeStructure treeStructure, Predicate<AbstractNode> predicate) {
        this.treeList = treeStructure.getTree();
        this.nextIndex = 1;
        this.diffIndex = 2;
        this.treeSize = this.treeList.size();
        this.predicate = predicate;
    }

    public ChildrenIterator(TreeStructure treeStructure, AbstractNode node, Predicate<AbstractNode> predicate) {
        this(treeStructure, predicate);
        this.setNode(node);
    }

    public void setNode(AbstractNode node) {
        this.nextIndex = node.getPre() + 1;
        this.treeSize = node.getPre() + node.size + 1;
        this.diffIndex = 2;
    }

    @Override
    public boolean hasNext() {
        while (this.loopStart || !this.predicate.evaluate(this.currentNode.getValue())) {
            if (!this.loopStart) {
                this.nextIndex = this.currentNode.getValue().getPre() + 1 + this.currentNode.getValue().size;
                this.diffIndex = this.nextIndex - this.currentNode.getValue().pre;
            }
            this.loopStart = false;
            if (this.nextIndex < this.treeSize) {
                if (this.diffIndex > 1) {
                    this.currentNode = this.treeList.getNode(this.nextIndex);
                    continue;
                }
                this.currentNode = this.currentNode.next();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public AbstractNode next() {
        this.nextIndex = this.currentNode.getValue().getPre() + 1 + this.currentNode.getValue().size;
        this.diffIndex = this.nextIndex - this.currentNode.getValue().pre;
        this.loopStart = true;
        return this.currentNode.getValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

