/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.DurableTreeList;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.utils.collection.avl.ResetableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator
extends AbstractNodeIterator
implements Iterator<Node>,
ResetableIterator {
    protected int treeSize;
    protected DurableTreeList treeList;
    protected int nextIndex;
    protected int diffIndex;
    protected DurableTreeList.DurableAVLNode currentNode;
    protected final boolean skipping;
    protected Predicate<AbstractNode> predicate;

    public TreeIterator(TreeStructure treeStructure, boolean skipping, Predicate<AbstractNode> predicate) {
        this.treeList = treeStructure.getTree();
        this.nextIndex = 1;
        this.diffIndex = 2;
        this.treeSize = this.treeList.size();
        this.skipping = skipping;
        this.predicate = predicate;
    }

    public void reset() {
        this.nextIndex = 1;
        this.diffIndex = 2;
    }

    @Override
    public boolean hasNext() {
        if (this.nextIndex < this.treeSize) {
            this.currentNode = this.diffIndex > 1 ? this.treeList.getNode(this.nextIndex) : this.currentNode.next();
            if (this.skipping) {
                while (!this.currentNode.getValue().isEnabled() || !this.predicate.evaluate(this.currentNode.getValue())) {
                    ++this.nextIndex;
                    if (this.nextIndex >= this.treeSize) {
                        return false;
                    }
                    this.currentNode = this.currentNode.next();
                }
                return true;
            }
            while (!this.predicate.evaluate(this.currentNode.getValue())) {
                ++this.nextIndex;
                if (this.nextIndex >= this.treeSize) {
                    return false;
                }
                this.currentNode = this.currentNode.next();
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractNode next() {
        if (this.skipping) {
            this.nextIndex = this.currentNode.getValue().getPre() + 1 + this.currentNode.getValue().size;
            this.diffIndex = this.nextIndex - this.currentNode.getValue().pre;
        } else {
            ++this.nextIndex;
            this.diffIndex = 1;
        }
        return this.currentNode.getValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

