/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node.iterators;

import java.util.Iterator;
import org.gephi.graph.dhns.core.DurableTreeList;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeListIterator
extends AbstractNodeIterator
implements Iterator<AbstractNode> {
    protected final DurableTreeList treeList;
    protected DurableTreeList.DurableAVLNode next;
    protected int nextIndex;

    public TreeListIterator(DurableTreeList treeList, int fromIndex) throws IndexOutOfBoundsException {
        this.treeList = treeList;
        this.nextIndex = fromIndex;
    }

    public TreeListIterator(DurableTreeList treeList) throws IndexOutOfBoundsException {
        this(treeList, 0);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.treeList.size();
    }

    @Override
    public AbstractNode next() {
        this.next = this.next == null ? this.treeList.getNode(this.nextIndex) : this.next.next();
        AbstractNode value = this.next.getValue();
        value.avlNode.setIndex(this.nextIndex);
        ++this.nextIndex;
        return value;
    }

    @Override
    public void remove() {
        this.treeList.remove(--this.nextIndex);
        this.next = null;
    }
}

