/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.utils;

import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphStructure;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.EdgeDataImpl;
import org.gephi.graph.dhns.edge.iterators.EdgeIterator;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.NodeDataImpl;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.graph.dhns.predicate.Tautology;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataSerializer {
    private static final String ELEMENT_DATA = "Data";
    private static final String ELEMENT_NODEDATA = "nodedata";
    private static final String ELEMENT_NODEDATA_POSITION = "position";
    private static final String ELEMENT_NODEDATA_COLOR = "color";
    private static final String ELEMENT_NODEDATA_SIZE = "size";
    private static final String ELEMENT_EDGEDATA = "edgedata";
    private static final String ELEMENT_EDGEDATA_COLOR = "edgedata";

    public Element writeData(Document document, Dhns dhns) {
        Element dataE = document.createElement(ELEMENT_DATA);
        TreeStructure treeStructure = dhns.getGraphStructure().getMainView().getStructure();
        TreeListIterator itr = new TreeListIterator(treeStructure.getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode absNode = itr.next();
            NodeDataImpl nodeData = absNode.getNodeData();
            if (nodeData == null) continue;
            Element nodeDataE = this.writeNodeData(document, nodeData);
            dataE.appendChild(nodeDataE);
        }
        EdgeIterator edgeIterator = new EdgeIterator(treeStructure, new TreeListIterator(treeStructure.getTree(), 1), false, Tautology.instance, Tautology.instance);
        while (edgeIterator.hasNext()) {
            EdgeDataImpl edgeData = edgeIterator.next().getEdgeData();
            if (edgeData == null) continue;
            Element edgeDataE = this.writeEdgeData(document, edgeData);
            dataE.appendChild(edgeDataE);
        }
        return dataE;
    }

    public void readData(Element dataE, Dhns dhns) {
        GraphStructure structure = dhns.getGraphStructure();
        TreeStructure treeStructure = structure.getMainView().getStructure();
        NodeList dataListE = dataE.getChildNodes();
        for (int i = 0; i < dataListE.getLength(); ++i) {
            if (dataListE.item(i).getNodeType() != 1) continue;
            Element itemE = (Element)dataListE.item(i);
            if (itemE.getTagName().equals(ELEMENT_NODEDATA)) {
                AbstractNode node = treeStructure.getNodeAt(Integer.parseInt(itemE.getAttribute("nodepre")));
                NodeDataImpl nodeDataImpl = node.getNodeData();
                this.readNodeData(itemE, nodeDataImpl, structure);
                continue;
            }
            if (!itemE.getTagName().equals("edgedata")) continue;
            AbstractNode source = treeStructure.getNodeAt(Integer.parseInt(itemE.getAttribute("sourcepre")));
            AbstractNode target = treeStructure.getNodeAt(Integer.parseInt(itemE.getAttribute("targetpre")));
            AbstractEdge edge = (AbstractEdge)source.getEdgesOutTree().getItem(target.getId());
            EdgeDataImpl edgeDataImpl = edge.getEdgeData();
            this.readEdgeData(itemE, edgeDataImpl, structure);
        }
    }

    public Element writeNodeData(Document document, NodeDataImpl nodeData) {
        Element nodeDataE = document.createElement(ELEMENT_NODEDATA);
        AbstractNode node = nodeData.getRootNode();
        nodeDataE.setAttribute("nodepre", String.valueOf(node.getPre()));
        if (nodeData.getId() != null && !nodeData.getId().equals("" + node.getId())) {
            nodeDataE.setAttribute("id", nodeData.getId());
        }
        Element positionE = document.createElement(ELEMENT_NODEDATA_POSITION);
        positionE.setAttribute("x", String.valueOf(nodeData.x()));
        positionE.setAttribute("y", String.valueOf(nodeData.y()));
        positionE.setAttribute("z", String.valueOf(nodeData.z()));
        nodeDataE.appendChild(positionE);
        Element colorE = document.createElement(ELEMENT_NODEDATA_COLOR);
        colorE.setAttribute("r", String.valueOf(nodeData.r()));
        colorE.setAttribute("g", String.valueOf(nodeData.g()));
        colorE.setAttribute("b", String.valueOf(nodeData.b()));
        colorE.setAttribute("a", String.valueOf(nodeData.alpha()));
        nodeDataE.appendChild(colorE);
        Element sizeE = document.createElement(ELEMENT_NODEDATA_SIZE);
        sizeE.setAttribute("value", String.valueOf(nodeData.getSize()));
        nodeDataE.appendChild(sizeE);
        return nodeDataE;
    }

    public void readNodeData(Element nodeDataE, NodeData nodeData, GraphStructure structure) {
        if (nodeDataE.hasAttribute("id")) {
            structure.setNodeId((NodeDataImpl)nodeData, nodeDataE.getAttribute("id"));
        }
        NodeList dataE = nodeDataE.getChildNodes();
        for (int i = 0; i < dataE.getLength(); ++i) {
            if (dataE.item(i).getNodeType() != 1) continue;
            Element itemE = (Element)dataE.item(i);
            if (itemE.getTagName().equals(ELEMENT_NODEDATA_POSITION)) {
                nodeData.setX(Float.parseFloat(itemE.getAttribute("x")));
                nodeData.setY(Float.parseFloat(itemE.getAttribute("y")));
                nodeData.setZ(Float.parseFloat(itemE.getAttribute("z")));
                continue;
            }
            if (itemE.getTagName().equals(ELEMENT_NODEDATA_COLOR)) {
                nodeData.setR(Float.parseFloat(itemE.getAttribute("r")));
                nodeData.setG(Float.parseFloat(itemE.getAttribute("g")));
                nodeData.setB(Float.parseFloat(itemE.getAttribute("b")));
                nodeData.setAlpha(Float.parseFloat(itemE.getAttribute("a")));
                continue;
            }
            if (!itemE.getTagName().equals(ELEMENT_NODEDATA_SIZE)) continue;
            nodeData.setSize(Float.parseFloat(itemE.getAttribute("value")));
        }
    }

    public Element writeEdgeData(Document document, EdgeDataImpl edgeData) {
        Element edgeDataE = document.createElement("edgedata");
        AbstractEdge edge = edgeData.getEdge();
        edgeDataE.setAttribute("sourcepre", String.valueOf(edge.getSource().getPre()));
        edgeDataE.setAttribute("targetpre", String.valueOf(edge.getTarget().getPre()));
        if (edgeData.getId() != null && !edgeData.getId().equals("" + edge.getId())) {
            edgeDataE.setAttribute("id", edgeData.getId());
        }
        Element colorE = document.createElement(ELEMENT_NODEDATA_COLOR);
        colorE.setAttribute("r", String.valueOf(edgeData.r()));
        colorE.setAttribute("g", String.valueOf(edgeData.g()));
        colorE.setAttribute("b", String.valueOf(edgeData.b()));
        colorE.setAttribute("a", String.valueOf(edgeData.alpha()));
        edgeDataE.appendChild(colorE);
        return edgeDataE;
    }

    public void readEdgeData(Element edgeDataE, EdgeData edgeData, GraphStructure structure) {
        if (edgeDataE.hasAttribute("id")) {
            structure.setEdgeId((AbstractEdge)edgeData.getEdge(), edgeDataE.getAttribute("id"));
        }
        NodeList dataE = edgeDataE.getChildNodes();
        for (int i = 0; i < dataE.getLength(); ++i) {
            Element itemE;
            if (dataE.item(i).getNodeType() != 1 || !(itemE = (Element)dataE.item(i)).getTagName().equals("edgedata")) continue;
            edgeData.setR(Float.parseFloat(itemE.getAttribute("r")));
            edgeData.setG(Float.parseFloat(itemE.getAttribute("g")));
            edgeData.setB(Float.parseFloat(itemE.getAttribute("b")));
            edgeData.setAlpha(Float.parseFloat(itemE.getAttribute("a")));
        }
    }
}

