/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.ByteExporter;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.io.exporter.spi.FileExporterBuilder;
import org.gephi.io.exporter.spi.GraphFileExporterBuilder;
import org.gephi.io.exporter.spi.VectorFileExporterBuilder;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExportControllerImpl
implements ExportController {
    private final FileExporterBuilder[] fileExporterBuilders;
    private final ExporterUI[] uis;

    public ExportControllerImpl() {
        Lookup.getDefault().lookupAll(GraphFileExporterBuilder.class);
        Lookup.getDefault().lookupAll(VectorFileExporterBuilder.class);
        this.fileExporterBuilders = Lookup.getDefault().lookupAll(FileExporterBuilder.class).toArray(new FileExporterBuilder[0]);
        this.uis = Lookup.getDefault().lookupAll(ExporterUI.class).toArray(new ExporterUI[0]);
    }

    public void exportFile(File file) throws IOException {
        Exporter fileExporter = this.getFileExporter(file);
        if (fileExporter == null) {
            throw new RuntimeException(NbBundle.getMessage(ExportControllerImpl.class, (String)"ExportControllerImpl.error.nomatchingexporter"));
        }
        this.exportFile(file, fileExporter);
    }

    public void exportFile(File file, Workspace workspace) throws IOException {
        Exporter fileExporter = this.getFileExporter(file);
        if (fileExporter == null) {
            throw new RuntimeException(NbBundle.getMessage(ExportControllerImpl.class, (String)"ExportControllerImpl.error.nomatchingexporter"));
        }
        fileExporter.setWorkspace(workspace);
        this.exportFile(file, fileExporter);
    }

    public void exportFile(File file, Exporter fileExporter) throws IOException {
        if (fileExporter.getWorkspace() == null) {
            ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            Workspace workspace = projectController.getCurrentWorkspace();
            fileExporter.setWorkspace(workspace);
        }
        if (fileExporter instanceof ByteExporter) {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
            ((ByteExporter)fileExporter).setOutputStream(stream);
            try {
                fileExporter.execute();
            }
            catch (Exception ex) {
                try {
                    ((OutputStream)stream).flush();
                    ((OutputStream)stream).close();
                }
                catch (IOException exe) {
                    // empty catch block
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            try {
                ((OutputStream)stream).flush();
                ((OutputStream)stream).close();
            }
            catch (IOException ex) {}
        } else if (fileExporter instanceof CharacterExporter) {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            ((CharacterExporter)fileExporter).setWriter(writer);
            try {
                fileExporter.execute();
            }
            catch (Exception ex) {
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException exe) {
                    // empty catch block
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            try {
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void exportStream(OutputStream stream, ByteExporter byteExporter) {
        if (byteExporter.getWorkspace() == null) {
            ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            Workspace workspace = projectController.getCurrentWorkspace();
            byteExporter.setWorkspace(workspace);
        }
        byteExporter.setOutputStream(stream);
        try {
            byteExporter.execute();
        }
        catch (Exception ex) {
            try {
                stream.flush();
                stream.close();
            }
            catch (IOException exe) {
                // empty catch block
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        try {
            stream.flush();
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void exportWriter(Writer writer, CharacterExporter characterExporter) {
        if (characterExporter.getWorkspace() == null) {
            ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            Workspace workspace = projectController.getCurrentWorkspace();
            characterExporter.setWorkspace(workspace);
        }
        characterExporter.setWriter(writer);
        try {
            characterExporter.execute();
        }
        catch (Exception ex) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException exe) {
                // empty catch block
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Exporter getFileExporter(File file) {
        for (FileExporterBuilder im : this.fileExporterBuilders) {
            for (FileType ft : im.getFileTypes()) {
                for (String ex : ft.getExtensions()) {
                    if (!this.hasExt(file, ex)) continue;
                    return im.buildExporter();
                }
            }
        }
        return null;
    }

    public Exporter getExporter(String exporterName) {
        for (FileExporterBuilder im : this.fileExporterBuilders) {
            if (!im.getName().equalsIgnoreCase(exporterName)) continue;
            return im.buildExporter();
        }
        for (FileExporterBuilder im : this.fileExporterBuilders) {
            for (FileType ft : im.getFileTypes()) {
                for (String ex : ft.getExtensions()) {
                    if (!ex.equalsIgnoreCase(exporterName)) continue;
                    return im.buildExporter();
                }
            }
        }
        return null;
    }

    public ExporterUI getUI(Exporter exporter) {
        for (ExporterUI ui : this.uis) {
            if (!ui.isUIForExporter(exporter)) continue;
            return ui;
        }
        return null;
    }

    private boolean hasExt(File file, String ext) {
        if (ext == null || ext.isEmpty()) {
            return false;
        }
        if (file.getName().length() - ext.length() <= 1) {
            return false;
        }
        boolean ret = file.getName().endsWith(ext);
        return ret;
    }
}

