/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.HierarchicalMixedGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.MixedGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ExporterCSV
implements GraphExporter,
CharacterExporter,
LongTask {
    private static final String SEPARATOR = ";";
    private static final String EOL = "\n";
    private boolean edgeWeight = true;
    private boolean writeZero = true;
    private boolean header = true;
    private boolean list = false;
    private Workspace workspace;
    private Writer writer;
    private boolean exportVisible;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public boolean execute() {
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = null;
        graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        int i;
        Node[] nodes;
        int max = graph.getNodeCount();
        Progress.start(this.progressTicket, max);
        if (!this.list && this.header) {
            this.writer.append(SEPARATOR);
            nodes = graph.getNodes().toArray();
            for (i = 0; i < nodes.length; ++i) {
                this.writeMatrixNode(nodes[i], i < nodes.length - 1);
            }
            this.writer.append(EOL);
        }
        if (this.list) {
            nodes = graph.getNodes().toArray();
            for (i = 0; i < nodes.length; ++i) {
                Node m;
                Node n = nodes[i];
                ArrayList<Node> neighbours = new ArrayList<Node>();
                for (Edge e : graph.getEdges(n)) {
                    if (e.isDirected() && (!e.isDirected() || n != e.getSource())) continue;
                    m = graph.getOpposite(n, e);
                    neighbours.add(m);
                }
                for (Edge e : ((HierarchicalGraph)graph).getMetaEdges(n)) {
                    if (e.isDirected() && (!e.isDirected() || n != e.getSource())) continue;
                    m = graph.getOpposite(n, e);
                    neighbours.add(m);
                }
                this.writeListNode(n, !neighbours.isEmpty());
                for (int j = 0; j < neighbours.size(); ++j) {
                    this.writeListNode((Node)neighbours.get(j), j < neighbours.size() - 1);
                }
                this.writer.append(EOL);
            }
        } else if (graph instanceof DirectedGraph) {
            Node[] nodes2;
            DirectedGraph directedGraph = (DirectedGraph)graph;
            for (Node n : nodes2 = graph.getNodes().toArray()) {
                if (!this.cancel) {
                    this.writeMatrixNode(n, true);
                    for (int j = 0; j < nodes2.length; ++j) {
                        Node m = nodes2[j];
                        Edge e = directedGraph.getEdge(n, m);
                        e = e == null ? ((HierarchicalDirectedGraph)directedGraph).getMetaEdge(n, m) : e;
                        this.writeEdge(e, j < nodes2.length - 1);
                    }
                    Progress.progress(this.progressTicket);
                    this.writer.append(EOL);
                    continue;
                }
                break;
            }
        } else if (graph instanceof UndirectedGraph) {
            Node[] nodes3;
            UndirectedGraph undirectedGraph = (UndirectedGraph)graph;
            for (Node n : nodes3 = graph.getNodes().toArray()) {
                if (!this.cancel) {
                    this.writeMatrixNode(n, true);
                    for (int j = 0; j < nodes3.length; ++j) {
                        Node m = nodes3[j];
                        Edge e = undirectedGraph.getEdge(n, m);
                        e = e == null ? ((HierarchicalUndirectedGraph)undirectedGraph).getMetaEdge(n, m) : e;
                        this.writeEdge(e, j < nodes3.length - 1);
                    }
                    Progress.progress(this.progressTicket);
                    this.writer.append(EOL);
                    continue;
                }
                break;
            }
        } else {
            MixedGraph mixedGraph = (MixedGraph)graph;
            Node[] nodes4 = graph.getNodes().toArray();
            for (Node n : graph.getNodes()) {
                if (!this.cancel) {
                    this.writeMatrixNode(n, true);
                    for (int j = 0; j < nodes4.length; ++j) {
                        Node m = nodes4[j];
                        Edge e = mixedGraph.getEdge(n, m);
                        e = e == null ? ((HierarchicalMixedGraph)mixedGraph).getMetaEdge(n, m) : e;
                        this.writeEdge(e, j < nodes4.length - 1);
                    }
                    Progress.progress(this.progressTicket);
                    this.writer.append(EOL);
                    continue;
                }
                break;
            }
        }
        graph.readUnlockAll();
        Progress.finish(this.progressTicket);
    }

    private void writeEdge(Edge edge, boolean writeSeparator) throws IOException {
        if (edge != null) {
            if (this.edgeWeight) {
                this.writer.append(Float.toString(edge.getWeight()));
            } else {
                this.writer.append(Float.toString(1.0f));
            }
            if (writeSeparator) {
                this.writer.append(SEPARATOR);
            }
        } else {
            if (this.writeZero) {
                this.writer.append("0");
            }
            if (writeSeparator) {
                this.writer.append(SEPARATOR);
            }
        }
    }

    private void writeMatrixNode(Node node, boolean writeSeparator) throws IOException {
        if (this.header) {
            String label = node.getNodeData().getLabel();
            if (label == null) {
                label = node.getNodeData().getId();
            }
            this.writer.append(label);
            if (writeSeparator) {
                this.writer.append(SEPARATOR);
            }
        }
    }

    private void writeListNode(Node node, boolean writeSeparator) throws IOException {
        String label = node.getNodeData().getLabel();
        if (label == null) {
            label = node.getNodeData().getId();
        }
        this.writer.append(label);
        if (writeSeparator) {
            this.writer.append(SEPARATOR);
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean isEdgeWeight() {
        return this.edgeWeight;
    }

    public void setEdgeWeight(boolean edgeWeight) {
        this.edgeWeight = edgeWeight;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public boolean isWriteZero() {
        return this.writeZero;
    }

    public void setWriteZero(boolean writeZero) {
        this.writeZero = writeZero;
    }

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

