/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.util.ArrayList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ExporterGDF
implements GraphExporter,
CharacterExporter,
LongTask {
    private Workspace workspace;
    private boolean exportVisible;
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private boolean normalize = false;
    private boolean simpleQuotes = false;
    private boolean useQuotes = true;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportAttributes = true;
    private boolean exportVisibility = false;
    private float minSize;
    private float maxSize;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private boolean edgeLabels;
    private boolean edgeColors;
    private NodeColumnsGDF[] defaultNodeColumnsGDFs;
    private EdgeColumnsGDF[] defaultEdgeColumnsGDFs;
    private AttributeColumn[] nodeColumns;
    private AttributeColumn[] edgeColumns;
    private Writer writer;
    private TimeInterval visibleInterval;

    public boolean execute() {
        AttributeModel attributeModel = (AttributeModel)this.workspace.getLookup().lookup(AttributeModel.class);
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = null;
        graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        DynamicModel dynamicModel = (DynamicModel)this.workspace.getLookup().lookup(DynamicModel.class);
        this.visibleInterval = dynamicModel != null && this.exportVisible ? dynamicModel.getVisibleInterval() : new TimeInterval();
        try {
            this.exportData(graph, attributeModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph, AttributeModel attributeModel) throws Exception {
        EdgeIterable edgeIterable;
        Progress.start(this.progressTicket);
        this.defaultNodeColumns(graph);
        this.defaultEdgeColumns(graph);
        this.attributesNodeColumns(attributeModel);
        this.attributesEdgeColumns(attributeModel);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("nodedef> name VARCHAR,");
        for (NodeColumnsGDF nodeColumnsGDF : this.defaultNodeColumnsGDFs) {
            if (!nodeColumnsGDF.isEnable()) continue;
            stringBuilder.append(nodeColumnsGDF.getTitle());
            stringBuilder.append(" ");
            stringBuilder.append(nodeColumnsGDF.getType().toString().toUpperCase());
            if (nodeColumnsGDF.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(nodeColumnsGDF.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        for (AttributeColumn attributeColumn : this.nodeColumns) {
            if (attributeColumn.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
            stringBuilder.append(attributeColumn.getTitle());
            stringBuilder.append(" ");
            DataTypeGDF dataTypeGDF = this.getDataTypeGDF(attributeColumn.getType());
            stringBuilder.append(dataTypeGDF.toString().toUpperCase());
            if (attributeColumn.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(attributeColumn.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        graph.readLock();
        if (this.normalize) {
            this.calculateMinMax(graph);
        }
        int max = graph.getNodeCount() + graph.getEdgeCount();
        Progress.switchToDeterminate(this.progressTicket, max);
        for (Node node : graph.getNodes()) {
            if (this.cancel) break;
            NodeData nodeData = node.getNodeData();
            stringBuilder.append(nodeData.getId());
            stringBuilder.append(",");
            for (NodeColumnsGDF nodeColumnsGDF : this.defaultNodeColumnsGDFs) {
                if (!nodeColumnsGDF.isEnable()) continue;
                nodeColumnsGDF.writeData(stringBuilder, node);
                stringBuilder.append(",");
            }
            for (AttributeColumn attributeColumn : this.nodeColumns) {
                if (attributeColumn.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
                Object object2 = node.getNodeData().getAttributes().getValue(attributeColumn.getIndex());
                object2 = DynamicUtilities.getDynamicValue(object2, this.visibleInterval.getLow(), this.visibleInterval.getHigh());
                if (object2 != null) {
                    if (attributeColumn.getType().equals((Object)AttributeType.STRING) || attributeColumn.getType().equals((Object)AttributeType.LIST_STRING)) {
                        String quote = !this.useQuotes ? "" : (this.simpleQuotes ? "'" : "\"");
                        stringBuilder.append(quote);
                        stringBuilder.append(object2.toString());
                        stringBuilder.append(quote);
                    } else {
                        stringBuilder.append(object2.toString());
                    }
                }
                stringBuilder.append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("\n");
            Progress.progress(this.progressTicket);
        }
        stringBuilder.append("edgedef> node1,node2,");
        HierarchicalGraph hg = (HierarchicalGraph)graph;
        for (Edge edge : hg.getEdgesAndMetaEdges()) {
            this.edgeColors = this.edgeColors || edge.getEdgeData().r() != -1.0f;
            this.edgeLabels = this.edgeLabels || edge.getEdgeData().getLabel() != null && !edge.getEdgeData().getLabel().isEmpty();
        }
        for (EdgeColumnsGDF c : this.defaultEdgeColumnsGDFs) {
            if (!c.isEnable()) continue;
            stringBuilder.append(c.getTitle());
            stringBuilder.append(" ");
            stringBuilder.append(c.getType().toString().toUpperCase());
            if (c.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(c.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        for (AttributeColumn c : this.edgeColumns) {
            if (c.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
            stringBuilder.append(c.getTitle());
            stringBuilder.append(" ");
            DataTypeGDF dataTypeGDF = this.getDataTypeGDF(c.getType());
            stringBuilder.append(dataTypeGDF.toString().toUpperCase());
            if (c.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(c.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        if (graph.getGraphModel().isHierarchical()) {
            HierarchicalGraph hierarchicalGraph = (HierarchicalGraph)graph;
            edgeIterable = hierarchicalGraph.getEdgesAndMetaEdges();
        } else {
            edgeIterable = graph.getEdges();
        }
        for (Edge edge : edgeIterable) {
            if (this.cancel) break;
            stringBuilder.append(edge.getSource().getNodeData().getId());
            stringBuilder.append(",");
            stringBuilder.append(edge.getTarget().getNodeData().getId());
            stringBuilder.append(",");
            for (EdgeColumnsGDF edgeColumnsGDF : this.defaultEdgeColumnsGDFs) {
                if (!edgeColumnsGDF.isEnable()) continue;
                edgeColumnsGDF.writeData(stringBuilder, edge);
                stringBuilder.append(",");
            }
            for (AttributeColumn attributeColumn : this.edgeColumns) {
                Object val = edge.getEdgeData().getAttributes().getValue(attributeColumn.getIndex());
                if ((val = DynamicUtilities.getDynamicValue(val, this.visibleInterval.getLow(), this.visibleInterval.getHigh())) != null) {
                    if (attributeColumn.getType().equals((Object)AttributeType.STRING) || attributeColumn.getType().equals((Object)AttributeType.LIST_STRING)) {
                        String quote = !this.useQuotes ? "" : (this.simpleQuotes ? "'" : "\"");
                        stringBuilder.append(quote);
                        stringBuilder.append(val.toString());
                        stringBuilder.append(quote);
                    } else {
                        stringBuilder.append(val.toString());
                    }
                }
                stringBuilder.append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("\n");
            Progress.progress(this.progressTicket);
        }
        graph.readUnlockAll();
        if (!this.cancel) {
            this.writer.append(stringBuilder);
        }
        Progress.finish(this.progressTicket);
    }

    private void attributesNodeColumns(AttributeModel attributeModel) {
        ArrayList<AttributeColumn> cols = new ArrayList<AttributeColumn>();
        if (attributeModel != null) {
            for (AttributeColumn column : attributeModel.getNodeTable().getColumns()) {
                if (this.isNodeDefaultColumn(column.getId())) continue;
                cols.add(column);
            }
        }
        this.nodeColumns = cols.toArray(new AttributeColumn[0]);
    }

    private void attributesEdgeColumns(AttributeModel attributeModel) {
        ArrayList<AttributeColumn> cols = new ArrayList<AttributeColumn>();
        if (attributeModel != null) {
            for (AttributeColumn column : attributeModel.getEdgeTable().getColumns()) {
                if (this.isEdgeDefaultColumn(column.getId())) continue;
                cols.add(column);
            }
        }
        this.edgeColumns = cols.toArray(new AttributeColumn[0]);
    }

    private boolean isNodeDefaultColumn(String id) {
        for (NodeColumnsGDF c : this.defaultNodeColumnsGDFs) {
            if (!c.title.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isEdgeDefaultColumn(String id) {
        for (EdgeColumnsGDF c : this.defaultEdgeColumnsGDFs) {
            if (!c.title.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private void defaultNodeColumns(Graph graph) {
        NodeColumnsGDF labelColumn = new NodeColumnsGDF("label"){

            public boolean isEnable() {
                return true;
            }

            public void writeData(StringBuilder builder, Node node) {
                String label = node.getNodeData().getLabel();
                if (label != null) {
                    String quote = !ExporterGDF.this.useQuotes ? "" : (ExporterGDF.this.simpleQuotes ? "'" : "\"");
                    builder.append(quote);
                    builder.append(label);
                    builder.append(quote);
                }
            }
        };
        NodeColumnsGDF visibleColumn = new NodeColumnsGDF("visible", DataTypeGDF.BOOLEAN){

            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            public void writeData(StringBuilder builder, Node node) {
                builder.append(true);
            }
        };
        NodeColumnsGDF labelVisibleColumn = new NodeColumnsGDF("labelvisible", DataTypeGDF.BOOLEAN){

            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            public void writeData(StringBuilder builder, Node node) {
                builder.append(node.getNodeData().getTextData().isVisible());
            }
        };
        NodeColumnsGDF widthColumn = new NodeColumnsGDF("width", DataTypeGDF.DOUBLE){

            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            public void writeData(StringBuilder builder, Node node) {
                float size = node.getNodeData().getSize();
                if (ExporterGDF.this.normalize) {
                    size = (size - ExporterGDF.this.minSize) / (ExporterGDF.this.maxSize - ExporterGDF.this.minSize);
                }
                builder.append(size);
            }
        };
        NodeColumnsGDF heightColumn = new NodeColumnsGDF("height", DataTypeGDF.DOUBLE){

            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            public void writeData(StringBuilder builder, Node node) {
                float size = node.getNodeData().getSize();
                if (ExporterGDF.this.normalize) {
                    size = (size - ExporterGDF.this.minSize) / (ExporterGDF.this.maxSize - ExporterGDF.this.minSize);
                }
                builder.append(size);
            }
        };
        NodeColumnsGDF xColumn = new NodeColumnsGDF("x", DataTypeGDF.DOUBLE){

            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            public void writeData(StringBuilder builder, Node node) {
                float x = node.getNodeData().x();
                if (ExporterGDF.this.normalize && (double)x != 0.0) {
                    x = (x - ExporterGDF.this.minX) / (ExporterGDF.this.maxX - ExporterGDF.this.minX);
                }
                builder.append(x);
            }
        };
        NodeColumnsGDF yColumn = new NodeColumnsGDF("y", DataTypeGDF.DOUBLE){

            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            public void writeData(StringBuilder builder, Node node) {
                float y = node.getNodeData().y();
                if (ExporterGDF.this.normalize && (double)y != 0.0) {
                    y = (y - ExporterGDF.this.minY) / (ExporterGDF.this.maxY - ExporterGDF.this.minY);
                }
                builder.append(y);
            }
        };
        NodeColumnsGDF colorColumn = new NodeColumnsGDF("color"){

            public boolean isEnable() {
                return ExporterGDF.this.exportColors;
            }

            public void writeData(StringBuilder builder, Node node) {
                String quote = "'";
                builder.append(quote);
                builder.append((int)(node.getNodeData().r() * 255.0f));
                builder.append(",");
                builder.append((int)(node.getNodeData().g() * 255.0f));
                builder.append(",");
                builder.append((int)(node.getNodeData().b() * 255.0f));
                builder.append(quote);
            }
        };
        NodeColumnsGDF fixedColumn = new NodeColumnsGDF("fixed", DataTypeGDF.BOOLEAN){

            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            public void writeData(StringBuilder builder, Node node) {
                builder.append(node.getNodeData().isFixed());
            }
        };
        NodeColumnsGDF styleColumn = new NodeColumnsGDF("style", DataTypeGDF.INT){

            public boolean isEnable() {
                return false;
            }

            public void writeData(StringBuilder builder, Node node) {
            }
        };
        this.defaultNodeColumnsGDFs = new NodeColumnsGDF[10];
        this.defaultNodeColumnsGDFs[0] = labelColumn;
        this.defaultNodeColumnsGDFs[1] = visibleColumn;
        this.defaultNodeColumnsGDFs[2] = labelVisibleColumn;
        this.defaultNodeColumnsGDFs[3] = widthColumn;
        this.defaultNodeColumnsGDFs[4] = heightColumn;
        this.defaultNodeColumnsGDFs[5] = xColumn;
        this.defaultNodeColumnsGDFs[6] = yColumn;
        this.defaultNodeColumnsGDFs[7] = colorColumn;
        this.defaultNodeColumnsGDFs[8] = fixedColumn;
        this.defaultNodeColumnsGDFs[9] = styleColumn;
    }

    private void defaultEdgeColumns(final Graph graph) {
        EdgeColumnsGDF labelColumn = new EdgeColumnsGDF("label"){

            public boolean isEnable() {
                return ExporterGDF.this.edgeLabels;
            }

            public void writeData(StringBuilder builder, Edge edge) {
                String label = edge.getEdgeData().getLabel();
                if (label != null) {
                    String quote = !ExporterGDF.this.useQuotes ? "" : (ExporterGDF.this.simpleQuotes ? "'" : "\"");
                    builder.append(quote);
                    builder.append(label);
                    builder.append(quote);
                }
            }
        };
        EdgeColumnsGDF weightColumn = new EdgeColumnsGDF("weight", DataTypeGDF.DOUBLE){

            public boolean isEnable() {
                return true;
            }

            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(edge.getWeight(ExporterGDF.this.visibleInterval.getLow(), ExporterGDF.this.visibleInterval.getHigh()));
            }
        };
        EdgeColumnsGDF directedColumn = new EdgeColumnsGDF("directed", DataTypeGDF.BOOLEAN){

            public boolean isEnable() {
                return true;
            }

            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(graph.isDirected(edge));
            }
        };
        EdgeColumnsGDF colorColumn = new EdgeColumnsGDF("color"){

            public boolean isEnable() {
                return ExporterGDF.this.exportColors && ExporterGDF.this.edgeColors;
            }

            public void writeData(StringBuilder builder, Edge edge) {
                if (edge.getEdgeData().r() != -1.0f) {
                    String quote = "'";
                    builder.append(quote);
                    builder.append((int)(edge.getEdgeData().r() * 255.0f));
                    builder.append(",");
                    builder.append((int)(edge.getEdgeData().g() * 255.0f));
                    builder.append(",");
                    builder.append((int)(edge.getEdgeData().b() * 255.0f));
                    builder.append(quote);
                }
            }
        };
        EdgeColumnsGDF visibleColumn = new EdgeColumnsGDF("visible", DataTypeGDF.BOOLEAN){

            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(true);
            }
        };
        EdgeColumnsGDF labelVisibleColumn = new EdgeColumnsGDF("labelvisible", DataTypeGDF.BOOLEAN){

            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(edge.getEdgeData().getTextData().isVisible());
            }
        };
        EdgeColumnsGDF edgeIdColumn = new EdgeColumnsGDF("id", DataTypeGDF.VARCHAR){

            public boolean isEnable() {
                return false;
            }

            public void writeData(StringBuilder builder, Edge edge) {
            }
        };
        this.defaultEdgeColumnsGDFs = new EdgeColumnsGDF[7];
        this.defaultEdgeColumnsGDFs[0] = edgeIdColumn;
        this.defaultEdgeColumnsGDFs[1] = labelColumn;
        this.defaultEdgeColumnsGDFs[2] = weightColumn;
        this.defaultEdgeColumnsGDFs[3] = directedColumn;
        this.defaultEdgeColumnsGDFs[4] = colorColumn;
        this.defaultEdgeColumnsGDFs[5] = visibleColumn;
        this.defaultEdgeColumnsGDFs[6] = labelVisibleColumn;
    }

    private void calculateMinMax(Graph graph) {
        this.minX = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.minSize = Float.POSITIVE_INFINITY;
        this.maxSize = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            NodeData nodeData = node.getNodeData();
            this.minX = Math.min(this.minX, nodeData.x());
            this.maxX = Math.max(this.maxX, nodeData.x());
            this.minY = Math.min(this.minY, nodeData.y());
            this.maxY = Math.max(this.maxY, nodeData.y());
            this.minSize = Math.min(this.minSize, nodeData.getSize());
            this.maxSize = Math.max(this.maxSize, nodeData.getSize());
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterGDF_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".gdf", NbBundle.getMessage(this.getClass(), (String)"fileType_GDF_Name"));
        return new FileType[]{ft};
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setSimpleQuotes(boolean simpleQuotes) {
        this.simpleQuotes = simpleQuotes;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isSimpleQuotes() {
        return this.simpleQuotes;
    }

    public boolean isUseQuotes() {
        return this.useQuotes;
    }

    public boolean isExportVisibility() {
        return this.exportVisibility;
    }

    public void setExportVisibility(boolean exportVisibility) {
        this.exportVisibility = exportVisibility;
    }

    public void setUseQuotes(boolean useQuotes) {
        this.useQuotes = useQuotes;
    }

    private DataTypeGDF getDataTypeGDF(AttributeType type) {
        switch (type) {
            case BOOLEAN: {
                return DataTypeGDF.BOOLEAN;
            }
            case DOUBLE: {
                return DataTypeGDF.DOUBLE;
            }
            case FLOAT: {
                return DataTypeGDF.FLOAT;
            }
            case INT: {
                return DataTypeGDF.INTEGER;
            }
            case LONG: {
                return DataTypeGDF.INTEGER;
            }
            case STRING: {
                return DataTypeGDF.VARCHAR;
            }
            case DYNAMIC_BOOLEAN: {
                return DataTypeGDF.BOOLEAN;
            }
            case DYNAMIC_DOUBLE: {
                return DataTypeGDF.DOUBLE;
            }
            case DYNAMIC_FLOAT: {
                return DataTypeGDF.FLOAT;
            }
            case DYNAMIC_INT: {
                return DataTypeGDF.INTEGER;
            }
            case DYNAMIC_LONG: {
                return DataTypeGDF.INTEGER;
            }
            case DYNAMIC_STRING: {
                return DataTypeGDF.VARCHAR;
            }
        }
        return DataTypeGDF.VARCHAR;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private abstract class EdgeColumnsGDF {
        protected final String title;
        protected final DataTypeGDF type;
        protected final Object defaultValue;

        public EdgeColumnsGDF(String title) {
            this(title, DataTypeGDF.VARCHAR);
        }

        public EdgeColumnsGDF(String title, DataTypeGDF type) {
            this(title, type, null);
        }

        public EdgeColumnsGDF(String title, DataTypeGDF type, Object defaultValue) {
            this.title = title;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public abstract boolean isEnable();

        public abstract void writeData(StringBuilder var1, Edge var2);

        public String getTitle() {
            return this.title;
        }

        public DataTypeGDF getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    private abstract class NodeColumnsGDF {
        protected final String title;
        protected final DataTypeGDF type;
        protected final Object defaultValue;

        public NodeColumnsGDF(String title) {
            this(title, DataTypeGDF.VARCHAR);
        }

        public NodeColumnsGDF(String title, DataTypeGDF type) {
            this(title, type, null);
        }

        public NodeColumnsGDF(String title, DataTypeGDF type, Object defaultValue) {
            this.title = title;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public abstract boolean isEnable();

        public abstract void writeData(StringBuilder var1, Node var2);

        public String getTitle() {
            return this.title;
        }

        public DataTypeGDF getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataTypeGDF {
        VARCHAR,
        BOOL,
        BOOLEAN,
        INTEGER,
        TINYINT,
        INT,
        DOUBLE,
        FLOAT;

    }
}

