/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExporterGEXF
implements GraphExporter,
CharacterExporter,
LongTask {
    private static final String GEXF = "gexf";
    private static final String GEXF_NAMESPACE = "http://www.gexf.net/1.1draft";
    private static final String GEXF_NAMESPACE_LOCATION = "http://www.gexf.net/1.1draft http://www.gexf.net/1.1draft/gexf.xsd";
    private static final String VIZ = "viz";
    private static final String VIZ_NAMESPACE = "http://www.gexf.net/1.1draft/viz";
    private static final String GEXF_VERSION = "version";
    private static final String GRAPH = "graph";
    private static final String GRAPH_MODE = "mode";
    private static final String GRAPH_DEFAULT_EDGETYPE = "defaultedgetype";
    private static final String GRAPH_START = "start";
    private static final String GRAPH_END = "end";
    private static final String GRAPH_TIMEFORMAT = "timeformat";
    private static final String META = "meta";
    private static final String META_LASTMODIFIEDDATE = "lastmodifieddate";
    private static final String META_CREATOR = "creator";
    private static final String META_DESCRIPTION = "description";
    private static final String NODES = "nodes";
    private static final String NODE = "node";
    private static final String NODE_ID = "id";
    private static final String NODE_LABEL = "label";
    private static final String NODE_PID = "pid";
    private static final String NODE_POSITION = "position";
    private static final String NODE_COLOR = "color";
    private static final String NODE_SIZE = "size";
    private static final String EDGES = "edges";
    private static final String EDGE = "edge";
    private static final String EDGE_ID = "id";
    private static final String EDGE_SOURCE = "source";
    private static final String EDGE_TARGET = "target";
    private static final String EDGE_LABEL = "label";
    private static final String EDGE_TYPE = "type";
    private static final String EDGE_WEIGHT = "weight";
    private static final String EDGE_COLOR = "color";
    private static final String START = "start";
    private static final String END = "end";
    private static final String START_OPEN = "startopen";
    private static final String END_OPEN = "endopen";
    private static final String SLICES = "slices";
    private static final String SLICE = "slice";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTES_CLASS = "class";
    private static final String ATTRIBUTES_MODE = "mode";
    private static final String ATTVALUES = "attvalues";
    private static final String ATTVALUE = "attvalue";
    private static final String ATTVALUE_FOR = "for";
    private static final String ATTVALUE_VALUE = "value";
    private boolean cancel = false;
    private ProgressTicket progress;
    private Workspace workspace;
    private boolean exportVisible;
    private Writer writer;
    private GraphModel graphModel;
    private AttributeModel attributeModel;
    private TimeInterval visibleInterval;
    private DynamicModel dynamicModel;
    private boolean normalize = false;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportSize = true;
    private boolean exportAttributes = true;
    private boolean exportHierarchy = false;
    private boolean exportDynamic = true;
    private float minSize;
    private float maxSize;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    public boolean execute() {
        this.attributeModel = (AttributeModel)this.workspace.getLookup().lookup(AttributeModel.class);
        this.graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        HierarchicalGraph graph = null;
        graph = this.exportVisible ? this.graphModel.getHierarchicalGraphVisible() : this.graphModel.getHierarchicalGraph();
        Progress.start(this.progress);
        graph.readLock();
        if (this.normalize) {
            this.calculateMinMax(graph);
        }
        int max = 0;
        if (this.exportHierarchy) {
            for (Node n : graph.getNodesTree()) {
                ++max;
            }
            for (Edge e : graph.getEdgesTree()) {
                ++max;
            }
        } else {
            max = graph.getNodeCount();
            for (Edge e : graph.getEdgesAndMetaEdges()) {
                ++max;
            }
        }
        Progress.switchToDeterminate(this.progress, max);
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
            XMLStreamWriter xmlWriter = outputFactory.createXMLStreamWriter(this.writer);
            xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.setPrefix("", GEXF_NAMESPACE);
            xmlWriter.writeStartElement(GEXF_NAMESPACE, GEXF);
            xmlWriter.writeNamespace("", GEXF_NAMESPACE);
            xmlWriter.writeAttribute(GEXF_VERSION, "1.1");
            if (this.exportColors || this.exportPosition || this.exportSize) {
                xmlWriter.writeNamespace(VIZ, VIZ_NAMESPACE);
            }
            xmlWriter.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xmlWriter.writeAttribute("xsi:schemaLocation", GEXF_NAMESPACE_LOCATION);
            if (this.exportDynamic) {
                DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
                DynamicModel dynamicModel = this.dynamicModel = dynamicController != null ? dynamicController.getModel(this.workspace) : null;
                this.visibleInterval = this.dynamicModel == null ? null : (this.exportVisible ? this.dynamicModel.getVisibleInterval() : new TimeInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            }
            this.writeMeta(xmlWriter);
            this.writeGraph(xmlWriter, graph);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.close();
        }
        catch (Exception e) {
            graph.readUnlockAll();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        graph.readUnlock();
        Progress.finish(this.progress);
        return !this.cancel;
    }

    private void writeGraph(XMLStreamWriter xmlWriter, HierarchicalGraph graph) throws Exception {
        xmlWriter.writeStartElement(GRAPH);
        xmlWriter.writeAttribute(GRAPH_DEFAULT_EDGETYPE, graph instanceof DirectedGraph ? "directed" : (graph instanceof UndirectedGraph ? "undirected" : "mixed"));
        if (this.exportDynamic) {
            if (!Double.isInfinite(this.visibleInterval.getLow())) {
                String intervalLow = this.formatTime(this.visibleInterval.getLow());
                xmlWriter.writeAttribute("start", intervalLow);
            }
            if (!Double.isInfinite(this.visibleInterval.getHigh())) {
                String intervalHigh = this.formatTime(this.visibleInterval.getHigh());
                xmlWriter.writeAttribute("end", intervalHigh);
            }
            String timeFormat = this.dynamicModel.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? "date" : "double";
            xmlWriter.writeAttribute(GRAPH_TIMEFORMAT, timeFormat);
        }
        xmlWriter.writeAttribute("mode", this.exportDynamic ? "dynamic" : "static");
        this.writeAttributes(xmlWriter, this.attributeModel.getNodeTable());
        this.writeAttributes(xmlWriter, this.attributeModel.getEdgeTable());
        this.writeNodes(xmlWriter, graph);
        this.writeEdges(xmlWriter, graph);
        xmlWriter.writeEndElement();
    }

    private void writeMeta(XMLStreamWriter xmlWriter) throws Exception {
        xmlWriter.writeStartElement(META);
        xmlWriter.writeAttribute(META_LASTMODIFIEDDATE, this.getDateTime());
        xmlWriter.writeStartElement(META_CREATOR);
        xmlWriter.writeCharacters("Gephi 0.7");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(META_DESCRIPTION);
        xmlWriter.writeCharacters("");
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private void writeAttributes(XMLStreamWriter xmlWriter, AttributeTable table) throws Exception {
        ArrayList<AttributeColumn> staticCols = new ArrayList<AttributeColumn>();
        ArrayList<AttributeColumn> dynamicCols = new ArrayList<AttributeColumn>();
        String attClass = table == this.attributeModel.getNodeTable() ? NODE : EDGE;
        for (AttributeColumn col : table.getColumns()) {
            if (!col.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) {
                if (this.exportDynamic && col.getType().isDynamicType()) {
                    dynamicCols.add(col);
                    continue;
                }
                staticCols.add(col);
                continue;
            }
            if (!this.exportDynamic || !col.getType().isDynamicType() || col.getType() == AttributeType.TIME_INTERVAL || !col.getOrigin().equals((Object)AttributeOrigin.PROPERTY) || col.getIndex() != PropertiesColumn.EDGE_WEIGHT.getIndex()) continue;
            dynamicCols.add(col);
        }
        if (!staticCols.isEmpty()) {
            this.writeAttributes(xmlWriter, staticCols.toArray(new AttributeColumn[0]), "static", attClass);
        }
        if (!dynamicCols.isEmpty()) {
            this.writeAttributes(xmlWriter, dynamicCols.toArray(new AttributeColumn[0]), "dynamic", attClass);
        }
    }

    private void writeAttributes(XMLStreamWriter xmlWriter, AttributeColumn[] cols, String mode, String attClass) throws Exception {
        if (this.exportAttributes) {
            xmlWriter.writeStartElement(ATTRIBUTES);
            xmlWriter.writeAttribute(ATTRIBUTES_CLASS, attClass);
            xmlWriter.writeAttribute("mode", mode);
            for (AttributeColumn col : cols) {
                if (col.getOrigin().equals((Object)AttributeOrigin.PROPERTY) && (!this.exportDynamic || !col.getOrigin().equals((Object)AttributeOrigin.PROPERTY) || col.getIndex() != PropertiesColumn.EDGE_WEIGHT.getIndex())) continue;
                xmlWriter.writeStartElement(ATTRIBUTE);
                xmlWriter.writeAttribute("id", col.getId());
                xmlWriter.writeAttribute(ATTRIBUTE_TITLE, col.getTitle());
                if (col.getType().equals((Object)AttributeType.INT)) {
                    xmlWriter.writeAttribute("type", "integer");
                } else if (col.getType().isListType()) {
                    if (col.getType().equals((Object)AttributeType.LIST_INTEGER)) {
                        xmlWriter.writeAttribute("type", "listint");
                    } else if (col.getType().equals((Object)AttributeType.LIST_CHARACTER)) {
                        xmlWriter.writeAttribute("type", "listchar");
                    } else {
                        xmlWriter.writeAttribute("type", col.getType().getTypeString().toLowerCase().replace("_", ""));
                    }
                } else if (col.getType().isDynamicType()) {
                    AttributeType staticType = TypeConvertor.getStaticType(col.getType());
                    if (staticType.equals((Object)AttributeType.INT)) {
                        xmlWriter.writeAttribute("type", "integer");
                    } else {
                        xmlWriter.writeAttribute("type", staticType.getTypeString().toLowerCase());
                    }
                } else {
                    xmlWriter.writeAttribute("type", col.getType().getTypeString().toLowerCase());
                }
                if (col.getDefaultValue() != null) {
                    xmlWriter.writeStartElement(ATTRIBUTE_DEFAULT);
                    xmlWriter.writeCharacters(col.getDefaultValue().toString());
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
    }

    private void writeNodes(XMLStreamWriter xmlWriter, HierarchicalGraph graph) throws Exception {
        if (this.cancel) {
            return;
        }
        xmlWriter.writeStartElement(NODES);
        AttributeColumn dynamicCol = this.attributeModel.getNodeTable().getColumn("time_interval");
        NodeIterable nodeIterable = this.exportHierarchy ? graph.getNodesTree() : graph.getNodes();
        for (Node node : nodeIterable) {
            TimeInterval timeInterval;
            Node parent;
            xmlWriter.writeStartElement(NODE);
            String id = node.getNodeData().getId();
            xmlWriter.writeAttribute("id", id);
            if (node.getNodeData().getLabel() != null && !node.getNodeData().getLabel().isEmpty()) {
                xmlWriter.writeAttribute("label", node.getNodeData().getLabel());
            }
            if (this.exportHierarchy && (parent = graph.getParent(node)) != null) {
                xmlWriter.writeAttribute(NODE_PID, parent.getNodeData().getId());
            }
            if (this.exportDynamic && dynamicCol != null && this.visibleInterval != null && (timeInterval = (TimeInterval)node.getNodeData().getAttributes().getValue(dynamicCol.getIndex())) != null) {
                this.writeTimeInterval(xmlWriter, timeInterval);
            }
            if (this.exportAttributes && node.getNodeData().getAttributes() != null) {
                AttributeRow attributeRow = (AttributeRow)node.getNodeData().getAttributes();
                this.writeAttValues(xmlWriter, attributeRow, this.visibleInterval);
            }
            if (this.exportSize) {
                this.writeNodeSize(xmlWriter, node);
            }
            if (this.exportPosition) {
                this.writeNodePosition(xmlWriter, node);
            }
            if (this.exportColors) {
                this.writeNodeColor(xmlWriter, node);
            }
            xmlWriter.writeEndElement();
            Progress.progress(this.progress);
            if (!this.cancel) continue;
            break;
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttValues(XMLStreamWriter xmlWriter, AttributeRow row, TimeInterval visibleInterval) throws Exception {
        xmlWriter.writeStartElement(ATTVALUES);
        for (AttributeValue val : row.getValues()) {
            AttributeColumn col = val.getColumn();
            if (col.getOrigin().equals((Object)AttributeOrigin.PROPERTY) && (!this.exportDynamic || !col.getOrigin().equals((Object)AttributeOrigin.PROPERTY) || col.getIndex() != PropertiesColumn.EDGE_WEIGHT.getIndex())) continue;
            AttributeType type = col.getType();
            if (type.isDynamicType()) {
                Object value;
                DynamicType dynamicValue = (DynamicType)val.getValue();
                if (dynamicValue != null && visibleInterval != null && this.exportDynamic) {
                    List intervals = dynamicValue.getIntervals(visibleInterval.getLow(), visibleInterval.getHigh());
                    for (Interval interval : intervals) {
                        Object value2 = interval.getValue();
                        if (value2 == null) continue;
                        xmlWriter.writeStartElement(ATTVALUE);
                        xmlWriter.writeAttribute(ATTVALUE_FOR, col.getId());
                        xmlWriter.writeAttribute(ATTVALUE_VALUE, value2.toString());
                        if (!Double.isInfinite(interval.getLow())) {
                            String intervalLow = this.formatTime(interval.getLow());
                            xmlWriter.writeAttribute(interval.isLowExcluded() ? START_OPEN : "start", intervalLow);
                        }
                        if (!Double.isInfinite(interval.getHigh())) {
                            String intervalHigh = this.formatTime(interval.getHigh());
                            xmlWriter.writeAttribute(interval.isHighExcluded() ? END_OPEN : "end", intervalHigh);
                        }
                        xmlWriter.writeEndElement();
                    }
                    continue;
                }
                if (dynamicValue == null) continue;
                TimeInterval interval = visibleInterval;
                if (interval == null) {
                    interval = new TimeInterval();
                }
                if ((value = DynamicUtilities.getDynamicValue(dynamicValue, interval.getLow(), interval.getHigh())) == null) continue;
                xmlWriter.writeStartElement(ATTVALUE);
                xmlWriter.writeAttribute(ATTVALUE_FOR, val.getColumn().getId());
                xmlWriter.writeAttribute(ATTVALUE_VALUE, value.toString());
                xmlWriter.writeEndElement();
                continue;
            }
            if (val.getValue() == null) continue;
            xmlWriter.writeStartElement(ATTVALUE);
            xmlWriter.writeAttribute(ATTVALUE_FOR, col.getId());
            xmlWriter.writeAttribute(ATTVALUE_VALUE, val.getValue().toString());
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    private void writeNodePosition(XMLStreamWriter xmlWriter, Node node) throws Exception {
        float x = node.getNodeData().x();
        if (this.normalize && (double)x != 0.0) {
            x = (x - this.minX) / (this.maxX - this.minX);
        }
        float y = node.getNodeData().y();
        if (this.normalize && (double)y != 0.0) {
            y = (y - this.minY) / (this.maxY - this.minY);
        }
        float z = node.getNodeData().z();
        if (this.normalize && (double)z != 0.0) {
            z = (z - this.minZ) / (this.maxZ - this.minZ);
        }
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            xmlWriter.writeStartElement(VIZ, NODE_POSITION, VIZ_NAMESPACE);
            xmlWriter.writeAttribute("x", "" + x);
            xmlWriter.writeAttribute("y", "" + y);
            if (z != 0.0f) {
                xmlWriter.writeAttribute("z", "" + z);
            }
            xmlWriter.writeEndElement();
        }
    }

    private void writeNodeSize(XMLStreamWriter xmlWriter, Node node) throws Exception {
        xmlWriter.writeStartElement(VIZ, NODE_SIZE, VIZ_NAMESPACE);
        float size = node.getNodeData().getSize();
        if (this.normalize) {
            size = (size - this.minSize) / (this.maxSize - this.minSize);
        }
        xmlWriter.writeAttribute(ATTVALUE_VALUE, "" + size);
        xmlWriter.writeEndElement();
    }

    private void writeNodeColor(XMLStreamWriter xmlWriter, Node node) throws Exception {
        int r = Math.round(node.getNodeData().r() * 255.0f);
        int g = Math.round(node.getNodeData().g() * 255.0f);
        int b = Math.round(node.getNodeData().b() * 255.0f);
        if (r != 0 || g != 0 || b != 0) {
            xmlWriter.writeStartElement(VIZ, "color", VIZ_NAMESPACE);
            xmlWriter.writeAttribute("r", "" + r);
            xmlWriter.writeAttribute("g", "" + g);
            xmlWriter.writeAttribute("b", "" + b);
            xmlWriter.writeEndElement();
        }
    }

    private void writeTimeInterval(XMLStreamWriter xmlWriter, TimeInterval timeInterval) throws Exception {
        List intervals = timeInterval.getIntervals(this.visibleInterval.getLow(), this.visibleInterval.getHigh());
        if (intervals.size() > 1) {
            xmlWriter.writeStartElement(SLICES);
            for (Interval interval : intervals) {
                xmlWriter.writeStartElement(SLICE);
                if (!Double.isInfinite(interval.getLow())) {
                    String intervalLow = this.formatTime(interval.getLow());
                    xmlWriter.writeAttribute(interval.isLowExcluded() ? START_OPEN : "start", intervalLow);
                }
                if (!Double.isInfinite(interval.getHigh())) {
                    String intervalHigh = this.formatTime(interval.getHigh());
                    xmlWriter.writeAttribute(interval.isHighExcluded() ? END_OPEN : "end", intervalHigh);
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        } else if (intervals.size() == 1) {
            Interval interval = intervals.get(0);
            if (!Double.isInfinite(interval.getLow())) {
                String intervalLow = this.formatTime(interval.getLow());
                xmlWriter.writeAttribute(interval.isLowExcluded() ? START_OPEN : "start", intervalLow);
            }
            if (!Double.isInfinite(interval.getHigh())) {
                String intervalHigh = this.formatTime(interval.getHigh());
                xmlWriter.writeAttribute(interval.isHighExcluded() ? END_OPEN : "end", intervalHigh);
            }
        }
    }

    private void writeEdges(XMLStreamWriter xmlWriter, HierarchicalGraph graph) throws Exception {
        if (this.cancel) {
            return;
        }
        xmlWriter.writeStartElement(EDGES);
        AttributeColumn dynamicCol = this.attributeModel.getEdgeTable().getColumn("time_interval");
        EdgeIterable edgeIterable = this.exportHierarchy ? graph.getEdgesTree() : graph.getEdgesAndMetaEdges();
        for (Edge edge : edgeIterable) {
            TimeInterval timeInterval;
            float weight;
            xmlWriter.writeStartElement(EDGE);
            if (edge.getEdgeData().getId() != null && !edge.getEdgeData().getId().equals(Integer.toString(edge.getId()))) {
                xmlWriter.writeAttribute("id", edge.getEdgeData().getId());
            }
            xmlWriter.writeAttribute(EDGE_SOURCE, edge.getSource().getNodeData().getId());
            xmlWriter.writeAttribute(EDGE_TARGET, edge.getTarget().getNodeData().getId());
            if (edge.isDirected() && this.graphModel.isMixed()) {
                xmlWriter.writeAttribute("type", "directed");
            } else if (!edge.isDirected() && this.graphModel.isMixed()) {
                xmlWriter.writeAttribute("type", "undirected");
            }
            String label = edge.getEdgeData().getLabel();
            if (label != null && !label.isEmpty()) {
                xmlWriter.writeAttribute("label", label);
            }
            if ((weight = edge.getWeight()) != 1.0f) {
                xmlWriter.writeAttribute(EDGE_WEIGHT, "" + weight);
            }
            if (this.exportDynamic && dynamicCol != null && this.visibleInterval != null && (timeInterval = (TimeInterval)edge.getEdgeData().getAttributes().getValue(dynamicCol.getIndex())) != null) {
                this.writeTimeInterval(xmlWriter, timeInterval);
            }
            if (this.exportColors) {
                this.writeEdgeColor(xmlWriter, edge);
            }
            if (this.exportAttributes && edge.getEdgeData().getAttributes() != null) {
                AttributeRow attributeRow = (AttributeRow)edge.getEdgeData().getAttributes();
                this.writeAttValues(xmlWriter, attributeRow, this.visibleInterval);
            }
            xmlWriter.writeEndElement();
            Progress.progress(this.progress);
            if (!this.cancel) continue;
            break;
        }
        xmlWriter.writeEndElement();
    }

    private void writeEdgeColor(XMLStreamWriter xmlWriter, Edge edge) throws Exception {
        if (edge.getEdgeData().r() != -1.0f) {
            int r = Math.round(edge.getEdgeData().r() * 255.0f);
            int g = Math.round(edge.getEdgeData().g() * 255.0f);
            int b = Math.round(edge.getEdgeData().b() * 255.0f);
            if (r != 0 || g != 0 || b != 0) {
                xmlWriter.writeStartElement(VIZ, "color", VIZ_NAMESPACE);
                xmlWriter.writeAttribute("r", "" + r);
                xmlWriter.writeAttribute("g", "" + g);
                xmlWriter.writeAttribute("b", "" + b);
                if (edge.getEdgeData().alpha() != 1.0f) {
                    xmlWriter.writeAttribute("a", "" + b);
                }
                xmlWriter.writeEndElement();
            }
        }
    }

    private void calculateMinMax(Graph graph) {
        this.minX = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.minZ = Float.POSITIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.minSize = Float.POSITIVE_INFINITY;
        this.maxSize = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            NodeData nodeData = node.getNodeData();
            this.minX = Math.min(this.minX, nodeData.x());
            this.maxX = Math.max(this.maxX, nodeData.x());
            this.minY = Math.min(this.minY, nodeData.y());
            this.maxY = Math.max(this.maxY, nodeData.y());
            this.minZ = Math.min(this.minZ, nodeData.z());
            this.maxZ = Math.max(this.maxZ, nodeData.z());
            this.minSize = Math.min(this.minSize, nodeData.getSize());
            this.maxSize = Math.max(this.maxSize, nodeData.getSize());
        }
    }

    private String formatTime(double time) {
        if (this.dynamicModel.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE)) {
            String t = DynamicUtilities.getXMLDateStringFromDouble(time);
            if (t.endsWith("T00:00:00.000")) {
                t = t.substring(0, t.length() - 13);
            }
            return t;
        }
        return Double.toString(time);
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterGEXF_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".gexf", NbBundle.getMessage(this.getClass(), (String)"fileType_GEXF_Name"));
        return new FileType[]{ft};
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setExportDynamic(boolean exportDynamic) {
        this.exportDynamic = exportDynamic;
    }

    public void setExportHierarchy(boolean exportHierarchy) {
        this.exportHierarchy = exportHierarchy;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public boolean isExportDynamic() {
        return this.exportDynamic;
    }

    public boolean isExportHierarchy() {
        return this.exportHierarchy;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

