/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExporterGraphML
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private Workspace workspace;
    private Writer writer;
    private boolean exportVisible;
    private GraphModel graphModel;
    private AttributeModel attributeModel;
    private boolean normalize = false;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportSize = true;
    private boolean exportAttributes = true;
    private boolean exportHierarchy = false;
    private float minSize;
    private float maxSize;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;
    private TimeInterval visibleInterval;

    public boolean execute() {
        this.attributeModel = (AttributeModel)this.workspace.getLookup().lookup(AttributeModel.class);
        this.graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        HierarchicalGraph graph = null;
        graph = this.exportVisible ? this.graphModel.getHierarchicalGraphVisible() : this.graphModel.getHierarchicalGraph();
        DynamicModel dynamicModel = (DynamicModel)this.workspace.getLookup().lookup(DynamicModel.class);
        this.visibleInterval = dynamicModel != null && this.exportVisible ? dynamicModel.getVisibleInterval() : new TimeInterval();
        try {
            this.exportData(this.createDocument(), graph, this.attributeModel);
        }
        catch (Exception e) {
            graph.readUnlockAll();
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        return document;
    }

    private void transform(Document document) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(this.writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, result);
    }

    public boolean exportData(Document document, HierarchicalGraph graph, AttributeModel model) throws Exception {
        int max;
        Progress.start(this.progressTicket);
        graph.readLock();
        this.calculateMinMax(graph);
        if (this.graphModel.isHierarchical()) {
            HierarchicalGraph hgraph = this.graphModel.getHierarchicalGraph();
            max = hgraph.getNodeCount() + hgraph.getEdgeCount();
        } else {
            max = graph.getNodeCount() + graph.getEdgeCount();
        }
        Progress.switchToDeterminate(this.progressTicket, max);
        Element root = document.createElementNS("http://graphml.graphdrawing.org/xmlns", "graphml");
        document.appendChild(root);
        this.createKeys(document, root);
        Element graphE = this.createGraph(document, graph);
        root.appendChild(graphE);
        graph.readUnlockAll();
        if (!this.cancel) {
            this.transform(document);
        }
        Progress.finish(this.progressTicket);
        return !this.cancel;
    }

    private void createKeys(Document document, Element root) {
        Element nodeLabelKeyE = document.createElement("key");
        nodeLabelKeyE.setAttribute("id", "label");
        nodeLabelKeyE.setAttribute("attr.name", "label");
        nodeLabelKeyE.setAttribute("attr.type", "string");
        nodeLabelKeyE.setAttribute("for", "node");
        root.appendChild(nodeLabelKeyE);
        Element edgeLabelKeyE = document.createElement("key");
        edgeLabelKeyE.setAttribute("id", "edgelabel");
        edgeLabelKeyE.setAttribute("attr.name", "Edge Label");
        edgeLabelKeyE.setAttribute("attr.type", "string");
        edgeLabelKeyE.setAttribute("for", "edge");
        root.appendChild(edgeLabelKeyE);
        Element weightKeyE = document.createElement("key");
        weightKeyE.setAttribute("id", "weight");
        weightKeyE.setAttribute("attr.name", "weight");
        weightKeyE.setAttribute("attr.type", "double");
        weightKeyE.setAttribute("for", "edge");
        root.appendChild(weightKeyE);
        Element edgeIdKeyE = document.createElement("key");
        edgeIdKeyE.setAttribute("id", "edgeid");
        edgeIdKeyE.setAttribute("attr.name", "Edge Id");
        edgeIdKeyE.setAttribute("attr.type", "string");
        edgeIdKeyE.setAttribute("for", "edge");
        root.appendChild(edgeIdKeyE);
        if (this.exportColors) {
            Element colorRKeyE = document.createElement("key");
            colorRKeyE.setAttribute("id", "r");
            colorRKeyE.setAttribute("attr.name", "r");
            colorRKeyE.setAttribute("attr.type", "int");
            colorRKeyE.setAttribute("for", "node");
            root.appendChild(colorRKeyE);
            Element colorGKeyE = document.createElement("key");
            colorGKeyE.setAttribute("id", "g");
            colorGKeyE.setAttribute("attr.name", "g");
            colorGKeyE.setAttribute("attr.type", "int");
            colorGKeyE.setAttribute("for", "node");
            root.appendChild(colorGKeyE);
            Element colorBKeyE = document.createElement("key");
            colorBKeyE.setAttribute("id", "b");
            colorBKeyE.setAttribute("attr.name", "b");
            colorBKeyE.setAttribute("attr.type", "int");
            colorBKeyE.setAttribute("for", "node");
            root.appendChild(colorBKeyE);
        }
        if (this.exportPosition) {
            Element positionKeyE = document.createElement("key");
            positionKeyE.setAttribute("id", "x");
            positionKeyE.setAttribute("attr.name", "x");
            positionKeyE.setAttribute("attr.type", "float");
            positionKeyE.setAttribute("for", "node");
            root.appendChild(positionKeyE);
            Element positionKey2E = document.createElement("key");
            positionKey2E.setAttribute("id", "y");
            positionKey2E.setAttribute("attr.name", "y");
            positionKey2E.setAttribute("attr.type", "float");
            positionKey2E.setAttribute("for", "node");
            root.appendChild(positionKey2E);
            if (this.minZ != 0.0f || this.maxZ != 0.0f) {
                Element positionKey3E = document.createElement("key");
                positionKey3E.setAttribute("id", "z");
                positionKey3E.setAttribute("attr.name", "z");
                positionKey3E.setAttribute("attr.type", "float");
                positionKey3E.setAttribute("for", "node");
                root.appendChild(positionKey3E);
            }
        }
        if (this.exportSize) {
            Element sizeKeyE = document.createElement("key");
            sizeKeyE.setAttribute("id", "size");
            sizeKeyE.setAttribute("attr.name", "size");
            sizeKeyE.setAttribute("attr.type", "float");
            sizeKeyE.setAttribute("for", "node");
            root.appendChild(sizeKeyE);
        }
        if (this.attributeModel != null && this.exportAttributes) {
            Element attributeE;
            for (AttributeColumn column : this.attributeModel.getNodeTable().getColumns()) {
                if (column.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
                attributeE = this.createAttribute(document, column);
                attributeE.setAttribute("for", "node");
                root.appendChild(attributeE);
            }
            for (AttributeColumn column : this.attributeModel.getEdgeTable().getColumns()) {
                if (column.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
                attributeE = this.createAttribute(document, column);
                attributeE.setAttribute("for", "edge");
                root.appendChild(attributeE);
            }
        }
    }

    private Element createGraph(Document document, Graph graph) throws Exception {
        Element graphE = document.createElement("graph");
        if (this.graphModel.isDirected()) {
            graphE.setAttribute("edgedefault", "directed");
        } else {
            graphE.setAttribute("edgedefault", "undirected");
        }
        this.createNodes(document, graphE, graph, null);
        this.createEdges(document, graphE, graph);
        return graphE;
    }

    private Element createAttribute(Document document, AttributeColumn column) {
        Element attributeE = document.createElement("key");
        attributeE.setAttribute("id", column.getId());
        attributeE.setAttribute("attr.name", column.getTitle());
        switch (column.getType()) {
            case INT: {
                attributeE.setAttribute("attr.type", "int");
                break;
            }
            default: {
                attributeE.setAttribute("attr.type", column.getType().getTypeString().toLowerCase());
            }
        }
        if (column.getDefaultValue() != null) {
            Element defaultE = document.createElement("default");
            Text defaultTextE = document.createTextNode(column.getDefaultValue().toString());
            defaultE.appendChild(defaultTextE);
        }
        return attributeE;
    }

    private Element createNodeAttvalue(Document document, AttributeColumn column, Node n) throws Exception {
        int index = column.getIndex();
        if (n.getNodeData().getAttributes().getValue(index) != null) {
            Object val = n.getNodeData().getAttributes().getValue(index);
            val = DynamicUtilities.getDynamicValue(val, this.visibleInterval.getLow(), this.visibleInterval.getHigh());
            String value = val.toString();
            String id = column.getId();
            Element attvalueE = document.createElement("data");
            attvalueE.setAttribute("key", id);
            attvalueE.setTextContent(value);
            return attvalueE;
        }
        return null;
    }

    private Element createEdgeAttvalue(Document document, AttributeColumn column, Edge e) throws Exception {
        int index = column.getIndex();
        if (e.getEdgeData().getAttributes().getValue(index) != null) {
            Object val = e.getEdgeData().getAttributes().getValue(index);
            val = DynamicUtilities.getDynamicValue(val, this.visibleInterval.getLow(), this.visibleInterval.getHigh());
            String value = val.toString();
            String id = column.getId();
            Element attvalueE = document.createElement("data");
            attvalueE.setAttribute("key", id);
            attvalueE.setTextContent(value);
            return attvalueE;
        }
        return null;
    }

    private void createNodes(Document document, Element parentE, Graph graph, Node nodeParent) throws Exception {
        if (nodeParent != null) {
            Element graphE = document.createElement("graph");
            if (this.graphModel.isDirected()) {
                graphE.setAttribute("edgedefault", "directed");
            } else {
                graphE.setAttribute("edgedefault", "undirected");
            }
            HierarchicalGraph hgraph = this.graphModel.getHierarchicalGraph();
            for (Node n : hgraph.getChildren(nodeParent)) {
                Element childE = this.createNode(document, graph, n);
                graphE.appendChild(childE);
            }
            parentE.appendChild(graphE);
        } else if (this.exportHierarchy && this.graphModel.isHierarchical()) {
            HierarchicalGraph hgraph = this.graphModel.getHierarchicalGraph();
            for (Node n : hgraph.getTopNodes()) {
                Element nodeE = this.createNode(document, hgraph, n);
                parentE.appendChild(nodeE);
            }
        } else {
            for (Node n : graph.getNodes()) {
                if (!this.cancel) {
                    Element nodeE = this.createNode(document, graph, n);
                    parentE.appendChild(nodeE);
                    continue;
                }
                break;
            }
        }
    }

    private Element createNode(Document document, Graph graph, Node n) throws Exception {
        HierarchicalGraph hgraph;
        int childCount;
        Element nodeE = document.createElement("node");
        nodeE.setAttribute("id", n.getNodeData().getId());
        if (n.getNodeData().getLabel() != null && !n.getNodeData().getLabel().isEmpty()) {
            Element labelE = this.createNodeLabel(document, n);
            nodeE.appendChild(labelE);
        }
        if (this.attributeModel != null && this.exportAttributes) {
            for (AttributeColumn column : this.attributeModel.getNodeTable().getColumns()) {
                Element attvalueE;
                if (column.getOrigin().equals((Object)AttributeOrigin.PROPERTY) || (attvalueE = this.createNodeAttvalue(document, column, n)) == null) continue;
                nodeE.appendChild(attvalueE);
            }
        }
        if (this.exportSize) {
            Element sizeE = this.createNodeSize(document, n);
            nodeE.appendChild(sizeE);
        }
        if (this.exportColors) {
            Element colorE = this.createNodeColorR(document, n);
            nodeE.appendChild(colorE);
            colorE = this.createNodeColorG(document, n);
            nodeE.appendChild(colorE);
            colorE = this.createNodeColorB(document, n);
            nodeE.appendChild(colorE);
        }
        if (this.exportPosition) {
            Element positionXE = this.createNodePositionX(document, n);
            nodeE.appendChild(positionXE);
            Element positionYE = this.createNodePositionY(document, n);
            nodeE.appendChild(positionYE);
            if (this.minZ != 0.0f || this.maxZ != 0.0f) {
                Element positionZE = this.createNodePositionZ(document, n);
                nodeE.appendChild(positionZE);
            }
        }
        if (this.exportHierarchy && this.graphModel.isHierarchical() && (childCount = (hgraph = this.graphModel.getHierarchicalGraph()).getChildrenCount(n)) != 0) {
            this.createNodes(document, nodeE, graph, n);
        }
        Progress.progress(this.progressTicket);
        return nodeE;
    }

    private void createEdges(Document document, Element edgesE, Graph graph) throws Exception {
        HierarchicalGraph hgraph = this.graphModel.getHierarchicalGraph();
        EdgeIterable it = this.exportHierarchy && this.graphModel.isHierarchical() ? hgraph.getEdgesTree() : hgraph.getEdgesAndMetaEdges();
        for (Edge e : it.toArray()) {
            if (this.cancel) break;
            Element edgeE = this.createEdge(document, e);
            edgesE.appendChild(edgeE);
        }
    }

    private Element createEdge(Document document, Edge e) throws Exception {
        Element edgeE = document.createElement("edge");
        edgeE.setAttribute("source", e.getSource().getNodeData().getId());
        edgeE.setAttribute("target", e.getTarget().getNodeData().getId());
        if (e.getEdgeData().getId() != null && !e.getEdgeData().getId().isEmpty() && !String.valueOf(e.getId()).equals(e.getEdgeData().getId())) {
            Element idE = this.createEdgeId(document, e);
            edgeE.appendChild(idE);
        }
        if (e.getEdgeData().getLabel() != null && !e.getEdgeData().getLabel().isEmpty()) {
            Element labelE = this.createEdgeLabel(document, e);
            edgeE.appendChild(labelE);
        }
        Element weightE = this.createEdgeWeight(document, e);
        edgeE.appendChild(weightE);
        if (e.isDirected() && !this.graphModel.isDirected()) {
            edgeE.setAttribute("type", "directed");
        } else if (!e.isDirected() && this.graphModel.isDirected()) {
            edgeE.setAttribute("type", "undirected");
        }
        if (this.attributeModel != null) {
            for (AttributeColumn column : this.attributeModel.getEdgeTable().getColumns()) {
                Element attvalueE;
                if (column.getOrigin().equals((Object)AttributeOrigin.PROPERTY) || (attvalueE = this.createEdgeAttvalue(document, column, e)) == null) continue;
                edgeE.appendChild(attvalueE);
            }
        }
        Progress.progress(this.progressTicket);
        return edgeE;
    }

    private Element createNodeSize(Document document, Node n) throws Exception {
        Element sizeE = document.createElement("data");
        float size = n.getNodeData().getSize();
        if (this.normalize) {
            size = (size - this.minSize) / (this.maxSize - this.minSize);
        }
        sizeE.setAttribute("key", "size");
        sizeE.setTextContent("" + size);
        return sizeE;
    }

    private Element createNodeColorR(Document document, Node n) throws Exception {
        int r = Math.round(n.getNodeData().r() * 255.0f);
        Element colorE = document.createElement("data");
        colorE.setAttribute("key", "r");
        colorE.setTextContent("" + r);
        return colorE;
    }

    private Element createNodeColorG(Document document, Node n) throws Exception {
        int g = Math.round(n.getNodeData().g() * 255.0f);
        Element colorE = document.createElement("data");
        colorE.setAttribute("key", "g");
        colorE.setTextContent("" + g);
        return colorE;
    }

    private Element createNodeColorB(Document document, Node n) throws Exception {
        int b = Math.round(n.getNodeData().b() * 255.0f);
        Element colorE = document.createElement("data");
        colorE.setAttribute("key", "b");
        colorE.setTextContent("" + b);
        return colorE;
    }

    private Element createNodePositionX(Document document, Node n) throws Exception {
        Element positionXE = document.createElement("data");
        float x = n.getNodeData().x();
        if (this.normalize && (double)x != 0.0) {
            x = (x - this.minX) / (this.maxX - this.minX);
        }
        positionXE.setAttribute("key", "x");
        positionXE.setTextContent("" + x);
        return positionXE;
    }

    private Element createNodePositionY(Document document, Node n) throws Exception {
        Element positionYE = document.createElement("data");
        float y = n.getNodeData().y();
        if (this.normalize && (double)y != 0.0) {
            y = (y - this.minY) / (this.maxY - this.minY);
        }
        positionYE.setAttribute("key", "y");
        positionYE.setTextContent("" + y);
        return positionYE;
    }

    private Element createNodePositionZ(Document document, Node n) throws Exception {
        Element positionZE = document.createElement("data");
        float z = n.getNodeData().z();
        if (this.normalize && (double)z != 0.0) {
            z = (z - this.minZ) / (this.maxZ - this.minZ);
        }
        positionZE.setAttribute("key", "z");
        positionZE.setTextContent("" + z);
        return positionZE;
    }

    private Element createNodeLabel(Document document, Node n) throws Exception {
        Element labelE = document.createElement("data");
        labelE.setAttribute("key", "label");
        labelE.setTextContent(n.getNodeData().getLabel());
        return labelE;
    }

    private Element createEdgeId(Document document, Edge e) throws Exception {
        Element idE = document.createElement("data");
        idE.setAttribute("key", "edgeid");
        idE.setTextContent(e.getEdgeData().getId());
        return idE;
    }

    private Element createEdgeWeight(Document document, Edge e) throws Exception {
        Element weightE = document.createElement("data");
        weightE.setAttribute("key", "weight");
        weightE.setTextContent(Float.toString(e.getWeight(this.visibleInterval.getLow(), this.visibleInterval.getHigh())));
        return weightE;
    }

    private Element createEdgeLabel(Document document, Edge e) throws Exception {
        Element labelE = document.createElement("data");
        labelE.setAttribute("key", "edgelabel");
        labelE.setTextContent(e.getEdgeData().getLabel());
        return labelE;
    }

    private void calculateMinMax(Graph graph) {
        this.minX = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.minZ = Float.POSITIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.minSize = Float.POSITIVE_INFINITY;
        this.maxSize = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            NodeData nodeData = node.getNodeData();
            this.minX = Math.min(this.minX, nodeData.x());
            this.maxX = Math.max(this.maxX, nodeData.x());
            this.minY = Math.min(this.minY, nodeData.y());
            this.maxY = Math.max(this.maxY, nodeData.y());
            this.minZ = Math.min(this.minZ, nodeData.z());
            this.maxZ = Math.max(this.maxZ, nodeData.z());
            this.minSize = Math.min(this.minSize, nodeData.getSize());
            this.maxSize = Math.max(this.maxSize, nodeData.getSize());
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterGraphML_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".graphml", NbBundle.getMessage(this.getClass(), (String)"fileType_GraphML_Name"));
        return new FileType[]{ft};
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public boolean isExportHierarchy() {
        return this.exportHierarchy;
    }

    public void setExportHierarchy(boolean exportHierarchy) {
        this.exportHierarchy = exportHierarchy;
    }
}

