/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.preview;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.gephi.io.exporter.spi.ByteExporter;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.preview.api.BidirectionalEdge;
import org.gephi.preview.api.Color;
import org.gephi.preview.api.CubicBezierCurve;
import org.gephi.preview.api.DirectedEdge;
import org.gephi.preview.api.Edge;
import org.gephi.preview.api.EdgeArrow;
import org.gephi.preview.api.EdgeLabel;
import org.gephi.preview.api.EdgeMiniLabel;
import org.gephi.preview.api.Graph;
import org.gephi.preview.api.GraphRenderer;
import org.gephi.preview.api.GraphSheet;
import org.gephi.preview.api.Node;
import org.gephi.preview.api.NodeLabel;
import org.gephi.preview.api.NodeLabelBorder;
import org.gephi.preview.api.Point;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.SelfLoop;
import org.gephi.preview.api.UndirectedEdge;
import org.gephi.preview.api.UnidirectionalEdge;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import sun.font.FontManager;

public class PDFExporter
implements GraphRenderer,
ByteExporter,
VectorExporter,
LongTask {
    private ProgressTicket progress;
    private Workspace workspace;
    private OutputStream stream;
    private boolean cancel = false;
    private PdfContentByte cb;
    private Document document;
    private float marginTop = 18.0f;
    private float marginBottom = 18.0f;
    private float marginLeft = 18.0f;
    private float marginRight = 18.0f;
    private boolean landscape = false;
    private Rectangle pageSize = PageSize.A4;
    private FontMapper fontMapper;

    public boolean execute() {
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        GraphSheet graphSheet = controller.getGraphSheet();
        Graph graph = graphSheet.getGraph();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        double pageHeight;
        double ratioHeight;
        Progress.start(this.progress);
        int max = 0;
        if (graph.showNodes().booleanValue()) {
            max += graph.countNodes();
        }
        if (graph.showEdges().booleanValue()) {
            max += graph.countUnidirectionalEdges() + graph.countBidirectionalEdges();
            if (graph.showSelfLoops().booleanValue()) {
                max += graph.countSelfLoops();
            }
        }
        Progress.switchToDeterminate(this.progress, max);
        Rectangle size = new Rectangle(this.pageSize);
        if (this.landscape) {
            size = new Rectangle(this.pageSize.rotate());
        }
        size.setBackgroundColor(new BaseColor(((PreviewController)Lookup.getDefault().lookup(PreviewController.class)).getModel().getBackgroundColor()));
        this.document = new Document(size);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.stream);
        this.document.open();
        this.cb = pdfWriter.getDirectContent();
        this.cb.saveState();
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (Node n : graph.getNodes()) {
            minX = Math.min(minX, n.getPosition().getX().floatValue() - n.getRadius().floatValue() - n.getBorderWidth().floatValue());
            maxX = Math.max(maxX, n.getPosition().getX().floatValue() + n.getRadius().floatValue() + n.getBorderWidth().floatValue());
            minY = Math.min(minY, -n.getPosition().getY().floatValue() - n.getRadius().floatValue() - n.getBorderWidth().floatValue());
            maxY = Math.max(maxY, -n.getPosition().getY().floatValue() + n.getRadius().floatValue() + n.getBorderWidth().floatValue());
        }
        double graphWidth = maxX - minX;
        double graphHeight = maxY - minY;
        double centerX = (double)minX + graphWidth / 2.0;
        double centerY = (double)minY + graphHeight / 2.0;
        double pageWidth = size.getWidth() - this.marginLeft - this.marginRight;
        double ratioWidth = pageWidth / graphWidth;
        double scale = ratioWidth < (ratioHeight = (pageHeight = (double)(size.getHeight() - this.marginTop - this.marginBottom)) / graphHeight) ? ratioWidth : ratioHeight;
        double translateX = ((double)this.marginLeft + pageWidth / 2.0) / scale;
        double translateY = ((double)this.marginBottom + pageHeight / 2.0) / scale;
        this.cb.transform(AffineTransform.getTranslateInstance(-centerX * scale, -centerY * scale));
        this.cb.transform(AffineTransform.getScaleInstance(scale, scale));
        this.cb.transform(AffineTransform.getTranslateInstance(translateX, translateY));
        this.renderGraph(graph);
        Progress.switchToIndeterminate(this.progress);
        this.cb.restoreState();
        this.document.close();
        Progress.finish(this.progress);
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void renderGraph(Graph graph) {
        if (graph.showEdges().booleanValue()) {
            this.renderGraphEdges(graph);
        }
        if (graph.showNodes().booleanValue()) {
            this.renderGraphNodes(graph);
        }
        this.renderGraphLabels(graph);
        this.renderGraphLabelBorders(graph);
    }

    public void renderGraphEdges(Graph graph) {
        this.renderGraphUnidirectionalEdges(graph);
        this.renderGraphBidirectionalEdges(graph);
        this.renderGraphUndirectedEdges(graph);
        if (graph.showSelfLoops().booleanValue()) {
            this.renderGraphSelfLoops(graph);
        }
    }

    public void renderGraphSelfLoops(Graph graph) {
        for (SelfLoop sl : graph.getSelfLoops()) {
            this.renderSelfLoop(sl);
        }
    }

    public void renderGraphUnidirectionalEdges(Graph graph) {
        for (UnidirectionalEdge edge : graph.getUnidirectionalEdges()) {
            this.renderDirectedEdge(edge);
        }
    }

    public void renderGraphBidirectionalEdges(Graph graph) {
        for (BidirectionalEdge edge : graph.getBidirectionalEdges()) {
            this.renderDirectedEdge(edge);
        }
    }

    public void renderGraphUndirectedEdges(Graph graph) {
        for (UndirectedEdge e : graph.getUndirectedEdges()) {
            this.renderEdge(e);
        }
    }

    public void renderGraphNodes(Graph graph) {
        for (Node n : graph.getNodes()) {
            this.renderNode(n);
        }
    }

    public void renderGraphLabels(Graph graph) {
        for (UnidirectionalEdge unidirectionalEdge : graph.getUnidirectionalEdges()) {
            if (unidirectionalEdge.isCurved().booleanValue()) continue;
            if (unidirectionalEdge.showLabel().booleanValue() && unidirectionalEdge.hasLabel() && unidirectionalEdge.getLabel().getFont() != null) {
                this.renderEdgeLabel(unidirectionalEdge.getLabel());
            }
            if (!unidirectionalEdge.showMiniLabels().booleanValue()) continue;
            this.renderEdgeMiniLabels(unidirectionalEdge);
        }
        for (BidirectionalEdge bidirectionalEdge : graph.getBidirectionalEdges()) {
            if (bidirectionalEdge.isCurved().booleanValue()) continue;
            if (bidirectionalEdge.showLabel().booleanValue() && bidirectionalEdge.hasLabel() && bidirectionalEdge.getLabel().getFont() != null) {
                this.renderEdgeLabel(bidirectionalEdge.getLabel());
            }
            if (!bidirectionalEdge.showMiniLabels().booleanValue()) continue;
            this.renderEdgeMiniLabels(bidirectionalEdge);
        }
        for (UndirectedEdge undirectedEdge : graph.getUndirectedEdges()) {
            if (!undirectedEdge.showLabel().booleanValue() || undirectedEdge.isCurved().booleanValue() || !undirectedEdge.hasLabel() || undirectedEdge.getLabel().getFont() == null) continue;
            this.renderEdgeLabel(undirectedEdge.getLabel());
        }
        for (Node node : graph.getNodes()) {
            if (!node.showLabel().booleanValue() || !node.hasLabel() || node.getLabel().getFont() == null) continue;
            this.renderNodeLabel(node.getLabel());
        }
    }

    public void renderGraphLabelBorders(Graph graph) {
    }

    public void renderNode(Node node) {
        Point center = node.getPosition();
        Color c = node.getColor();
        Color bc = node.getBorderColor();
        this.cb.setRGBColorStroke(bc.getRed().intValue(), bc.getGreen().intValue(), bc.getBlue().intValue());
        this.cb.setLineWidth(node.getBorderWidth().floatValue());
        this.cb.setRGBColorFill(c.getRed().intValue(), c.getGreen().intValue(), c.getBlue().intValue());
        this.cb.circle(center.getX().floatValue(), -center.getY().floatValue(), node.getRadius().floatValue());
        this.cb.fillStroke();
    }

    public void renderNodeLabel(NodeLabel label) {
        Point p = label.getPosition();
        Font font = label.getFont();
        this.setFillColor(label.getColor());
        try {
            BaseFont bf = this.genBaseFont(font);
            float ascent = bf.getAscentPoint(label.getValue(), (float)font.getSize());
            float descent = bf.getDescentPoint(label.getValue(), (float)font.getSize());
            float textHeight = (ascent - descent) / 2.0f;
            this.cb.beginText();
            this.cb.setFontAndSize(bf, (float)font.getSize());
            this.cb.showTextAligned(1, label.getValue(), p.getX().floatValue(), -p.getY().floatValue() - textHeight, 0.0f);
            this.cb.endText();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void renderNodeLabelBorder(NodeLabelBorder border) {
    }

    public void renderSelfLoop(SelfLoop selfLoop) {
        this.cubicBezierCurve(selfLoop.getCurve());
        this.setStrokeColor(selfLoop.getColor());
        this.cb.setLineWidth(selfLoop.getThickness().floatValue() * selfLoop.getScale().floatValue());
        this.cb.stroke();
    }

    public void renderDirectedEdge(DirectedEdge edge) {
        this.renderEdge(edge);
        if (!edge.isCurved().booleanValue() && edge.showArrows().booleanValue()) {
            this.renderEdgeArrows(edge);
        }
    }

    public void renderEdge(Edge edge) {
        if (edge.isCurved().booleanValue()) {
            this.renderCurvedEdge(edge);
        } else {
            this.renderStraightEdge(edge);
        }
        Progress.progress(this.progress);
    }

    public void renderStraightEdge(Edge edge) {
        this.line(edge.getNode1().getPosition(), edge.getNode2().getPosition());
        this.setStrokeColor(edge.getColor());
        this.cb.setLineWidth(edge.getThickness().floatValue() * edge.getScale().floatValue());
        this.cb.stroke();
    }

    public void renderCurvedEdge(Edge edge) {
        for (CubicBezierCurve c : edge.getCurves()) {
            this.cubicBezierCurve(c);
            this.setStrokeColor(edge.getColor());
            this.cb.setLineWidth(edge.getThickness().floatValue() * edge.getScale().floatValue());
            this.cb.stroke();
        }
    }

    public void renderEdgeArrows(DirectedEdge edge) {
        for (EdgeArrow a : edge.getArrows()) {
            this.renderEdgeArrow(a);
        }
    }

    public void renderEdgeMiniLabels(DirectedEdge edge) {
        for (EdgeMiniLabel ml : edge.getMiniLabels()) {
            this.renderEdgeMiniLabel(ml);
        }
    }

    public void renderEdgeArrow(EdgeArrow arrow) {
        Point pt1 = arrow.getPt1();
        Point pt2 = arrow.getPt2();
        Point pt3 = arrow.getPt3();
        this.cb.moveTo(pt1.getX().floatValue(), -pt1.getY().floatValue());
        this.cb.lineTo(pt2.getX().floatValue(), -pt2.getY().floatValue());
        this.cb.lineTo(pt3.getX().floatValue(), -pt3.getY().floatValue());
        this.cb.closePath();
        this.setFillColor(arrow.getColor());
        this.cb.fill();
    }

    public void renderEdgeLabel(EdgeLabel label) {
        Point p = label.getPosition();
        Font font = label.getFont();
        this.setFillColor(label.getColor());
        try {
            BaseFont bf = this.genBaseFont(font);
            this.cb.beginText();
            this.cb.setFontAndSize(bf, (float)font.getSize());
            this.cb.showTextAligned(1, label.getValue(), p.getX().floatValue(), -p.getY().floatValue(), (float)Math.toDegrees(-label.getAngle().floatValue()));
            this.cb.endText();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void renderEdgeMiniLabel(EdgeMiniLabel miniLabel) {
        Point p = miniLabel.getPosition();
        Font font = miniLabel.getFont();
        this.setFillColor(miniLabel.getColor());
        try {
            BaseFont bf = this.genBaseFont(font);
            this.cb.beginText();
            this.cb.setFontAndSize(bf, (float)font.getSize());
            this.cb.showTextAligned(miniLabel.getHAlign().toIText(), miniLabel.getValue(), p.getX().floatValue(), -p.getY().floatValue(), (float)Math.toDegrees(-miniLabel.getAngle().floatValue()));
            this.cb.endText();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private BaseFont genBaseFont(Font font) throws DocumentException, IOException {
        if (font != null) {
            try {
                this.loadFont(font);
            }
            catch (Exception e) {
                e.printStackTrace();
                return BaseFont.createFont();
            }
            return this.fontMapper.awtToPdf(font);
        }
        return BaseFont.createFont();
    }

    private void loadFont(Font font) throws Exception {
        if (this.fontMapper == null) {
            this.fontMapper = new DefaultFontMapper();
        }
        if (this.fontMapper instanceof DefaultFontMapper) {
            if (Utilities.isMac()) {
                String fontName = font.getName();
                if (!((DefaultFontMapper)this.fontMapper).getMapper().containsKey(fontName)) {
                    File homeLibraryFonts = new File(System.getProperty("user.home") + "/Library/Fonts");
                    File systemLibraryFonts = new File("/System/Library/Fonts");
                    File libraryFonts = new File("/Library/Fonts");
                    File fontResult = this.lookFor(fontName, homeLibraryFonts);
                    fontResult = fontResult != null ? fontResult : this.lookFor(fontName, systemLibraryFonts);
                    File file = fontResult = fontResult != null ? fontResult : this.lookFor(fontName, libraryFonts);
                    if (fontResult != null) {
                        fontName = fontResult.getName();
                        String fontFilePath = fontResult.getAbsolutePath();
                        this.loadFont(fontName, fontFilePath);
                    }
                }
            } else {
                String fontName = FontManager.getFileNameForFontName((String)font.getFontName());
                if (!((DefaultFontMapper)this.fontMapper).getMapper().containsKey(fontName)) {
                    String fontFilePath = FontManager.getFontPath((boolean)false);
                    fontFilePath = fontFilePath + "/" + fontName;
                    this.loadFont(fontName, fontFilePath);
                }
            }
        }
    }

    private void loadFont(String fontName, String fontFilePath) throws Exception {
        if (fontName != null && !fontName.isEmpty()) {
            fontName = fontName.toLowerCase();
            if (fontFilePath != null && !fontFilePath.isEmpty()) {
                if (fontName.endsWith(".ttf") || fontName.endsWith(".otf") || fontName.endsWith(".afm")) {
                    Object[] allNames = BaseFont.getAllFontNames((String)fontFilePath, (String)"Cp1252", null);
                    ((DefaultFontMapper)this.fontMapper).insertNames(allNames, fontFilePath);
                } else if (fontName.endsWith(".ttc")) {
                    String[] ttcs = BaseFont.enumerateTTCNames((String)fontFilePath);
                    for (int j = 0; j < ttcs.length; ++j) {
                        String nt = fontFilePath + "," + j;
                        Object[] allNames = BaseFont.getAllFontNames((String)nt, (String)"Cp1252", null);
                        ((DefaultFontMapper)this.fontMapper).insertNames(allNames, nt);
                    }
                }
            }
        }
    }

    private File lookFor(String fileName, File folder) {
        if (!folder.isDirectory()) {
            return null;
        }
        File lookFile = new File(folder, fileName + ".ttf");
        if (lookFile.exists()) {
            return lookFile;
        }
        lookFile = new File(folder, fileName + ".otf");
        if (lookFile.exists()) {
            return lookFile;
        }
        lookFile = new File(folder, fileName + ".ttc");
        if (lookFile.exists()) {
            return lookFile;
        }
        lookFile = new File(folder, fileName + ".afm");
        if (lookFile.exists()) {
            return lookFile;
        }
        return null;
    }

    private void line(Point start, Point end) {
        this.cb.moveTo(start.getX().floatValue(), -start.getY().floatValue());
        this.cb.lineTo(end.getX().floatValue(), -end.getY().floatValue());
    }

    private void cubicBezierCurve(CubicBezierCurve curve) {
        Point pt1 = curve.getPt1();
        Point pt2 = curve.getPt2();
        Point pt3 = curve.getPt3();
        Point pt4 = curve.getPt4();
        this.cb.moveTo(pt1.getX().floatValue(), -pt1.getY().floatValue());
        this.cb.curveTo(pt2.getX().floatValue(), -pt2.getY().floatValue(), pt3.getX().floatValue(), -pt3.getY().floatValue(), pt4.getX().floatValue(), -pt4.getY().floatValue());
    }

    private void setStrokeColor(Color color) {
        this.cb.setRGBColorStroke(color.getRed().intValue(), color.getGreen().intValue(), color.getBlue().intValue());
    }

    private void setFillColor(Color color) {
        this.cb.setRGBColorFill(color.getRed().intValue(), color.getGreen().intValue(), color.getBlue().intValue());
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setFontMapper(FontMapper fontMapper) {
        this.fontMapper = fontMapper;
    }

    public FontMapper getFontMapper() {
        return this.fontMapper;
    }

    static {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        e.getAllFonts();
    }
}

