/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.preview;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.gephi.io.exporter.preview.util.LengthUnit;
import org.gephi.io.exporter.preview.util.SupportSize;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.preview.api.BidirectionalEdge;
import org.gephi.preview.api.CubicBezierCurve;
import org.gephi.preview.api.DirectedEdge;
import org.gephi.preview.api.Edge;
import org.gephi.preview.api.EdgeArrow;
import org.gephi.preview.api.EdgeLabel;
import org.gephi.preview.api.EdgeMiniLabel;
import org.gephi.preview.api.Graph;
import org.gephi.preview.api.GraphRenderer;
import org.gephi.preview.api.GraphSheet;
import org.gephi.preview.api.Node;
import org.gephi.preview.api.NodeLabel;
import org.gephi.preview.api.NodeLabelBorder;
import org.gephi.preview.api.Point;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.SelfLoop;
import org.gephi.preview.api.UndirectedEdge;
import org.gephi.preview.api.UnidirectionalEdge;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class SVGExporter
implements GraphRenderer,
CharacterExporter,
VectorExporter,
LongTask {
    private Document doc;
    private ProgressTicket progress;
    private boolean cancel = false;
    private Workspace workspace;
    private Writer writer;
    private static final float MARGIN = 25.0f;
    private final String namespaceURI = "http://www.w3.org/2000/svg";
    private boolean scaleStrokes = false;
    private final HashMap<NodeLabel, SVGLocatable> nodeLabelMap = new HashMap();
    private Element svgRoot;
    private Element nodeGroupElem;
    private Element edgeGroupElem;
    private Element labelGroupElem;
    private Element labelBorderGroupElem;
    private float scaleRatio = 1.0f;

    public boolean execute() {
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        GraphSheet graphSheet = controller.getGraphSheet();
        try {
            this.exportData(graphSheet);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportData(GraphSheet graphSheet) throws Exception {
        SupportSize supportSize = new SupportSize(595, 841, LengthUnit.PIXELS);
        Progress.start(this.progress);
        Graph graph = graphSheet.getGraph();
        int max = 0;
        if (graph.showNodes().booleanValue()) {
            max += graph.countNodes();
        }
        if (graph.showEdges().booleanValue()) {
            max += graph.countUnidirectionalEdges() + graph.countBidirectionalEdges();
            if (graph.showSelfLoops().booleanValue()) {
                max += graph.countSelfLoops();
            }
        }
        Progress.switchToDeterminate(this.progress, max);
        this.buildDOM(graphSheet, supportSize);
        SVGTranscoder t = new SVGTranscoder();
        t.addTranscodingHint(SVGTranscoder.KEY_XML_DECLARATION, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        TranscoderInput input = new TranscoderInput(this.doc);
        try {
            TranscoderOutput output = new TranscoderOutput(this.writer);
            t.transcode(input, output);
        }
        finally {
            this.writer.close();
        }
        Progress.finish(this.progress);
    }

    public void renderGraph(Graph graph) {
        if (graph.showEdges().booleanValue()) {
            this.renderGraphEdges(graph);
        }
        if (graph.showNodes().booleanValue()) {
            this.renderGraphNodes(graph);
        }
        this.renderGraphLabels(graph);
        this.renderGraphLabelBorders(graph);
    }

    public void renderGraphEdges(Graph graph) {
        this.edgeGroupElem = this.createGroupElem("edges");
        this.svgRoot.appendChild(this.edgeGroupElem);
        this.renderGraphUnidirectionalEdges(graph);
        this.renderGraphBidirectionalEdges(graph);
        this.renderGraphUndirectedEdges(graph);
        if (graph.showSelfLoops().booleanValue()) {
            this.renderGraphSelfLoops(graph);
        }
    }

    public void renderGraphSelfLoops(Graph graph) {
        for (SelfLoop sl : graph.getSelfLoops()) {
            this.renderSelfLoop(sl);
        }
    }

    public void renderGraphUnidirectionalEdges(Graph graph) {
        for (UnidirectionalEdge edge : graph.getUnidirectionalEdges()) {
            this.renderDirectedEdge(edge);
        }
    }

    public void renderGraphBidirectionalEdges(Graph graph) {
        for (BidirectionalEdge edge : graph.getBidirectionalEdges()) {
            this.renderDirectedEdge(edge);
        }
    }

    public void renderGraphUndirectedEdges(Graph graph) {
        for (UndirectedEdge e : graph.getUndirectedEdges()) {
            this.renderEdge(e);
        }
    }

    public void renderGraphNodes(Graph graph) {
        this.nodeGroupElem = this.createGroupElem("nodes");
        this.svgRoot.appendChild(this.nodeGroupElem);
        for (Node n : graph.getNodes()) {
            this.renderNode(n);
        }
    }

    public void renderGraphLabels(Graph graph) {
        this.labelGroupElem = this.createGroupElem("labels");
        this.svgRoot.appendChild(this.labelGroupElem);
        for (UnidirectionalEdge unidirectionalEdge : graph.getUnidirectionalEdges()) {
            if (unidirectionalEdge.isCurved().booleanValue()) continue;
            if (unidirectionalEdge.showLabel().booleanValue() && unidirectionalEdge.hasLabel() && unidirectionalEdge.getLabel().getFont() != null) {
                this.renderEdgeLabel(unidirectionalEdge.getLabel());
            }
            if (!unidirectionalEdge.showMiniLabels().booleanValue()) continue;
            this.renderEdgeMiniLabels(unidirectionalEdge);
        }
        for (BidirectionalEdge bidirectionalEdge : graph.getBidirectionalEdges()) {
            if (bidirectionalEdge.isCurved().booleanValue()) continue;
            if (bidirectionalEdge.showLabel().booleanValue() && bidirectionalEdge.hasLabel() && bidirectionalEdge.getLabel().getFont() != null) {
                this.renderEdgeLabel(bidirectionalEdge.getLabel());
            }
            if (!bidirectionalEdge.showMiniLabels().booleanValue()) continue;
            this.renderEdgeMiniLabels(bidirectionalEdge);
        }
        for (UndirectedEdge undirectedEdge : graph.getUndirectedEdges()) {
            if (!undirectedEdge.showLabel().booleanValue() || undirectedEdge.isCurved().booleanValue() || !undirectedEdge.hasLabel() || undirectedEdge.getLabel().getFont() == null) continue;
            this.renderEdgeLabel(undirectedEdge.getLabel());
        }
        for (Node node : graph.getNodes()) {
            if (!node.showLabel().booleanValue() || !node.hasLabel() || node.getLabel().getFont() == null) continue;
            this.renderNodeLabel(node.getLabel());
        }
    }

    public void renderGraphLabelBorders(Graph graph) {
        this.labelBorderGroupElem = this.createGroupElem("label borders");
        this.svgRoot.insertBefore(this.labelBorderGroupElem, this.labelGroupElem);
        for (Node n : graph.getNodes()) {
            if (!n.showLabel().booleanValue() || !n.hasLabel() || !n.showLabelBorders().booleanValue() || n.getLabel().getFont() == null) continue;
            this.renderNodeLabelBorder(n.getLabelBorder());
        }
    }

    public void renderNode(Node node) {
        Element nodeElem = this.createElement("circle");
        nodeElem.setAttribute("cx", node.getPosition().getX().toString());
        nodeElem.setAttribute("cy", node.getPosition().getY().toString());
        nodeElem.setAttribute("r", node.getRadius().toString());
        nodeElem.setAttribute("fill", node.getColor().toHexString());
        nodeElem.setAttribute("stroke", node.getBorderColor().toHexString());
        nodeElem.setAttribute("stroke-width", new Float(node.getBorderWidth().floatValue() * this.scaleRatio).toString());
        this.nodeGroupElem.appendChild(nodeElem);
        Progress.progress(this.progress);
    }

    public void renderNodeLabel(NodeLabel label) {
        Text labelText = this.createTextNode(label.getValue());
        Element labelElem = this.createElement("text");
        labelElem.setAttribute("x", label.getPosition().getX().toString());
        labelElem.setAttribute("y", label.getPosition().getY().toString());
        labelElem.setAttribute("style", "text-anchor: middle");
        labelElem.setAttribute("fill", label.getColor().toHexString());
        labelElem.setAttribute("font-family", label.getFont().getFamily());
        labelElem.setAttribute("font-size", Integer.toString(label.getFont().getSize()));
        labelElem.appendChild(labelText);
        this.labelGroupElem.appendChild(labelElem);
        this.nodeLabelMap.put(label, (SVGLocatable)labelElem);
    }

    public void renderNodeLabelBorder(NodeLabelBorder border) {
        SVGRect rect = this.nodeLabelMap.get(border.getLabel()).getBBox();
        Element borderElem = this.createElement("rect");
        borderElem.setAttribute("x", Float.toString(rect.getX()));
        borderElem.setAttribute("y", Float.toString(rect.getY()));
        borderElem.setAttribute("width", Float.toString(rect.getWidth()));
        borderElem.setAttribute("height", Float.toString(rect.getHeight()));
        borderElem.setAttribute("fill", border.getColor().toHexString());
        this.labelBorderGroupElem.appendChild(borderElem);
    }

    public void renderSelfLoop(SelfLoop selfLoop) {
        CubicBezierCurve curve = selfLoop.getCurve();
        Element selfLoopElem = this.createElement("path");
        selfLoopElem.setAttribute("d", String.format(Locale.ENGLISH, "M %f,%f C %f,%f %f,%f %f,%f", curve.getPt1().getX(), curve.getPt1().getY(), curve.getPt2().getX(), curve.getPt2().getY(), curve.getPt3().getX(), curve.getPt3().getY(), curve.getPt4().getX(), curve.getPt4().getY()));
        selfLoopElem.setAttribute("stroke", selfLoop.getColor().toHexString());
        selfLoopElem.setAttribute("stroke-width", Float.toString(selfLoop.getThickness().floatValue() * selfLoop.getScale().floatValue() * this.scaleRatio));
        selfLoopElem.setAttribute("fill", "none");
        this.edgeGroupElem.appendChild(selfLoopElem);
    }

    public void renderDirectedEdge(DirectedEdge edge) {
        this.renderEdge(edge);
        if (!edge.isCurved().booleanValue() && edge.showArrows().booleanValue()) {
            this.renderEdgeArrows(edge);
        }
    }

    public void renderEdge(Edge edge) {
        if (edge.isCurved().booleanValue()) {
            this.renderCurvedEdge(edge);
        } else {
            this.renderStraightEdge(edge);
        }
        Progress.progress(this.progress);
    }

    public void renderStraightEdge(Edge edge) {
        Point boundary1 = edge.getNode1().getPosition();
        Point boundary2 = edge.getNode2().getPosition();
        Element edgeElem = this.createElement("path");
        edgeElem.setAttribute("d", String.format(Locale.ENGLISH, "M %f,%f L %f,%f", boundary1.getX(), boundary1.getY(), boundary2.getX(), boundary2.getY()));
        edgeElem.setAttribute("stroke", edge.getColor().toHexString());
        edgeElem.setAttribute("stroke-width", Float.toString(edge.getThickness().floatValue() * edge.getScale().floatValue() * this.scaleRatio));
        this.edgeGroupElem.appendChild(edgeElem);
    }

    public void renderCurvedEdge(Edge edge) {
        for (CubicBezierCurve curve : edge.getCurves()) {
            Element curveElem = this.createElement("path");
            curveElem.setAttribute("d", String.format(Locale.ENGLISH, "M %f,%f C %f,%f %f,%f %f,%f", curve.getPt1().getX(), curve.getPt1().getY(), curve.getPt2().getX(), curve.getPt2().getY(), curve.getPt3().getX(), curve.getPt3().getY(), curve.getPt4().getX(), curve.getPt4().getY()));
            curveElem.setAttribute("stroke", edge.getColor().toHexString());
            curveElem.setAttribute("stroke-width", Float.toString(edge.getThickness().floatValue() * edge.getScale().floatValue() * this.scaleRatio));
            curveElem.setAttribute("fill", "none");
            this.edgeGroupElem.appendChild(curveElem);
        }
    }

    public void renderEdgeArrows(DirectedEdge edge) {
        for (EdgeArrow a : edge.getArrows()) {
            this.renderEdgeArrow(a);
        }
    }

    public void renderEdgeMiniLabels(DirectedEdge edge) {
        for (EdgeMiniLabel ml : edge.getMiniLabels()) {
            this.renderEdgeMiniLabel(ml);
        }
    }

    public void renderEdgeArrow(EdgeArrow arrow) {
        Element arrowElem = this.createElement("polyline");
        arrowElem.setAttribute("points", String.format(Locale.ENGLISH, "%f,%f %f,%f %f,%f", arrow.getPt1().getX(), arrow.getPt1().getY(), arrow.getPt2().getX(), arrow.getPt2().getY(), arrow.getPt3().getX(), arrow.getPt3().getY()));
        arrowElem.setAttribute("fill", arrow.getColor().toHexString());
        arrowElem.setAttribute("stroke", "none");
        this.edgeGroupElem.appendChild(arrowElem);
    }

    public void renderEdgeLabel(EdgeLabel label) {
        Text text = this.createTextNode(label.getValue());
        Element labelElem = this.createElement("text");
        labelElem.setAttribute("x", "0");
        labelElem.setAttribute("y", "0");
        labelElem.setAttribute("style", "text-anchor: middle");
        labelElem.setAttribute("fill", label.getColor().toHexString());
        labelElem.setAttribute("font-family", label.getFont().getFamily());
        labelElem.setAttribute("font-size", Integer.toString(label.getFont().getSize()));
        labelElem.setAttribute("transform", String.format(Locale.ENGLISH, "translate(%f,%f) rotate(%f)", label.getPosition().getX(), label.getPosition().getY(), Math.toDegrees(label.getAngle().floatValue())));
        labelElem.appendChild(text);
        this.labelGroupElem.appendChild(labelElem);
    }

    public void renderEdgeMiniLabel(EdgeMiniLabel miniLabel) {
        Text text = this.createTextNode(miniLabel.getValue());
        Element miniLabelElem = this.createElement("text");
        miniLabelElem.setAttribute("x", "0");
        miniLabelElem.setAttribute("y", "0");
        miniLabelElem.setAttribute("style", miniLabel.getHAlign().toCSS());
        miniLabelElem.setAttribute("fill", miniLabel.getColor().toHexString());
        miniLabelElem.setAttribute("font-family", miniLabel.getFont().getFamily());
        miniLabelElem.setAttribute("font-size", Integer.toString(miniLabel.getFont().getSize()));
        miniLabelElem.setAttribute("transform", String.format(Locale.ENGLISH, "translate(%f,%f) rotate(%f)", miniLabel.getPosition().getX(), miniLabel.getPosition().getY(), Math.toDegrees(miniLabel.getAngle().floatValue())));
        miniLabelElem.appendChild(text);
        this.labelGroupElem.appendChild(miniLabelElem);
    }

    protected Document buildDOM(GraphSheet graphSheet, SupportSize supportSize) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        DocumentType doctype = impl.createDocumentType("-//W3C//DTD SVG 1.1//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "");
        this.doc = impl.createDocument("http://www.w3.org/2000/svg", "svg", doctype);
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        ctx.setDynamicState(2);
        GVTBuilder builder = new GVTBuilder();
        builder.build(ctx, this.doc);
        graphSheet.setMargin(25.0f);
        int width = graphSheet.getWidth().intValue();
        int height = graphSheet.getHeight().intValue();
        if (width > height) {
            supportSize = new SupportSize(width * supportSize.getHeightInt() / height, supportSize.getHeightInt(), LengthUnit.PIXELS);
        } else if (height > width) {
            supportSize = new SupportSize(supportSize.getWidthInt(), height * supportSize.getWidthInt() / width, LengthUnit.PIXELS);
        }
        this.svgRoot = this.doc.getDocumentElement();
        this.svgRoot.setAttributeNS(null, "width", supportSize.getWidth());
        this.svgRoot.setAttributeNS(null, "height", supportSize.getHeight());
        this.svgRoot.setAttributeNS(null, "version", "1.1");
        this.svgRoot.setAttributeNS(null, "viewBox", String.format(Locale.ENGLISH, "%d %d %d %d", graphSheet.getTopLeftPosition().getX().intValue(), graphSheet.getTopLeftPosition().getY().intValue(), width, height));
        if (this.scaleStrokes) {
            this.scaleRatio = (float)supportSize.getWidthInt().intValue() / (float)width;
        }
        this.renderGraph(graphSheet.getGraph());
        return this.doc;
    }

    private Element createElement(String qualifiedName) {
        return this.doc.createElementNS("http://www.w3.org/2000/svg", qualifiedName);
    }

    private Text createTextNode(String data) {
        return this.doc.createTextNode(data);
    }

    private Element createGroupElem(String name) {
        Element group = this.createElement("g");
        group.setAttribute("id", name);
        return group;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setScaleStrokes(boolean scaleStrokes) {
        this.scaleStrokes = scaleStrokes;
    }

    public boolean isScaleStrokes() {
        return this.scaleStrokes;
    }
}

