/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.generator.plugin;

import java.util.Random;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.type.DynamicFloat;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.io.generator.spi.Generator;
import org.gephi.io.generator.spi.GeneratorUI;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.utils.progress.ProgressTicket;

public class DynamicGraph
implements Generator {
    protected int numberOfNodes = 50;
    protected double wiringProbability = 0.05;

    public void generate(ContainerLoader container) {
        Random random = new Random();
        AttributeColumn col = container.getAttributeModel().getNodeTable().addColumn("score", AttributeType.DYNAMIC_INT);
        NodeDraft[] nodeArray = new NodeDraft[this.numberOfNodes];
        for (int i = 0; i < this.numberOfNodes; ++i) {
            NodeDraft nodeDraft = container.factory().newNodeDraft();
            nodeDraft.setId("n" + i);
            container.addNode(nodeDraft);
            Random r = new Random();
            int randomStart = r.nextInt(10) + 2000;
            int randomEnd = randomStart + 20 + r.nextInt(10);
            nodeDraft.addTimeInterval("" + randomStart, "" + randomEnd);
            randomEnd = randomStart + r.nextInt(10);
            nodeDraft.addAttributeValue(col, r.nextInt(5), "" + randomStart, "" + randomEnd);
            randomStart = randomEnd + 1;
            randomEnd = randomStart + r.nextInt(10);
            nodeDraft.addAttributeValue(col, r.nextInt(5), "" + randomStart, "" + randomEnd);
            nodeArray[i] = nodeDraft;
        }
        if (this.wiringProbability > 0.0) {
            AttributeColumn oldWeight = container.getAttributeModel().getEdgeTable().getColumn(PropertiesColumn.EDGE_WEIGHT.getIndex());
            AttributeColumn weightCol = container.getAttributeModel().getEdgeTable().replaceColumn(oldWeight, PropertiesColumn.EDGE_WEIGHT.getId(), PropertiesColumn.EDGE_WEIGHT.getTitle(), AttributeType.DYNAMIC_FLOAT, AttributeOrigin.PROPERTY, null);
            for (int i = 0; i < this.numberOfNodes - 1; ++i) {
                NodeDraft node1 = nodeArray[i];
                for (int j = i + 1; j < this.numberOfNodes; ++j) {
                    NodeDraft node2 = nodeArray[j];
                    if (!(random.nextDouble() < this.wiringProbability)) continue;
                    EdgeDraft edgeDraft = container.factory().newEdgeDraft();
                    edgeDraft.setSource(node1);
                    edgeDraft.setTarget(node2);
                    Random r = new Random();
                    DynamicFloat dynamicWeight = new DynamicFloat(new Interval<Float>(2010.0, 2012.0, false, true, new Float(r.nextInt(3) + 1)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2012.0, 2014.0, false, true, new Float(r.nextInt(3) + 2)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2014.0, 2016.0, false, true, new Float(r.nextInt(3) + 3)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2016.0, 2018.0, false, true, new Float(r.nextInt(3) + 4)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2018.0, 2020.0, false, true, new Float(r.nextInt(3) + 5)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2020.0, 2022.0, false, true, new Float(r.nextInt(3) + 6)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2022.0, 2024.0, false, true, new Float(r.nextInt(3) + 7)));
                    dynamicWeight = new DynamicFloat(dynamicWeight, new Interval<Float>(2024.0, 2026.0, false, false, new Float(r.nextInt(3) + 8)));
                    edgeDraft.addAttributeValue(weightCol, dynamicWeight);
                    container.addEdge(edgeDraft);
                }
            }
        }
    }

    public String getName() {
        return "Dynamic Graph Example";
    }

    public GeneratorUI getUI() {
        return null;
    }

    public boolean cancel() {
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
    }
}

