/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.gephi.utils.CharsetToolkit;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ImportUtils {
    public static LineNumberReader getTextReader(FileObject fileObject) throws IOException {
        try {
            return ImportUtils.getTextReader(fileObject.getInputStream());
        }
        catch (IOException ex) {
            throw new IOException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_file_not_found"));
        }
    }

    public static LineNumberReader getTextReader(InputStream stream) throws IOException {
        CharsetToolkit charsetToolkit = new CharsetToolkit(stream);
        LineNumberReader reader = (LineNumberReader)charsetToolkit.getReader();
        return reader;
    }

    public static LineNumberReader getTextReader(Reader reader) {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        return lineNumberReader;
    }

    public static Document getXMLDocument(InputStream stream) throws RuntimeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(stream);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_missing_document_instance_factory"));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_file_not_found"));
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_sax"));
        }
        catch (IOException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_io"));
        }
    }

    public static Document getXMLDocument(Reader reader) throws RuntimeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_missing_document_instance_factory"));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_file_not_found"));
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_sax"));
        }
        catch (IOException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_io"));
        }
    }

    public static Document getXMLDocument(FileObject fileObject) throws RuntimeException {
        try {
            InputStream stream = fileObject.getInputStream();
            return ImportUtils.getXMLDocument(stream);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_file_not_found"));
        }
    }

    public static XMLStreamReader getXMLReader(Reader reader) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            inputFactory.setXMLReporter(new XMLReporter(){

                public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                    throw new RuntimeException("Error:" + errorType + ", message : " + message);
                }
            });
            return inputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, (String)"ImportUtils.error_io"));
        }
    }

    public static FileObject getArchivedFile(FileObject fileObject) {
        if (FileUtil.isArchiveFile((FileObject)fileObject)) {
            fileObject = FileUtil.getArchiveRoot((FileObject)fileObject).getChildren()[0];
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getBzipFile(FileObject in, File out, boolean isTar) throws IOException {
        int BUFF_SIZE = 8192;
        byte[] buffer = new byte[8192];
        CBZip2InputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            FileInputStream is = new FileInputStream(in.getPath());
            is.read();
            is.read();
            inputStream = new CBZip2InputStream((InputStream)is);
            outStream = new FileOutputStream(out.getAbsolutePath());
            if (isTar) {
                int nRead;
                int remainingBytes = ImportUtils.readTarHeader((InputStream)inputStream);
                ByteBuffer bb = ByteBuffer.allocateDirect(32768);
                byte[] tmpCache = new byte[8192];
                while ((nRead = inputStream.read(tmpCache)) != -1) {
                    if (nRead == 0) continue;
                    bb.put(tmpCache);
                    bb.position(0);
                    bb.limit(nRead);
                    while (bb.hasRemaining() && remainingBytes > 0) {
                        int nGet = Math.min(bb.remaining(), 8192);
                        nGet = Math.min(nGet, remainingBytes);
                        bb.get(buffer, 0, nGet);
                        outStream.write(buffer, 0, nGet);
                        remainingBytes -= nGet;
                    }
                    bb.clear();
                }
            } else {
                int len;
                while ((len = inputStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getGzFile(FileObject in, File out, boolean isTar) throws IOException {
        int BUFF_SIZE = 8192;
        byte[] buffer = new byte[8192];
        GZIPInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(in.getPath()));
            outStream = new FileOutputStream(out);
            if (isTar) {
                int nRead;
                int remainingBytes = ImportUtils.readTarHeader(inputStream);
                ByteBuffer bb = ByteBuffer.allocateDirect(32768);
                byte[] tmpCache = new byte[8192];
                while ((nRead = inputStream.read(tmpCache)) != -1) {
                    if (nRead == 0) continue;
                    bb.put(tmpCache);
                    bb.position(0);
                    bb.limit(nRead);
                    while (bb.hasRemaining() && remainingBytes > 0) {
                        int nGet = Math.min(bb.remaining(), 8192);
                        nGet = Math.min(nGet, remainingBytes);
                        bb.get(buffer, 0, nGet);
                        outStream.write(buffer, 0, nGet);
                        remainingBytes -= nGet;
                    }
                    bb.clear();
                }
            } else {
                int len;
                while ((len = inputStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return out;
    }

    private static int readTarHeader(InputStream inputStream) throws IOException {
        int FILE_SIZE_OFFSET = 124;
        int FILE_SIZE_LENGTH = 12;
        int HEADER_LENGTH = 512;
        ImportUtils.ignoreBytes(inputStream, 124);
        String fileSizeLengthOctalString = ImportUtils.readString(inputStream, 12).trim();
        int fileSize = Integer.parseInt(fileSizeLengthOctalString, 8);
        ImportUtils.ignoreBytes(inputStream, 376);
        return fileSize;
    }

    private static void ignoreBytes(InputStream inputStream, int numberOfBytes) throws IOException {
        for (int counter = 0; counter < numberOfBytes; ++counter) {
            inputStream.read();
        }
    }

    private static String readString(InputStream inputStream, int numberOfBytes) throws IOException {
        return new String(ImportUtils.readBytes(inputStream, numberOfBytes));
    }

    private static byte[] readBytes(InputStream inputStream, int numberOfBytes) throws IOException {
        byte[] readBytes = new byte[numberOfBytes];
        inputStream.read(readBytes);
        return readBytes;
    }
}

