/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gephi.io.importer.api.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Report {
    private final Queue<ReportEntry> entries = new ConcurrentLinkedQueue<ReportEntry>();
    private Issue.Level exceptionLevel = Issue.Level.CRITICAL;

    public void log(String message) {
        this.entries.add(new ReportEntry(message));
    }

    public void append(Report report) {
        this.entries.addAll(report.entries);
    }

    public void logIssue(Issue issue) {
        this.entries.add(new ReportEntry(issue));
        if (issue.getLevel().toInteger() >= this.exceptionLevel.toInteger()) {
            if (issue.getThrowable() != null) {
                throw new RuntimeException(issue.getMessage(), issue.getThrowable());
            }
            throw new RuntimeException(issue.getMessage());
        }
    }

    public List<Issue> getIssues() {
        ArrayList<Issue> res = new ArrayList<Issue>();
        for (ReportEntry re : this.entries) {
            if (re.issue == null) continue;
            res.add(re.issue);
        }
        return res;
    }

    public String getHtml() {
        StringBuilder builder = new StringBuilder();
        for (ReportEntry re : this.entries) {
            if (re.issue != null) {
                builder.append(re.issue.getMessage());
                builder.append("<br>");
                continue;
            }
            builder.append(re.message);
            builder.append("<br>");
        }
        return builder.toString();
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (ReportEntry re : this.entries) {
            if (re.issue != null) {
                builder.append(re.issue.getMessage());
                builder.append("\n");
                continue;
            }
            builder.append(re.message);
            builder.append("\n");
        }
        return builder.toString();
    }

    public Issue.Level getExceptionLevel() {
        return this.exceptionLevel;
    }

    public void setExceptionLevel(Issue.Level exceptionLevel) {
        this.exceptionLevel = exceptionLevel;
    }

    public void pruneReport(int limit) {
        if (this.entries.size() > limit) {
            int step = 0;
            while (this.entries.size() > limit && step < 3) {
                ReportEntry issue;
                Iterator itr;
                ReportEntry lastIssue;
                if (step == 0) {
                    lastIssue = null;
                    itr = this.entries.iterator();
                    while (itr.hasNext()) {
                        issue = (ReportEntry)itr.next();
                        if (issue.issue == null || !issue.issue.getLevel().equals((Object)Issue.Level.INFO)) continue;
                        lastIssue = issue;
                        itr.remove();
                    }
                    if (lastIssue != null) {
                        this.entries.add(lastIssue);
                        this.entries.add(new ReportEntry(new Issue("More issues not listed...", Issue.Level.INFO)));
                    }
                    step = 1;
                    continue;
                }
                if (step == 1) {
                    lastIssue = null;
                    itr = this.entries.iterator();
                    while (itr.hasNext()) {
                        issue = (ReportEntry)itr.next();
                        if (issue.issue == null || !issue.issue.getLevel().equals((Object)Issue.Level.WARNING)) continue;
                        lastIssue = issue;
                        itr.remove();
                    }
                    if (lastIssue != null) {
                        this.entries.add(lastIssue);
                        this.entries.add(new ReportEntry(new Issue("More issues not listed...", Issue.Level.WARNING)));
                    }
                    step = 2;
                    continue;
                }
                if (step == 2) {
                    lastIssue = null;
                    itr = this.entries.iterator();
                    while (itr.hasNext()) {
                        issue = (ReportEntry)itr.next();
                        if (issue.issue == null || !issue.issue.getLevel().equals((Object)Issue.Level.INFO)) continue;
                        lastIssue = issue;
                        itr.remove();
                    }
                    if (lastIssue != null) {
                        this.entries.add(lastIssue);
                        this.entries.add(new ReportEntry(new Issue("More issues not listed...", Issue.Level.INFO)));
                    }
                    step = 3;
                    continue;
                }
                if (step != 3) continue;
                lastIssue = null;
                itr = this.entries.iterator();
                while (itr.hasNext()) {
                    issue = (ReportEntry)itr.next();
                    if (issue.issue != null) continue;
                    lastIssue = issue;
                    itr.remove();
                }
                if (lastIssue != null) {
                    this.entries.add(lastIssue);
                    this.entries.add(new ReportEntry("More messages not listed..."));
                }
                step = 4;
            }
        }
    }

    private class ReportEntry {
        private final Issue issue;
        private final String message;

        public ReportEntry(Issue issue) {
            this.issue = issue;
            this.message = null;
        }

        public ReportEntry(String message) {
            this.message = message;
            this.issue = null;
        }
    }
}

