/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import java.awt.Color;
import java.util.ArrayList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeDraftGetter;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.impl.ImportContainerImpl;
import org.gephi.io.importer.impl.NodeDraftImpl;
import org.openide.util.NbBundle;

public class EdgeDraftImpl
implements EdgeDraft,
EdgeDraftGetter {
    private final ImportContainerImpl container;
    private String id;
    private String label;
    private boolean autoId;
    private NodeDraftImpl source;
    private NodeDraftImpl target;
    private float weight = 1.0f;
    private EdgeDraft.EdgeType edgeType;
    private Color color;
    private boolean visible = true;
    private Color labelColor;
    private float labelSize = -1.0f;
    private boolean labelVisible = true;
    private final AttributeRow attributeRow;
    private TimeInterval timeInterval;

    public EdgeDraftImpl(ImportContainerImpl container, String id) {
        this.container = container;
        this.id = id;
        this.autoId = true;
        this.attributeRow = container.getAttributeModel().rowFactory().newEdgeRow(null);
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String r, String g, String b) {
        this.setColor(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    public void setColor(float r, float g, float b) {
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        this.setColor(new Color(r, g, b));
    }

    public void setColor(int r, int g, int b) {
        this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public void setColor(String color) {
        this.setColor(Color.getColor(color));
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelSize(float size) {
        this.labelSize = size;
    }

    public void setLabelVisible(boolean labelVisible) {
        this.labelVisible = labelVisible;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setLabelColor(String r, String g, String b) {
        this.setColor(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    public void setLabelColor(float r, float g, float b) {
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        this.setColor(new Color(r, g, b));
    }

    public void setLabelColor(int r, int g, int b) {
        this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public void setLabelColor(String color) {
        this.setColor(Color.getColor(color));
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setType(EdgeDraft.EdgeType edgeType) {
        this.edgeType = edgeType;
    }

    public void setId(String id) {
        this.id = id;
        this.autoId = false;
    }

    public void setSource(NodeDraft nodeSource) {
        this.source = (NodeDraftImpl)nodeSource;
    }

    public void setTarget(NodeDraft nodeTarget) {
        this.target = (NodeDraftImpl)nodeTarget;
    }

    public void addAttributeValue(AttributeColumn column, Object value) {
        if (column.getType().isDynamicType() && !(value instanceof DynamicType)) {
            if (value instanceof String && !column.getType().equals((Object)AttributeType.DYNAMIC_STRING)) {
                value = TypeConvertor.getStaticType(column.getType()).parse((String)value);
            }
            value = DynamicUtilities.createDynamicObject(column.getType(), new Interval<Object>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, value));
        }
        this.attributeRow.setValue(column, value);
    }

    public void addAttributeValue(AttributeColumn column, Object value, String dateFrom, String dateTo) throws IllegalArgumentException {
        this.addAttributeValue(column, value, dateFrom, dateTo, false, false);
    }

    public void addAttributeValue(AttributeColumn column, Object value, String dateFrom, String dateTo, boolean startOpen, boolean endOpen) throws IllegalArgumentException {
        Object sourceVal;
        if (!column.getType().isDynamicType()) {
            throw new IllegalArgumentException("The column must be dynamic");
        }
        Double start = Double.NEGATIVE_INFINITY;
        Double end = Double.POSITIVE_INFINITY;
        if (dateFrom != null && !dateFrom.isEmpty()) {
            try {
                start = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateFrom)) : Double.valueOf(Double.parseDouble(dateFrom));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateFrom));
            }
        }
        if (dateTo != null && !dateTo.isEmpty()) {
            try {
                end = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateTo)) : Double.valueOf(Double.parseDouble(dateTo));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateTo));
            }
        }
        if (start == null && end == null || start == Double.NEGATIVE_INFINITY && end == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(NbBundle.getMessage(EdgeDraftImpl.class, (String)"ImportContainerException_TimeInterval_Empty"));
        }
        if (value instanceof String && !column.getType().equals((Object)AttributeType.DYNAMIC_STRING)) {
            value = TypeConvertor.getStaticType(column.getType()).parse((String)value);
        }
        if ((sourceVal = this.attributeRow.getValue(column)) != null && sourceVal instanceof DynamicType) {
            value = DynamicUtilities.createDynamicObject(column.getType(), (DynamicType)sourceVal, new Interval<Object>(start, end, startOpen, endOpen, value));
        } else if (sourceVal != null && !(sourceVal instanceof DynamicType)) {
            ArrayList<Interval> intervals = new ArrayList<Interval>(2);
            intervals.add(new Interval<Object>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, sourceVal));
            intervals.add(new Interval<Object>(start, end, startOpen, endOpen, value));
            value = DynamicUtilities.createDynamicObject(column.getType(), intervals);
        } else {
            value = DynamicUtilities.createDynamicObject(column.getType(), new Interval<Object>(start, end, startOpen, endOpen, value));
        }
        this.attributeRow.setValue(column, value);
    }

    public void addTimeInterval(String dateFrom, String dateTo) throws IllegalArgumentException {
        this.addTimeInterval(dateFrom, dateTo, false, false);
    }

    public void addTimeInterval(String dateFrom, String dateTo, boolean startOpen, boolean endOpen) throws IllegalArgumentException {
        if (this.timeInterval == null) {
            this.timeInterval = new TimeInterval();
        }
        Double start = null;
        Double end = null;
        if (dateFrom != null && !dateFrom.isEmpty()) {
            try {
                start = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateFrom)) : Double.valueOf(Double.parseDouble(dateFrom));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateFrom));
            }
        }
        if (dateTo != null && !dateTo.isEmpty()) {
            try {
                end = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateTo)) : Double.valueOf(Double.parseDouble(dateTo));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateTo));
            }
        }
        if (start == null && end == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(EdgeDraftImpl.class, (String)"ImportContainerException_TimeInterval_Empty"));
        }
        this.timeInterval = new TimeInterval(this.timeInterval, start != null ? start : Double.NEGATIVE_INFINITY, end != null ? end : Double.POSITIVE_INFINITY, startOpen, endOpen);
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        this.timeInterval = timeInterval;
    }

    public AttributeRow getAttributeRow() {
        return this.attributeRow;
    }

    public NodeDraftImpl getSource() {
        return this.source;
    }

    public NodeDraftImpl getTarget() {
        return this.target;
    }

    public Color getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public float getLabelSize() {
        return this.labelSize;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public float getWeight() {
        return this.weight;
    }

    public EdgeDraft.EdgeType getType() {
        return this.edgeType;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isAutoId() {
        return this.autoId;
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public String toString() {
        String res = "edge";
        res = !this.autoId ? res + " id=" + this.id : (this.label != null ? res + " label=" + this.label : res + this.id);
        return res;
    }
}

