/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.api.AttributeValueFactory;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeDraftGetter;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.NodeDraftGetter;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.impl.EdgeDraftImpl;
import org.gephi.io.importer.impl.ImportContainerParameters;
import org.gephi.io.importer.impl.NodeDraftImpl;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContainerImpl
implements Container,
ContainerLoader,
ContainerUnloader {
    private String source;
    private final FactoryImpl factory;
    private final ImportContainerParameters parameters;
    private HashMap<String, NodeDraftImpl> nodeMap;
    private HashMap<String, NodeDraftImpl> nodeLabelMap;
    private final HashMap<String, EdgeDraftImpl> edgeMap;
    private final HashMap<String, EdgeDraftImpl> edgeSourceTargetMap;
    private final AttributeModel attributeModel;
    private boolean dynamicGraph = false;
    private boolean hierarchicalGraph = false;
    private Report report;
    private int directedEdgesCount = 0;
    private int undirectedEdgesCount = 0;
    private DynamicModel.TimeFormat timeFormat = DynamicModel.TimeFormat.DOUBLE;
    private Double timeIntervalMin;
    private Double timeIntervalMax;
    private static int nodeIDgen = 0;
    private static int edgeIDgen = 0;

    public ImportContainerImpl() {
        this.parameters = new ImportContainerParameters();
        this.nodeMap = new LinkedHashMap<String, NodeDraftImpl>();
        this.nodeLabelMap = new HashMap();
        this.edgeMap = new LinkedHashMap<String, EdgeDraftImpl>();
        this.edgeSourceTargetMap = new HashMap();
        this.attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).newModel();
        this.factory = new FactoryImpl();
    }

    @Override
    public ContainerLoader getLoader() {
        return this;
    }

    @Override
    public synchronized ContainerUnloader getUnloader() {
        return this;
    }

    @Override
    public ContainerLoader.DraftFactory factory() {
        return this.factory;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void addNode(NodeDraft nodeDraft) {
        if (nodeDraft == null) {
            throw new NullPointerException();
        }
        NodeDraftImpl nodeDraftImpl = (NodeDraftImpl)nodeDraft;
        if (this.nodeMap.containsKey(nodeDraftImpl.getId())) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_nodeExist", (Object)nodeDraftImpl.getId());
            this.report.logIssue(new Issue(message, Issue.Level.WARNING));
            return;
        }
        if (this.parameters.isDuplicateWithLabels() && nodeDraftImpl.getLabel() != null && !nodeDraftImpl.getLabel().equals(nodeDraftImpl.getId()) && this.nodeLabelMap.containsKey(nodeDraftImpl.getLabel())) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_nodeExist", (Object)nodeDraftImpl.getId());
            this.report.logIssue(new Issue(message, Issue.Level.WARNING));
            return;
        }
        this.nodeMap.put(nodeDraftImpl.getId(), nodeDraftImpl);
        if (nodeDraftImpl.getLabel() != null && !nodeDraftImpl.getLabel().equals(nodeDraftImpl.getId())) {
            this.nodeLabelMap.put(nodeDraftImpl.getLabel(), nodeDraftImpl);
        }
    }

    @Override
    public NodeDraftImpl getNode(String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException();
        }
        NodeDraftImpl node = this.nodeMap.get(id);
        if (node == null) {
            if (this.parameters.isAutoNode()) {
                node = this.factory.newNodeDraft();
                node.setId(id);
                this.addNode(node);
                node.setCreatedAuto(true);
                this.report.logIssue(new Issue("Unknown node id, creates node from id='" + id + "'", Issue.Level.INFO));
            } else {
                String message = NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_UnknowNodeId", (Object)id);
                this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            }
        }
        return node;
    }

    @Override
    public boolean nodeExists(String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException();
        }
        return this.nodeMap.containsKey(id);
    }

    @Override
    public void addEdge(EdgeDraft edgeDraft) {
        if (edgeDraft == null) {
            throw new NullPointerException();
        }
        EdgeDraftImpl edgeDraftImpl = (EdgeDraftImpl)edgeDraft;
        if (edgeDraftImpl.getSource() == null) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_MissingNodeSource");
            this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (edgeDraftImpl.getTarget() == null) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_MissingNodeTarget");
            this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (edgeDraftImpl.getSource() == edgeDraftImpl.getTarget() && !this.parameters.isSelfLoops()) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_SelfLoop");
            this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (edgeDraftImpl.getType() != null) {
            switch (edgeDraftImpl.getType()) {
                case DIRECTED: {
                    ++this.directedEdgesCount;
                    break;
                }
                case UNDIRECTED: {
                    ++this.undirectedEdgesCount;
                    break;
                }
                case MUTUAL: {
                    this.directedEdgesCount += 2;
                }
            }
            switch (this.parameters.getEdgeDefault()) {
                case DIRECTED: {
                    EdgeDraft.EdgeType type1 = edgeDraftImpl.getType();
                    if (!type1.equals((Object)EdgeDraft.EdgeType.UNDIRECTED)) break;
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_Bad_Edge_Type"), Issue.Level.WARNING));
                    break;
                }
                case UNDIRECTED: {
                    EdgeDraft.EdgeType type2 = edgeDraftImpl.getType();
                    if (!type2.equals((Object)EdgeDraft.EdgeType.DIRECTED)) break;
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_Bad_Edge_Type"), Issue.Level.WARNING));
                    break;
                }
            }
        }
        String id = edgeDraftImpl.getId();
        String sourceTargetId = edgeDraftImpl.getSource().getId() + "-" + edgeDraftImpl.getTarget().getId();
        if (this.edgeMap.containsKey(id) || this.edgeSourceTargetMap.containsKey(sourceTargetId)) {
            if (!this.parameters.isParallelEdges()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_edgeExist"), Issue.Level.WARNING));
                return;
            }
            if (this.parameters.isMergeParallelEdgesWeight()) {
                EdgeDraftImpl existingEdge = this.edgeMap.get(id);
                if (existingEdge == null) {
                    existingEdge = this.edgeSourceTargetMap.get(sourceTargetId);
                }
                existingEdge.setWeight(existingEdge.getWeight() + edgeDraftImpl.getWeight());
            }
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_Parallel_Edge", (Object)id), Issue.Level.INFO));
            return;
        }
        this.edgeSourceTargetMap.put(sourceTargetId, edgeDraftImpl);
        this.edgeMap.put(id, edgeDraftImpl);
        if (edgeDraftImpl.getType() != null && edgeDraftImpl.getType().equals((Object)EdgeDraft.EdgeType.MUTUAL)) {
            id = edgeDraftImpl.getId() + "-mutual";
            sourceTargetId = edgeDraftImpl.getTarget().getId() + "-" + edgeDraftImpl.getSource().getId();
            if (this.edgeSourceTargetMap.containsKey(sourceTargetId)) {
                if (!this.parameters.isParallelEdges()) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_edgeExist"), Issue.Level.WARNING));
                    return;
                }
                if (this.parameters.isMergeParallelEdgesWeight()) {
                    EdgeDraftImpl existingEdge = this.edgeSourceTargetMap.get(sourceTargetId);
                    existingEdge.setWeight(existingEdge.getWeight() + edgeDraftImpl.getWeight());
                }
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_Parallel_Edge", (Object)id), Issue.Level.INFO));
                return;
            }
            this.edgeSourceTargetMap.put(sourceTargetId, edgeDraftImpl);
            this.edgeMap.put(id, edgeDraftImpl);
        }
    }

    @Override
    public void removeEdge(EdgeDraft edgeDraft) {
        if (edgeDraft == null) {
            throw new NullPointerException();
        }
        EdgeDraftImpl edgeDraftImpl = (EdgeDraftImpl)edgeDraft;
        String id = edgeDraftImpl.getId();
        String sourceTargetId = edgeDraftImpl.getSource().getId() + "-" + edgeDraftImpl.getTarget().getId();
        if (!this.edgeMap.containsKey(id) && !this.edgeSourceTargetMap.containsKey(sourceTargetId)) {
            return;
        }
        if (edgeDraftImpl.getType() != null) {
            switch (edgeDraftImpl.getType()) {
                case DIRECTED: {
                    --this.directedEdgesCount;
                    break;
                }
                case UNDIRECTED: {
                    --this.undirectedEdgesCount;
                    break;
                }
                case MUTUAL: {
                    this.directedEdgesCount -= 2;
                }
            }
        }
        this.edgeSourceTargetMap.remove(sourceTargetId);
        this.edgeMap.remove(id);
        if (edgeDraftImpl.getType() != null && edgeDraftImpl.getType().equals((Object)EdgeDraft.EdgeType.MUTUAL)) {
            id = edgeDraftImpl.getId() + "-mutual";
            sourceTargetId = edgeDraftImpl.getTarget().getId() + "-" + edgeDraftImpl.getSource().getId();
            this.edgeSourceTargetMap.remove(sourceTargetId);
            this.edgeMap.remove(id);
        }
    }

    @Override
    public boolean edgeExists(String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException();
        }
        return this.edgeMap.containsKey(id);
    }

    @Override
    public boolean edgeExists(NodeDraft source, NodeDraft target) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        return this.edgeSourceTargetMap.containsKey(((NodeDraftImpl)source).getId() + "-" + ((NodeDraftImpl)target).getId());
    }

    @Override
    public EdgeDraft getEdge(String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException();
        }
        return this.edgeMap.get(id);
    }

    @Override
    public EdgeDraft getEdge(NodeDraft source, NodeDraft target) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        return this.edgeSourceTargetMap.get(((NodeDraftImpl)source).getId() + "-" + ((NodeDraftImpl)target).getId());
    }

    @Override
    public EdgeDraftGetter getEdge(NodeDraftGetter source, NodeDraftGetter target) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        return this.edgeSourceTargetMap.get(((NodeDraftImpl)source).getId() + "-" + ((NodeDraftImpl)target).getId());
    }

    @Override
    public Collection<? extends NodeDraftGetter> getNodes() {
        return this.nodeMap.values();
    }

    @Override
    public Collection<? extends EdgeDraftGetter> getEdges() {
        return this.edgeMap.values();
    }

    @Override
    public AttributeModel getAttributeModel() {
        return this.attributeModel;
    }

    public AttributeValueFactory getFactory() {
        return this.attributeModel.valueFactory();
    }

    @Override
    public Double getTimeIntervalMin() {
        return this.timeIntervalMin;
    }

    @Override
    public Double getTimeIntervalMax() {
        return this.timeIntervalMax;
    }

    @Override
    public DynamicModel.TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public void setTimeIntervalMax(String timeIntervalMax) {
        if (this.timeFormat.equals((Object)DynamicModel.TimeFormat.DATE)) {
            try {
                this.timeIntervalMax = DynamicUtilities.getDoubleFromXMLDateString(timeIntervalMax);
            }
            catch (Exception ex) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)timeIntervalMax), Issue.Level.SEVERE));
            }
        } else {
            try {
                this.timeIntervalMax = Double.parseDouble(timeIntervalMax);
            }
            catch (Exception ex) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)timeIntervalMax), Issue.Level.SEVERE));
            }
        }
    }

    @Override
    public void setTimeIntervalMin(String timeIntervalMin) {
        if (this.timeFormat.equals((Object)DynamicModel.TimeFormat.DATE)) {
            try {
                this.timeIntervalMin = DynamicUtilities.getDoubleFromXMLDateString(timeIntervalMin);
            }
            catch (Exception ex) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)timeIntervalMin), Issue.Level.SEVERE));
            }
        } else {
            try {
                this.timeIntervalMin = Double.parseDouble(timeIntervalMin);
            }
            catch (Exception ex) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)timeIntervalMin), Issue.Level.SEVERE));
            }
        }
    }

    @Override
    public void setTimeFormat(DynamicModel.TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean verify() {
        for (EdgeDraftImpl edgeDraftImpl : this.edgeMap.values().toArray(new EdgeDraftImpl[0])) {
            if (!(edgeDraftImpl.getWeight() <= 0.0f) || !this.parameters.isRemoveEdgeWithWeightZero()) continue;
            String id = edgeDraftImpl.getId();
            String sourceTargetId = edgeDraftImpl.getSource().getId() + "-" + edgeDraftImpl.getTarget().getId();
            this.edgeMap.remove(id);
            this.edgeSourceTargetMap.remove(sourceTargetId);
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_Weight_Zero_Ignored", (Object)id), Issue.Level.SEVERE));
        }
        if (this.directedEdgesCount > 0 && this.undirectedEdgesCount == 0) {
            this.parameters.setEdgeDefault(EdgeDefault.DIRECTED);
        } else if (this.directedEdgesCount == 0 && this.undirectedEdgesCount > 0) {
            this.parameters.setEdgeDefault(EdgeDefault.UNDIRECTED);
        } else if (this.directedEdgesCount > 0 && this.undirectedEdgesCount > 0) {
            this.parameters.setEdgeDefault(EdgeDefault.MIXED);
        }
        for (NodeDraftImpl node : this.nodeMap.values()) {
            boolean bl = this.dynamicGraph = node.getTimeInterval() != null;
            if (!this.dynamicGraph) continue;
            break;
        }
        if (!this.dynamicGraph) {
            for (EdgeDraftImpl edge : this.edgeMap.values()) {
                boolean bl = this.dynamicGraph = edge.getTimeInterval() != null;
                if (!this.dynamicGraph) continue;
                break;
            }
        }
        if (!this.dynamicGraph) {
            for (AttributeColumn attributeColumn : this.attributeModel.getNodeTable().getColumns()) {
                this.dynamicGraph = attributeColumn.getType().isDynamicType();
                if (this.dynamicGraph) break;
            }
            for (AttributeColumn attributeColumn : this.attributeModel.getEdgeTable().getColumns()) {
                this.dynamicGraph = attributeColumn.getType().isDynamicType();
                if (this.dynamicGraph) break;
            }
        }
        if (this.timeIntervalMin != null || this.timeIntervalMax != null) {
            String message;
            if (this.timeFormat.equals((Object)DynamicModel.TimeFormat.DATE)) {
                try {
                    message = "[" + (this.timeIntervalMin != null ? DynamicUtilities.getXMLDateStringFromDouble(this.timeIntervalMin) : "-inf") + ",";
                    message = message + (this.timeIntervalMax != null ? DynamicUtilities.getXMLDateStringFromDouble(this.timeIntervalMax) : "+inf") + "]";
                    this.report.log(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerLog.TimeInterval", (Object)message));
                }
                catch (Exception e) {}
            } else {
                message = "[" + (this.timeIntervalMin != null ? this.timeIntervalMin.toString() : "-inf") + ",";
                message = message + (this.timeIntervalMax != null ? this.timeIntervalMax.toString() : "+inf") + "]";
                this.report.log(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerLog.TimeInterval", (Object)message));
            }
        }
        if (this.dynamicGraph) {
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerLog.TimeFormat", (Object)this.timeFormat.toString()));
        }
        if (this.dynamicGraph && this.parameters.isRemoveIntervalsOverlapping()) {
            DynamicType type;
            AttributeValue val;
            for (NodeDraftImpl node : this.nodeMap.values()) {
                void var4_19;
                AttributeValue[] values = node.getAttributeRow().getValues();
                boolean bl = false;
                while (var4_19 < values.length) {
                    val = values[var4_19];
                    if (val.getValue() != null && val.getValue() instanceof DynamicType) {
                        type = (DynamicType)val.getValue();
                        type = DynamicUtilities.removeOverlapping(type);
                        node.getAttributeRow().setValue(val.getColumn(), (Object)type);
                    }
                    ++var4_19;
                }
            }
            for (EdgeDraftImpl edge : this.edgeMap.values()) {
                void var4_21;
                AttributeValue[] values = edge.getAttributeRow().getValues();
                boolean bl = false;
                while (var4_21 < values.length) {
                    val = values[var4_21];
                    if (val.getValue() != null && val.getValue() instanceof DynamicType) {
                        type = (DynamicType)val.getValue();
                        type = DynamicUtilities.removeOverlapping(type);
                        edge.getAttributeRow().setValue(val.getColumn(), (Object)type);
                    }
                    ++var4_21;
                }
            }
        }
        if (this.dynamicGraph && (this.timeIntervalMin != null || this.timeIntervalMax != null)) {
            DynamicType type;
            AttributeValue val;
            boolean issue;
            for (NodeDraftImpl node : this.nodeMap.values()) {
                issue = false;
                if (this.timeIntervalMin != null || this.timeIntervalMax != null) {
                    if (this.timeIntervalMin != null && node.getTimeInterval() != null && node.getTimeInterval().getLow() < this.timeIntervalMin) {
                        node.setTimeInterval((TimeInterval)DynamicUtilities.fitToInterval(node.getTimeInterval(), this.timeIntervalMin, node.getTimeInterval().getHigh()));
                        issue = true;
                    }
                    if (this.timeIntervalMax != null && node.getTimeInterval() != null && node.getTimeInterval().getHigh() > this.timeIntervalMax) {
                        node.setTimeInterval((TimeInterval)DynamicUtilities.fitToInterval(node.getTimeInterval(), node.getTimeInterval().getLow(), this.timeIntervalMax));
                        issue = true;
                    }
                    if (node.getTimeInterval() == null) {
                        node.setTimeInterval(new TimeInterval(this.timeIntervalMin, this.timeIntervalMax));
                    }
                }
                AttributeValue[] attributeValueArray = node.getAttributeRow().getValues();
                for (int i = 0; i < attributeValueArray.length; ++i) {
                    val = attributeValueArray[i];
                    if (val.getValue() == null || !(val.getValue() instanceof DynamicType)) continue;
                    type = (DynamicType)val.getValue();
                    if (this.timeIntervalMin != null && type.getLow() < this.timeIntervalMin) {
                        if (!Double.isInfinite(type.getLow())) {
                            issue = true;
                        }
                        node.getAttributeRow().setValue(val.getColumn(), (Object)DynamicUtilities.fitToInterval(type, this.timeIntervalMin, type.getHigh()));
                    }
                    if (this.timeIntervalMax == null || !(type.getHigh() > this.timeIntervalMax)) continue;
                    if (!Double.isInfinite(type.getHigh())) {
                        issue = true;
                    }
                    node.getAttributeRow().setValue(val.getColumn(), (Object)DynamicUtilities.fitToInterval(type, type.getLow(), this.timeIntervalMax));
                }
                if (!issue) continue;
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_TimeIntervalVerify_Node_OutOfBound", (Object)node.getId()), Issue.Level.WARNING));
            }
            for (EdgeDraftImpl edge : this.edgeMap.values()) {
                issue = false;
                if (this.timeIntervalMin != null || this.timeIntervalMax != null) {
                    if (this.timeIntervalMin != null && edge.getTimeInterval() != null && edge.getTimeInterval().getLow() < this.timeIntervalMin) {
                        edge.setTimeInterval((TimeInterval)DynamicUtilities.fitToInterval(edge.getTimeInterval(), this.timeIntervalMin, edge.getTimeInterval().getHigh()));
                        issue = true;
                    }
                    if (this.timeIntervalMax != null && edge.getTimeInterval() != null && edge.getTimeInterval().getHigh() > this.timeIntervalMax) {
                        edge.setTimeInterval((TimeInterval)DynamicUtilities.fitToInterval(edge.getTimeInterval(), edge.getTimeInterval().getLow(), this.timeIntervalMax));
                        issue = true;
                    }
                    if (edge.getTimeInterval() == null) {
                        edge.setTimeInterval(new TimeInterval(this.timeIntervalMin, this.timeIntervalMax));
                    }
                }
                AttributeValue[] attributeValueArray = edge.getAttributeRow().getValues();
                for (int i = 0; i < attributeValueArray.length; ++i) {
                    val = attributeValueArray[i];
                    if (val.getValue() == null || !(val.getValue() instanceof DynamicType)) continue;
                    type = (DynamicType)val.getValue();
                    if (this.timeIntervalMin != null && type.getLow() < this.timeIntervalMin) {
                        if (!Double.isInfinite(type.getLow())) {
                            issue = true;
                        }
                        edge.getAttributeRow().setValue(val.getColumn(), (Object)DynamicUtilities.fitToInterval(type, this.timeIntervalMin, type.getHigh()));
                    }
                    if (this.timeIntervalMax == null || !(type.getHigh() > this.timeIntervalMax)) continue;
                    if (!Double.isInfinite(type.getHigh())) {
                        issue = true;
                    }
                    edge.getAttributeRow().setValue(val.getColumn(), (Object)DynamicUtilities.fitToInterval(type, type.getLow(), this.timeIntervalMax));
                }
                if (!issue) continue;
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_TimeIntervalVerify_Edge_OutOfBound", (Object)edge.getId()), Issue.Level.WARNING));
            }
        }
        return true;
    }

    @Override
    public void closeLoader() {
        if (this.parameters.getEdgeDefault().equals((Object)EdgeDefault.UNDIRECTED)) {
            Iterator<EdgeDraftImpl> itr = this.edgeMap.values().iterator();
            while (itr.hasNext()) {
                EdgeDraftImpl edge = itr.next();
                String oppositekey = edge.getTarget().getId() + "-" + edge.getSource().getId();
                EdgeDraftImpl opposite = this.edgeSourceTargetMap.get(oppositekey);
                if (opposite == null) continue;
                if (this.parameters.isUndirectedSumDirectedEdgesWeight()) {
                    opposite.setWeight(edge.getWeight() + opposite.getWeight());
                } else {
                    opposite.setWeight(Math.max(edge.getWeight(), opposite.getWeight()));
                }
                itr.remove();
                this.edgeSourceTargetMap.remove(edge.getSource().getId() + "-" + edge.getTarget().getId());
            }
        } else if (this.parameters.getEdgeDefault().equals((Object)EdgeDefault.MIXED)) {
            for (EdgeDraftImpl edge : this.edgeMap.values().toArray(new EdgeDraftImpl[0])) {
                if (edge.getType() == null) {
                    edge.setType(EdgeDraft.EdgeType.UNDIRECTED);
                }
                if (!edge.getType().equals((Object)EdgeDraft.EdgeType.UNDIRECTED)) continue;
                String myKey = edge.getSource().getId() + "-" + edge.getTarget().getId();
                String oppositekey = edge.getTarget().getId() + "-" + edge.getSource().getId();
                EdgeDraftImpl opposite = this.edgeSourceTargetMap.get(oppositekey);
                if (opposite == null) continue;
                if (this.parameters.isUndirectedSumDirectedEdgesWeight()) {
                    edge.setWeight(edge.getWeight() + opposite.getWeight());
                } else {
                    edge.setWeight(Math.max(edge.getWeight(), opposite.getWeight()));
                }
                this.edgeMap.remove(edge.getId());
                this.edgeSourceTargetMap.remove(myKey);
            }
        }
        if (!this.allowAutoNode()) {
            for (NodeDraftImpl nodeDraftImpl : this.nodeMap.values().toArray(new NodeDraftImpl[0])) {
                if (!nodeDraftImpl.isCreatedAuto()) continue;
                this.nodeMap.remove(nodeDraftImpl.getId());
                Iterator<EdgeDraftImpl> itr = this.edgeMap.values().iterator();
                while (itr.hasNext()) {
                    EdgeDraftImpl edge = itr.next();
                    if (edge.getSource() != nodeDraftImpl && edge.getTarget() != nodeDraftImpl) continue;
                    itr.remove();
                }
            }
        }
        LinkedHashMap<String, NodeDraftImpl> sortedNodeMap = new LinkedHashMap<String, NodeDraftImpl>();
        ArrayList<NodeDraftImpl> sortedMapValues = new ArrayList<NodeDraftImpl>(this.nodeMap.values());
        Collections.sort(sortedMapValues, new Comparator<NodeDraftImpl>(){

            @Override
            public int compare(NodeDraftImpl o1, NodeDraftImpl o2) {
                return new Integer(o2.getHeight()).compareTo(o1.getHeight());
            }
        });
        for (NodeDraftImpl n : sortedMapValues) {
            sortedNodeMap.put(n.getId(), n);
        }
        this.nodeMap = sortedNodeMap;
        for (NodeDraftImpl node : this.nodeMap.values()) {
            if (node.getLabel() != null) continue;
            node.setLabel(node.getId());
        }
        boolean customPosition = false;
        for (NodeDraftImpl node : this.nodeMap.values()) {
            if (Float.isNaN(node.getX())) {
                node.setX(0.0f);
            }
            if (Float.isNaN(node.getY())) {
                node.setY(0.0f);
            }
            if (Float.isNaN(node.getZ())) {
                node.setZ(0.0f);
            }
            if (node.getX() == 0.0f && node.getY() == 0.0f) continue;
            customPosition = true;
        }
        if (!customPosition) {
            for (NodeDraftImpl node : this.nodeMap.values()) {
                node.setX((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
                node.setY((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
            }
        }
    }

    @Override
    public boolean isDynamicGraph() {
        return this.dynamicGraph;
    }

    @Override
    public boolean isHierarchicalGraph() {
        return this.hierarchicalGraph;
    }

    public void setDynamicGraph(boolean dynamicGraph) {
        this.dynamicGraph = dynamicGraph;
    }

    public void setHierarchicalGraph(boolean hierarchicalGraph) {
        this.hierarchicalGraph = hierarchicalGraph;
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public void setReport(Report report) {
        this.report = report;
    }

    @Override
    public void setAllowAutoNode(boolean value) {
        this.parameters.setAutoNode(value);
    }

    @Override
    public void setAllowParallelEdge(boolean value) {
        this.parameters.setParallelEdges(value);
    }

    @Override
    public void setAllowSelfLoop(boolean value) {
        this.parameters.setSelfLoops(value);
    }

    @Override
    public void setEdgeDefault(EdgeDefault edgeDefault) {
        this.parameters.setEdgeDefault(edgeDefault);
        this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, (String)"ImportContainerException_Set_EdgeDefault", (Object)edgeDefault.toString()), Issue.Level.INFO));
    }

    @Override
    public void setUndirectedSumDirectedEdgesWeight(boolean value) {
        this.parameters.setUndirectedSumDirectedEdgesWeight(value);
    }

    @Override
    public boolean allowAutoNode() {
        return this.parameters.isAutoNode();
    }

    @Override
    public boolean allowParallelEdges() {
        return this.parameters.isParallelEdges();
    }

    @Override
    public boolean allowSelfLoop() {
        return this.parameters.isSelfLoops();
    }

    @Override
    public EdgeDefault getEdgeDefault() {
        return this.parameters.getEdgeDefault();
    }

    @Override
    public boolean isAutoScale() {
        return this.parameters.isAutoScale();
    }

    @Override
    public void setAutoScale(boolean autoscale) {
        this.parameters.setAutoScale(autoscale);
    }

    public class FactoryImpl
    implements ContainerLoader.DraftFactory {
        public NodeDraftImpl newNodeDraft() {
            NodeDraftImpl node = new NodeDraftImpl(ImportContainerImpl.this, "n" + nodeIDgen);
            nodeIDgen++;
            return node;
        }

        public EdgeDraftImpl newEdgeDraft() {
            EdgeDraftImpl edge = new EdgeDraftImpl(ImportContainerImpl.this, "e" + edgeIDgen);
            edgeIDgen++;
            return edge;
        }
    }
}

