/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Node;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.NodeDraftGetter;
import org.gephi.io.importer.impl.ImportContainerImpl;
import org.openide.util.NbBundle;

public class NodeDraftImpl
implements NodeDraft,
NodeDraftGetter {
    private final ImportContainerImpl container;
    private boolean autoId;
    private boolean createdAuto = false;
    private String id;
    private String label;
    private NodeDraftImpl[] parents;
    private Color color;
    private float size;
    private float x;
    private float y;
    private float z;
    private boolean visible = true;
    private boolean fixed = false;
    private float labelSize = -1.0f;
    private boolean labelVisible = true;
    private Color labelColor;
    private TimeInterval timeInterval;
    private final AttributeRow attributeRow;
    private Node node;
    private int height;

    public NodeDraftImpl(ImportContainerImpl container, String id) {
        this.container = container;
        this.id = id;
        this.autoId = true;
        this.attributeRow = container.getAttributeModel().rowFactory().newNodeRow(null);
    }

    public void setCreatedAuto(boolean createdAuto) {
        this.createdAuto = createdAuto;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String r, String g, String b) {
        this.setColor(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    public void setColor(float r, float g, float b) {
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        this.setColor(new Color(r, g, b));
    }

    public void setColor(int r, int g, int b) {
        this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public void setColor(String color) {
        this.setColor(Color.getColor(color));
    }

    public void setId(String id) {
        this.id = id;
        this.autoId = false;
        this.createdAuto = false;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setLabel(String label) {
        this.label = label;
        this.createdAuto = false;
    }

    public void setLabelSize(float size) {
        this.labelSize = size;
    }

    public void setLabelVisible(boolean labelVisible) {
        this.labelVisible = labelVisible;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setLabelColor(String r, String g, String b) {
        this.setColor(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    public void setLabelColor(float r, float g, float b) {
        r = Math.max(Math.min(r, 1.0f), 0.0f);
        g = Math.max(Math.min(g, 1.0f), 0.0f);
        b = Math.max(Math.min(b, 1.0f), 0.0f);
        this.setColor(new Color(r, g, b));
    }

    public void setLabelColor(int r, int g, int b) {
        this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public void setLabelColor(String color) {
        this.setColor(Color.getColor(color));
    }

    public void setParent(NodeDraft draft) {
        NodeDraftImpl draftImpl = (NodeDraftImpl)draft;
        if (this.parents == null) {
            this.parents = new NodeDraftImpl[1];
            this.parents[0] = draftImpl;
        } else {
            this.parents = Arrays.copyOf(this.parents, this.parents.length + 1);
            this.parents[this.parents.length - 1] = draftImpl;
        }
        draftImpl.setHeight(this.height + 1);
        this.container.setHierarchicalGraph(true);
    }

    public void setHeight(int height) {
        if (height > this.height) {
            this.height = height;
            if (this.parents != null) {
                for (NodeDraftImpl p : this.parents) {
                    p.setHeight(height + 1);
                }
            }
        }
    }

    public void addChild(NodeDraft child) {
        child.setParent(this);
    }

    public void addAttributeValue(AttributeColumn column, Object value) {
        if (column.getType().isDynamicType() && !(value instanceof DynamicType)) {
            if (value instanceof String && !column.getType().equals((Object)AttributeType.DYNAMIC_STRING)) {
                value = TypeConvertor.getStaticType(column.getType()).parse((String)value);
            }
            value = DynamicUtilities.createDynamicObject(column.getType(), new Interval<Object>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, value));
        }
        this.attributeRow.setValue(column, value);
    }

    public void addAttributeValue(AttributeColumn column, Object value, String dateFrom, String dateTo) throws IllegalArgumentException {
        this.addAttributeValue(column, value, dateFrom, dateTo, false, false);
    }

    public void addAttributeValue(AttributeColumn column, Object value, String dateFrom, String dateTo, boolean startOpen, boolean endOpen) throws IllegalArgumentException {
        Object sourceVal;
        if (!column.getType().isDynamicType()) {
            throw new IllegalArgumentException("The column must be dynamic");
        }
        Double start = Double.NEGATIVE_INFINITY;
        Double end = Double.POSITIVE_INFINITY;
        if (dateFrom != null && !dateFrom.isEmpty()) {
            try {
                start = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateFrom)) : Double.valueOf(Double.parseDouble(dateFrom));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateFrom));
            }
        }
        if (dateTo != null && !dateTo.isEmpty()) {
            try {
                end = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateTo)) : Double.valueOf(Double.parseDouble(dateTo));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateTo));
            }
        }
        if (start == null && end == null || start == Double.NEGATIVE_INFINITY && end == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_Empty"));
        }
        if (value instanceof String && !column.getType().equals((Object)AttributeType.DYNAMIC_STRING)) {
            AttributeType staticType = TypeConvertor.getStaticType(column.getType());
            value = staticType.parse((String)value);
        }
        if ((sourceVal = this.attributeRow.getValue(column)) != null && sourceVal instanceof DynamicType) {
            value = DynamicUtilities.createDynamicObject(column.getType(), (DynamicType)sourceVal, new Interval<Object>(start, end, startOpen, endOpen, value));
        } else if (sourceVal != null && !(sourceVal instanceof DynamicType)) {
            ArrayList<Interval> intervals = new ArrayList<Interval>(2);
            intervals.add(new Interval<Object>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, sourceVal));
            intervals.add(new Interval<Object>(start, end, startOpen, endOpen, value));
            value = DynamicUtilities.createDynamicObject(column.getType(), intervals);
        } else {
            value = DynamicUtilities.createDynamicObject(column.getType(), new Interval<Object>(start, end, startOpen, endOpen, value));
        }
        this.attributeRow.setValue(column, value);
    }

    public void addTimeInterval(String dateFrom, String dateTo) throws IllegalArgumentException {
        this.addTimeInterval(dateFrom, dateTo, false, false);
    }

    public void addTimeInterval(String dateFrom, String dateTo, boolean startOpen, boolean endOpen) throws IllegalArgumentException {
        if (this.timeInterval == null) {
            this.timeInterval = new TimeInterval();
        }
        Double start = null;
        Double end = null;
        if (dateFrom != null && !dateFrom.isEmpty()) {
            try {
                start = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateFrom)) : Double.valueOf(Double.parseDouble(dateFrom));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateFrom));
            }
        }
        if (dateTo != null && !dateTo.isEmpty()) {
            try {
                end = this.container.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE) ? Double.valueOf(DynamicUtilities.getDoubleFromXMLDateString(dateTo)) : Double.valueOf(Double.parseDouble(dateTo));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_ParseError", (Object)dateTo));
            }
        }
        if (start == null && end == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(NodeDraftImpl.class, (String)"ImportContainerException_TimeInterval_Empty"));
        }
        this.timeInterval = new TimeInterval(this.timeInterval, start != null ? start : Double.NEGATIVE_INFINITY, end != null ? end : Double.POSITIVE_INFINITY, startOpen, endOpen);
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        this.timeInterval = timeInterval;
    }

    public AttributeRow getAttributeRow() {
        return this.attributeRow;
    }

    public Color getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    public float getSize() {
        return this.size;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getLabel() {
        return this.label;
    }

    public float getLabelSize() {
        return this.labelSize;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public int getHeight() {
        return this.height;
    }

    public NodeDraftGetter[] getParents() {
        return this.parents;
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public boolean isCreatedAuto() {
        return this.createdAuto;
    }

    public boolean isAutoId() {
        return this.autoId;
    }

    public String toString() {
        String res = "node";
        res = !this.autoId ? res + " id=" + this.id : (this.label != null ? res + " label=" + this.label : res + this.id);
        return res;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }
}

