/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.io.database.drivers.SQLUtils;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.PropertiesAssociations;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.plugin.database.EdgeListDatabaseImpl;
import org.gephi.io.importer.spi.DatabaseImporter;

public class ImporterEdgeList
implements DatabaseImporter {
    private Report report;
    private EdgeListDatabaseImpl database;
    private ContainerLoader container;
    private Connection connection;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        try {
            this.importData();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        this.close();
        return true;
    }

    private void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.report.log("Database connection terminated");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void importData() throws Exception {
        String url = SQLUtils.getUrl(this.database.getSQLDriver(), this.database.getHost(), this.database.getPort(), this.database.getDBName());
        try {
            this.report.log("Try to connect at " + url);
            this.connection = this.database.getSQLDriver().getConnection(url, this.database.getUsername(), this.database.getPasswd());
            this.report.log("Database connection established");
        }
        catch (SQLException ex) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.report.log("Database connection terminated");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.report.logIssue(new Issue("Failed to connect at " + url, Issue.Level.CRITICAL, ex));
        }
        if (this.connection == null) {
            this.report.logIssue(new Issue("Failed to connect at " + url, Issue.Level.CRITICAL));
        }
        this.report.log(this.database.getPropertiesAssociations().getInfos());
        this.getNodes(this.connection);
        this.getEdges(this.connection);
        this.getNodesAttributes(this.connection);
        this.getEdgesAttributes(this.connection);
    }

    private void getNodes(Connection connection) throws SQLException {
        ContainerLoader.DraftFactory factory = this.container.factory();
        PropertiesAssociations properties = this.database.getPropertiesAssociations();
        Statement s = connection.createStatement();
        try {
            s.executeQuery(this.database.getNodeQuery());
        }
        catch (SQLException ex) {
            this.report.logIssue(new Issue("Failed to execute Node query", Issue.Level.SEVERE, ex));
            return;
        }
        ResultSet rs = s.getResultSet();
        this.findNodeAttributesColumns(rs);
        AttributeTable nodeClass = this.container.getAttributeModel().getNodeTable();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        int count = 0;
        while (rs.next()) {
            NodeDraft node = factory.newNodeDraft();
            for (int i = 0; i < columnsCount; ++i) {
                String columnName = metaData.getColumnLabel(i + 1);
                PropertiesAssociations.NodeProperties p = properties.getNodeProperty(columnName);
                if (p != null) {
                    this.injectNodeProperty(p, rs, i + 1, node);
                    continue;
                }
                AttributeColumn col = nodeClass.getColumn(columnName);
                this.injectNodeAttribute(rs, i + 1, col, node);
            }
            this.container.addNode(node);
            ++count;
        }
        rs.close();
        s.close();
    }

    private void getEdges(Connection connection) throws SQLException {
        ContainerLoader.DraftFactory factory = this.container.factory();
        PropertiesAssociations properties = this.database.getPropertiesAssociations();
        Statement s = connection.createStatement();
        try {
            s.executeQuery(this.database.getEdgeQuery());
        }
        catch (SQLException ex) {
            this.report.logIssue(new Issue("Failed to execute Edge query", Issue.Level.SEVERE, ex));
            return;
        }
        ResultSet rs = s.getResultSet();
        this.findEdgeAttributesColumns(rs);
        AttributeTable edgeClass = this.container.getAttributeModel().getEdgeTable();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        int count = 0;
        while (rs.next()) {
            EdgeDraft edge = factory.newEdgeDraft();
            for (int i = 0; i < columnsCount; ++i) {
                String columnName = metaData.getColumnLabel(i + 1);
                PropertiesAssociations.EdgeProperties p = properties.getEdgeProperty(columnName);
                if (p != null) {
                    this.injectEdgeProperty(p, rs, i + 1, edge);
                    continue;
                }
                AttributeColumn col = edgeClass.getColumn(columnName);
                this.injectEdgeAttribute(rs, i + 1, col, edge);
            }
            this.container.addEdge(edge);
            ++count;
        }
        rs.close();
        s.close();
    }

    private void getNodesAttributes(Connection connection) throws SQLException {
    }

    private void getEdgesAttributes(Connection connection) throws SQLException {
    }

    private void injectNodeProperty(PropertiesAssociations.NodeProperties p, ResultSet rs, int column, NodeDraft nodeDraft) throws SQLException {
        switch (p) {
            case ID: {
                String id = rs.getString(column);
                if (id == null) break;
                nodeDraft.setId(id);
                break;
            }
            case LABEL: {
                String label = rs.getString(column);
                if (label == null) break;
                nodeDraft.setLabel(label);
                break;
            }
            case X: {
                float x = rs.getFloat(column);
                if (x == 0.0f) break;
                nodeDraft.setX(x);
                break;
            }
            case Y: {
                float y = rs.getFloat(column);
                if (y == 0.0f) break;
                nodeDraft.setY(y);
                break;
            }
            case Z: {
                float z = rs.getFloat(column);
                if (z == 0.0f) break;
                nodeDraft.setZ(z);
                break;
            }
            case R: {
                break;
            }
            case G: {
                break;
            }
        }
    }

    private void injectEdgeProperty(PropertiesAssociations.EdgeProperties p, ResultSet rs, int column, EdgeDraft edgeDraft) throws SQLException {
        switch (p) {
            case ID: {
                String id = rs.getString(column);
                if (id == null) break;
                edgeDraft.setId(id);
                break;
            }
            case LABEL: {
                String label = rs.getString(column);
                if (label == null) break;
                edgeDraft.setLabel(label);
                break;
            }
            case SOURCE: {
                String source = rs.getString(column);
                if (source == null) break;
                NodeDraft sourceNode = this.container.getNode(source);
                edgeDraft.setSource(sourceNode);
                break;
            }
            case TARGET: {
                String target = rs.getString(column);
                if (target == null) break;
                NodeDraft targetNode = this.container.getNode(target);
                edgeDraft.setTarget(targetNode);
                break;
            }
            case WEIGHT: {
                float weight = rs.getFloat(column);
                if (weight == 0.0f) break;
                edgeDraft.setWeight(weight);
                break;
            }
            case R: {
                break;
            }
            case G: {
                break;
            }
        }
    }

    private void injectNodeAttribute(ResultSet rs, int columnIndex, AttributeColumn column, NodeDraft draft) {
        switch (column.getType()) {
            case BOOLEAN: {
                try {
                    boolean val = rs.getBoolean(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a BOOLEAN value for node attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case DOUBLE: {
                try {
                    double val = rs.getDouble(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a DOUBLE value for node attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case FLOAT: {
                try {
                    float val = rs.getFloat(columnIndex);
                    draft.addAttributeValue(column, Float.valueOf(val));
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a FLOAT value for node attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case INT: {
                try {
                    int val = rs.getInt(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a INT value for node attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case LONG: {
                try {
                    long val = rs.getLong(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a LONG value for node attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            default: {
                try {
                    String val = rs.getString(columnIndex);
                    if (val != null) {
                        draft.addAttributeValue(column, val);
                        break;
                    }
                    this.report.logIssue(new Issue("Failed to get a STRING value for node attribute '" + column.getId() + "'", Issue.Level.WARNING));
                    break;
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a STRING value for node attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
            }
        }
    }

    private void injectEdgeAttribute(ResultSet rs, int columnIndex, AttributeColumn column, EdgeDraft draft) {
        switch (column.getType()) {
            case BOOLEAN: {
                try {
                    boolean val = rs.getBoolean(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a BOOLEAN value for edge attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case DOUBLE: {
                try {
                    double val = rs.getDouble(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a DOUBLE value for edge attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case FLOAT: {
                try {
                    float val = rs.getFloat(columnIndex);
                    draft.addAttributeValue(column, Float.valueOf(val));
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a FLOAT value for edge attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case INT: {
                try {
                    int val = rs.getInt(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a INT value for edge attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            case LONG: {
                try {
                    long val = rs.getLong(columnIndex);
                    draft.addAttributeValue(column, val);
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a LONG value for edge attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
                break;
            }
            default: {
                try {
                    String val = rs.getString(columnIndex);
                    if (val != null) {
                        draft.addAttributeValue(column, val);
                        break;
                    }
                    this.report.logIssue(new Issue("Failed to get a BOOLEAN value for edge attribute '" + column.getId() + "'", Issue.Level.WARNING));
                    break;
                }
                catch (SQLException ex) {
                    this.report.logIssue(new Issue("Failed to get a STRING value for edge attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
                }
            }
        }
    }

    private void findNodeAttributesColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        AttributeTable nodeClass = this.container.getAttributeModel().getNodeTable();
        for (int i = 0; i < columnsCount; ++i) {
            String columnName = metaData.getColumnLabel(i + 1);
            PropertiesAssociations.NodeProperties p = this.database.getPropertiesAssociations().getNodeProperty(columnName);
            if (p != null) continue;
            AttributeType type = AttributeType.STRING;
            switch (metaData.getColumnType(i + 1)) {
                case -5: {
                    type = AttributeType.LONG;
                    break;
                }
                case 4: {
                    type = AttributeType.INT;
                    break;
                }
                case -6: {
                    type = AttributeType.INT;
                    break;
                }
                case 5: {
                    type = AttributeType.INT;
                    break;
                }
                case 16: {
                    type = AttributeType.BOOLEAN;
                    break;
                }
                case 6: {
                    type = AttributeType.FLOAT;
                    break;
                }
                case 8: {
                    type = AttributeType.DOUBLE;
                    break;
                }
                case 12: {
                    type = AttributeType.STRING;
                    break;
                }
                default: {
                    this.report.logIssue(new Issue("Unknown SQL Type " + metaData.getColumnType(i + 1) + ", STRING used.", Issue.Level.WARNING));
                }
            }
            this.report.log("Node attribute found: " + columnName + "(" + (Object)((Object)type) + ")");
            nodeClass.addColumn(columnName, type);
        }
    }

    private void findEdgeAttributesColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        AttributeTable edgeClass = this.container.getAttributeModel().getEdgeTable();
        for (int i = 0; i < columnsCount; ++i) {
            String columnName = metaData.getColumnLabel(i + 1);
            PropertiesAssociations.EdgeProperties p = this.database.getPropertiesAssociations().getEdgeProperty(columnName);
            if (p != null) continue;
            AttributeType type = AttributeType.STRING;
            switch (metaData.getColumnType(i + 1)) {
                case -5: {
                    type = AttributeType.LONG;
                    break;
                }
                case 4: {
                    type = AttributeType.INT;
                    break;
                }
                case -6: {
                    type = AttributeType.INT;
                    break;
                }
                case 5: {
                    type = AttributeType.INT;
                    break;
                }
                case 16: {
                    type = AttributeType.BOOLEAN;
                    break;
                }
                case 6: {
                    type = AttributeType.FLOAT;
                    break;
                }
                case 8: {
                    type = AttributeType.DOUBLE;
                    break;
                }
                case 12: {
                    type = AttributeType.STRING;
                    break;
                }
                default: {
                    this.report.logIssue(new Issue("Unknown SQL Type " + metaData.getColumnType(i + 1) + ", STRING used.", Issue.Level.WARNING));
                }
            }
            this.report.log("Edge attribute found: " + columnName + "(" + (Object)((Object)type) + ")");
            edgeClass.addColumn(columnName, type);
        }
    }

    public void setDatabase(Database database) {
        this.database = (EdgeListDatabaseImpl)database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }
}

