/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.awt.Color;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterDOT
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private Map<String, Color> colorTable = new HashMap<String, Color>();
    private String graphName = "";

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader(this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start(this.progressTicket);
        this.initColorTable();
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.setSyntax(streamTokenizer);
        this.graph(streamTokenizer);
    }

    protected void setSyntax(StreamTokenizer tk) {
        tk.resetSyntax();
        tk.eolIsSignificant(false);
        tk.slashStarComments(true);
        tk.slashSlashComments(true);
        tk.whitespaceChars(0, 32);
        tk.wordChars(33, 255);
        tk.ordinaryChar(91);
        tk.ordinaryChar(93);
        tk.ordinaryChar(123);
        tk.ordinaryChar(125);
        tk.ordinaryChar(45);
        tk.ordinaryChar(62);
        tk.ordinaryChar(47);
        tk.ordinaryChar(42);
        tk.ordinaryChar(44);
        tk.quoteChar(34);
        tk.whitespaceChars(59, 59);
        tk.ordinaryChar(61);
    }

    protected void graph(StreamTokenizer streamTokenizer) throws Exception {
        boolean found = false;
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("digraph") && !streamTokenizer.sval.equalsIgnoreCase("graph")) continue;
            found = true;
            this.container.setEdgeDefault(streamTokenizer.sval.equalsIgnoreCase("digraph") ? EdgeDefault.DIRECTED : EdgeDefault.UNDIRECTED);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3) {
                this.graphName = streamTokenizer.sval;
                streamTokenizer.nextToken();
            }
            while (streamTokenizer.ttype != 123) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -1) continue;
                return;
            }
            this.stmtList(streamTokenizer);
        }
        if (!found) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_nothingfound"), Issue.Level.SEVERE));
        }
    }

    protected void stmtList(StreamTokenizer streamTokenizer) throws Exception {
        do {
            streamTokenizer.nextToken();
            this.stmt(streamTokenizer);
        } while (streamTokenizer.ttype != -1);
    }

    protected void stmt(StreamTokenizer streamTokenizer) throws Exception {
        if (!(streamTokenizer.sval == null || streamTokenizer.sval.equalsIgnoreCase("graph") || streamTokenizer.sval.equalsIgnoreCase("node") || streamTokenizer.sval.equalsIgnoreCase("edge"))) {
            String nodeId = this.nodeID(streamTokenizer);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 45) {
                NodeDraft nodeDraft = this.getOrCreateNode(nodeId);
                this.edgeStructure(streamTokenizer, nodeDraft);
            } else if (streamTokenizer.ttype == 91) {
                NodeDraft nodeDraft = this.getOrCreateNode(nodeId);
                this.nodeAttributes(streamTokenizer, nodeDraft);
            }
        }
    }

    protected String nodeID(StreamTokenizer streamTokenizer) {
        if (streamTokenizer.ttype == 34 || streamTokenizer.ttype == -3 || streamTokenizer.ttype >= 97 && streamTokenizer.ttype <= 122 || streamTokenizer.ttype >= 65 && streamTokenizer.ttype <= 90) {
            return streamTokenizer.sval;
        }
        return null;
    }

    protected NodeDraft getOrCreateNode(String id) {
        if (!this.container.nodeExists(id)) {
            NodeDraft nodeDraft = this.container.factory().newNodeDraft();
            nodeDraft.setId(id);
            this.container.addNode(nodeDraft);
            return nodeDraft;
        }
        return this.container.getNode(id);
    }

    protected void nodeAttributes(StreamTokenizer streamTokenizer, NodeDraft nodeDraft) throws Exception {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 93 || streamTokenizer.ttype == -1) {
            return;
        }
        if (streamTokenizer.ttype == -3) {
            if (streamTokenizer.sval.equalsIgnoreCase("label")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        nodeDraft.setLabel(streamTokenizer.sval);
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("color")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        if (this.colorTable.containsKey(streamTokenizer.sval)) {
                            nodeDraft.setColor(this.colorTable.get(streamTokenizer.sval));
                        } else {
                            try {
                                String[] colors = streamTokenizer.sval.split(" ");
                                nodeDraft.setColor(Float.parseFloat(colors[0]), Float.parseFloat(colors[1]), Float.parseFloat(colors[2]));
                            }
                            catch (Exception e) {}
                        }
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_colorunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_colorunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("pos")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        try {
                            String[] positions = streamTokenizer.sval.split(",");
                            if (positions.length == 2) {
                                nodeDraft.setX(Float.parseFloat(positions[0]));
                                nodeDraft.setY(Float.parseFloat(positions[1]));
                            } else if (positions.length == 3) {
                                nodeDraft.setX(Float.parseFloat(positions[0]));
                                nodeDraft.setY(Float.parseFloat(positions[1]));
                                nodeDraft.setZ(Float.parseFloat(positions[2]));
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_posunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_posunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("style")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        streamTokenizer.pushBack();
                    }
                } else {
                    streamTokenizer.pushBack();
                }
            }
        }
        this.nodeAttributes(streamTokenizer, nodeDraft);
    }

    protected void edgeStructure(StreamTokenizer streamTokenizer, NodeDraft nodeDraft) throws Exception {
        streamTokenizer.nextToken();
        EdgeDraft edge = null;
        if (streamTokenizer.ttype == 62 || streamTokenizer.ttype == 45) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 123) {
                while (true) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 125) {
                        this.nodeID(streamTokenizer);
                        edge = this.container.factory().newEdgeDraft();
                        edge.setSource(nodeDraft);
                        edge.setTarget(this.getOrCreateNode("" + streamTokenizer.sval));
                        this.container.addEdge(edge);
                        continue;
                    }
                    break;
                }
            } else {
                this.nodeID(streamTokenizer);
                edge = this.container.factory().newEdgeDraft();
                edge.setSource(nodeDraft);
                edge.setTarget(this.getOrCreateNode("" + streamTokenizer.sval));
                this.container.addEdge(edge);
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_edgeparsing", (Object)streamTokenizer.lineno()), Issue.Level.SEVERE));
            if (streamTokenizer.ttype == -3) {
                streamTokenizer.pushBack();
            }
            return;
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 91) {
            this.edgeAttributes(streamTokenizer, edge);
        } else {
            streamTokenizer.pushBack();
        }
    }

    protected void edgeAttributes(StreamTokenizer streamTokenizer, EdgeDraft edge) throws Exception {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 93 || streamTokenizer.ttype == -1) {
            return;
        }
        if (streamTokenizer.ttype == -3) {
            if (streamTokenizer.sval.equalsIgnoreCase("label")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        edge.setLabel(streamTokenizer.sval);
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("color")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        if (this.colorTable.containsKey(streamTokenizer.sval)) {
                            edge.setColor(this.colorTable.get(streamTokenizer.sval));
                        } else {
                            try {
                                String[] colors = streamTokenizer.sval.split(" ");
                                edge.setColor(Float.parseFloat(colors[0]), Float.parseFloat(colors[1]), Float.parseFloat(colors[2]));
                            }
                            catch (Exception e) {}
                        }
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_color_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_color_labelunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("style")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        streamTokenizer.pushBack();
                    }
                } else {
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase("weight")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        try {
                            Float weight = Float.valueOf(Float.parseFloat(streamTokenizer.sval));
                            edge.setWeight(weight.floatValue());
                        }
                        catch (Exception e) {
                            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_weightunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        }
                    } else {
                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_weightunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                        streamTokenizer.pushBack();
                    }
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDOT.class, (String)"importerDOT_error_weightunreachable", (Object)streamTokenizer.lineno()), Issue.Level.WARNING));
                    streamTokenizer.pushBack();
                }
            }
        }
        this.edgeAttributes(streamTokenizer, edge);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    private void initColorTable() {
        this.colorTable.put("aliceblue", new Color(240, 248, 255));
        this.colorTable.put("antiquewhite", new Color(250, 235, 215));
        this.colorTable.put("antiquewhite1", new Color(255, 239, 219));
        this.colorTable.put("antiquewhite2", new Color(238, 223, 204));
        this.colorTable.put("antiquewhite3", new Color(205, 192, 176));
        this.colorTable.put("antiquewhite4", new Color(139, 131, 120));
        this.colorTable.put("aquamarine", new Color(127, 255, 212));
        this.colorTable.put("aquamarine1", new Color(127, 255, 212));
        this.colorTable.put("aquamarine2", new Color(118, 238, 198));
        this.colorTable.put("aquamarine3", new Color(102, 205, 170));
        this.colorTable.put("aquamarine4", new Color(69, 139, 116));
        this.colorTable.put("azure", new Color(240, 255, 255));
        this.colorTable.put("azure1", new Color(240, 255, 255));
        this.colorTable.put("azure2", new Color(224, 238, 238));
        this.colorTable.put("azure3", new Color(193, 205, 205));
        this.colorTable.put("azure4", new Color(131, 139, 139));
        this.colorTable.put("beige", new Color(245, 245, 220));
        this.colorTable.put("bisque", new Color(255, 228, 196));
        this.colorTable.put("bisque1", new Color(255, 228, 196));
        this.colorTable.put("bisque2", new Color(238, 213, 183));
        this.colorTable.put("bisque3", new Color(205, 183, 158));
        this.colorTable.put("bisque4", new Color(139, 125, 107));
        this.colorTable.put("black", new Color(0, 0, 0));
        this.colorTable.put("blanchedalmond", new Color(255, 235, 205));
        this.colorTable.put("blue", new Color(0, 0, 255));
        this.colorTable.put("blue1", new Color(0, 0, 255));
        this.colorTable.put("blue2", new Color(0, 0, 238));
        this.colorTable.put("blue3", new Color(0, 0, 205));
        this.colorTable.put("blue4", new Color(0, 0, 139));
        this.colorTable.put("blueviolet", new Color(138, 43, 226));
        this.colorTable.put("brown", new Color(165, 42, 42));
        this.colorTable.put("brown1", new Color(255, 64, 64));
        this.colorTable.put("brown2", new Color(238, 59, 59));
        this.colorTable.put("brown3", new Color(205, 51, 51));
        this.colorTable.put("brown4", new Color(139, 35, 35));
        this.colorTable.put("burlywood", new Color(222, 184, 135));
        this.colorTable.put("burlywood1", new Color(255, 211, 155));
        this.colorTable.put("burlywood2", new Color(238, 197, 145));
        this.colorTable.put("burlywood3", new Color(205, 170, 125));
        this.colorTable.put("burlywood4", new Color(139, 115, 85));
        this.colorTable.put("cadetblue", new Color(95, 158, 160));
        this.colorTable.put("cadetblue1", new Color(152, 245, 255));
        this.colorTable.put("cadetblue2", new Color(142, 229, 238));
        this.colorTable.put("cadetblue3", new Color(122, 197, 205));
        this.colorTable.put("cadetblue4", new Color(83, 134, 139));
        this.colorTable.put("chartreuse", new Color(127, 255, 0));
        this.colorTable.put("chartreuse1", new Color(127, 255, 0));
        this.colorTable.put("chartreuse2", new Color(118, 238, 0));
        this.colorTable.put("chartreuse3", new Color(102, 205, 0));
        this.colorTable.put("chartreuse4", new Color(69, 139, 0));
        this.colorTable.put("chocolate", new Color(210, 105, 30));
        this.colorTable.put("chocolate1", new Color(255, 127, 36));
        this.colorTable.put("chocolate2", new Color(238, 118, 33));
        this.colorTable.put("chocolate3", new Color(205, 102, 29));
        this.colorTable.put("chocolate4", new Color(139, 69, 19));
        this.colorTable.put("coral", new Color(255, 127, 80));
        this.colorTable.put("coral1", new Color(255, 114, 86));
        this.colorTable.put("coral2", new Color(238, 106, 80));
        this.colorTable.put("coral3", new Color(205, 91, 69));
        this.colorTable.put("coral4", new Color(139, 62, 47));
        this.colorTable.put("cornflowerblue", new Color(100, 149, 237));
        this.colorTable.put("cornsilk", new Color(255, 248, 220));
        this.colorTable.put("cornsilk1", new Color(255, 248, 220));
        this.colorTable.put("cornsilk2", new Color(238, 232, 205));
        this.colorTable.put("cornsilk3", new Color(205, 200, 177));
        this.colorTable.put("cornsilk4", new Color(139, 136, 120));
        this.colorTable.put("crimson", new Color(220, 20, 60));
        this.colorTable.put("cyan", new Color(0, 255, 255));
        this.colorTable.put("cyan1", new Color(0, 255, 255));
        this.colorTable.put("cyan2", new Color(0, 238, 238));
        this.colorTable.put("cyan3", new Color(0, 205, 205));
        this.colorTable.put("cyan4", new Color(0, 139, 139));
        this.colorTable.put("darkblue", new Color(0, 0, 139));
        this.colorTable.put("darkcyan", new Color(0, 139, 139));
        this.colorTable.put("darkgoldenrod", new Color(184, 134, 11));
        this.colorTable.put("darkgoldenrod1", new Color(255, 185, 15));
        this.colorTable.put("darkgoldenrod2", new Color(238, 173, 14));
        this.colorTable.put("darkgoldenrod3", new Color(205, 149, 12));
        this.colorTable.put("darkgoldenrod4", new Color(139, 101, 8));
        this.colorTable.put("darkgray", new Color(169, 169, 169));
        this.colorTable.put("darkgreen", new Color(0, 100, 0));
        this.colorTable.put("darkgrey", new Color(169, 169, 169));
        this.colorTable.put("darkkhaki", new Color(189, 183, 107));
        this.colorTable.put("darkmagenta", new Color(139, 0, 139));
        this.colorTable.put("darkolivegreen", new Color(85, 107, 47));
        this.colorTable.put("darkolivegreen1", new Color(202, 255, 112));
        this.colorTable.put("darkolivegreen2", new Color(188, 238, 104));
        this.colorTable.put("darkolivegreen3", new Color(162, 205, 90));
        this.colorTable.put("darkolivegreen4", new Color(110, 139, 61));
        this.colorTable.put("darkorange", new Color(255, 140, 0));
        this.colorTable.put("darkorange1", new Color(255, 127, 0));
        this.colorTable.put("darkorange2", new Color(238, 118, 0));
        this.colorTable.put("darkorange3", new Color(205, 102, 0));
        this.colorTable.put("darkorange4", new Color(139, 69, 0));
        this.colorTable.put("darkorchid", new Color(153, 50, 204));
        this.colorTable.put("darkorchid1", new Color(191, 62, 255));
        this.colorTable.put("darkorchid2", new Color(178, 58, 238));
        this.colorTable.put("darkorchid3", new Color(154, 50, 205));
        this.colorTable.put("darkorchid4", new Color(104, 34, 139));
        this.colorTable.put("darkred", new Color(139, 0, 0));
        this.colorTable.put("darksalmon", new Color(233, 150, 122));
        this.colorTable.put("darkseagreen", new Color(143, 188, 143));
        this.colorTable.put("darkseagreen1", new Color(193, 255, 193));
        this.colorTable.put("darkseagreen2", new Color(180, 238, 180));
        this.colorTable.put("darkseagreen3", new Color(155, 205, 155));
        this.colorTable.put("darkseagreen4", new Color(105, 139, 105));
        this.colorTable.put("darkslateblue", new Color(72, 61, 139));
        this.colorTable.put("darkslategray", new Color(47, 79, 79));
        this.colorTable.put("darkslategray1", new Color(151, 255, 255));
        this.colorTable.put("darkslategray2", new Color(141, 238, 238));
        this.colorTable.put("darkslategray3", new Color(121, 205, 205));
        this.colorTable.put("darkslategray4", new Color(82, 139, 139));
        this.colorTable.put("darkslategrey", new Color(47, 79, 79));
        this.colorTable.put("darkturquoise", new Color(0, 206, 209));
        this.colorTable.put("darkviolet", new Color(148, 0, 211));
        this.colorTable.put("deeppink", new Color(255, 20, 147));
        this.colorTable.put("deeppink1", new Color(255, 20, 147));
        this.colorTable.put("deeppink2", new Color(238, 18, 137));
        this.colorTable.put("deeppink3", new Color(205, 16, 118));
        this.colorTable.put("deeppink4", new Color(139, 10, 80));
        this.colorTable.put("deepskyblue", new Color(0, 191, 255));
        this.colorTable.put("deepskyblue1", new Color(0, 191, 255));
        this.colorTable.put("deepskyblue2", new Color(0, 178, 238));
        this.colorTable.put("deepskyblue3", new Color(0, 154, 205));
        this.colorTable.put("deepskyblue4", new Color(0, 104, 139));
        this.colorTable.put("dimgray", new Color(105, 105, 105));
        this.colorTable.put("dimgrey", new Color(105, 105, 105));
        this.colorTable.put("dodgerblue", new Color(30, 144, 255));
        this.colorTable.put("dodgerblue1", new Color(30, 144, 255));
        this.colorTable.put("dodgerblue2", new Color(28, 134, 238));
        this.colorTable.put("dodgerblue3", new Color(24, 116, 205));
        this.colorTable.put("dodgerblue4", new Color(16, 78, 139));
        this.colorTable.put("firebrick", new Color(178, 34, 34));
        this.colorTable.put("firebrick1", new Color(255, 48, 48));
        this.colorTable.put("firebrick2", new Color(238, 44, 44));
        this.colorTable.put("firebrick3", new Color(205, 38, 38));
        this.colorTable.put("firebrick4", new Color(139, 26, 26));
        this.colorTable.put("floralwhite", new Color(255, 250, 240));
        this.colorTable.put("forestgreen", new Color(34, 139, 34));
        this.colorTable.put("gainsboro", new Color(220, 220, 220));
        this.colorTable.put("ghostwhite", new Color(248, 248, 255));
        this.colorTable.put("gold", new Color(255, 215, 0));
        this.colorTable.put("gold1", new Color(255, 215, 0));
        this.colorTable.put("gold2", new Color(238, 201, 0));
        this.colorTable.put("gold3", new Color(205, 173, 0));
        this.colorTable.put("gold4", new Color(139, 117, 0));
        this.colorTable.put("goldenrod", new Color(218, 165, 32));
        this.colorTable.put("goldenrod1", new Color(255, 193, 37));
        this.colorTable.put("goldenrod2", new Color(238, 180, 34));
        this.colorTable.put("goldenrod3", new Color(205, 155, 29));
        this.colorTable.put("goldenrod4", new Color(139, 105, 20));
        this.colorTable.put("green", new Color(0, 255, 0));
        this.colorTable.put("green1", new Color(0, 255, 0));
        this.colorTable.put("green2", new Color(0, 238, 0));
        this.colorTable.put("green3", new Color(0, 205, 0));
        this.colorTable.put("green4", new Color(0, 139, 0));
        this.colorTable.put("greenyellow", new Color(173, 255, 47));
        this.colorTable.put("gray", new Color(190, 190, 190));
        this.colorTable.put("grey", new Color(190, 190, 190));
        this.colorTable.put("gray0", new Color(0, 0, 0));
        this.colorTable.put("grey0", new Color(0, 0, 0));
        this.colorTable.put("gray1", new Color(3, 3, 3));
        this.colorTable.put("grey1", new Color(3, 3, 3));
        this.colorTable.put("gray2", new Color(5, 5, 5));
        this.colorTable.put("grey2", new Color(5, 5, 5));
        this.colorTable.put("gray3", new Color(8, 8, 8));
        this.colorTable.put("grey3", new Color(8, 8, 8));
        this.colorTable.put("gray4", new Color(10, 10, 10));
        this.colorTable.put("grey4", new Color(10, 10, 10));
        this.colorTable.put("gray5", new Color(13, 13, 13));
        this.colorTable.put("grey5", new Color(13, 13, 13));
        this.colorTable.put("gray6", new Color(15, 15, 15));
        this.colorTable.put("grey6", new Color(15, 15, 15));
        this.colorTable.put("gray7", new Color(18, 18, 18));
        this.colorTable.put("grey7", new Color(18, 18, 18));
        this.colorTable.put("gray8", new Color(20, 20, 20));
        this.colorTable.put("grey8", new Color(20, 20, 20));
        this.colorTable.put("gray9", new Color(23, 23, 23));
        this.colorTable.put("grey9", new Color(23, 23, 23));
        this.colorTable.put("gray10", new Color(26, 26, 26));
        this.colorTable.put("grey10", new Color(26, 26, 26));
        this.colorTable.put("gray11", new Color(28, 28, 28));
        this.colorTable.put("grey11", new Color(28, 28, 28));
        this.colorTable.put("gray12", new Color(31, 31, 31));
        this.colorTable.put("grey12", new Color(31, 31, 31));
        this.colorTable.put("gray13", new Color(33, 33, 33));
        this.colorTable.put("grey13", new Color(33, 33, 33));
        this.colorTable.put("gray14", new Color(36, 36, 36));
        this.colorTable.put("grey14", new Color(36, 36, 36));
        this.colorTable.put("gray15", new Color(38, 38, 38));
        this.colorTable.put("grey15", new Color(38, 38, 38));
        this.colorTable.put("gray16", new Color(41, 41, 41));
        this.colorTable.put("grey16", new Color(41, 41, 41));
        this.colorTable.put("gray17", new Color(43, 43, 43));
        this.colorTable.put("grey17", new Color(43, 43, 43));
        this.colorTable.put("gray18", new Color(46, 46, 46));
        this.colorTable.put("grey18", new Color(46, 46, 46));
        this.colorTable.put("gray19", new Color(48, 48, 48));
        this.colorTable.put("grey19", new Color(48, 48, 48));
        this.colorTable.put("gray20", new Color(51, 51, 51));
        this.colorTable.put("grey20", new Color(51, 51, 51));
        this.colorTable.put("gray21", new Color(54, 54, 54));
        this.colorTable.put("grey21", new Color(54, 54, 54));
        this.colorTable.put("gray22", new Color(56, 56, 56));
        this.colorTable.put("grey22", new Color(56, 56, 56));
        this.colorTable.put("gray23", new Color(59, 59, 59));
        this.colorTable.put("grey23", new Color(59, 59, 59));
        this.colorTable.put("gray24", new Color(61, 61, 61));
        this.colorTable.put("grey24", new Color(61, 61, 61));
        this.colorTable.put("gray25", new Color(64, 64, 64));
        this.colorTable.put("grey25", new Color(64, 64, 64));
        this.colorTable.put("gray26", new Color(66, 66, 66));
        this.colorTable.put("grey26", new Color(66, 66, 66));
        this.colorTable.put("gray27", new Color(69, 69, 69));
        this.colorTable.put("grey27", new Color(69, 69, 69));
        this.colorTable.put("gray28", new Color(71, 71, 71));
        this.colorTable.put("grey28", new Color(71, 71, 71));
        this.colorTable.put("gray29", new Color(74, 74, 74));
        this.colorTable.put("grey29", new Color(74, 74, 74));
        this.colorTable.put("gray30", new Color(77, 77, 77));
        this.colorTable.put("grey30", new Color(77, 77, 77));
        this.colorTable.put("gray31", new Color(79, 79, 79));
        this.colorTable.put("grey31", new Color(79, 79, 79));
        this.colorTable.put("gray32", new Color(82, 82, 82));
        this.colorTable.put("grey32", new Color(82, 82, 82));
        this.colorTable.put("gray33", new Color(84, 84, 84));
        this.colorTable.put("grey33", new Color(84, 84, 84));
        this.colorTable.put("gray34", new Color(87, 87, 87));
        this.colorTable.put("grey34", new Color(87, 87, 87));
        this.colorTable.put("gray35", new Color(89, 89, 89));
        this.colorTable.put("grey35", new Color(89, 89, 89));
        this.colorTable.put("gray36", new Color(92, 92, 92));
        this.colorTable.put("grey36", new Color(92, 92, 92));
        this.colorTable.put("gray37", new Color(94, 94, 94));
        this.colorTable.put("grey37", new Color(94, 94, 94));
        this.colorTable.put("gray38", new Color(97, 97, 97));
        this.colorTable.put("grey38", new Color(97, 97, 97));
        this.colorTable.put("gray39", new Color(99, 99, 99));
        this.colorTable.put("grey39", new Color(99, 99, 99));
        this.colorTable.put("gray40", new Color(102, 102, 102));
        this.colorTable.put("grey40", new Color(102, 102, 102));
        this.colorTable.put("gray41", new Color(105, 105, 105));
        this.colorTable.put("grey41", new Color(105, 105, 105));
        this.colorTable.put("gray42", new Color(107, 107, 107));
        this.colorTable.put("grey42", new Color(107, 107, 107));
        this.colorTable.put("gray43", new Color(110, 110, 110));
        this.colorTable.put("grey43", new Color(110, 110, 110));
        this.colorTable.put("gray44", new Color(112, 112, 112));
        this.colorTable.put("grey44", new Color(112, 112, 112));
        this.colorTable.put("gray45", new Color(115, 115, 115));
        this.colorTable.put("grey45", new Color(115, 115, 115));
        this.colorTable.put("gray46", new Color(117, 117, 117));
        this.colorTable.put("grey46", new Color(117, 117, 117));
        this.colorTable.put("gray47", new Color(120, 120, 120));
        this.colorTable.put("grey47", new Color(120, 120, 120));
        this.colorTable.put("gray48", new Color(122, 122, 122));
        this.colorTable.put("grey48", new Color(122, 122, 122));
        this.colorTable.put("gray49", new Color(125, 125, 125));
        this.colorTable.put("grey49", new Color(125, 125, 125));
        this.colorTable.put("gray50", new Color(127, 127, 127));
        this.colorTable.put("grey50", new Color(127, 127, 127));
        this.colorTable.put("gray51", new Color(130, 130, 130));
        this.colorTable.put("grey51", new Color(130, 130, 130));
        this.colorTable.put("gray52", new Color(133, 133, 133));
        this.colorTable.put("grey52", new Color(133, 133, 133));
        this.colorTable.put("gray53", new Color(135, 135, 135));
        this.colorTable.put("grey53", new Color(135, 135, 135));
        this.colorTable.put("gray54", new Color(138, 138, 138));
        this.colorTable.put("grey54", new Color(138, 138, 138));
        this.colorTable.put("gray55", new Color(140, 140, 140));
        this.colorTable.put("grey55", new Color(140, 140, 140));
        this.colorTable.put("gray56", new Color(143, 143, 143));
        this.colorTable.put("grey56", new Color(143, 143, 143));
        this.colorTable.put("gray57", new Color(145, 145, 145));
        this.colorTable.put("grey57", new Color(145, 145, 145));
        this.colorTable.put("gray58", new Color(148, 148, 148));
        this.colorTable.put("grey58", new Color(148, 148, 148));
        this.colorTable.put("gray59", new Color(150, 150, 150));
        this.colorTable.put("grey59", new Color(150, 150, 150));
        this.colorTable.put("gray60", new Color(153, 153, 153));
        this.colorTable.put("grey60", new Color(153, 153, 153));
        this.colorTable.put("gray61", new Color(156, 156, 156));
        this.colorTable.put("grey61", new Color(156, 156, 156));
        this.colorTable.put("gray62", new Color(158, 158, 158));
        this.colorTable.put("grey62", new Color(158, 158, 158));
        this.colorTable.put("gray63", new Color(161, 161, 161));
        this.colorTable.put("grey63", new Color(161, 161, 161));
        this.colorTable.put("gray64", new Color(163, 163, 163));
        this.colorTable.put("grey64", new Color(163, 163, 163));
        this.colorTable.put("gray65", new Color(166, 166, 166));
        this.colorTable.put("grey65", new Color(166, 166, 166));
        this.colorTable.put("gray66", new Color(168, 168, 168));
        this.colorTable.put("grey66", new Color(168, 168, 168));
        this.colorTable.put("gray67", new Color(171, 171, 171));
        this.colorTable.put("grey67", new Color(171, 171, 171));
        this.colorTable.put("gray68", new Color(173, 173, 173));
        this.colorTable.put("grey68", new Color(173, 173, 173));
        this.colorTable.put("gray69", new Color(176, 176, 176));
        this.colorTable.put("grey69", new Color(176, 176, 176));
        this.colorTable.put("gray70", new Color(179, 179, 179));
        this.colorTable.put("grey70", new Color(179, 179, 179));
        this.colorTable.put("gray71", new Color(181, 181, 181));
        this.colorTable.put("grey71", new Color(181, 181, 181));
        this.colorTable.put("gray72", new Color(184, 184, 184));
        this.colorTable.put("grey72", new Color(184, 184, 184));
        this.colorTable.put("gray73", new Color(186, 186, 186));
        this.colorTable.put("grey73", new Color(186, 186, 186));
        this.colorTable.put("gray74", new Color(189, 189, 189));
        this.colorTable.put("grey74", new Color(189, 189, 189));
        this.colorTable.put("gray75", new Color(191, 191, 191));
        this.colorTable.put("grey75", new Color(191, 191, 191));
        this.colorTable.put("gray76", new Color(194, 194, 194));
        this.colorTable.put("grey76", new Color(194, 194, 194));
        this.colorTable.put("gray77", new Color(196, 196, 196));
        this.colorTable.put("grey77", new Color(196, 196, 196));
        this.colorTable.put("gray78", new Color(199, 199, 199));
        this.colorTable.put("grey78", new Color(199, 199, 199));
        this.colorTable.put("gray79", new Color(201, 201, 201));
        this.colorTable.put("grey79", new Color(201, 201, 201));
        this.colorTable.put("gray80", new Color(204, 204, 204));
        this.colorTable.put("grey80", new Color(204, 204, 204));
        this.colorTable.put("gray81", new Color(207, 207, 207));
        this.colorTable.put("grey81", new Color(207, 207, 207));
        this.colorTable.put("gray82", new Color(209, 209, 209));
        this.colorTable.put("grey82", new Color(209, 209, 209));
        this.colorTable.put("gray83", new Color(212, 212, 212));
        this.colorTable.put("grey83", new Color(212, 212, 212));
        this.colorTable.put("gray84", new Color(214, 214, 214));
        this.colorTable.put("grey84", new Color(214, 214, 214));
        this.colorTable.put("gray85", new Color(217, 217, 217));
        this.colorTable.put("grey85", new Color(217, 217, 217));
        this.colorTable.put("gray86", new Color(219, 219, 219));
        this.colorTable.put("grey86", new Color(219, 219, 219));
        this.colorTable.put("gray87", new Color(222, 222, 222));
        this.colorTable.put("grey87", new Color(222, 222, 222));
        this.colorTable.put("gray88", new Color(224, 224, 224));
        this.colorTable.put("grey88", new Color(224, 224, 224));
        this.colorTable.put("gray89", new Color(227, 227, 227));
        this.colorTable.put("grey89", new Color(227, 227, 227));
        this.colorTable.put("gray90", new Color(229, 229, 229));
        this.colorTable.put("grey90", new Color(229, 229, 229));
        this.colorTable.put("gray91", new Color(232, 232, 232));
        this.colorTable.put("grey91", new Color(232, 232, 232));
        this.colorTable.put("gray92", new Color(235, 235, 235));
        this.colorTable.put("grey92", new Color(235, 235, 235));
        this.colorTable.put("gray93", new Color(237, 237, 237));
        this.colorTable.put("grey93", new Color(237, 237, 237));
        this.colorTable.put("gray94", new Color(240, 240, 240));
        this.colorTable.put("grey94", new Color(240, 240, 240));
        this.colorTable.put("gray95", new Color(242, 242, 242));
        this.colorTable.put("grey95", new Color(242, 242, 242));
        this.colorTable.put("gray96", new Color(245, 245, 245));
        this.colorTable.put("grey96", new Color(245, 245, 245));
        this.colorTable.put("gray97", new Color(247, 247, 247));
        this.colorTable.put("grey97", new Color(247, 247, 247));
        this.colorTable.put("gray98", new Color(250, 250, 250));
        this.colorTable.put("grey98", new Color(250, 250, 250));
        this.colorTable.put("gray99", new Color(252, 252, 252));
        this.colorTable.put("grey99", new Color(252, 252, 252));
        this.colorTable.put("gray100", new Color(255, 255, 255));
        this.colorTable.put("grey100", new Color(255, 255, 255));
        this.colorTable.put("honeydew", new Color(240, 255, 240));
        this.colorTable.put("honeydew1", new Color(240, 255, 240));
        this.colorTable.put("honeydew2", new Color(224, 238, 224));
        this.colorTable.put("honeydew3", new Color(193, 205, 193));
        this.colorTable.put("honeydew4", new Color(131, 139, 131));
        this.colorTable.put("hotpink", new Color(255, 105, 180));
        this.colorTable.put("hotpink1", new Color(255, 110, 180));
        this.colorTable.put("hotpink2", new Color(238, 106, 167));
        this.colorTable.put("hotpink3", new Color(205, 96, 144));
        this.colorTable.put("hotpink4", new Color(139, 58, 98));
        this.colorTable.put("indianred", new Color(205, 92, 92));
        this.colorTable.put("indianred1", new Color(255, 106, 106));
        this.colorTable.put("indianred2", new Color(238, 99, 99));
        this.colorTable.put("indianred3", new Color(205, 85, 85));
        this.colorTable.put("indianred4", new Color(139, 58, 58));
        this.colorTable.put("indigo", new Color(75, 0, 130));
        this.colorTable.put("ivory", new Color(255, 255, 240));
        this.colorTable.put("ivory1", new Color(255, 255, 240));
        this.colorTable.put("ivory2", new Color(238, 238, 224));
        this.colorTable.put("ivory3", new Color(205, 205, 193));
        this.colorTable.put("ivory4", new Color(139, 139, 131));
        this.colorTable.put("khaki", new Color(240, 230, 140));
        this.colorTable.put("khaki1", new Color(255, 246, 143));
        this.colorTable.put("khaki2", new Color(238, 230, 133));
        this.colorTable.put("khaki3", new Color(205, 198, 115));
        this.colorTable.put("khaki4", new Color(139, 134, 78));
        this.colorTable.put("lavender", new Color(230, 230, 250));
        this.colorTable.put("lavenderblush", new Color(255, 240, 245));
        this.colorTable.put("lavenderblush1", new Color(255, 240, 245));
        this.colorTable.put("lavenderblush2", new Color(238, 224, 229));
        this.colorTable.put("lavenderblush3", new Color(205, 193, 197));
        this.colorTable.put("lavenderblush4", new Color(139, 131, 134));
        this.colorTable.put("lawngreen", new Color(124, 252, 0));
        this.colorTable.put("lemonchiffon", new Color(255, 250, 205));
        this.colorTable.put("lemonchiffon1", new Color(255, 250, 205));
        this.colorTable.put("lemonchiffon2", new Color(238, 233, 191));
        this.colorTable.put("lemonchiffon3", new Color(205, 201, 165));
        this.colorTable.put("lemonchiffon4", new Color(139, 137, 112));
        this.colorTable.put("lightblue", new Color(173, 216, 230));
        this.colorTable.put("lightblue1", new Color(191, 239, 255));
        this.colorTable.put("lightblue2", new Color(178, 223, 238));
        this.colorTable.put("lightblue3", new Color(154, 192, 205));
        this.colorTable.put("lightblue4", new Color(104, 131, 139));
        this.colorTable.put("lightcoral", new Color(240, 128, 128));
        this.colorTable.put("lightcyan", new Color(224, 255, 255));
        this.colorTable.put("lightcyan1", new Color(224, 255, 255));
        this.colorTable.put("lightcyan2", new Color(209, 238, 238));
        this.colorTable.put("lightcyan3", new Color(180, 205, 205));
        this.colorTable.put("lightcyan4", new Color(122, 139, 139));
        this.colorTable.put("lightgoldenrod", new Color(238, 221, 130));
        this.colorTable.put("lightgoldenrod1", new Color(255, 236, 139));
        this.colorTable.put("lightgoldenrod2", new Color(238, 220, 130));
        this.colorTable.put("lightgoldenrod3", new Color(205, 190, 112));
        this.colorTable.put("lightgoldenrod4", new Color(139, 129, 76));
        this.colorTable.put("lightgoldenrodyellow", new Color(250, 250, 210));
        this.colorTable.put("lightgray", new Color(211, 211, 211));
        this.colorTable.put("lightgreen", new Color(144, 238, 144));
        this.colorTable.put("lightgrey", new Color(211, 211, 211));
        this.colorTable.put("lightpink", new Color(255, 182, 193));
        this.colorTable.put("lightpink1", new Color(255, 174, 185));
        this.colorTable.put("lightpink2", new Color(238, 162, 173));
        this.colorTable.put("lightpink3", new Color(205, 140, 149));
        this.colorTable.put("lightpink4", new Color(139, 95, 101));
        this.colorTable.put("lightsalmon", new Color(255, 160, 122));
        this.colorTable.put("lightsalmon1", new Color(255, 160, 122));
        this.colorTable.put("lightsalmon2", new Color(238, 149, 114));
        this.colorTable.put("lightsalmon3", new Color(205, 129, 98));
        this.colorTable.put("lightsalmon4", new Color(139, 87, 66));
        this.colorTable.put("lightseagreen", new Color(32, 178, 170));
        this.colorTable.put("lightskyblue", new Color(135, 206, 250));
        this.colorTable.put("lightskyblue1", new Color(176, 226, 255));
        this.colorTable.put("lightskyblue2", new Color(164, 211, 238));
        this.colorTable.put("lightskyblue3", new Color(141, 182, 205));
        this.colorTable.put("lightskyblue4", new Color(96, 123, 139));
        this.colorTable.put("lightslateblue", new Color(132, 112, 255));
        this.colorTable.put("lightslategray", new Color(119, 136, 153));
        this.colorTable.put("lightslategrey", new Color(119, 136, 153));
        this.colorTable.put("lightsteelblue", new Color(176, 196, 222));
        this.colorTable.put("lightsteelblue1", new Color(202, 225, 255));
        this.colorTable.put("lightsteelblue2", new Color(188, 210, 238));
        this.colorTable.put("lightsteelblue3", new Color(162, 181, 205));
        this.colorTable.put("lightsteelblue4", new Color(110, 123, 139));
        this.colorTable.put("lightyellow", new Color(255, 255, 224));
        this.colorTable.put("lightyellow1", new Color(255, 255, 224));
        this.colorTable.put("lightyellow2", new Color(238, 238, 209));
        this.colorTable.put("lightyellow3", new Color(205, 205, 180));
        this.colorTable.put("lightyellow4", new Color(139, 139, 122));
        this.colorTable.put("limegreen", new Color(50, 205, 50));
        this.colorTable.put("linen", new Color(250, 240, 230));
        this.colorTable.put("magenta", new Color(255, 0, 255));
        this.colorTable.put("magenta1", new Color(255, 0, 255));
        this.colorTable.put("magenta2", new Color(238, 0, 238));
        this.colorTable.put("magenta3", new Color(205, 0, 205));
        this.colorTable.put("magenta4", new Color(139, 0, 139));
        this.colorTable.put("maroon", new Color(176, 48, 96));
        this.colorTable.put("maroon1", new Color(255, 52, 179));
        this.colorTable.put("maroon2", new Color(238, 48, 167));
        this.colorTable.put("maroon3", new Color(205, 41, 144));
        this.colorTable.put("maroon4", new Color(139, 28, 98));
        this.colorTable.put("mediumaquamarine", new Color(102, 205, 170));
        this.colorTable.put("mediumblue", new Color(0, 0, 205));
        this.colorTable.put("mediumorchid", new Color(186, 85, 211));
        this.colorTable.put("mediumorchid1", new Color(224, 102, 255));
        this.colorTable.put("mediumorchid2", new Color(209, 95, 238));
        this.colorTable.put("mediumorchid3", new Color(180, 82, 205));
        this.colorTable.put("mediumorchid4", new Color(122, 55, 139));
        this.colorTable.put("mediumpurple", new Color(147, 112, 219));
        this.colorTable.put("mediumpurple1", new Color(171, 130, 255));
        this.colorTable.put("mediumpurple2", new Color(159, 121, 238));
        this.colorTable.put("mediumpurple3", new Color(137, 104, 205));
        this.colorTable.put("mediumpurple4", new Color(93, 71, 139));
        this.colorTable.put("mediumseagreen", new Color(60, 179, 113));
        this.colorTable.put("mediumslateblue", new Color(123, 104, 238));
        this.colorTable.put("mediumspringgreen", new Color(0, 250, 154));
        this.colorTable.put("mediumturquoise", new Color(72, 209, 204));
        this.colorTable.put("mediumvioletred", new Color(199, 21, 133));
        this.colorTable.put("midnightblue", new Color(25, 25, 112));
        this.colorTable.put("mintcream", new Color(245, 255, 250));
        this.colorTable.put("mistyrose", new Color(255, 228, 225));
        this.colorTable.put("mistyrose1", new Color(255, 228, 225));
        this.colorTable.put("mistyrose2", new Color(238, 213, 210));
        this.colorTable.put("mistyrose3", new Color(205, 183, 181));
        this.colorTable.put("mistyrose4", new Color(139, 125, 123));
        this.colorTable.put("moccasin", new Color(255, 228, 181));
        this.colorTable.put("navajowhite", new Color(255, 222, 173));
        this.colorTable.put("navajowhite1", new Color(255, 222, 173));
        this.colorTable.put("navajowhite2", new Color(238, 207, 161));
        this.colorTable.put("navajowhite3", new Color(205, 179, 139));
        this.colorTable.put("navajowhite4", new Color(139, 121, 94));
        this.colorTable.put("navy", new Color(0, 0, 128));
        this.colorTable.put("navyblue", new Color(0, 0, 128));
        this.colorTable.put("oldlace", new Color(253, 245, 230));
        this.colorTable.put("olivedrab", new Color(107, 142, 35));
        this.colorTable.put("olivedrab1", new Color(192, 255, 62));
        this.colorTable.put("olivedrab2", new Color(179, 238, 58));
        this.colorTable.put("olivedrab3", new Color(154, 205, 50));
        this.colorTable.put("olivedrab4", new Color(105, 139, 34));
        this.colorTable.put("orange", new Color(255, 165, 0));
        this.colorTable.put("orange1", new Color(255, 165, 0));
        this.colorTable.put("orange2", new Color(238, 154, 0));
        this.colorTable.put("orange3", new Color(205, 133, 0));
        this.colorTable.put("orange4", new Color(139, 90, 0));
        this.colorTable.put("orangered", new Color(255, 69, 0));
        this.colorTable.put("orangered1", new Color(255, 69, 0));
        this.colorTable.put("orangered2", new Color(238, 64, 0));
        this.colorTable.put("orangered3", new Color(205, 55, 0));
        this.colorTable.put("orangered4", new Color(139, 37, 0));
        this.colorTable.put("orchid", new Color(218, 112, 214));
        this.colorTable.put("orchid1", new Color(255, 131, 250));
        this.colorTable.put("orchid2", new Color(238, 122, 233));
        this.colorTable.put("orchid3", new Color(205, 105, 201));
        this.colorTable.put("orchid4", new Color(139, 71, 137));
        this.colorTable.put("palegoldenrod", new Color(238, 232, 170));
        this.colorTable.put("palegreen", new Color(152, 251, 152));
        this.colorTable.put("palegreen1", new Color(154, 255, 154));
        this.colorTable.put("palegreen2", new Color(144, 238, 144));
        this.colorTable.put("palegreen3", new Color(124, 205, 124));
        this.colorTable.put("palegreen4", new Color(84, 139, 84));
        this.colorTable.put("paleturquoise", new Color(175, 238, 238));
        this.colorTable.put("paleturquoise1", new Color(187, 255, 255));
        this.colorTable.put("paleturquoise2", new Color(174, 238, 238));
        this.colorTable.put("paleturquoise3", new Color(150, 205, 205));
        this.colorTable.put("paleturquoise4", new Color(102, 139, 139));
        this.colorTable.put("palevioletred", new Color(219, 112, 147));
        this.colorTable.put("palevioletred1", new Color(255, 130, 171));
        this.colorTable.put("palevioletred2", new Color(238, 121, 159));
        this.colorTable.put("palevioletred3", new Color(205, 104, 137));
        this.colorTable.put("palevioletred4", new Color(139, 71, 93));
        this.colorTable.put("papayawhip", new Color(255, 239, 213));
        this.colorTable.put("peachpuff", new Color(255, 218, 185));
        this.colorTable.put("peachpuff1", new Color(255, 218, 185));
        this.colorTable.put("peachpuff2", new Color(238, 203, 173));
        this.colorTable.put("peachpuff3", new Color(205, 175, 149));
        this.colorTable.put("peachpuff4", new Color(139, 119, 101));
        this.colorTable.put("peru", new Color(205, 133, 63));
        this.colorTable.put("pink", new Color(255, 192, 203));
        this.colorTable.put("pink1", new Color(255, 181, 197));
        this.colorTable.put("pink2", new Color(238, 169, 184));
        this.colorTable.put("pink3", new Color(205, 145, 158));
        this.colorTable.put("pink4", new Color(139, 99, 108));
        this.colorTable.put("plum", new Color(221, 160, 221));
        this.colorTable.put("plum1", new Color(255, 187, 255));
        this.colorTable.put("plum2", new Color(238, 174, 238));
        this.colorTable.put("plum3", new Color(205, 150, 205));
        this.colorTable.put("plum4", new Color(139, 102, 139));
        this.colorTable.put("powderblue", new Color(176, 224, 230));
        this.colorTable.put("purple", new Color(160, 32, 240));
        this.colorTable.put("purple1", new Color(155, 48, 255));
        this.colorTable.put("purple2", new Color(145, 44, 238));
        this.colorTable.put("purple3", new Color(125, 38, 205));
        this.colorTable.put("purple4", new Color(85, 26, 139));
        this.colorTable.put("red", new Color(255, 0, 0));
        this.colorTable.put("red1", new Color(255, 0, 0));
        this.colorTable.put("red2", new Color(238, 0, 0));
        this.colorTable.put("red3", new Color(205, 0, 0));
        this.colorTable.put("red4", new Color(139, 0, 0));
        this.colorTable.put("rosybrown", new Color(188, 143, 143));
        this.colorTable.put("rosybrown1", new Color(255, 193, 193));
        this.colorTable.put("rosybrown2", new Color(238, 180, 180));
        this.colorTable.put("rosybrown3", new Color(205, 155, 155));
        this.colorTable.put("rosybrown4", new Color(139, 105, 105));
        this.colorTable.put("royalblue", new Color(65, 105, 225));
        this.colorTable.put("royalblue1", new Color(72, 118, 255));
        this.colorTable.put("royalblue2", new Color(67, 110, 238));
        this.colorTable.put("royalblue3", new Color(58, 95, 205));
        this.colorTable.put("royalblue4", new Color(39, 64, 139));
        this.colorTable.put("saddlebrown", new Color(139, 69, 19));
        this.colorTable.put("salmon", new Color(250, 128, 114));
        this.colorTable.put("salmon1", new Color(255, 140, 105));
        this.colorTable.put("salmon2", new Color(238, 130, 98));
        this.colorTable.put("salmon3", new Color(205, 112, 84));
        this.colorTable.put("salmon4", new Color(139, 76, 57));
        this.colorTable.put("sandybrown", new Color(244, 164, 96));
        this.colorTable.put("seagreen", new Color(46, 139, 87));
        this.colorTable.put("seagreen1", new Color(84, 255, 159));
        this.colorTable.put("seagreen2", new Color(78, 238, 148));
        this.colorTable.put("seagreen3", new Color(67, 205, 128));
        this.colorTable.put("seagreen4", new Color(46, 139, 87));
        this.colorTable.put("seashell", new Color(255, 245, 238));
        this.colorTable.put("seashell1", new Color(255, 245, 238));
        this.colorTable.put("seashell2", new Color(238, 229, 222));
        this.colorTable.put("seashell3", new Color(205, 197, 191));
        this.colorTable.put("seashell4", new Color(139, 134, 130));
        this.colorTable.put("sgiindigo2", new Color(33, 136, 104));
        this.colorTable.put("sienna", new Color(160, 82, 45));
        this.colorTable.put("sienna1", new Color(255, 130, 71));
        this.colorTable.put("sienna2", new Color(238, 121, 66));
        this.colorTable.put("sienna3", new Color(205, 104, 57));
        this.colorTable.put("sienna4", new Color(139, 71, 38));
        this.colorTable.put("skyblue", new Color(135, 206, 235));
        this.colorTable.put("skyblue1", new Color(135, 206, 255));
        this.colorTable.put("skyblue2", new Color(126, 192, 238));
        this.colorTable.put("skyblue3", new Color(108, 166, 205));
        this.colorTable.put("skyblue4", new Color(74, 112, 139));
        this.colorTable.put("slateblue", new Color(106, 90, 205));
        this.colorTable.put("slateblue1", new Color(131, 111, 255));
        this.colorTable.put("slateblue2", new Color(122, 103, 238));
        this.colorTable.put("slateblue3", new Color(105, 89, 205));
        this.colorTable.put("slateblue4", new Color(71, 60, 139));
        this.colorTable.put("slategray", new Color(112, 128, 144));
        this.colorTable.put("slategray1", new Color(198, 226, 255));
        this.colorTable.put("slategray2", new Color(185, 211, 238));
        this.colorTable.put("slategray3", new Color(159, 182, 205));
        this.colorTable.put("slategray4", new Color(108, 123, 139));
        this.colorTable.put("slategrey", new Color(112, 128, 144));
        this.colorTable.put("snow", new Color(255, 250, 250));
        this.colorTable.put("snow1", new Color(255, 250, 250));
        this.colorTable.put("snow2", new Color(238, 233, 233));
        this.colorTable.put("snow3", new Color(205, 201, 201));
        this.colorTable.put("snow4", new Color(139, 137, 137));
        this.colorTable.put("springgreen", new Color(0, 255, 127));
        this.colorTable.put("springgreen1", new Color(0, 255, 127));
        this.colorTable.put("springgreen2", new Color(0, 238, 118));
        this.colorTable.put("springgreen3", new Color(0, 205, 102));
        this.colorTable.put("springgreen4", new Color(0, 139, 69));
        this.colorTable.put("steelblue", new Color(70, 130, 180));
        this.colorTable.put("steelblue1", new Color(99, 184, 255));
        this.colorTable.put("steelblue2", new Color(92, 172, 238));
        this.colorTable.put("steelblue3", new Color(79, 148, 205));
        this.colorTable.put("steelblue4", new Color(54, 100, 139));
        this.colorTable.put("tan", new Color(210, 180, 140));
        this.colorTable.put("tan1", new Color(255, 165, 79));
        this.colorTable.put("tan2", new Color(238, 154, 73));
        this.colorTable.put("tan3", new Color(205, 133, 63));
        this.colorTable.put("tan4", new Color(139, 90, 43));
        this.colorTable.put("thistle", new Color(216, 191, 216));
        this.colorTable.put("thistle1", new Color(255, 225, 255));
        this.colorTable.put("thistle2", new Color(238, 210, 238));
        this.colorTable.put("thistle3", new Color(205, 181, 205));
        this.colorTable.put("thistle4", new Color(139, 123, 139));
        this.colorTable.put("tomato", new Color(255, 99, 71));
        this.colorTable.put("tomato1", new Color(255, 99, 71));
        this.colorTable.put("tomato2", new Color(238, 92, 66));
        this.colorTable.put("tomato3", new Color(205, 79, 57));
        this.colorTable.put("tomato4", new Color(139, 54, 38));
        this.colorTable.put("turquoise", new Color(64, 224, 208));
        this.colorTable.put("turquoise1", new Color(0, 245, 255));
        this.colorTable.put("turquoise2", new Color(0, 229, 238));
        this.colorTable.put("turquoise3", new Color(0, 197, 205));
        this.colorTable.put("turquoise4", new Color(0, 134, 139));
        this.colorTable.put("violet", new Color(238, 130, 238));
        this.colorTable.put("violetred", new Color(208, 32, 144));
        this.colorTable.put("violetred1", new Color(255, 62, 150));
        this.colorTable.put("violetred2", new Color(238, 58, 140));
        this.colorTable.put("violetred3", new Color(205, 50, 120));
        this.colorTable.put("violetred4", new Color(139, 34, 82));
        this.colorTable.put("wheat", new Color(245, 222, 179));
        this.colorTable.put("wheat1", new Color(255, 231, 186));
        this.colorTable.put("wheat2", new Color(238, 216, 174));
        this.colorTable.put("wheat3", new Color(205, 186, 150));
        this.colorTable.put("wheat4", new Color(139, 126, 102));
        this.colorTable.put("white", new Color(255, 255, 255));
        this.colorTable.put("whitesmoke", new Color(245, 245, 245));
        this.colorTable.put("yellow", new Color(255, 255, 0));
        this.colorTable.put("yellow1", new Color(255, 255, 0));
        this.colorTable.put("yellow2", new Color(238, 238, 0));
        this.colorTable.put("yellow3", new Color(205, 205, 0));
        this.colorTable.put("yellow4", new Color(139, 139, 0));
        this.colorTable.put("yellowgreen", new Color(154, 205, 50));
    }
}

