/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.awt.Color;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterGEXF
implements FileImporter,
LongTask {
    private static final String GEXF = "gexf";
    private static final String GEXF_VERSION = "version";
    private static final String GRAPH = "graph";
    private static final String GRAPH_DEFAULT_EDGETYPE = "defaultedgetype";
    private static final String GRAPH_TIMEFORMAT = "timeformat";
    private static final String GRAPH_TIMEFORMAT2 = "timetype";
    private static final String START = "start";
    private static final String END = "end";
    private static final String START_OPEN = "startopen";
    private static final String END_OPEN = "endopen";
    private static final String NODE = "node";
    private static final String NODE_ID = "id";
    private static final String NODE_LABEL = "label";
    private static final String NODE_PID = "pid";
    private static final String NODE_POSITION = "position";
    private static final String NODE_COLOR = "color";
    private static final String NODE_SIZE = "size";
    private static final String NODE_SLICE = "slice";
    private static final String EDGE = "edge";
    private static final String EDGE_ID = "id";
    private static final String EDGE_SOURCE = "source";
    private static final String EDGE_TARGET = "target";
    private static final String EDGE_LABEL = "label";
    private static final String EDGE_TYPE = "type";
    private static final String EDGE_WEIGHT = "weight";
    private static final String EDGE_COLOR = "color";
    private static final String EDGE_SLICE = "slice";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTES_CLASS = "class";
    private static final String ATTRIBUTES_TYPE = "type";
    private static final String ATTRIBUTES_TYPE2 = "mode";
    private static final String ATTVALUE = "attvalue";
    private static final String ATTVALUE_FOR = "for";
    private static final String ATTVALUE_FOR2 = "id";
    private static final String ATTVALUE_VALUE = "value";
    private static final String ATTVALUE_START = "start";
    private static final String ATTVALUE_END = "end";
    private Reader reader;
    private ContainerLoader container;
    private boolean cancel;
    private Report report;
    private ProgressTicket progress;
    private XMLStreamReader xmlReader;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        Progress.start(this.progress);
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            inputFactory.setXMLReporter(new XMLReporter(){

                public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                    System.out.println("Error:" + errorType + ", message : " + message);
                }
            });
            this.xmlReader = inputFactory.createXMLStreamReader(this.reader);
            while (this.xmlReader.hasNext()) {
                String name;
                Integer eventType = this.xmlReader.next();
                if (eventType.equals(1)) {
                    name = this.xmlReader.getLocalName();
                    if (GEXF.equalsIgnoreCase(name)) {
                        this.readGexf(this.xmlReader);
                        continue;
                    }
                    if (GRAPH.equalsIgnoreCase(name)) {
                        this.readGraph(this.xmlReader);
                        continue;
                    }
                    if (NODE.equalsIgnoreCase(name)) {
                        this.readNode(this.xmlReader, null);
                        continue;
                    }
                    if (EDGE.equalsIgnoreCase(name)) {
                        this.readEdge(this.xmlReader);
                        continue;
                    }
                    if (!ATTRIBUTES.equalsIgnoreCase(name)) continue;
                    this.readAttributes(this.xmlReader);
                    continue;
                }
                if (eventType.equals(2) && !NODE.equalsIgnoreCase(name = this.xmlReader.getLocalName())) continue;
            }
            this.xmlReader.close();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        Progress.finish(this.progress);
        return !this.cancel;
    }

    private void readGexf(XMLStreamReader reader) throws Exception {
        String version = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (!GEXF_VERSION.equalsIgnoreCase(attName)) continue;
            version = reader.getAttributeValue(i);
        }
        if (!version.isEmpty() && version.equals("1.0")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version10"), Issue.Level.INFO));
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version11"), Issue.Level.INFO));
        }
    }

    private void readGraph(XMLStreamReader reader) throws Exception {
        String defaultEdgeType = "";
        String start = "";
        String end = "";
        String timeFormat = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (GRAPH_DEFAULT_EDGETYPE.equalsIgnoreCase(attName)) {
                defaultEdgeType = reader.getAttributeValue(i);
                continue;
            }
            if ("start".equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                continue;
            }
            if ("end".equalsIgnoreCase(attName)) {
                end = reader.getAttributeValue(i);
                continue;
            }
            if (!GRAPH_TIMEFORMAT.equalsIgnoreCase(attName) && !GRAPH_TIMEFORMAT2.equalsIgnoreCase(attName)) continue;
            timeFormat = reader.getAttributeValue(i);
        }
        if (!defaultEdgeType.isEmpty()) {
            if (defaultEdgeType.equalsIgnoreCase("undirected")) {
                this.container.setEdgeDefault(EdgeDefault.UNDIRECTED);
            } else if (defaultEdgeType.equalsIgnoreCase("directed")) {
                this.container.setEdgeDefault(EdgeDefault.DIRECTED);
            } else if (defaultEdgeType.equalsIgnoreCase("mutual")) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgedouble"), Issue.Level.WARNING));
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_defaultedgetype", (Object)defaultEdgeType), Issue.Level.SEVERE));
            }
        }
        if (!timeFormat.isEmpty()) {
            if ("double".equalsIgnoreCase(timeFormat) || "float".equalsIgnoreCase(timeFormat)) {
                this.container.setTimeFormat(DynamicModel.TimeFormat.DOUBLE);
            } else if ("date".equalsIgnoreCase(timeFormat)) {
                this.container.setTimeFormat(DynamicModel.TimeFormat.DATE);
            }
        }
        if (!start.isEmpty()) {
            this.container.setTimeIntervalMin(start);
        }
        if (!end.isEmpty()) {
            this.container.setTimeIntervalMax(end);
        }
    }

    private void readNode(XMLStreamReader reader, NodeDraft parent) throws Exception {
        String id = "";
        String label = "";
        String startDate = "";
        String endDate = "";
        String pid = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if ("label".equalsIgnoreCase(attName)) {
                label = reader.getAttributeValue(i);
                continue;
            }
            if ("start".equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if ("end".equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                continue;
            }
            if (END_OPEN.equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                endOpen = true;
                continue;
            }
            if (!NODE_PID.equalsIgnoreCase(attName)) continue;
            pid = reader.getAttributeValue(i);
        }
        if (id.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeid"), Issue.Level.SEVERE));
            return;
        }
        NodeDraft node = null;
        node = this.container.nodeExists(id) ? this.container.getNode(id) : this.container.factory().newNodeDraft();
        node.setId(id);
        node.setLabel(label);
        if (parent != null) {
            node.setParent(parent);
        } else if (!pid.isEmpty()) {
            NodeDraft parentNode = this.container.getNode(pid);
            if (parentNode == null) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_pid_notfound", (Object)pid, (Object)id), Issue.Level.SEVERE));
            } else {
                node.setParent(parentNode);
            }
        }
        if (!this.container.nodeExists(id)) {
            this.container.addNode(node);
        }
        boolean end = false;
        boolean slices = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = this.xmlReader.getLocalName();
                    if (ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readNodeAttValue(reader, node);
                        break;
                    }
                    if (NODE_POSITION.equalsIgnoreCase(name)) {
                        this.readNodePosition(reader, node);
                        break;
                    }
                    if ("color".equalsIgnoreCase(name)) {
                        this.readNodeColor(reader, node);
                        break;
                    }
                    if (NODE_SIZE.equalsIgnoreCase(name)) {
                        this.readNodeSize(reader, node);
                        break;
                    }
                    if ("slice".equalsIgnoreCase(name)) {
                        this.readNodeSlice(reader, node);
                        slices = true;
                        break;
                    }
                    if (!NODE.equalsIgnoreCase(name)) break;
                    this.readNode(reader, node);
                    break;
                }
                case 2: {
                    if (!NODE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!(slices || startDate.isEmpty() && endDate.isEmpty())) {
            try {
                node.addTimeInterval(startDate, endDate, startOpen, endOpen);
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_timeinterval_parseerror", (Object)id), Issue.Level.SEVERE));
            }
        }
    }

    private void readNodeAttValue(XMLStreamReader reader, NodeDraft node) {
        AttributeColumn column;
        String fore = "";
        String value = "";
        String startDate = "";
        String endDate = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (ATTVALUE_FOR.equalsIgnoreCase(attName) || "id".equalsIgnoreCase(attName)) {
                fore = reader.getAttributeValue(i);
                continue;
            }
            if (ATTVALUE_VALUE.equalsIgnoreCase(attName)) {
                value = reader.getAttributeValue(i);
                continue;
            }
            if ("start".equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                continue;
            }
            if (!"end".equalsIgnoreCase(attName)) continue;
            endDate = reader.getAttributeValue(i);
        }
        if (fore.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datakey", (Object)node), Issue.Level.SEVERE));
            return;
        }
        if (!value.isEmpty() && (column = this.container.getAttributeModel().getNodeTable().getColumn(fore)) != null) {
            if (!startDate.isEmpty() || !endDate.isEmpty()) {
                try {
                    node.addAttributeValue(column, value, startDate, endDate);
                }
                catch (IllegalArgumentException e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeattribute_timeinterval_parseerror", (Object)node), Issue.Level.SEVERE));
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datavalue", (Object)fore, (Object)node, (Object)column.getTitle()), Issue.Level.SEVERE));
                }
            } else if (column.getType().isDynamicType()) {
                node.addAttributeValue(column, value);
            } else {
                try {
                    Object val = column.getType().parse(value);
                    node.addAttributeValue(column, val);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datavalue", (Object)fore, (Object)node, (Object)column.getTitle()), Issue.Level.SEVERE));
                }
            }
        }
    }

    private void readNodeColor(XMLStreamReader reader, NodeDraft node) throws Exception {
        String rStr = "";
        String gStr = "";
        String bStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("r".equalsIgnoreCase(attName)) {
                rStr = reader.getAttributeValue(i);
                continue;
            }
            if ("g".equalsIgnoreCase(attName)) {
                gStr = reader.getAttributeValue(i);
                continue;
            }
            if (!"b".equalsIgnoreCase(attName)) continue;
            bStr = reader.getAttributeValue(i);
        }
        int r = rStr.isEmpty() ? 0 : Integer.parseInt(rStr);
        int g = gStr.isEmpty() ? 0 : Integer.parseInt(gStr);
        int b = bStr.isEmpty() ? 0 : Integer.parseInt(bStr);
        node.setColor(new Color(r, g, b));
    }

    private void readNodePosition(XMLStreamReader reader, NodeDraft node) throws Exception {
        String xStr = "";
        String yStr = "";
        String zStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("x".equalsIgnoreCase(attName)) {
                xStr = reader.getAttributeValue(i);
                continue;
            }
            if ("y".equalsIgnoreCase(attName)) {
                yStr = reader.getAttributeValue(i);
                continue;
            }
            if (!"z".equalsIgnoreCase(attName)) continue;
            zStr = reader.getAttributeValue(i);
        }
        if (!xStr.isEmpty()) {
            try {
                float x = Float.parseFloat(xStr);
                node.setX(x);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeposition", (Object)node, (Object)"X"), Issue.Level.WARNING));
            }
        }
        if (!yStr.isEmpty()) {
            try {
                float y = Float.parseFloat(yStr);
                node.setY(y);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeposition", (Object)node, (Object)"Y"), Issue.Level.WARNING));
            }
        }
        if (!zStr.isEmpty()) {
            try {
                float z = Float.parseFloat(zStr);
                node.setZ(z);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeposition", (Object)node, (Object)"Z"), Issue.Level.WARNING));
            }
        }
    }

    private void readNodeSize(XMLStreamReader reader, NodeDraft node) throws Exception {
        String sizeStr;
        String attName = reader.getAttributeName(0).getLocalPart();
        if (ATTVALUE_VALUE.equalsIgnoreCase(attName) && !(sizeStr = reader.getAttributeValue(0)).isEmpty()) {
            try {
                float size = Float.parseFloat(sizeStr);
                node.setSize(size);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodesize", (Object)node), Issue.Level.WARNING));
            }
        }
    }

    private void readNodeSlice(XMLStreamReader reader, NodeDraft node) throws Exception {
        String start = "";
        String end = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("start".equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                continue;
            }
            if ("end".equalsIgnoreCase(attName)) {
                end = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if (!END_OPEN.equalsIgnoreCase(attName)) continue;
            end = reader.getAttributeValue(i);
            endOpen = true;
        }
        if (!start.isEmpty() || !end.isEmpty()) {
            try {
                node.addTimeInterval(start, end, startOpen, endOpen);
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_timeinterval_parseerror", (Object)node), Issue.Level.SEVERE));
            }
        }
    }

    private void readEdge(XMLStreamReader reader) throws Exception {
        String id = "";
        String label = "";
        String source = "";
        String target = "";
        String weight = "";
        String edgeType = "";
        String startDate = "";
        String endDate = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (EDGE_SOURCE.equalsIgnoreCase(attName)) {
                source = reader.getAttributeValue(i);
                continue;
            }
            if (EDGE_TARGET.equalsIgnoreCase(attName)) {
                target = reader.getAttributeValue(i);
                continue;
            }
            if (EDGE_WEIGHT.equalsIgnoreCase(attName)) {
                weight = reader.getAttributeValue(i);
                continue;
            }
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if ("type".equalsIgnoreCase(attName)) {
                edgeType = reader.getAttributeValue(i);
                continue;
            }
            if ("label".equalsIgnoreCase(attName)) {
                label = reader.getAttributeValue(i);
                continue;
            }
            if ("start".equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                continue;
            }
            if ("end".equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if (!END_OPEN.equalsIgnoreCase(attName)) continue;
            endDate = reader.getAttributeValue(i);
            endOpen = true;
        }
        EdgeDraft edge = this.container.factory().newEdgeDraft();
        NodeDraft nodeSource = this.container.getNode(source);
        NodeDraft nodeTarget = this.container.getNode(target);
        edge.setSource(nodeSource);
        edge.setTarget(nodeTarget);
        if (!edgeType.isEmpty()) {
            if (edgeType.equalsIgnoreCase("undirected")) {
                edge.setType(EdgeDraft.EdgeType.UNDIRECTED);
            } else if (edgeType.equalsIgnoreCase("directed")) {
                edge.setType(EdgeDraft.EdgeType.DIRECTED);
            } else if (edgeType.equalsIgnoreCase("mutual")) {
                edge.setType(EdgeDraft.EdgeType.MUTUAL);
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgetype", (Object)edgeType, (Object)edge), Issue.Level.SEVERE));
            }
        }
        if (!id.isEmpty()) {
            edge.setId(id);
        }
        if (!weight.isEmpty()) {
            try {
                float weightNumber = Float.parseFloat(weight);
                edge.setWeight(weightNumber);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgeweight", (Object)edge), Issue.Level.WARNING));
            }
        }
        if (!label.isEmpty()) {
            edge.setLabel(label);
        }
        this.container.addEdge(edge);
        boolean end = false;
        boolean slices = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readEdgeAttValue(reader, edge);
                        break;
                    }
                    if ("color".equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readEdgeColor(reader, edge);
                        break;
                    }
                    if (!"slice".equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    this.readEdgeSlice(reader, edge);
                    slices = true;
                    break;
                }
                case 2: {
                    if (!EDGE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!(slices || startDate.isEmpty() && endDate.isEmpty())) {
            try {
                edge.addTimeInterval(startDate, endDate, startOpen, endOpen);
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_timeinterval_parseerror", (Object)edge), Issue.Level.SEVERE));
            }
        }
    }

    private void readEdgeAttValue(XMLStreamReader reader, EdgeDraft edge) {
        AttributeColumn column;
        String fore = "";
        String value = "";
        String startDate = "";
        String endDate = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (ATTVALUE_FOR.equalsIgnoreCase(attName) || "id".equalsIgnoreCase(attName)) {
                fore = reader.getAttributeValue(i);
                continue;
            }
            if (ATTVALUE_VALUE.equalsIgnoreCase(attName)) {
                value = reader.getAttributeValue(i);
                continue;
            }
            if ("start".equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                continue;
            }
            if (!"end".equalsIgnoreCase(attName)) continue;
            endDate = reader.getAttributeValue(i);
        }
        if (fore.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datakey", (Object)edge), Issue.Level.SEVERE));
            return;
        }
        if (!value.isEmpty() && (column = this.container.getAttributeModel().getEdgeTable().getColumn(fore)) != null) {
            if (!startDate.isEmpty() || !endDate.isEmpty()) {
                try {
                    edge.addAttributeValue(column, value, startDate, endDate);
                }
                catch (IllegalArgumentException e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgeattribute_timeinterval_parseerror", (Object)edge), Issue.Level.SEVERE));
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datavalue", (Object)fore, (Object)edge, (Object)column.getTitle()), Issue.Level.SEVERE));
                }
            } else if (column.getType().isDynamicType()) {
                edge.addAttributeValue(column, value);
            } else {
                try {
                    Object val = column.getType().parse(value);
                    edge.addAttributeValue(column, val);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datavalue", (Object)fore, (Object)edge, (Object)column.getTitle()), Issue.Level.SEVERE));
                }
            }
        }
    }

    private void readEdgeColor(XMLStreamReader reader, EdgeDraft edge) throws Exception {
        String rStr = "";
        String gStr = "";
        String bStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("r".equalsIgnoreCase(attName)) {
                rStr = reader.getAttributeValue(i);
                continue;
            }
            if ("g".equalsIgnoreCase(attName)) {
                gStr = reader.getAttributeValue(i);
                continue;
            }
            if (!"b".equalsIgnoreCase(attName)) continue;
            bStr = reader.getAttributeValue(i);
        }
        int r = rStr.isEmpty() ? 0 : Integer.parseInt(rStr);
        int g = gStr.isEmpty() ? 0 : Integer.parseInt(gStr);
        int b = bStr.isEmpty() ? 0 : Integer.parseInt(bStr);
        edge.setColor(new Color(r, g, b));
    }

    private void readEdgeSlice(XMLStreamReader reader, EdgeDraft edge) throws Exception {
        String start = "";
        String end = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("start".equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                continue;
            }
            if ("end".equalsIgnoreCase(attName)) {
                end = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if (!END_OPEN.equalsIgnoreCase(attName)) continue;
            end = reader.getAttributeValue(i);
            endOpen = true;
        }
        if (!start.isEmpty() || !end.isEmpty()) {
            try {
                edge.addTimeInterval(start, end, startOpen, endOpen);
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_timeinterval_parseerror", (Object)edge), Issue.Level.SEVERE));
            }
        }
    }

    private void readAttributes(XMLStreamReader reader) throws Exception {
        String classAtt = "";
        String typeAtt = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (ATTRIBUTES_CLASS.equalsIgnoreCase(attName)) {
                classAtt = reader.getAttributeValue(i);
                continue;
            }
            if (!"type".equalsIgnoreCase(attName) && !ATTRIBUTES_TYPE2.equalsIgnoreCase(attName)) continue;
            typeAtt = reader.getAttributeValue(i);
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (!ATTRIBUTE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    this.readAttribute(reader, classAtt, typeAtt);
                    break;
                }
                case 2: {
                    if (!ATTRIBUTES.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    private void readAttribute(XMLStreamReader reader, String classAtt, String typeAtt) throws Exception {
        String id = "";
        String type = "";
        String title = "";
        String defaultStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if ("type".equalsIgnoreCase(attName)) {
                type = reader.getAttributeValue(i);
                continue;
            }
            if (!ATTRIBUTE_TITLE.equalsIgnoreCase(attName)) continue;
            title = reader.getAttributeValue(i);
        }
        if (title.isEmpty()) {
            title = id;
        }
        if (!id.isEmpty() && !type.isEmpty()) {
            if (classAtt.isEmpty() || !classAtt.equalsIgnoreCase(NODE) && !classAtt.equalsIgnoreCase(EDGE)) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributeclass", (Object)title), Issue.Level.SEVERE));
            }
            boolean end = false;
            boolean defaultFlag = false;
            while (reader.hasNext() && !end) {
                int xmltype = reader.next();
                switch (xmltype) {
                    case 1: {
                        if (!ATTRIBUTE_DEFAULT.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                        defaultFlag = true;
                        break;
                    }
                    case 4: {
                        if (!defaultFlag || this.xmlReader.isWhiteSpace()) break;
                        defaultStr = this.xmlReader.getText();
                        break;
                    }
                    case 2: {
                        if (!ATTRIBUTE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                        end = true;
                    }
                }
            }
            boolean dynamic = typeAtt.equalsIgnoreCase("dynamic");
            AttributeType attributeType = AttributeType.STRING;
            if (type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("bool")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_BOOLEAN : AttributeType.BOOLEAN;
            } else if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("int")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_INT : AttributeType.INT;
            } else if (type.equalsIgnoreCase("long")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_LONG : AttributeType.LONG;
            } else if (type.equalsIgnoreCase("float")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_FLOAT : AttributeType.FLOAT;
            } else if (type.equalsIgnoreCase("double")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_DOUBLE : AttributeType.DOUBLE;
            } else if (type.equalsIgnoreCase("string")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_STRING : AttributeType.STRING;
            } else if (type.equalsIgnoreCase("bigdecimal")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_BIGDECIMAL : AttributeType.BIGDECIMAL;
            } else if (type.equalsIgnoreCase("biginteger")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_BIGINTEGER : AttributeType.BIGINTEGER;
            } else if (type.equalsIgnoreCase("byte")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_BYTE : AttributeType.BYTE;
            } else if (type.equalsIgnoreCase("char")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_CHAR : AttributeType.CHAR;
            } else if (type.equalsIgnoreCase("short")) {
                attributeType = dynamic ? AttributeType.DYNAMIC_SHORT : AttributeType.SHORT;
            } else if (type.equalsIgnoreCase("listboolean")) {
                attributeType = AttributeType.LIST_BOOLEAN;
            } else if (type.equalsIgnoreCase("listint")) {
                attributeType = AttributeType.LIST_INTEGER;
            } else if (type.equalsIgnoreCase("listlong")) {
                attributeType = AttributeType.LIST_LONG;
            } else if (type.equalsIgnoreCase("listfloat")) {
                attributeType = AttributeType.LIST_FLOAT;
            } else if (type.equalsIgnoreCase("listdouble")) {
                attributeType = AttributeType.LIST_DOUBLE;
            } else if (type.equalsIgnoreCase("liststring")) {
                attributeType = AttributeType.LIST_STRING;
            } else if (type.equalsIgnoreCase("listbigdecimal")) {
                attributeType = AttributeType.LIST_BIGDECIMAL;
            } else if (type.equalsIgnoreCase("listbiginteger")) {
                attributeType = AttributeType.LIST_BIGINTEGER;
            } else if (type.equalsIgnoreCase("listbyte")) {
                attributeType = AttributeType.LIST_BYTE;
            } else if (type.equalsIgnoreCase("listchar")) {
                attributeType = AttributeType.LIST_CHARACTER;
            } else if (type.equalsIgnoreCase("listshort")) {
                attributeType = AttributeType.LIST_SHORT;
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributetype2", (Object)type), Issue.Level.SEVERE));
                return;
            }
            Object defaultValue = null;
            if (!defaultStr.isEmpty()) {
                try {
                    defaultValue = attributeType.parse(defaultStr);
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_default", (Object)defaultStr, (Object)title));
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributedefault", (Object)title, (Object)attributeType.getTypeString()), Issue.Level.SEVERE));
                }
            }
            if (NODE.equalsIgnoreCase(classAtt) || classAtt.isEmpty()) {
                if (this.container.getAttributeModel().getNodeTable().hasColumn(id) || this.container.getAttributeModel().getNodeTable().hasColumn(title)) {
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributecolumn_exist", (Object)id));
                    return;
                }
                this.container.getAttributeModel().getNodeTable().addColumn(id, title, attributeType, AttributeOrigin.DATA, defaultValue);
                this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_nodeattribute", (Object)title, (Object)attributeType.getTypeString()));
            } else if (EDGE.equalsIgnoreCase(classAtt) || classAtt.isEmpty()) {
                if ((id.equalsIgnoreCase(EDGE_WEIGHT) || title.equalsIgnoreCase(EDGE_WEIGHT)) && dynamic && attributeType.equals((Object)AttributeType.DYNAMIC_FLOAT)) {
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_dynamic_weight", (Object)id));
                    this.container.getAttributeModel().getEdgeTable().removeColumn(this.container.getAttributeModel().getEdgeTable().getColumn(PropertiesColumn.EDGE_WEIGHT.getIndex()));
                    this.container.getAttributeModel().getEdgeTable().addColumn(id, PropertiesColumn.EDGE_WEIGHT.getTitle(), attributeType, AttributeOrigin.PROPERTY, defaultValue);
                    return;
                }
                if (this.container.getAttributeModel().getEdgeTable().hasColumn(id) || this.container.getAttributeModel().getEdgeTable().hasColumn(title)) {
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributecolumn_exist", (Object)id));
                    return;
                }
                this.container.getAttributeModel().getEdgeTable().addColumn(id, title, attributeType, AttributeOrigin.DATA, defaultValue);
                this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_edgeattribute", (Object)title, (Object)attributeType.getTypeString()));
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributeempty", (Object)title), Issue.Level.SEVERE));
        }
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

