/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.awt.Color;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterGML
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader(this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start(this.progressTicket);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(93);
        tokenizer.wordChars(95, 95);
        ArrayList list = this.parseList(tokenizer);
        boolean ret = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!"graph".equals(list.get(i)) || list.size() < i + 2 || !(list.get(i + 1) instanceof ArrayList)) continue;
            ret = this.parseGraph((ArrayList)list.get(i + 1));
        }
        if (!ret) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_badparsing"), Issue.Level.SEVERE));
        }
        Progress.finish(this.progressTicket);
    }

    private ArrayList parseList(StreamTokenizer tokenizer) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        block5: while (true) {
            int t;
            if ((t = tokenizer.nextToken()) == 93 || t == -1) {
                return list;
            }
            if (t != -3) break;
            String key = tokenizer.sval;
            list.add(key);
            t = tokenizer.nextToken();
            switch (t) {
                case 91: {
                    list.add(this.parseList(tokenizer));
                    continue block5;
                }
                case -2: {
                    list.add(new Double(tokenizer.nval));
                    continue block5;
                }
                case -3: 
                case 34: {
                    list.add(tokenizer.sval);
                    continue block5;
                }
            }
            break;
        }
        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_listtoken", (Object)tokenizer.lineno()), Issue.Level.SEVERE));
        return list;
    }

    private boolean parseGraph(ArrayList list) {
        if ((list.size() & 1) != 0) {
            return false;
        }
        Progress.switchToDeterminate(this.progressTicket, list.size());
        boolean ret = true;
        for (int i = 0; i < list.size(); i += 2) {
            Object key = list.get(i);
            Object value = list.get(i + 1);
            if ("node".equals(key)) {
                ret = this.parseNode((ArrayList)value);
            } else if ("edge".equals(key)) {
                ret = this.parseEdge((ArrayList)value);
            } else if ("directed".equals(key)) {
                if (value instanceof Double) {
                    EdgeDefault edgeDefault = (Double)value == 1.0 ? EdgeDefault.DIRECTED : EdgeDefault.UNDIRECTED;
                    this.container.setEdgeDefault(edgeDefault);
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_directedgraphparse"), Issue.Level.WARNING));
                }
            }
            if (!ret || this.cancel) break;
            Progress.progress(this.progressTicket);
        }
        return ret;
    }

    private boolean parseNode(ArrayList list) {
        NodeDraft node = this.container.factory().newNodeDraft();
        String id = null;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("id".equals(key)) {
                id = value.toString();
                node.setId(id);
                continue;
            }
            if (!"label".equals(key)) continue;
            String label = value.toString();
            node.setLabel(label);
        }
        if (id == null) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_nodeidmissing"), Issue.Level.WARNING));
        }
        boolean ret = this.addNodeAttributes(node, "", list);
        this.container.addNode(node);
        return ret;
    }

    private boolean addNodeAttributes(NodeDraft node, String prefix, ArrayList list) {
        boolean ret = true;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("id".equals(key) || "label".equals(key)) continue;
            if (value instanceof ArrayList) {
                ret = this.addNodeAttributes(node, prefix + "." + key, (ArrayList)value);
                if (ret) continue;
                break;
            }
            if ("x".equals(key) && value instanceof Double) {
                node.setX(((Double)value).floatValue());
                continue;
            }
            if ("y".equals(key) && value instanceof Double) {
                node.setY(((Double)value).floatValue());
                continue;
            }
            if ("z".equals(key) && value instanceof Double) {
                node.setZ(((Double)value).floatValue());
                continue;
            }
            if ("w".equals(key) && value instanceof Double) {
                node.setSize(((Double)value).floatValue());
                continue;
            }
            if ("h".equals(key)) continue;
            if ("fill".equals(key)) {
                int colorHex = -1;
                if (value instanceof String) {
                    String str = ((String)value).trim().replace("#", "");
                    try {
                        colorHex = Integer.valueOf(str, 16);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (colorHex == -1) continue;
                node.setColor(new Color(colorHex));
                continue;
            }
            AttributeTable nodeClass = this.container.getAttributeModel().getNodeTable();
            AttributeColumn column = null;
            column = nodeClass.getColumn(key);
            if (column == null) {
                column = nodeClass.addColumn(key, AttributeType.STRING);
                this.report.log("Node attribute " + column.getTitle() + " (" + (Object)((Object)column.getType()) + ")");
            }
            node.addAttributeValue(column, value.toString());
        }
        return ret;
    }

    private boolean parseEdge(ArrayList list) {
        EdgeDraft edgeDraft = this.container.factory().newEdgeDraft();
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("source".equals(key)) {
                NodeDraft source = this.container.getNode(value.toString());
                edgeDraft.setSource(source);
                continue;
            }
            if ("target".equals(key)) {
                NodeDraft target = this.container.getNode(value.toString());
                edgeDraft.setTarget(target);
                continue;
            }
            if ("value".equals(key)) {
                if (!(value instanceof Double)) continue;
                edgeDraft.setWeight(((Double)value).floatValue());
                continue;
            }
            if (!"label".equals(key)) continue;
            edgeDraft.setLabel(value.toString());
        }
        boolean ret = this.addEdgeAttributes(edgeDraft, "", list);
        this.container.addEdge(edgeDraft);
        return ret;
    }

    private boolean addEdgeAttributes(EdgeDraft edge, String prefix, ArrayList list) {
        boolean ret = true;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("source".equals(key) || "target".equals(key) || "value".equals(key) || "label".equals(key)) continue;
            if (value instanceof ArrayList) {
                ret = this.addEdgeAttributes(edge, prefix + "." + key, (ArrayList)value);
                if (ret) continue;
                break;
            }
            if ("directed".equals(key)) {
                if (value instanceof Double) {
                    EdgeDraft.EdgeType type = (Double)value == 1.0 ? EdgeDraft.EdgeType.DIRECTED : EdgeDraft.EdgeType.UNDIRECTED;
                    edge.setType(type);
                    continue;
                }
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_directedparse", (Object)edge.toString()), Issue.Level.WARNING));
                continue;
            }
            AttributeTable edgeClass = this.container.getAttributeModel().getEdgeTable();
            AttributeColumn column = null;
            column = edgeClass.getColumn(key);
            if (column == null) {
                column = edgeClass.addColumn(key, AttributeType.STRING);
                this.report.log("Edge attribute " + column.getTitle() + " (" + (Object)((Object)column.getType()) + ")");
            }
            edge.addAttributeValue(column, value.toString());
        }
        return ret;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

