/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.BufferedReader;
import java.io.LineNumberReader;
import java.io.Reader;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.plugin.file.ImporterGDF;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterTLP
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = this.report;
        LineNumberReader lineReader = ImportUtils.getTextReader(this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start(this.progressTicket);
        this.walkFile(reader);
        Progress.finish(this.progressTicket);
    }

    private void walkFile(BufferedReader reader) throws Exception {
        int cptLine = 0;
        boolean state = false;
        while (reader.ready() && !this.cancel) {
            String[] tokens;
            String line = reader.readLine();
            if (!this.isComment(line) && (tokens = line.split("\\s|\\)")).length > 0) {
                if (!state) {
                    if (tokens[0].equals("(nodes")) {
                        this.parseNodes(tokens);
                    } else if (tokens[0].equals("(edge")) {
                        this.parseEdge(tokens, cptLine);
                    } else if (tokens[0].equals("(property")) {
                        state = true;
                    }
                }
                if (state) {
                    return;
                }
            }
            ++cptLine;
        }
    }

    private boolean isComment(String s) {
        return s.startsWith(";");
    }

    private void parseNodes(String[] tokens) {
        for (int i = 1; i < tokens.length; ++i) {
            NodeDraft node = this.container.factory().newNodeDraft();
            String id = tokens[i];
            node.setId(id);
            this.container.addNode(node);
        }
    }

    private void parseEdge(String[] tokens, int cptLine) {
        if (tokens.length != 4) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGDF.class, (String)"importerTPL_error_dataformat1", (Object)cptLine), Issue.Level.WARNING));
        }
        EdgeDraft edge = this.container.factory().newEdgeDraft();
        String id = tokens[1];
        NodeDraft source = this.container.getNode(tokens[2]);
        NodeDraft target = this.container.getNode(tokens[3]);
        edge.setId(id);
        edge.setSource(source);
        edge.setTarget(target);
        this.container.addEdge(edge);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

