/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.awt.Color;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.type.DynamicFloat;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDraftGetter;
import org.gephi.io.importer.api.NodeDraftGetter;
import org.gephi.project.api.Workspace;

public abstract class AbstractProcessor {
    protected Workspace workspace;
    protected ContainerUnloader container;
    protected AttributeModel attributeModel;

    protected void flushToNode(NodeDraftGetter nodeDraft, Node node) {
        if (nodeDraft.getColor() != null) {
            node.getNodeData().setR((float)nodeDraft.getColor().getRed() / 255.0f);
            node.getNodeData().setG((float)nodeDraft.getColor().getGreen() / 255.0f);
            node.getNodeData().setB((float)nodeDraft.getColor().getBlue() / 255.0f);
        }
        if (nodeDraft.getLabel() != null) {
            node.getNodeData().setLabel(nodeDraft.getLabel());
        }
        if (node.getNodeData().getTextData() != null) {
            node.getNodeData().getTextData().setVisible(nodeDraft.isLabelVisible());
        }
        if (nodeDraft.getLabelColor() != null && node.getNodeData().getTextData() != null) {
            Color labelColor = nodeDraft.getLabelColor();
            node.getNodeData().getTextData().setColor((float)labelColor.getRed() / 255.0f, (float)labelColor.getGreen() / 255.0f, (float)labelColor.getBlue() / 255.0f, (float)labelColor.getAlpha() / 255.0f);
        }
        if (nodeDraft.getLabelSize() != -1.0f && node.getNodeData().getTextData() != null) {
            node.getNodeData().getTextData().setSize(nodeDraft.getLabelSize());
        }
        node.getNodeData().setX(nodeDraft.getX());
        node.getNodeData().setY(nodeDraft.getY());
        node.getNodeData().setZ(nodeDraft.getZ());
        if (nodeDraft.getSize() != 0.0f && !Float.isNaN(nodeDraft.getSize())) {
            node.getNodeData().setSize(nodeDraft.getSize());
        } else {
            node.getNodeData().setSize(10.0f);
        }
        if (nodeDraft.getTimeInterval() != null) {
            AttributeColumn col = this.attributeModel.getNodeTable().getColumn("time_interval");
            if (col == null) {
                col = this.attributeModel.getNodeTable().addColumn("time_interval", "Time Interval", AttributeType.TIME_INTERVAL, AttributeOrigin.PROPERTY, null);
            }
            node.getNodeData().getAttributes().setValue(col.getIndex(), (Object)nodeDraft.getTimeInterval());
        }
        this.flushToNodeAttributes(nodeDraft, node);
    }

    protected void flushToNodeAttributes(NodeDraftGetter nodeDraft, Node node) {
        if (node.getNodeData().getAttributes() != null) {
            AttributeRow row = (AttributeRow)node.getNodeData().getAttributes();
            for (AttributeValue val : nodeDraft.getAttributeRow().getValues()) {
                if (val.getColumn().getOrigin().equals((Object)AttributeOrigin.PROPERTY) || val.getValue() == null) continue;
                row.setValue(val.getColumn(), val.getValue());
            }
        }
    }

    protected void flushToEdge(EdgeDraftGetter edgeDraft, Edge edge) {
        if (edgeDraft.getColor() != null) {
            edge.getEdgeData().setR((float)edgeDraft.getColor().getRed() / 255.0f);
            edge.getEdgeData().setG((float)edgeDraft.getColor().getGreen() / 255.0f);
            edge.getEdgeData().setB((float)edgeDraft.getColor().getBlue() / 255.0f);
        } else {
            edge.getEdgeData().setR(-1.0f);
            edge.getEdgeData().setG(-1.0f);
            edge.getEdgeData().setB(-1.0f);
        }
        if (edgeDraft.getLabel() != null) {
            edge.getEdgeData().setLabel(edgeDraft.getLabel());
        }
        if (edge.getEdgeData().getTextData() != null) {
            edge.getEdgeData().getTextData().setVisible(edgeDraft.isLabelVisible());
        }
        if (edgeDraft.getLabelSize() != -1.0f && edge.getEdgeData().getTextData() != null) {
            edge.getEdgeData().getTextData().setSize(edgeDraft.getLabelSize());
        }
        if (edgeDraft.getLabelColor() != null && edge.getEdgeData().getTextData() != null) {
            Color labelColor = edgeDraft.getLabelColor();
            edge.getEdgeData().getTextData().setColor((float)labelColor.getRed() / 255.0f, (float)labelColor.getGreen() / 255.0f, (float)labelColor.getBlue() / 255.0f, (float)labelColor.getAlpha() / 255.0f);
        }
        if (edgeDraft.getTimeInterval() != null) {
            AttributeColumn col = this.attributeModel.getEdgeTable().getColumn("time_interval");
            if (col == null) {
                col = this.attributeModel.getEdgeTable().addColumn("time_interval", "Time Interval", AttributeType.TIME_INTERVAL, AttributeOrigin.PROPERTY, null);
            }
            edge.getEdgeData().getAttributes().setValue(col.getIndex(), (Object)edgeDraft.getTimeInterval());
        }
        this.flushToEdgeAttributes(edgeDraft, edge);
    }

    protected void flushToEdgeAttributes(EdgeDraftGetter edgeDraft, Edge edge) {
        AttributeColumn dynamicWeightCol;
        if (edge.getEdgeData().getAttributes() != null) {
            AttributeRow row = (AttributeRow)edge.getEdgeData().getAttributes();
            for (AttributeValue val : edgeDraft.getAttributeRow().getValues()) {
                if (val.getColumn().getOrigin().equals((Object)AttributeOrigin.PROPERTY) || val.getValue() == null) continue;
                row.setValue(val.getColumn(), val.getValue());
            }
        }
        if ((dynamicWeightCol = this.container.getAttributeModel().getEdgeTable().getColumn(PropertiesColumn.EDGE_WEIGHT.getTitle(), AttributeType.DYNAMIC_FLOAT)) != null) {
            DynamicFloat weight = (DynamicFloat)edgeDraft.getAttributeRow().getValue(dynamicWeightCol.getIndex());
            AttributeRow row = (AttributeRow)edge.getEdgeData().getAttributes();
            if (weight == null) {
                row.setValue(PropertiesColumn.EDGE_WEIGHT.getIndex(), (Object)new DynamicFloat(new Interval<Float>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Float.valueOf(edgeDraft.getWeight()))));
            } else {
                row.setValue(PropertiesColumn.EDGE_WEIGHT.getIndex(), (Object)weight);
            }
        }
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setContainer(ContainerUnloader container) {
        this.container = container;
    }
}

