/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.util.HashMap;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeDraftGetter;
import org.gephi.io.importer.api.NodeDraftGetter;
import org.gephi.io.processor.plugin.AbstractProcessor;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.ProjectController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AppendProcessor
extends AbstractProcessor
implements Processor {
    public String getDisplayName() {
        return NbBundle.getMessage(AppendProcessor.class, (String)"AppendProcessor.displayName");
    }

    /*
     * WARNING - void declaration
     */
    public void process() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (this.workspace == null) {
            this.workspace = pc.getCurrentWorkspace();
            if (this.workspace == null) {
                this.workspace = pc.newWorkspace(pc.getCurrentProject());
                pc.openWorkspace(this.workspace);
            }
        }
        if (this.container.getSource() != null) {
            pc.setSource(this.workspace, this.container.getSource());
        }
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        HierarchicalGraph graph = null;
        switch (this.container.getEdgeDefault()) {
            case DIRECTED: {
                graph = graphModel.getHierarchicalDirectedGraph();
                break;
            }
            case UNDIRECTED: {
                graph = graphModel.getHierarchicalUndirectedGraph();
                break;
            }
            case MIXED: {
                graph = graphModel.getHierarchicalMixedGraph();
                break;
            }
            default: {
                graph = graphModel.getHierarchicalMixedGraph();
            }
        }
        GraphFactory factory = graphModel.factory();
        this.attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        this.attributeModel.mergeModel(this.container.getAttributeModel());
        if (this.container.getTimeFormat() != null) {
            DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
            dynamicController.setTimeFormat(this.container.getTimeFormat());
        }
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (Node n2 : graph.getNodes()) {
            String string = n2.getNodeData().getId();
            if (string != null && !string.equalsIgnoreCase(String.valueOf(n2.getId()))) {
                map.put(string, n2);
            }
            if (n2.getNodeData().getLabel() == null || n2.getNodeData().getLabel().isEmpty()) continue;
            map.put(n2.getNodeData().getLabel(), n2);
        }
        int nodeCount = 0;
        for (NodeDraftGetter nodeDraftGetter : this.container.getNodes()) {
            void var9_16;
            String id = nodeDraftGetter.getId();
            String label = nodeDraftGetter.getLabel();
            if (!nodeDraftGetter.isAutoId() && id != null && map.get(id) != null) {
                Node node = (Node)map.get(id);
            } else if (label != null && map.get(label) != null) {
                Node node = (Node)map.get(label);
            } else {
                Node node = factory.newNode(nodeDraftGetter.isAutoId() ? null : id);
                ++nodeCount;
            }
            this.flushToNode(nodeDraftGetter, (Node)var9_16);
            nodeDraftGetter.setNode((Node)var9_16);
        }
        for (NodeDraftGetter nodeDraftGetter : this.container.getNodes()) {
            Node node = nodeDraftGetter.getNode();
            NodeDraftGetter[] parents = nodeDraftGetter.getParents();
            if (parents != null) {
                for (int i = 0; i < parents.length; ++i) {
                    Node parent = parents[i].getNode();
                    graph.addNode(node, parent);
                }
                continue;
            }
            graph.addNode(node);
        }
        int edgeCount = 0;
        for (EdgeDraftGetter edgeDraftGetter : this.container.getEdges()) {
            Node target;
            Node source = edgeDraftGetter.getSource().getNode();
            if (graph.getEdge(source, target = edgeDraftGetter.getTarget().getNode()) != null) continue;
            Edge e = null;
            switch (this.container.getEdgeDefault()) {
                case DIRECTED: {
                    e = factory.newEdge(edgeDraftGetter.isAutoId() ? null : edgeDraftGetter.getId(), source, target, edgeDraftGetter.getWeight(), true);
                    break;
                }
                case UNDIRECTED: {
                    e = factory.newEdge(edgeDraftGetter.isAutoId() ? null : edgeDraftGetter.getId(), source, target, edgeDraftGetter.getWeight(), false);
                    break;
                }
                case MIXED: {
                    e = factory.newEdge(edgeDraftGetter.isAutoId() ? null : edgeDraftGetter.getId(), source, target, edgeDraftGetter.getWeight(), !edgeDraftGetter.getType().equals((Object)EdgeDraft.EdgeType.UNDIRECTED));
                }
            }
            this.flushToEdge(edgeDraftGetter, e);
            ++edgeCount;
            graph.addEdge(e);
        }
        System.out.println("# New Nodes appended: " + nodeCount + "\n# New Edges appended: " + edgeCount);
        this.workspace = null;
    }
}

