/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.util.Collection;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.NodeDraftGetter;
import org.gephi.io.processor.spi.Scaler;

public class DefaultScaler
implements Scaler {
    private float sizeMinimum;
    private float sizeMaximum;
    private float weightMinimum;
    private float weightMaximum;
    private float octreeLimit;

    private void setDefaults() {
        this.sizeMaximum = 100.0f;
        this.sizeMinimum = 4.0f;
        this.weightMinimum = 0.4f;
        this.weightMaximum = 2.0f;
        this.octreeLimit = 5000.0f;
    }

    public void doScale(Container container) {
        this.setDefaults();
        float sizeMin = Float.POSITIVE_INFINITY;
        float sizeMax = Float.NEGATIVE_INFINITY;
        float xMin = Float.POSITIVE_INFINITY;
        float xMax = Float.NEGATIVE_INFINITY;
        float yMin = Float.POSITIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        float zMin = Float.POSITIVE_INFINITY;
        float zMax = Float.NEGATIVE_INFINITY;
        float sizeRatio = 0.0f;
        float averageSize = 2.5f;
        Collection<? extends NodeDraftGetter> nodes = container.getUnloader().getNodes();
        double centroidX = 0.0;
        double centroidY = 0.0;
        for (NodeDraftGetter nodeDraftGetter : nodes) {
            centroidX += (double)nodeDraftGetter.getX();
            centroidY += (double)nodeDraftGetter.getY();
        }
        centroidX /= (double)nodes.size();
        centroidY /= (double)nodes.size();
        for (NodeDraftGetter nodeDraftGetter : nodes) {
            nodeDraftGetter.setX((float)((double)nodeDraftGetter.getX() - centroidX));
            nodeDraftGetter.setY((float)((double)nodeDraftGetter.getY() - centroidY));
        }
        for (NodeDraftGetter nodeDraftGetter : nodes) {
            sizeMin = Math.min(nodeDraftGetter.getSize(), sizeMin);
            sizeMax = Math.max(nodeDraftGetter.getSize(), sizeMax);
            xMin = Math.min(nodeDraftGetter.getX(), xMin);
            xMax = Math.max(nodeDraftGetter.getX(), xMax);
            yMin = Math.min(nodeDraftGetter.getY(), yMin);
            yMax = Math.max(nodeDraftGetter.getY(), yMax);
            zMin = Math.min(nodeDraftGetter.getZ(), zMin);
            zMax = Math.max(nodeDraftGetter.getZ(), zMax);
        }
        if (sizeMin != 0.0f && sizeMax != 0.0f) {
            sizeRatio = sizeMin == sizeMax ? this.sizeMinimum / sizeMin : (this.sizeMaximum - this.sizeMinimum) / (sizeMax - sizeMin);
            if (xMin * sizeRatio < -this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / xMin);
            }
            if (xMax * sizeRatio > this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / xMax);
            }
            if (yMin * sizeRatio < -this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / yMin);
            }
            if (yMax * sizeRatio > this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / yMax);
            }
            if (zMin * sizeRatio < -this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / zMin);
            }
            if (zMax * sizeRatio > this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / zMax);
            }
            averageSize = 0.0f;
            for (NodeDraftGetter nodeDraftGetter : nodes) {
                float size = (nodeDraftGetter.getSize() - sizeMin) * sizeRatio + this.sizeMinimum;
                nodeDraftGetter.setSize(size);
                nodeDraftGetter.setX(nodeDraftGetter.getX() * sizeRatio);
                nodeDraftGetter.setY(nodeDraftGetter.getY() * sizeRatio);
                nodeDraftGetter.setZ(nodeDraftGetter.getZ() * sizeRatio);
                averageSize += size;
            }
            averageSize /= (float)container.getUnloader().getNodes().size();
        }
    }
}

