/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeDraftGetter;
import org.gephi.io.importer.api.NodeDraftGetter;
import org.gephi.io.processor.plugin.AbstractProcessor;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.ProjectController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DynamicProcessor
extends AbstractProcessor
implements Processor {
    private boolean dateMode = true;
    private String date = "";
    private boolean labelmatching = true;
    private double point;

    /*
     * WARNING - void declaration
     */
    public void process() {
        void var14_24;
        AttributeType dynamicType;
        AttributeColumn existingCol;
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (this.workspace == null) {
            this.workspace = pc.getCurrentWorkspace();
            if (this.workspace == null) {
                this.workspace = pc.newWorkspace(pc.getCurrentProject());
                pc.openWorkspace(this.workspace);
            }
        }
        if (this.container.getSource() != null) {
            pc.setSource(this.workspace, this.container.getSource());
        }
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        HierarchicalGraph graph = null;
        switch (this.container.getEdgeDefault()) {
            case DIRECTED: {
                graph = graphModel.getHierarchicalDirectedGraph();
                break;
            }
            case UNDIRECTED: {
                graph = graphModel.getHierarchicalUndirectedGraph();
                break;
            }
            case MIXED: {
                graph = graphModel.getHierarchicalMixedGraph();
                break;
            }
            default: {
                graph = graphModel.getHierarchicalMixedGraph();
            }
        }
        GraphFactory factory = graphModel.factory();
        this.attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        AttributeTable nodeTable = this.container.getAttributeModel().getNodeTable();
        AttributeTable edgeTable = this.container.getAttributeModel().getEdgeTable();
        for (AttributeColumn column : nodeTable.getColumns()) {
            existingCol = this.attributeModel.getNodeTable().getColumn(column.getTitle());
            if (existingCol != null || column.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
            dynamicType = TypeConvertor.getDynamicType(column.getType());
            if (dynamicType != null && !column.getType().isDynamicType()) {
                this.attributeModel.getNodeTable().addColumn(column.getId(), column.getTitle(), dynamicType, column.getOrigin(), null);
                continue;
            }
            this.attributeModel.getNodeTable().addColumn(column.getId(), column.getTitle(), column.getType(), column.getOrigin(), column.getDefaultValue());
        }
        for (AttributeColumn column : edgeTable.getColumns()) {
            existingCol = this.attributeModel.getEdgeTable().getColumn(column.getTitle());
            if (existingCol == null) {
                if (column.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
                dynamicType = TypeConvertor.getDynamicType(column.getType());
                if (dynamicType != null && !column.getType().isDynamicType()) {
                    this.attributeModel.getEdgeTable().addColumn(column.getId(), column.getTitle(), dynamicType, column.getOrigin(), null);
                    continue;
                }
                this.attributeModel.getEdgeTable().addColumn(column.getId(), column.getTitle(), column.getType(), column.getOrigin(), column.getDefaultValue());
                continue;
            }
            if (!PropertiesColumn.EDGE_WEIGHT.getId().equals(column.getId()) || existingCol.getType().isDynamicType()) continue;
            this.attributeModel.getEdgeTable().replaceColumn(this.attributeModel.getEdgeTable().getColumn(PropertiesColumn.EDGE_WEIGHT.getIndex()), PropertiesColumn.EDGE_WEIGHT.getId(), PropertiesColumn.EDGE_WEIGHT.getTitle(), AttributeType.DYNAMIC_FLOAT, AttributeOrigin.PROPERTY, null);
        }
        AttributeColumn nodeDynamicColumn = this.attributeModel.getNodeTable().getColumn("time_interval");
        AttributeColumn edgeDynamicColumn = this.attributeModel.getEdgeTable().getColumn("time_interval");
        if (nodeDynamicColumn == null) {
            nodeDynamicColumn = this.attributeModel.getNodeTable().addColumn("time_interval", "Time Interval", AttributeType.TIME_INTERVAL, AttributeOrigin.PROPERTY, null);
        }
        if (edgeDynamicColumn == null) {
            edgeDynamicColumn = this.attributeModel.getEdgeTable().addColumn("time_interval", "Time Interval", AttributeType.TIME_INTERVAL, AttributeOrigin.PROPERTY, null);
        }
        if (this.dateMode) {
            try {
                this.point = DynamicUtilities.getDoubleFromXMLDateString(this.date);
            }
            catch (Exception e) {
                throw new RuntimeException("The entered date can't be parsed");
            }
        } else {
            this.point = Double.parseDouble(this.date);
        }
        DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
        dynamicController.setTimeFormat(this.dateMode ? DynamicModel.TimeFormat.DATE : DynamicModel.TimeFormat.DOUBLE);
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (Node n : graph.getNodes()) {
            String id = n.getNodeData().getId();
            if (id != null && !this.labelmatching && !id.equalsIgnoreCase(String.valueOf(n.getId()))) {
                map.put(id, n);
            }
            if (n.getNodeData().getLabel() == null || n.getNodeData().getLabel().isEmpty() || !this.labelmatching) continue;
            map.put(n.getNodeData().getLabel(), n);
        }
        HashSet<Node> nodesInDraft = new HashSet<Node>();
        int newNodeCount = 0;
        for (NodeDraftGetter nodeDraftGetter : this.container.getNodes()) {
            Node node = null;
            String string = nodeDraftGetter.getId();
            String label = nodeDraftGetter.getLabel();
            if (!nodeDraftGetter.isAutoId() && string != null && map.get(string) != null && !this.labelmatching) {
                node = (Node)map.get(string);
            } else if (label != null && map.get(label) != null && this.labelmatching) {
                node = (Node)map.get(label);
            }
            TimeInterval timeInterval = null;
            if (node == null) {
                node = factory.newNode(nodeDraftGetter.isAutoId() ? null : nodeDraftGetter.getId());
                this.flushToNode(nodeDraftGetter, node);
                nodeDraftGetter.setNode(node);
                ++newNodeCount;
            } else {
                timeInterval = (TimeInterval)node.getNodeData().getAttributes().getValue(nodeDynamicColumn.getIndex());
                this.flushToNodeAttributes(nodeDraftGetter, node);
                nodeDraftGetter.setNode(node);
            }
            nodesInDraft.add(node);
            node.getNodeData().getAttributes().setValue(nodeDynamicColumn.getIndex(), (Object)this.addPoint(timeInterval, this.point));
        }
        for (NodeDraftGetter nodeDraftGetter : this.container.getNodes()) {
            Node n = nodeDraftGetter.getNode();
            NodeDraftGetter[] nodeDraftGetterArray = nodeDraftGetter.getParents();
            if (nodeDraftGetterArray != null) {
                for (int i = 0; i < nodeDraftGetterArray.length; ++i) {
                    Node parent = nodeDraftGetterArray[i].getNode();
                    graph.addNode(n, parent);
                }
                continue;
            }
            graph.addNode(n);
        }
        for (Node node : graph.getNodes()) {
            if (nodesInDraft.contains(node)) continue;
            TimeInterval timeInterval = (TimeInterval)node.getNodeData().getAttributes().getValue(nodeDynamicColumn.getIndex());
            node.getNodeData().getAttributes().setValue(nodeDynamicColumn.getIndex(), (Object)this.removePoint(timeInterval, this.point));
        }
        HashSet<Edge> edgesInDraft = new HashSet<Edge>();
        boolean bl = false;
        for (EdgeDraftGetter edgeDraftGetter : this.container.getEdges()) {
            Node source = edgeDraftGetter.getSource().getNode();
            Node target = edgeDraftGetter.getTarget().getNode();
            Edge edge = graph.getEdge(source, target);
            TimeInterval timeInterval = null;
            if (edge == null) {
                switch (this.container.getEdgeDefault()) {
                    case DIRECTED: {
                        edge = factory.newEdge(edgeDraftGetter.isAutoId() ? null : edgeDraftGetter.getId(), source, target, edgeDraftGetter.getWeight(), true);
                        break;
                    }
                    case UNDIRECTED: {
                        edge = factory.newEdge(edgeDraftGetter.isAutoId() ? null : edgeDraftGetter.getId(), source, target, edgeDraftGetter.getWeight(), false);
                        break;
                    }
                    case MIXED: {
                        edge = factory.newEdge(edgeDraftGetter.isAutoId() ? null : edgeDraftGetter.getId(), source, target, edgeDraftGetter.getWeight(), !edgeDraftGetter.getType().equals((Object)EdgeDraft.EdgeType.UNDIRECTED));
                    }
                }
                ++var14_24;
                graph.addEdge(edge);
                this.flushToEdge(edgeDraftGetter, edge);
            } else {
                timeInterval = (TimeInterval)edge.getEdgeData().getAttributes().getValue(edgeDynamicColumn.getIndex());
                this.flushToEdgeAttributes(edgeDraftGetter, edge);
            }
            edgesInDraft.add(edge);
            edge.getEdgeData().getAttributes().setValue(edgeDynamicColumn.getIndex(), (Object)this.addPoint(timeInterval, this.point));
        }
        for (Edge edge : graph.getEdges()) {
            if (edgesInDraft.contains(edge)) continue;
            TimeInterval timeInterval = (TimeInterval)edge.getEdgeData().getAttributes().getValue(edgeDynamicColumn.getIndex());
            edge.getEdgeData().getAttributes().setValue(edgeDynamicColumn.getIndex(), (Object)this.removePoint(timeInterval, this.point));
        }
        System.out.println("# New Nodes loaded: " + newNodeCount + "\n# New Edges loaded: " + (int)var14_24);
        this.workspace = null;
    }

    protected void flushToNodeAttributes(NodeDraftGetter nodeDraft, Node node) {
        if (node.getNodeData().getAttributes() != null) {
            AttributeRow row = (AttributeRow)node.getNodeData().getAttributes();
            for (int i = 0; i < row.countValues(); ++i) {
                Object val = row.getValue(i);
                AttributeColumn col = row.getColumnAt(i);
                Object draftValue = nodeDraft.getAttributeRow().getValue(col.getId());
                if (col.getType().isDynamicType()) {
                    if (draftValue == null && val != null) {
                        this.removePoint(col.getType(), (DynamicType)val, this.point);
                        continue;
                    }
                    if (draftValue == null) continue;
                    DynamicType dynamicValue = this.addPoint(col.getType(), (DynamicType)val, draftValue, this.point);
                    row.setValue(col.getIndex(), (Object)dynamicValue);
                    continue;
                }
                if (draftValue == null || col.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
                row.setValue(col.getIndex(), draftValue);
            }
        }
    }

    protected void flushToEdgeAttributes(EdgeDraftGetter edgeDraft, Edge edge) {
        if (edge.getEdgeData().getAttributes() != null) {
            AttributeRow row = (AttributeRow)edge.getEdgeData().getAttributes();
            for (int i = 0; i < row.countValues(); ++i) {
                Object val = row.getValue(i);
                AttributeColumn col = row.getColumnAt(i);
                Object draftValue = edgeDraft.getAttributeRow().getValue(col);
                if (col.getId().equals(PropertiesColumn.EDGE_WEIGHT.getId())) {
                    draftValue = new Float(edgeDraft.getWeight());
                }
                if (col.getType().isDynamicType()) {
                    if (draftValue == null && val != null) {
                        this.removePoint(col.getType(), (DynamicType)val, this.point);
                        continue;
                    }
                    if (draftValue == null) continue;
                    DynamicType dynamicValue = this.addPoint(col.getType(), (DynamicType)val, draftValue, this.point);
                    row.setValue(col.getIndex(), (Object)dynamicValue);
                    continue;
                }
                if (draftValue == null || col.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) continue;
                row.setValue(col.getIndex(), draftValue);
            }
        }
    }

    private TimeInterval addPoint(TimeInterval source, double point) {
        if (source == null) {
            return new TimeInterval(point, Double.POSITIVE_INFINITY);
        }
        List intervals = source.getIntervals(point, point);
        if (intervals.isEmpty()) {
            return new TimeInterval(source, point, Double.POSITIVE_INFINITY);
        }
        return source;
    }

    private DynamicType addPoint(AttributeType type, DynamicType source, Object value, double point) {
        if (source == null) {
            return DynamicUtilities.createDynamicObject(type, new Interval<Object>(point, Double.POSITIVE_INFINITY, value));
        }
        List intervals = source.getIntervals(point, point);
        if (intervals.isEmpty()) {
            return DynamicUtilities.createDynamicObject(type, source, new Interval<Object>(point, Double.POSITIVE_INFINITY, value));
        }
        if (intervals.size() > 1) {
            throw new RuntimeException("DynamicProcessor doesn't support overlapping intervals.");
        }
        Interval toRemove = intervals.get(0);
        if (!toRemove.getValue().equals(value)) {
            Interval<Object> toAdd = new Interval(toRemove.getLow(), point, toRemove.isLowExcluded(), true, toRemove.getValue());
            DynamicType updated = DynamicUtilities.createDynamicObject(type, source, toAdd, toRemove);
            toAdd = new Interval<Object>(point, Double.POSITIVE_INFINITY, value);
            updated = DynamicUtilities.createDynamicObject(type, updated, toAdd);
            return updated;
        }
        return source;
    }

    private TimeInterval removePoint(TimeInterval source, double point) {
        if (source == null) {
            return null;
        }
        List intervals = source.getIntervals(point, point);
        if (intervals.size() > 1) {
            throw new RuntimeException("DynamicProcessor doesn't support overlapping intervals.");
        }
        if (!intervals.isEmpty()) {
            Interval toRemove = intervals.get(0);
            if (toRemove.getLow() >= point) {
                return source;
            }
            Double[] toAdd = new Double[]{toRemove.getLow(), point};
            return new TimeInterval(source, toAdd[0], toAdd[1], toRemove.isLowExcluded(), true, toRemove.getLow(), toRemove.getHigh(), toRemove.isLowExcluded(), toRemove.isHighExcluded());
        }
        return source;
    }

    private DynamicType removePoint(AttributeType type, DynamicType source, double point) {
        if (source == null) {
            return null;
        }
        List intervals = source.getIntervals(point, point);
        if (intervals.size() > 1) {
            throw new RuntimeException("DynamicProcessor doesn't support overlapping intervals.");
        }
        if (!intervals.isEmpty()) {
            Interval toRemove = intervals.get(0);
            if (toRemove.getLow() >= point) {
                return source;
            }
            Interval toAdd = new Interval(toRemove.getLow(), point, toRemove.isLowExcluded(), true, toRemove.getValue());
            return DynamicUtilities.createDynamicObject(type, source, toAdd, toRemove);
        }
        return source;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DynamicProcessor.class, (String)"DynamicProcessor.displayName");
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public boolean isDateMode() {
        return this.dateMode;
    }

    public void setDateMode(boolean dateMode) {
        this.dateMode = dateMode;
    }

    public boolean isLabelmatching() {
        return this.labelmatching;
    }

    public void setLabelmatching(boolean labelmatching) {
        this.labelmatching = labelmatching;
    }
}

