/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout;

import org.gephi.graph.api.GraphController;
import org.gephi.layout.LayoutModelImpl;
import org.gephi.layout.api.LayoutController;
import org.gephi.layout.api.LayoutModel;
import org.gephi.layout.spi.Layout;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class LayoutControllerImpl
implements LayoutController {
    private LayoutModelImpl model;
    private LayoutRun layoutRun;

    public LayoutControllerImpl() {
        ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add(new LayoutModelImpl());
            }

            public void select(Workspace workspace) {
                LayoutControllerImpl.this.model = (LayoutModelImpl)workspace.getLookup().lookup(LayoutModelImpl.class);
                if (LayoutControllerImpl.this.model == null) {
                    LayoutControllerImpl.this.model = new LayoutModelImpl();
                }
                workspace.add(LayoutControllerImpl.this.model);
            }

            public void unselect(Workspace workspace) {
                if (LayoutControllerImpl.this.model.getSelectedLayout() != null) {
                    LayoutControllerImpl.this.model.saveProperties(LayoutControllerImpl.this.model.getSelectedLayout());
                }
            }

            public void close(Workspace workspace) {
                LayoutModelImpl layoutModel = (LayoutModelImpl)workspace.getLookup().lookup(LayoutModelImpl.class);
                if (layoutModel != null) {
                    layoutModel.getExecutor().cancel();
                }
            }

            public void disable() {
                LayoutControllerImpl.this.model = null;
            }
        });
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (projectController.getCurrentWorkspace() != null) {
            this.model = (LayoutModelImpl)projectController.getCurrentWorkspace().getLookup().lookup(LayoutModelImpl.class);
            if (this.model == null) {
                this.model = new LayoutModelImpl();
            }
            projectController.getCurrentWorkspace().add(this.model);
        }
    }

    public LayoutModel getModel() {
        return this.model;
    }

    public void setLayout(Layout layout) {
        this.model.setSelectedLayout(layout);
        this.injectGraph();
    }

    public void executeLayout() {
        if (this.model.getSelectedLayout() != null) {
            this.layoutRun = new LayoutRun(this.model.getSelectedLayout());
            this.model.getExecutor().execute(this.layoutRun, this.layoutRun);
            this.model.setRunning(true);
        }
    }

    public void injectGraph() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (this.model.getSelectedLayout() != null && graphController.getModel() != null) {
            this.model.getSelectedLayout().setGraphModel(graphController.getModel());
        }
    }

    public boolean canExecute() {
        return this.model.getSelectedLayout() != null && !this.model.isRunning();
    }

    public boolean canStop() {
        return this.model.isRunning();
    }

    public void stopLayout() {
        this.model.getExecutor().cancel();
    }

    private static class LayoutRun
    implements LongTask,
    Runnable {
        private Layout layout;
        private boolean stopRun = false;
        private ProgressTicket progressTicket;

        public LayoutRun(Layout layout) {
            this.layout = layout;
        }

        public void run() {
            Progress.setDisplayName(this.progressTicket, this.layout.getBuilder().getName());
            Progress.start(this.progressTicket);
            this.layout.initAlgo();
            while (this.layout.canAlgo() && !this.stopRun) {
                this.layout.goAlgo();
            }
            this.layout.endAlgo();
            Progress.finish(this.progressTicket);
        }

        public boolean cancel() {
            this.stopRun = true;
            return true;
        }

        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
            if (this.layout instanceof LongTask) {
                ((LongTask)((Object)this.layout)).setProgressTicket(progressTicket);
            }
        }
    }
}

