/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.layout.api.LayoutModel;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutModelImpl
implements LayoutModel {
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private Layout selectedLayout;
    private LayoutBuilder selectedBuilder;
    private Map<LayoutPropertyKey, Object> savedProperties = new HashMap<LayoutPropertyKey, Object>();
    private LongTaskExecutor executor = new LongTaskExecutor(true, "layout", 5);

    public LayoutModelImpl() {
        this.executor.setLongTaskListener(new LongTaskListener(){

            public void taskFinished(LongTask task) {
                LayoutModelImpl.this.setRunning(false);
            }
        });
        this.executor.setDefaultErrorHandler(new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                Logger.getLogger("").log(Level.SEVERE, "", t.getCause() != null ? t.getCause() : t);
            }
        });
    }

    public Layout getSelectedLayout() {
        return this.selectedLayout;
    }

    public LayoutBuilder getSelectedBuilder() {
        return this.selectedBuilder;
    }

    public Layout getLayout(LayoutBuilder layoutBuilder) {
        Layout layout = layoutBuilder.buildLayout();
        this.selectedBuilder = layoutBuilder;
        layout.resetPropertiesValues();
        return layout;
    }

    protected void setSelectedLayout(Layout selectedLayout) {
        Layout oldValue = this.selectedLayout;
        this.selectedLayout = selectedLayout;
        LayoutBuilder layoutBuilder = this.selectedBuilder = selectedLayout != null ? selectedLayout.getBuilder() : null;
        if (oldValue != null) {
            this.saveProperties(oldValue);
        }
        if (selectedLayout != null) {
            this.loadProperties(selectedLayout);
        }
        this.firePropertyChangeEvent("selectedLayout", oldValue, selectedLayout);
    }

    public boolean isRunning() {
        return this.executor.isRunning();
    }

    protected void setRunning(boolean running) {
        this.firePropertyChangeEvent("running", !running, running);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = null;
        if (propertyName.equals("selectedLayout")) {
            evt = new PropertyChangeEvent(this, "selectedLayout", oldValue, newValue);
        } else if (propertyName.equals("running")) {
            evt = new PropertyChangeEvent(this, "running", oldValue, newValue);
        } else {
            return;
        }
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    public LongTaskExecutor getExecutor() {
        return this.executor;
    }

    public void saveProperties(Layout layout) {
        for (LayoutProperty p : layout.getProperties()) {
            try {
                Object value = p.getProperty().getValue();
                if (value == null) continue;
                this.savedProperties.put(new LayoutPropertyKey(p.getProperty().getName(), layout.getClass().getName()), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadProperties(Layout layout) {
        ArrayList<LayoutPropertyKey> layoutValues = new ArrayList<LayoutPropertyKey>();
        for (LayoutPropertyKey val : this.savedProperties.keySet()) {
            if (!val.layoutClassName.equals(layout.getClass().getName())) continue;
            layoutValues.add(val);
        }
        for (LayoutProperty property : layout.getProperties()) {
            for (LayoutPropertyKey l : layoutValues) {
                if (!property.getProperty().getName().equals(l.name)) continue;
                try {
                    property.getProperty().setValue(this.savedProperties.get(l));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Element writeXML(Document document) {
        Element layoutModelE = document.createElement("layoutmodel");
        if (this.selectedLayout != null) {
            this.saveProperties(this.selectedLayout);
        }
        Element propertiesE = document.createElement("properties");
        for (Map.Entry<LayoutPropertyKey, Object> entry : this.savedProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            Element propertyE = document.createElement("property");
            propertyE.setAttribute("layout", entry.getKey().layoutClassName);
            propertyE.setAttribute("property", entry.getKey().name);
            propertyE.setAttribute("class", entry.getValue().getClass().getName());
            propertyE.setTextContent(entry.getValue().toString());
            propertiesE.appendChild(propertyE);
        }
        layoutModelE.appendChild(propertiesE);
        return layoutModelE;
    }

    public void readXML(Element layoutModelElement) {
        NodeList propertyList = layoutModelElement.getElementsByTagName("property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Node n = propertyList.item(i);
            if (n.getNodeType() != 1) continue;
            Element propertyE = (Element)n;
            LayoutPropertyKey key = new LayoutPropertyKey(propertyE.getAttribute("property"), propertyE.getAttribute("layout"));
            Object value = this.parse(propertyE.getAttribute("class"), propertyE.getTextContent());
            if (value == null) continue;
            this.savedProperties.put(key, value);
        }
    }

    private Object parse(String classStr, String str) {
        try {
            Class<?> c = Class.forName(classStr);
            if (c.equals(Boolean.class)) {
                return new Boolean(str);
            }
            if (c.equals(Integer.class)) {
                return new Integer(str);
            }
            if (c.equals(Float.class)) {
                return new Float(str);
            }
            if (c.equals(Double.class)) {
                return new Double(str);
            }
            if (c.equals(Long.class)) {
                return new Long(str);
            }
            if (c.equals(String.class)) {
                return str;
            }
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return null;
    }

    private static class LayoutPropertyKey {
        private volatile int hashCode = 0;
        private final String name;
        private final String layoutClassName;

        public LayoutPropertyKey(String name, String layoutClassName) {
            this.name = name;
            this.layoutClassName = layoutClassName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LayoutPropertyKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            LayoutPropertyKey s = (LayoutPropertyKey)obj;
            return s.layoutClassName.equals(this.layoutClassName) && s.name.equals(this.name);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 7;
                hash += 53 * this.layoutClassName.hashCode();
                this.hashCode = hash += 53 * this.name.hashCode();
            }
            return this.hashCode;
        }
    }
}

