/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin;

import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.GraphModel;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public abstract class AbstractLayout
implements Layout {
    private final LayoutBuilder layoutBuilder;
    protected GraphModel graphModel;
    protected DynamicModel dynamicModel;
    private boolean converged;

    public AbstractLayout(LayoutBuilder layoutBuilder) {
        this.layoutBuilder = layoutBuilder;
    }

    public LayoutBuilder getBuilder() {
        return this.layoutBuilder;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
        Workspace workspace = graphModel.getWorkspace();
        DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
        if (dynamicController != null && workspace != null) {
            this.dynamicModel = dynamicController.getModel(workspace);
        }
    }

    public boolean canAlgo() {
        return !this.isConverged() && this.graphModel != null;
    }

    public void setConverged(boolean converged) {
        this.converged = converged;
    }

    public boolean isConverged() {
        return this.converged;
    }
}

