/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.ForceVectorUtils;

public class GraphUtils {
    public static Node getTopmostParent(HierarchicalGraph graph, Node n) {
        Node parent = graph.getParent(n);
        while (parent != null) {
            n = parent;
            parent = graph.getParent(n);
        }
        return n;
    }

    public static float getAverageEdgeLength(HierarchicalGraph graph) {
        float edgeLength = 0.0f;
        int count = 1;
        for (Edge e : graph.getEdgesAndMetaEdges()) {
            edgeLength += ForceVectorUtils.distance(e.getSource().getNodeData(), e.getTarget().getNodeData());
            ++count;
        }
        return edgeLength / (float)count;
    }
}

