/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force.quadtree;

import java.util.ArrayList;
import java.util.List;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Spatial;
import org.gephi.layout.plugin.force.quadtree.AddBehaviour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTree
implements Spatial {
    private float posX;
    private float posY;
    private float size;
    private float centerMassX;
    private float centerMassY;
    private int mass;
    private int maxLevel;
    private AddBehaviour add;
    private List<QuadTree> children;
    private boolean isLeaf;
    public static final float eps = 1.0E-6f;

    public static QuadTree buildTree(HierarchicalGraph graph, int maxLevel) {
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getTopNodes()) {
            minX = Math.min(minX, node.getNodeData().x());
            maxX = Math.max(maxX, node.getNodeData().x());
            minY = Math.min(minY, node.getNodeData().y());
            maxY = Math.max(maxY, node.getNodeData().y());
        }
        float size = Math.max(maxY - minY, maxX - minX);
        QuadTree tree = new QuadTree(minX, minY, size, maxLevel);
        for (Node node : graph.getTopNodes()) {
            tree.addNode(node.getNodeData());
        }
        return tree;
    }

    public QuadTree(float posX, float posY, float size, int maxLevel) {
        this.posX = posX;
        this.posY = posY;
        this.size = size;
        this.maxLevel = maxLevel;
        this.isLeaf = true;
        this.mass = 0;
        this.add = new FirstAdd();
    }

    public float size() {
        return this.size;
    }

    private void divideTree() {
        float childSize = this.size / 2.0f;
        this.children = new ArrayList<QuadTree>();
        this.children.add(new QuadTree(this.posX + childSize, this.posY + childSize, childSize, this.maxLevel - 1));
        this.children.add(new QuadTree(this.posX, this.posY + childSize, childSize, this.maxLevel - 1));
        this.children.add(new QuadTree(this.posX, this.posY, childSize, this.maxLevel - 1));
        this.children.add(new QuadTree(this.posX + childSize, this.posY, childSize, this.maxLevel - 1));
        this.isLeaf = false;
    }

    private boolean addToChildren(Spatial node) {
        for (QuadTree q : this.children) {
            if (!q.addNode(node)) continue;
            return true;
        }
        return false;
    }

    private void assimilateNode(Spatial node) {
        this.centerMassX = ((float)this.mass * this.centerMassX + node.x()) / (float)(this.mass + 1);
        this.centerMassY = ((float)this.mass * this.centerMassY + node.y()) / (float)(this.mass + 1);
        ++this.mass;
    }

    public Iterable<QuadTree> getChildren() {
        return this.children;
    }

    @Override
    public float x() {
        return this.centerMassX;
    }

    @Override
    public float y() {
        return this.centerMassY;
    }

    public int mass() {
        return this.mass;
    }

    @Override
    public float z() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean addNode(Spatial node) {
        if (this.posX <= node.x() && node.x() <= this.posX + this.size && this.posY <= node.y() && node.y() <= this.posY + this.size) {
            return this.add.addNode(node);
        }
        return false;
    }

    public boolean isIsLeaf() {
        return this.isLeaf;
    }

    class RootAdd
    implements AddBehaviour {
        RootAdd() {
        }

        public boolean addNode(Spatial node) {
            QuadTree.this.assimilateNode(node);
            return QuadTree.this.addToChildren(node);
        }
    }

    class LeafAdd
    implements AddBehaviour {
        LeafAdd() {
        }

        public boolean addNode(Spatial node) {
            QuadTree.this.assimilateNode(node);
            return true;
        }
    }

    class SecondAdd
    implements AddBehaviour {
        SecondAdd() {
        }

        public boolean addNode(Spatial node) {
            QuadTree.this.divideTree();
            QuadTree.this.add = new RootAdd();
            QuadTree.this.addToChildren(QuadTree.this);
            return QuadTree.this.add.addNode(node);
        }
    }

    class FirstAdd
    implements AddBehaviour {
        FirstAdd() {
        }

        public boolean addNode(Spatial node) {
            QuadTree.this.mass = 1;
            QuadTree.this.centerMassX = node.x();
            QuadTree.this.centerMassY = node.y();
            if (QuadTree.this.maxLevel == 0) {
                QuadTree.this.add = new LeafAdd();
            } else {
                QuadTree.this.add = new SecondAdd();
            }
            return true;
        }
    }
}

