/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force.yifanHu;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.Spatial;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.GraphUtils;
import org.gephi.layout.plugin.force.AbstractForce;
import org.gephi.layout.plugin.force.Displacement;
import org.gephi.layout.plugin.force.ForceVector;
import org.gephi.layout.plugin.force.quadtree.BarnesHut;
import org.gephi.layout.plugin.force.quadtree.QuadTree;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class YifanHuLayout
extends AbstractLayout
implements Layout {
    private float optimalDistance;
    private float relativeStrength;
    private float step;
    private float initialStep;
    private int progress;
    private float stepRatio;
    private int quadTreeMaxLevel;
    private float barnesHutTheta;
    private float convergenceThreshold;
    private boolean adaptiveCooling;
    private Displacement displacement;
    private double energy0;
    private double energy;
    private HierarchicalGraph graph;

    public YifanHuLayout(LayoutBuilder layoutBuilder, Displacement displacement) {
        super(layoutBuilder);
        this.displacement = displacement;
    }

    protected void postAlgo() {
        this.updateStep();
        if (Math.abs((this.energy - this.energy0) / this.energy) < (double)this.getConvergenceThreshold().floatValue()) {
            this.setConverged(true);
        }
    }

    private Displacement getDisplacement() {
        this.displacement.setStep(this.step);
        return this.displacement;
    }

    private AbstractForce getEdgeForce() {
        return new SpringForce(this.getOptimalDistance().floatValue());
    }

    private AbstractForce getNodeForce() {
        return new ElectricalForce(this.getRelativeStrength().floatValue(), this.getOptimalDistance().floatValue());
    }

    private void updateStep() {
        if (this.isAdaptiveCooling().booleanValue()) {
            if (this.energy < this.energy0) {
                ++this.progress;
                if (this.progress >= 5) {
                    this.progress = 0;
                    this.setStep(Float.valueOf(this.step / this.getStepRatio().floatValue()));
                }
            } else {
                this.progress = 0;
                this.setStep(Float.valueOf(this.step * this.getStepRatio().floatValue()));
            }
        } else {
            this.setStep(Float.valueOf(this.step * this.getStepRatio().floatValue()));
        }
    }

    public void resetPropertiesValues() {
        this.setStepRatio(Float.valueOf(0.95f));
        this.setRelativeStrength(Float.valueOf(0.2f));
        if (this.graph != null) {
            this.setOptimalDistance(Float.valueOf((float)(Math.pow(this.getRelativeStrength().floatValue(), 0.3333333333333333) * (double)GraphUtils.getAverageEdgeLength(this.graph))));
        } else {
            this.setOptimalDistance(Float.valueOf(100.0f));
        }
        this.setInitialStep(Float.valueOf(this.optimalDistance / 5.0f));
        this.setStep(Float.valueOf(this.initialStep));
        this.setQuadTreeMaxLevel(10);
        this.setBarnesHutTheta(Float.valueOf(1.2f));
        this.setAdaptiveCooling(true);
        this.setConvergenceThreshold(Float.valueOf(1.0E-4f));
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String YIFANHU_CATEGORY = "Yifan Hu's properties";
        String BARNESHUT_CATEGORY = "Barnes-Hut's properties";
        try {
            properties.add(LayoutProperty.createProperty(this, Float.class, "Optimal Distance", "Yifan Hu's properties", "The natural length of the springs. Bigger values mean nodes will be farther apart.", "getOptimalDistance", "setOptimalDistance"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Relative Strength", "Yifan Hu's properties", "The relative strength between electrical force (repulsion) and spring force (attraction).", "getRelativeStrength", "setRelativeStrength"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Initial Step size", "Yifan Hu's properties", "The initial step size used in the integration phase. Set this value to a meaningful size compared to the optimal distance (10% is a good starting point).", "getInitialStep", "setInitialStep"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Step ratio", "Yifan Hu's properties", "The ratio used to update the step size across iterations.", "getStepRatio", "setStepRatio"));
            properties.add(LayoutProperty.createProperty(this, Boolean.class, "Adaptive Cooling", "Yifan Hu's properties", "Controls the use of adaptive cooling. It is used help the layout algoritm to avoid energy local minima.", "isAdaptiveCooling", "setAdaptiveCooling"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Convergence Threshold", "Yifan Hu's properties", "Relative energy convergence threshold. Smaller values mean more accuracy.", "getConvergenceThreshold", "setConvergenceThreshold"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, "Quadtree Max Level", "Barnes-Hut's properties", "The maximun level to be used in the quadtree representation. Greater values mean more accuracy.", "getQuadTreeMaxLevel", "setQuadTreeMaxLevel"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Theta", "Barnes-Hut's properties", "The theta parameter for Barnes-Hut opening criteria. Smaller values mean more accuracy.", "getBarnesHutTheta", "setBarnesHutTheta"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void initAlgo() {
        if (this.graphModel == null) {
            return;
        }
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        this.energy = Double.POSITIVE_INFINITY;
        for (Node n : this.graph.getNodes()) {
            NodeData data = n.getNodeData();
            data.setLayoutData(new ForceVector());
        }
        this.progress = 0;
        this.setConverged(false);
        this.setStep(Float.valueOf(this.initialStep));
    }

    public void endAlgo() {
        for (Node node : this.graph.getNodes()) {
            NodeData data = node.getNodeData();
            data.setLayoutData(null);
        }
    }

    public void goAlgo() {
        ForceVector force;
        NodeData data;
        ForceVector f;
        Node[] nodes;
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        this.graph.readLock();
        for (Node n : nodes = this.graph.getNodes().toArray()) {
            if (n.getNodeData().getLayoutData() != null && n.getNodeData().getLayoutData() instanceof ForceVector) continue;
            n.getNodeData().setLayoutData(new ForceVector());
        }
        QuadTree tree = QuadTree.buildTree(this.graph, this.getQuadTreeMaxLevel());
        BarnesHut barnes = new BarnesHut(this.getNodeForce());
        barnes.setTheta(this.getBarnesHutTheta().floatValue());
        for (Node node : nodes) {
            NodeData data2 = node.getNodeData();
            ForceVector layoutData = (ForceVector)data2.getLayoutData();
            f = barnes.calculateForce(data2, tree);
            layoutData.add(f);
        }
        for (Edge e : this.graph.getEdgesAndMetaEdges()) {
            if (e.getSource().equals(e.getTarget())) continue;
            NodeData n1 = e.getSource().getNodeData();
            NodeData n2 = e.getTarget().getNodeData();
            ForceVector f1 = (ForceVector)n1.getLayoutData();
            ForceVector f2 = (ForceVector)n2.getLayoutData();
            f = this.getEdgeForce().calculateForce(n1, n2);
            f1.add(f);
            f2.subtract(f);
        }
        this.energy0 = this.energy;
        this.energy = 0.0;
        double maxForce = 1.0;
        for (Node n : nodes) {
            data = n.getNodeData();
            force = (ForceVector)data.getLayoutData();
            this.energy += (double)force.getNorm();
            maxForce = Math.max(maxForce, (double)force.getNorm());
        }
        for (Node n : nodes) {
            data = n.getNodeData();
            if (data.isFixed()) continue;
            force = (ForceVector)data.getLayoutData();
            force.multiply((float)(1.0 / maxForce));
            this.getDisplacement().moveNode(data, force);
        }
        this.postAlgo();
        System.out.println("energy0 = " + this.energy0 + "   energy = " + this.energy);
        this.graph.readUnlock();
    }

    public Integer getQuadTreeMaxLevel() {
        return this.quadTreeMaxLevel;
    }

    public void setQuadTreeMaxLevel(Integer quadTreeMaxLevel) {
        this.quadTreeMaxLevel = quadTreeMaxLevel;
    }

    public Float getBarnesHutTheta() {
        return Float.valueOf(this.barnesHutTheta);
    }

    public void setBarnesHutTheta(Float barnesHutTheta) {
        this.barnesHutTheta = barnesHutTheta.floatValue();
    }

    public Float getOptimalDistance() {
        return Float.valueOf(this.optimalDistance);
    }

    public void setOptimalDistance(Float optimalDistance) {
        this.optimalDistance = optimalDistance.floatValue();
    }

    public Float getRelativeStrength() {
        return Float.valueOf(this.relativeStrength);
    }

    public void setRelativeStrength(Float relativeStrength) {
        this.relativeStrength = relativeStrength.floatValue();
    }

    public void setStep(Float step) {
        this.step = step.floatValue();
    }

    public Boolean isAdaptiveCooling() {
        return this.adaptiveCooling;
    }

    public void setAdaptiveCooling(Boolean adaptiveCooling) {
        this.adaptiveCooling = adaptiveCooling;
    }

    public Float getStepRatio() {
        return Float.valueOf(this.stepRatio);
    }

    public void setStepRatio(Float stepRatio) {
        this.stepRatio = stepRatio.floatValue();
    }

    public Float getConvergenceThreshold() {
        return Float.valueOf(this.convergenceThreshold);
    }

    public void setConvergenceThreshold(Float convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold.floatValue();
    }

    public Float getInitialStep() {
        return Float.valueOf(this.initialStep);
    }

    public void setInitialStep(Float initialStep) {
        this.initialStep = initialStep.floatValue();
    }

    public class ElectricalForce
    extends AbstractForce {
        private float relativeStrength;
        private float optimalDistance;

        public ElectricalForce(float relativeStrength, float optimalDistance) {
            this.relativeStrength = relativeStrength;
            this.optimalDistance = optimalDistance;
        }

        public ForceVector calculateForce(Spatial node1, Spatial node2, float distance) {
            ForceVector f = new ForceVector(node2.x() - node1.x(), node2.y() - node1.y());
            float scale = -this.relativeStrength * this.optimalDistance * this.optimalDistance / (distance * distance);
            if (Float.isNaN(scale) || Float.isInfinite(scale)) {
                scale = -1.0f;
            }
            f.multiply(scale);
            return f;
        }
    }

    public class SpringForce
    extends AbstractForce {
        private float optimalDistance;

        public SpringForce(float optimalDistance) {
            this.optimalDistance = optimalDistance;
        }

        public ForceVector calculateForce(Spatial node1, Spatial node2, float distance) {
            ForceVector f = new ForceVector(node2.x() - node1.x(), node2.y() - node1.y());
            f.multiply(distance / this.optimalDistance);
            return f;
        }

        public void setOptimalDistance(Float optimalDistance) {
            this.optimalDistance = optimalDistance.floatValue();
        }

        public Float getOptimalDistance() {
            return Float.valueOf(this.optimalDistance);
        }
    }
}

