/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas;

import java.util.ArrayList;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;
import org.gephi.layout.plugin.ForceVectorUtils;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.NbBundle;

public class ForceAtlasLayout
extends AbstractLayout
implements Layout {
    protected HierarchicalGraph graph;
    public double inertia;
    private double repulsionStrength;
    private double attractionStrength;
    private double maxDisplacement;
    private boolean freezeBalance;
    private double freezeStrength;
    private double freezeInertia;
    private double gravity;
    private double speed;
    private double cooling;
    private boolean outboundAttractionDistribution;
    private boolean adjustSizes;
    private TimeInterval timeInterval;

    public ForceAtlasLayout(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.inertia = 0.1;
        this.setRepulsionStrength(200.0);
        this.setAttractionStrength(10.0);
        this.setMaxDisplacement(10.0);
        this.setFreezeBalance(true);
        this.setFreezeStrength(80.0);
        this.setFreezeInertia(0.2);
        this.setGravity(30.0);
        this.setOutboundAttractionDistribution(false);
        this.setAdjustSizes(false);
        this.setSpeed(1.0);
        this.setCooling(1.0);
    }

    public void initAlgo() {
        this.graph = this.graphModel.getHierarchicalGraphVisible();
    }

    public void goAlgo() {
        Node nf;
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        this.timeInterval = DynamicUtilities.getVisibleInterval(this.dynamicModel);
        this.graph.readLock();
        Node[] nodes = this.graph.getNodes().toArray();
        Edge[] edges = this.graph.getEdgesAndMetaEdges().toArray();
        for (Node node : nodes) {
            if (node.getNodeData().getLayoutData() != null && node.getNodeData().getLayoutData() instanceof ForceVectorNodeLayoutData) continue;
            node.getNodeData().setLayoutData(new ForceVectorNodeLayoutData());
        }
        for (Node node : nodes) {
            ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
            layoutData.old_dx = layoutData.dx;
            layoutData.old_dy = layoutData.dy;
            layoutData.dx = (float)((double)layoutData.dx * this.inertia);
            layoutData.dy = (float)((double)layoutData.dy * this.inertia);
        }
        if (this.isAdjustSizes().booleanValue()) {
            for (Node node : nodes) {
                for (Node n2 : nodes) {
                    if (node == n2) continue;
                    ForceVectorUtils.fcBiRepulsor_noCollide(node.getNodeData(), n2.getNodeData(), this.getRepulsionStrength() * (double)(1 + this.graph.getDegree(node)) * (double)(1 + this.graph.getDegree(n2)));
                }
            }
        } else {
            for (Node node : nodes) {
                for (Node n2 : nodes) {
                    if (node == n2) continue;
                    ForceVectorUtils.fcBiRepulsor(node.getNodeData(), n2.getNodeData(), this.getRepulsionStrength() * (double)(1 + this.graph.getDegree(node)) * (double)(1 + this.graph.getDegree(n2)));
                }
            }
        }
        if (this.isAdjustSizes().booleanValue()) {
            if (this.isOutboundAttractionDistribution().booleanValue()) {
                for (Edge edge : edges) {
                    nf = edge.getSource();
                    Node nt = edge.getTarget();
                    double bonus = nf.getNodeData().isFixed() || nt.getNodeData().isFixed() ? 100.0 : 1.0;
                    ForceVectorUtils.fcBiAttractor_noCollide(nf.getNodeData(), nt.getNodeData(), (bonus *= (double)this.getWeight(edge)) * this.getAttractionStrength() / (double)(1 + this.graph.getDegree(nf)));
                }
            } else {
                for (Edge edge : edges) {
                    nf = edge.getSource();
                    Node nt = edge.getTarget();
                    double bonus = nf.getNodeData().isFixed() || nt.getNodeData().isFixed() ? 100.0 : 1.0;
                    ForceVectorUtils.fcBiAttractor_noCollide(nf.getNodeData(), nt.getNodeData(), (bonus *= (double)this.getWeight(edge)) * this.getAttractionStrength());
                }
            }
        } else if (this.isOutboundAttractionDistribution().booleanValue()) {
            for (Edge edge : edges) {
                nf = edge.getSource();
                Node nt = edge.getTarget();
                double bonus = nf.getNodeData().isFixed() || nt.getNodeData().isFixed() ? 100.0 : 1.0;
                ForceVectorUtils.fcBiAttractor(nf.getNodeData(), nt.getNodeData(), (bonus *= (double)this.getWeight(edge)) * this.getAttractionStrength() / (double)(1 + this.graph.getDegree(nf)));
            }
        } else {
            for (Edge edge : edges) {
                nf = edge.getSource();
                Node nt = edge.getTarget();
                double bonus = nf.getNodeData().isFixed() || nt.getNodeData().isFixed() ? 100.0 : 1.0;
                ForceVectorUtils.fcBiAttractor(nf.getNodeData(), nt.getNodeData(), (bonus *= (double)this.getWeight(edge)) * this.getAttractionStrength());
            }
        }
        for (Node node : nodes) {
            float nx = node.getNodeData().x();
            float ny = node.getNodeData().y();
            double d = 1.0E-4 + Math.sqrt(nx * nx + ny * ny);
            double gf = 1.0E-4 * this.getGravity() * d;
            ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
            layoutData.dx = (float)((double)layoutData.dx - gf * (double)nx / d);
            layoutData.dy = (float)((double)layoutData.dy - gf * (double)ny / d);
        }
        if (this.isFreezeBalance().booleanValue()) {
            for (Node node : nodes) {
                ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
                layoutData.dx = (float)((double)layoutData.dx * (this.getSpeed() * 10.0));
                layoutData.dy = (float)((double)layoutData.dy * (this.getSpeed() * 10.0));
            }
        } else {
            for (Node node : nodes) {
                ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
                layoutData.dx = (float)((double)layoutData.dx * this.getSpeed());
                layoutData.dy = (float)((double)layoutData.dy * this.getSpeed());
            }
        }
        for (Node node : nodes) {
            float ratio;
            NodeData nData = node.getNodeData();
            ForceVectorNodeLayoutData nLayout = (ForceVectorNodeLayoutData)nData.getLayoutData();
            if (nData.isFixed()) continue;
            double d = 1.0E-4 + Math.sqrt(nLayout.dx * nLayout.dx + nLayout.dy * nLayout.dy);
            if (this.isFreezeBalance().booleanValue()) {
                nLayout.freeze = (float)(this.getFreezeInertia() * (double)nLayout.freeze + (1.0 - this.getFreezeInertia()) * 0.1 * this.getFreezeStrength() * Math.sqrt(Math.sqrt((nLayout.old_dx - nLayout.dx) * (nLayout.old_dx - nLayout.dx) + (nLayout.old_dy - nLayout.dy) * (nLayout.old_dy - nLayout.dy))));
                ratio = (float)Math.min(d / (d * (double)(1.0f + nLayout.freeze)), this.getMaxDisplacement() / d);
            } else {
                ratio = (float)Math.min(1.0, this.getMaxDisplacement() / d);
            }
            nLayout.dx = (float)((double)nLayout.dx * ((double)ratio / this.getCooling()));
            nLayout.dy = (float)((double)nLayout.dy * ((double)ratio / this.getCooling()));
            float x = nData.x() + nLayout.dx;
            float y = nData.y() + nLayout.dy;
            nData.setX(x);
            nData.setY(y);
        }
        this.graph.readUnlock();
    }

    public void endAlgo() {
        for (Node n : this.graph.getNodes()) {
            n.getNodeData().setLayoutData(null);
        }
    }

    public boolean canAlgo() {
        return true;
    }

    private float getWeight(Edge edge) {
        if (this.timeInterval != null) {
            return edge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh());
        }
        return edge.getWeight();
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FORCE_ATLAS = "Force Atlas";
        try {
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.inertia.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.inertia.desc"), "getInertia", "setInertia"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.repulsionStrength.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.repulsionStrength.desc"), "getRepulsionStrength", "setRepulsionStrength"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.attractionStrength.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.attractionStrength.desc"), "getAttractionStrength", "setAttractionStrength"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.maxDisplacement.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.maxDisplacement.desc"), "getMaxDisplacement", "setMaxDisplacement"));
            properties.add(LayoutProperty.createProperty(this, Boolean.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeBalance.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeBalance.desc"), "isFreezeBalance", "setFreezeBalance"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeStrength.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeStrength.desc"), "getFreezeStrength", "setFreezeStrength"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeInertia.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeInertia.desc"), "getFreezeInertia", "setFreezeInertia"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.gravity.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.gravity.desc"), "getGravity", "setGravity"));
            properties.add(LayoutProperty.createProperty(this, Boolean.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.outboundAttractionDistribution.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.outboundAttractionDistribution.desc"), "isOutboundAttractionDistribution", "setOutboundAttractionDistribution"));
            properties.add(LayoutProperty.createProperty(this, Boolean.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.adjustSizes.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.adjustSizes.desc"), "isAdjustSizes", "setAdjustSizes"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.speed.name"), "Force Atlas", NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.speed.desc"), "getSpeed", "setSpeed"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void setInertia(Double inertia) {
        this.inertia = inertia;
    }

    public Double getInertia() {
        return this.inertia;
    }

    public Double getRepulsionStrength() {
        return this.repulsionStrength;
    }

    public void setRepulsionStrength(Double repulsionStrength) {
        this.repulsionStrength = repulsionStrength;
    }

    public Double getAttractionStrength() {
        return this.attractionStrength;
    }

    public void setAttractionStrength(Double attractionStrength) {
        this.attractionStrength = attractionStrength;
    }

    public Double getMaxDisplacement() {
        return this.maxDisplacement;
    }

    public void setMaxDisplacement(Double maxDisplacement) {
        this.maxDisplacement = maxDisplacement;
    }

    public Boolean isFreezeBalance() {
        return this.freezeBalance;
    }

    public void setFreezeBalance(Boolean freezeBalance) {
        this.freezeBalance = freezeBalance;
    }

    public Double getFreezeStrength() {
        return this.freezeStrength;
    }

    public void setFreezeStrength(Double freezeStrength) {
        this.freezeStrength = freezeStrength;
    }

    public Double getFreezeInertia() {
        return this.freezeInertia;
    }

    public void setFreezeInertia(Double freezeInertia) {
        this.freezeInertia = freezeInertia;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getCooling() {
        return this.cooling;
    }

    public void setCooling(Double cooling) {
        this.cooling = cooling;
    }

    public Boolean isOutboundAttractionDistribution() {
        return this.outboundAttractionDistribution;
    }

    public void setOutboundAttractionDistribution(Boolean outboundAttractionDistribution) {
        this.outboundAttractionDistribution = outboundAttractionDistribution;
    }

    public Boolean isAdjustSizes() {
        return this.adjustSizes;
    }

    public void setAdjustSizes(Boolean adjustSizes) {
        this.adjustSizes = adjustSizes;
    }
}

